# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixSite2CloudArgs', 'AviatrixSite2Cloud']

@pulumi.input_type
class AviatrixSite2CloudArgs:
    def __init__(__self__, *,
                 connection_name: pulumi.Input[str],
                 connection_type: pulumi.Input[str],
                 primary_cloud_gateway_name: pulumi.Input[str],
                 remote_gateway_ip: pulumi.Input[str],
                 remote_gateway_type: pulumi.Input[str],
                 tunnel_type: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 auth_type: Optional[pulumi.Input[str]] = None,
                 backup_gateway_name: Optional[pulumi.Input[str]] = None,
                 backup_local_tunnel_ip: Optional[pulumi.Input[str]] = None,
                 backup_pre_shared_key: Optional[pulumi.Input[str]] = None,
                 backup_remote_gateway_ip: Optional[pulumi.Input[str]] = None,
                 backup_remote_gateway_latitude: Optional[pulumi.Input[float]] = None,
                 backup_remote_gateway_longitude: Optional[pulumi.Input[float]] = None,
                 backup_remote_identifier: Optional[pulumi.Input[str]] = None,
                 backup_remote_tunnel_ip: Optional[pulumi.Input[str]] = None,
                 ca_cert_tag_name: Optional[pulumi.Input[str]] = None,
                 custom_algorithms: Optional[pulumi.Input[bool]] = None,
                 custom_mapped: Optional[pulumi.Input[bool]] = None,
                 enable_active_active: Optional[pulumi.Input[bool]] = None,
                 enable_dead_peer_detection: Optional[pulumi.Input[bool]] = None,
                 enable_event_triggered_ha: Optional[pulumi.Input[bool]] = None,
                 enable_ikev2: Optional[pulumi.Input[bool]] = None,
                 enable_single_ip_ha: Optional[pulumi.Input[bool]] = None,
                 forward_traffic_to_transit: Optional[pulumi.Input[bool]] = None,
                 ha_enabled: Optional[pulumi.Input[bool]] = None,
                 local_destination_real_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 local_destination_virtual_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 local_source_real_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 local_source_virtual_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 local_subnet_cidr: Optional[pulumi.Input[str]] = None,
                 local_subnet_virtual: Optional[pulumi.Input[str]] = None,
                 local_tunnel_ip: Optional[pulumi.Input[str]] = None,
                 phase1_authentication: Optional[pulumi.Input[str]] = None,
                 phase1_dh_groups: Optional[pulumi.Input[str]] = None,
                 phase1_encryption: Optional[pulumi.Input[str]] = None,
                 phase1_remote_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 phase2_authentication: Optional[pulumi.Input[str]] = None,
                 phase2_dh_groups: Optional[pulumi.Input[str]] = None,
                 phase2_encryption: Optional[pulumi.Input[str]] = None,
                 pre_shared_key: Optional[pulumi.Input[str]] = None,
                 private_route_encryption: Optional[pulumi.Input[bool]] = None,
                 remote_destination_real_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remote_destination_virtual_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remote_gateway_latitude: Optional[pulumi.Input[float]] = None,
                 remote_gateway_longitude: Optional[pulumi.Input[float]] = None,
                 remote_identifier: Optional[pulumi.Input[str]] = None,
                 remote_source_real_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remote_source_virtual_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remote_subnet_cidr: Optional[pulumi.Input[str]] = None,
                 remote_subnet_virtual: Optional[pulumi.Input[str]] = None,
                 remote_tunnel_ip: Optional[pulumi.Input[str]] = None,
                 route_table_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ssl_server_pool: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AviatrixSite2Cloud resource.
        :param pulumi.Input[str] connection_name: Site2Cloud Connection Name.
        :param pulumi.Input[str] connection_type: Connection Type. Valid values: 'mapped' and 'unmapped'.
        :param pulumi.Input[str] primary_cloud_gateway_name: Primary Cloud Gateway Name.
        :param pulumi.Input[str] remote_gateway_ip: Remote Gateway IP.
        :param pulumi.Input[str] remote_gateway_type: Remote gateway type. Valid values: 'generic', 'avx', 'aws', 'azure', 'sonicwall' and 'oracle'.
        :param pulumi.Input[str] tunnel_type: Site2Cloud Tunnel Type. Valid values: 'policy' and 'route'.
        :param pulumi.Input[str] vpc_id: VPC Id of the cloud gateway.
        :param pulumi.Input[str] auth_type: Authentication Type. Valid values: 'PSK' and 'Cert'. Default value: 'PSK'.
        :param pulumi.Input[str] backup_gateway_name: Backup gateway name.
        :param pulumi.Input[str] backup_local_tunnel_ip: Backup local tunnel IP address.
        :param pulumi.Input[str] backup_pre_shared_key: Backup Pre-Shared Key.
        :param pulumi.Input[str] backup_remote_gateway_ip: Backup remote remote gateway IP.
        :param pulumi.Input[float] backup_remote_gateway_latitude: Latitude of backup remote gateway.
        :param pulumi.Input[float] backup_remote_gateway_longitude: Longitude of backup remote gateway.
        :param pulumi.Input[str] backup_remote_identifier: Backup remote identifier. Required for Cert based authentication type with HA enabled.
        :param pulumi.Input[str] backup_remote_tunnel_ip: Backup remote tunnel IP address.
        :param pulumi.Input[str] ca_cert_tag_name: Name of Remote CA Certificate Tag for creating Site2Cloud tunnels. Required for Cert based authentication type.
        :param pulumi.Input[bool] custom_algorithms: Switch to enable custom/non-default algorithms for IPSec Authentication/Encryption.
        :param pulumi.Input[bool] custom_mapped: Enable custom mapped.
        :param pulumi.Input[bool] enable_active_active: Switch to Enable/Disable active_active_ha for an existing site2cloud connection.
        :param pulumi.Input[bool] enable_dead_peer_detection: Switch to Enable/Disable Deed Peer Detection for an existing site2cloud connection.
        :param pulumi.Input[bool] enable_event_triggered_ha: Enable Event Triggered HA.
        :param pulumi.Input[bool] enable_ikev2: Switch to enable IKEv2 for policy based site2cloud.
        :param pulumi.Input[bool] enable_single_ip_ha: Enable single IP HA on a site2cloud connection.
        :param pulumi.Input[bool] forward_traffic_to_transit: Enable spoke gateway with mapped site2cloud configurations to forward traffic from site2cloud connection to Aviatrix
               Transit Gateway.
        :param pulumi.Input[bool] ha_enabled: Specify whether enabling HA or not.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_destination_real_cidrs: Local Initiated Traffic Destination Real CIDRs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_destination_virtual_cidrs: Local Initiated Traffic Destination Virtual CIDRs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_source_real_cidrs: Local Initiated Traffic Source Real CIDRs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_source_virtual_cidrs: Local Initiated Traffic Source Virtual CIDRs.
        :param pulumi.Input[str] local_subnet_cidr: Local Subnet CIDR.
        :param pulumi.Input[str] local_subnet_virtual: Local Subnet CIDR (Virtual).
        :param pulumi.Input[str] local_tunnel_ip: Local tunnel IP address.
        :param pulumi.Input[str] phase1_authentication: Phase one Authentication. Valid values: 'SHA-1', 'SHA-256', 'SHA-384' and 'SHA-512'.
        :param pulumi.Input[str] phase1_dh_groups: Phase one DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        :param pulumi.Input[str] phase1_encryption: Phase one Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC' and 'AES-256-CBC', 'AES-128-GCM-64',
               'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', and 'AES-256-GCM-128'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] phase1_remote_identifiers: Phase 1 remote identifier of the IPsec tunnel.
        :param pulumi.Input[str] phase2_authentication: Phase two Authentication. Valid values: 'NO-AUTH', 'HMAC-SHA-1', 'HMAC-SHA-256', 'HMAC-SHA-384' and 'HMAC-SHA-512'.
        :param pulumi.Input[str] phase2_dh_groups: Phase two DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        :param pulumi.Input[str] phase2_encryption: Phase two Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC', 'AES-256-CBC', 'AES-128-GCM-64',
               'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', 'AES-256-GCM-128', and 'NULL-ENCR'.
        :param pulumi.Input[str] pre_shared_key: Pre-Shared Key.
        :param pulumi.Input[bool] private_route_encryption: Private route encryption switch.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_destination_real_cidrs: Remote Initiated Traffic Destination Real CIDRs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_destination_virtual_cidrs: Remote Initiated Traffic Destination Virtual CIDRs.
        :param pulumi.Input[float] remote_gateway_latitude: Latitude of remote gateway.
        :param pulumi.Input[float] remote_gateway_longitude: Longitude of remote gateway.
        :param pulumi.Input[str] remote_identifier: Remote identifier. Required for Cert based authentication type.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_source_real_cidrs: Remote Initiated Traffic Source Real CIDRs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_source_virtual_cidrs: Remote Initiated Traffic Source Virtual CIDRs.
        :param pulumi.Input[str] remote_subnet_cidr: Remote Subnet CIDR.
        :param pulumi.Input[str] remote_subnet_virtual: Remote Subnet CIDR (Virtual).
        :param pulumi.Input[str] remote_tunnel_ip: Remote tunnel IP address.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] route_table_lists: Route tables to modify.
        :param pulumi.Input[str] ssl_server_pool: Specify ssl_server_pool for tunnel_type 'tcp'. Default value is '192.168.44.0/24'
        """
        pulumi.set(__self__, "connection_name", connection_name)
        pulumi.set(__self__, "connection_type", connection_type)
        pulumi.set(__self__, "primary_cloud_gateway_name", primary_cloud_gateway_name)
        pulumi.set(__self__, "remote_gateway_ip", remote_gateway_ip)
        pulumi.set(__self__, "remote_gateway_type", remote_gateway_type)
        pulumi.set(__self__, "tunnel_type", tunnel_type)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if backup_gateway_name is not None:
            pulumi.set(__self__, "backup_gateway_name", backup_gateway_name)
        if backup_local_tunnel_ip is not None:
            pulumi.set(__self__, "backup_local_tunnel_ip", backup_local_tunnel_ip)
        if backup_pre_shared_key is not None:
            pulumi.set(__self__, "backup_pre_shared_key", backup_pre_shared_key)
        if backup_remote_gateway_ip is not None:
            pulumi.set(__self__, "backup_remote_gateway_ip", backup_remote_gateway_ip)
        if backup_remote_gateway_latitude is not None:
            pulumi.set(__self__, "backup_remote_gateway_latitude", backup_remote_gateway_latitude)
        if backup_remote_gateway_longitude is not None:
            pulumi.set(__self__, "backup_remote_gateway_longitude", backup_remote_gateway_longitude)
        if backup_remote_identifier is not None:
            pulumi.set(__self__, "backup_remote_identifier", backup_remote_identifier)
        if backup_remote_tunnel_ip is not None:
            pulumi.set(__self__, "backup_remote_tunnel_ip", backup_remote_tunnel_ip)
        if ca_cert_tag_name is not None:
            pulumi.set(__self__, "ca_cert_tag_name", ca_cert_tag_name)
        if custom_algorithms is not None:
            pulumi.set(__self__, "custom_algorithms", custom_algorithms)
        if custom_mapped is not None:
            pulumi.set(__self__, "custom_mapped", custom_mapped)
        if enable_active_active is not None:
            pulumi.set(__self__, "enable_active_active", enable_active_active)
        if enable_dead_peer_detection is not None:
            pulumi.set(__self__, "enable_dead_peer_detection", enable_dead_peer_detection)
        if enable_event_triggered_ha is not None:
            pulumi.set(__self__, "enable_event_triggered_ha", enable_event_triggered_ha)
        if enable_ikev2 is not None:
            pulumi.set(__self__, "enable_ikev2", enable_ikev2)
        if enable_single_ip_ha is not None:
            pulumi.set(__self__, "enable_single_ip_ha", enable_single_ip_ha)
        if forward_traffic_to_transit is not None:
            pulumi.set(__self__, "forward_traffic_to_transit", forward_traffic_to_transit)
        if ha_enabled is not None:
            pulumi.set(__self__, "ha_enabled", ha_enabled)
        if local_destination_real_cidrs is not None:
            pulumi.set(__self__, "local_destination_real_cidrs", local_destination_real_cidrs)
        if local_destination_virtual_cidrs is not None:
            pulumi.set(__self__, "local_destination_virtual_cidrs", local_destination_virtual_cidrs)
        if local_source_real_cidrs is not None:
            pulumi.set(__self__, "local_source_real_cidrs", local_source_real_cidrs)
        if local_source_virtual_cidrs is not None:
            pulumi.set(__self__, "local_source_virtual_cidrs", local_source_virtual_cidrs)
        if local_subnet_cidr is not None:
            pulumi.set(__self__, "local_subnet_cidr", local_subnet_cidr)
        if local_subnet_virtual is not None:
            pulumi.set(__self__, "local_subnet_virtual", local_subnet_virtual)
        if local_tunnel_ip is not None:
            pulumi.set(__self__, "local_tunnel_ip", local_tunnel_ip)
        if phase1_authentication is not None:
            pulumi.set(__self__, "phase1_authentication", phase1_authentication)
        if phase1_dh_groups is not None:
            pulumi.set(__self__, "phase1_dh_groups", phase1_dh_groups)
        if phase1_encryption is not None:
            pulumi.set(__self__, "phase1_encryption", phase1_encryption)
        if phase1_remote_identifiers is not None:
            pulumi.set(__self__, "phase1_remote_identifiers", phase1_remote_identifiers)
        if phase2_authentication is not None:
            pulumi.set(__self__, "phase2_authentication", phase2_authentication)
        if phase2_dh_groups is not None:
            pulumi.set(__self__, "phase2_dh_groups", phase2_dh_groups)
        if phase2_encryption is not None:
            pulumi.set(__self__, "phase2_encryption", phase2_encryption)
        if pre_shared_key is not None:
            pulumi.set(__self__, "pre_shared_key", pre_shared_key)
        if private_route_encryption is not None:
            pulumi.set(__self__, "private_route_encryption", private_route_encryption)
        if remote_destination_real_cidrs is not None:
            pulumi.set(__self__, "remote_destination_real_cidrs", remote_destination_real_cidrs)
        if remote_destination_virtual_cidrs is not None:
            pulumi.set(__self__, "remote_destination_virtual_cidrs", remote_destination_virtual_cidrs)
        if remote_gateway_latitude is not None:
            pulumi.set(__self__, "remote_gateway_latitude", remote_gateway_latitude)
        if remote_gateway_longitude is not None:
            pulumi.set(__self__, "remote_gateway_longitude", remote_gateway_longitude)
        if remote_identifier is not None:
            pulumi.set(__self__, "remote_identifier", remote_identifier)
        if remote_source_real_cidrs is not None:
            pulumi.set(__self__, "remote_source_real_cidrs", remote_source_real_cidrs)
        if remote_source_virtual_cidrs is not None:
            pulumi.set(__self__, "remote_source_virtual_cidrs", remote_source_virtual_cidrs)
        if remote_subnet_cidr is not None:
            pulumi.set(__self__, "remote_subnet_cidr", remote_subnet_cidr)
        if remote_subnet_virtual is not None:
            pulumi.set(__self__, "remote_subnet_virtual", remote_subnet_virtual)
        if remote_tunnel_ip is not None:
            pulumi.set(__self__, "remote_tunnel_ip", remote_tunnel_ip)
        if route_table_lists is not None:
            pulumi.set(__self__, "route_table_lists", route_table_lists)
        if ssl_server_pool is not None:
            pulumi.set(__self__, "ssl_server_pool", ssl_server_pool)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Input[str]:
        """
        Site2Cloud Connection Name.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> pulumi.Input[str]:
        """
        Connection Type. Valid values: 'mapped' and 'unmapped'.
        """
        return pulumi.get(self, "connection_type")

    @connection_type.setter
    def connection_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_type", value)

    @property
    @pulumi.getter(name="primaryCloudGatewayName")
    def primary_cloud_gateway_name(self) -> pulumi.Input[str]:
        """
        Primary Cloud Gateway Name.
        """
        return pulumi.get(self, "primary_cloud_gateway_name")

    @primary_cloud_gateway_name.setter
    def primary_cloud_gateway_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "primary_cloud_gateway_name", value)

    @property
    @pulumi.getter(name="remoteGatewayIp")
    def remote_gateway_ip(self) -> pulumi.Input[str]:
        """
        Remote Gateway IP.
        """
        return pulumi.get(self, "remote_gateway_ip")

    @remote_gateway_ip.setter
    def remote_gateway_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "remote_gateway_ip", value)

    @property
    @pulumi.getter(name="remoteGatewayType")
    def remote_gateway_type(self) -> pulumi.Input[str]:
        """
        Remote gateway type. Valid values: 'generic', 'avx', 'aws', 'azure', 'sonicwall' and 'oracle'.
        """
        return pulumi.get(self, "remote_gateway_type")

    @remote_gateway_type.setter
    def remote_gateway_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "remote_gateway_type", value)

    @property
    @pulumi.getter(name="tunnelType")
    def tunnel_type(self) -> pulumi.Input[str]:
        """
        Site2Cloud Tunnel Type. Valid values: 'policy' and 'route'.
        """
        return pulumi.get(self, "tunnel_type")

    @tunnel_type.setter
    def tunnel_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "tunnel_type", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        VPC Id of the cloud gateway.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[pulumi.Input[str]]:
        """
        Authentication Type. Valid values: 'PSK' and 'Cert'. Default value: 'PSK'.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter(name="backupGatewayName")
    def backup_gateway_name(self) -> Optional[pulumi.Input[str]]:
        """
        Backup gateway name.
        """
        return pulumi.get(self, "backup_gateway_name")

    @backup_gateway_name.setter
    def backup_gateway_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_gateway_name", value)

    @property
    @pulumi.getter(name="backupLocalTunnelIp")
    def backup_local_tunnel_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Backup local tunnel IP address.
        """
        return pulumi.get(self, "backup_local_tunnel_ip")

    @backup_local_tunnel_ip.setter
    def backup_local_tunnel_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_local_tunnel_ip", value)

    @property
    @pulumi.getter(name="backupPreSharedKey")
    def backup_pre_shared_key(self) -> Optional[pulumi.Input[str]]:
        """
        Backup Pre-Shared Key.
        """
        return pulumi.get(self, "backup_pre_shared_key")

    @backup_pre_shared_key.setter
    def backup_pre_shared_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_pre_shared_key", value)

    @property
    @pulumi.getter(name="backupRemoteGatewayIp")
    def backup_remote_gateway_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Backup remote remote gateway IP.
        """
        return pulumi.get(self, "backup_remote_gateway_ip")

    @backup_remote_gateway_ip.setter
    def backup_remote_gateway_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_remote_gateway_ip", value)

    @property
    @pulumi.getter(name="backupRemoteGatewayLatitude")
    def backup_remote_gateway_latitude(self) -> Optional[pulumi.Input[float]]:
        """
        Latitude of backup remote gateway.
        """
        return pulumi.get(self, "backup_remote_gateway_latitude")

    @backup_remote_gateway_latitude.setter
    def backup_remote_gateway_latitude(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "backup_remote_gateway_latitude", value)

    @property
    @pulumi.getter(name="backupRemoteGatewayLongitude")
    def backup_remote_gateway_longitude(self) -> Optional[pulumi.Input[float]]:
        """
        Longitude of backup remote gateway.
        """
        return pulumi.get(self, "backup_remote_gateway_longitude")

    @backup_remote_gateway_longitude.setter
    def backup_remote_gateway_longitude(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "backup_remote_gateway_longitude", value)

    @property
    @pulumi.getter(name="backupRemoteIdentifier")
    def backup_remote_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Backup remote identifier. Required for Cert based authentication type with HA enabled.
        """
        return pulumi.get(self, "backup_remote_identifier")

    @backup_remote_identifier.setter
    def backup_remote_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_remote_identifier", value)

    @property
    @pulumi.getter(name="backupRemoteTunnelIp")
    def backup_remote_tunnel_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Backup remote tunnel IP address.
        """
        return pulumi.get(self, "backup_remote_tunnel_ip")

    @backup_remote_tunnel_ip.setter
    def backup_remote_tunnel_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_remote_tunnel_ip", value)

    @property
    @pulumi.getter(name="caCertTagName")
    def ca_cert_tag_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of Remote CA Certificate Tag for creating Site2Cloud tunnels. Required for Cert based authentication type.
        """
        return pulumi.get(self, "ca_cert_tag_name")

    @ca_cert_tag_name.setter
    def ca_cert_tag_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_cert_tag_name", value)

    @property
    @pulumi.getter(name="customAlgorithms")
    def custom_algorithms(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable custom/non-default algorithms for IPSec Authentication/Encryption.
        """
        return pulumi.get(self, "custom_algorithms")

    @custom_algorithms.setter
    def custom_algorithms(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "custom_algorithms", value)

    @property
    @pulumi.getter(name="customMapped")
    def custom_mapped(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable custom mapped.
        """
        return pulumi.get(self, "custom_mapped")

    @custom_mapped.setter
    def custom_mapped(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "custom_mapped", value)

    @property
    @pulumi.getter(name="enableActiveActive")
    def enable_active_active(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to Enable/Disable active_active_ha for an existing site2cloud connection.
        """
        return pulumi.get(self, "enable_active_active")

    @enable_active_active.setter
    def enable_active_active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_active_active", value)

    @property
    @pulumi.getter(name="enableDeadPeerDetection")
    def enable_dead_peer_detection(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to Enable/Disable Deed Peer Detection for an existing site2cloud connection.
        """
        return pulumi.get(self, "enable_dead_peer_detection")

    @enable_dead_peer_detection.setter
    def enable_dead_peer_detection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_dead_peer_detection", value)

    @property
    @pulumi.getter(name="enableEventTriggeredHa")
    def enable_event_triggered_ha(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Event Triggered HA.
        """
        return pulumi.get(self, "enable_event_triggered_ha")

    @enable_event_triggered_ha.setter
    def enable_event_triggered_ha(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_event_triggered_ha", value)

    @property
    @pulumi.getter(name="enableIkev2")
    def enable_ikev2(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable IKEv2 for policy based site2cloud.
        """
        return pulumi.get(self, "enable_ikev2")

    @enable_ikev2.setter
    def enable_ikev2(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ikev2", value)

    @property
    @pulumi.getter(name="enableSingleIpHa")
    def enable_single_ip_ha(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable single IP HA on a site2cloud connection.
        """
        return pulumi.get(self, "enable_single_ip_ha")

    @enable_single_ip_ha.setter
    def enable_single_ip_ha(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_single_ip_ha", value)

    @property
    @pulumi.getter(name="forwardTrafficToTransit")
    def forward_traffic_to_transit(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable spoke gateway with mapped site2cloud configurations to forward traffic from site2cloud connection to Aviatrix
        Transit Gateway.
        """
        return pulumi.get(self, "forward_traffic_to_transit")

    @forward_traffic_to_transit.setter
    def forward_traffic_to_transit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "forward_traffic_to_transit", value)

    @property
    @pulumi.getter(name="haEnabled")
    def ha_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether enabling HA or not.
        """
        return pulumi.get(self, "ha_enabled")

    @ha_enabled.setter
    def ha_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ha_enabled", value)

    @property
    @pulumi.getter(name="localDestinationRealCidrs")
    def local_destination_real_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Local Initiated Traffic Destination Real CIDRs.
        """
        return pulumi.get(self, "local_destination_real_cidrs")

    @local_destination_real_cidrs.setter
    def local_destination_real_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "local_destination_real_cidrs", value)

    @property
    @pulumi.getter(name="localDestinationVirtualCidrs")
    def local_destination_virtual_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Local Initiated Traffic Destination Virtual CIDRs.
        """
        return pulumi.get(self, "local_destination_virtual_cidrs")

    @local_destination_virtual_cidrs.setter
    def local_destination_virtual_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "local_destination_virtual_cidrs", value)

    @property
    @pulumi.getter(name="localSourceRealCidrs")
    def local_source_real_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Local Initiated Traffic Source Real CIDRs.
        """
        return pulumi.get(self, "local_source_real_cidrs")

    @local_source_real_cidrs.setter
    def local_source_real_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "local_source_real_cidrs", value)

    @property
    @pulumi.getter(name="localSourceVirtualCidrs")
    def local_source_virtual_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Local Initiated Traffic Source Virtual CIDRs.
        """
        return pulumi.get(self, "local_source_virtual_cidrs")

    @local_source_virtual_cidrs.setter
    def local_source_virtual_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "local_source_virtual_cidrs", value)

    @property
    @pulumi.getter(name="localSubnetCidr")
    def local_subnet_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Local Subnet CIDR.
        """
        return pulumi.get(self, "local_subnet_cidr")

    @local_subnet_cidr.setter
    def local_subnet_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_subnet_cidr", value)

    @property
    @pulumi.getter(name="localSubnetVirtual")
    def local_subnet_virtual(self) -> Optional[pulumi.Input[str]]:
        """
        Local Subnet CIDR (Virtual).
        """
        return pulumi.get(self, "local_subnet_virtual")

    @local_subnet_virtual.setter
    def local_subnet_virtual(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_subnet_virtual", value)

    @property
    @pulumi.getter(name="localTunnelIp")
    def local_tunnel_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Local tunnel IP address.
        """
        return pulumi.get(self, "local_tunnel_ip")

    @local_tunnel_ip.setter
    def local_tunnel_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_tunnel_ip", value)

    @property
    @pulumi.getter(name="phase1Authentication")
    def phase1_authentication(self) -> Optional[pulumi.Input[str]]:
        """
        Phase one Authentication. Valid values: 'SHA-1', 'SHA-256', 'SHA-384' and 'SHA-512'.
        """
        return pulumi.get(self, "phase1_authentication")

    @phase1_authentication.setter
    def phase1_authentication(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase1_authentication", value)

    @property
    @pulumi.getter(name="phase1DhGroups")
    def phase1_dh_groups(self) -> Optional[pulumi.Input[str]]:
        """
        Phase one DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        """
        return pulumi.get(self, "phase1_dh_groups")

    @phase1_dh_groups.setter
    def phase1_dh_groups(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase1_dh_groups", value)

    @property
    @pulumi.getter(name="phase1Encryption")
    def phase1_encryption(self) -> Optional[pulumi.Input[str]]:
        """
        Phase one Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC' and 'AES-256-CBC', 'AES-128-GCM-64',
        'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', and 'AES-256-GCM-128'.
        """
        return pulumi.get(self, "phase1_encryption")

    @phase1_encryption.setter
    def phase1_encryption(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase1_encryption", value)

    @property
    @pulumi.getter(name="phase1RemoteIdentifiers")
    def phase1_remote_identifiers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Phase 1 remote identifier of the IPsec tunnel.
        """
        return pulumi.get(self, "phase1_remote_identifiers")

    @phase1_remote_identifiers.setter
    def phase1_remote_identifiers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "phase1_remote_identifiers", value)

    @property
    @pulumi.getter(name="phase2Authentication")
    def phase2_authentication(self) -> Optional[pulumi.Input[str]]:
        """
        Phase two Authentication. Valid values: 'NO-AUTH', 'HMAC-SHA-1', 'HMAC-SHA-256', 'HMAC-SHA-384' and 'HMAC-SHA-512'.
        """
        return pulumi.get(self, "phase2_authentication")

    @phase2_authentication.setter
    def phase2_authentication(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase2_authentication", value)

    @property
    @pulumi.getter(name="phase2DhGroups")
    def phase2_dh_groups(self) -> Optional[pulumi.Input[str]]:
        """
        Phase two DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        """
        return pulumi.get(self, "phase2_dh_groups")

    @phase2_dh_groups.setter
    def phase2_dh_groups(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase2_dh_groups", value)

    @property
    @pulumi.getter(name="phase2Encryption")
    def phase2_encryption(self) -> Optional[pulumi.Input[str]]:
        """
        Phase two Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC', 'AES-256-CBC', 'AES-128-GCM-64',
        'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', 'AES-256-GCM-128', and 'NULL-ENCR'.
        """
        return pulumi.get(self, "phase2_encryption")

    @phase2_encryption.setter
    def phase2_encryption(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase2_encryption", value)

    @property
    @pulumi.getter(name="preSharedKey")
    def pre_shared_key(self) -> Optional[pulumi.Input[str]]:
        """
        Pre-Shared Key.
        """
        return pulumi.get(self, "pre_shared_key")

    @pre_shared_key.setter
    def pre_shared_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pre_shared_key", value)

    @property
    @pulumi.getter(name="privateRouteEncryption")
    def private_route_encryption(self) -> Optional[pulumi.Input[bool]]:
        """
        Private route encryption switch.
        """
        return pulumi.get(self, "private_route_encryption")

    @private_route_encryption.setter
    def private_route_encryption(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "private_route_encryption", value)

    @property
    @pulumi.getter(name="remoteDestinationRealCidrs")
    def remote_destination_real_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Remote Initiated Traffic Destination Real CIDRs.
        """
        return pulumi.get(self, "remote_destination_real_cidrs")

    @remote_destination_real_cidrs.setter
    def remote_destination_real_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "remote_destination_real_cidrs", value)

    @property
    @pulumi.getter(name="remoteDestinationVirtualCidrs")
    def remote_destination_virtual_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Remote Initiated Traffic Destination Virtual CIDRs.
        """
        return pulumi.get(self, "remote_destination_virtual_cidrs")

    @remote_destination_virtual_cidrs.setter
    def remote_destination_virtual_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "remote_destination_virtual_cidrs", value)

    @property
    @pulumi.getter(name="remoteGatewayLatitude")
    def remote_gateway_latitude(self) -> Optional[pulumi.Input[float]]:
        """
        Latitude of remote gateway.
        """
        return pulumi.get(self, "remote_gateway_latitude")

    @remote_gateway_latitude.setter
    def remote_gateway_latitude(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "remote_gateway_latitude", value)

    @property
    @pulumi.getter(name="remoteGatewayLongitude")
    def remote_gateway_longitude(self) -> Optional[pulumi.Input[float]]:
        """
        Longitude of remote gateway.
        """
        return pulumi.get(self, "remote_gateway_longitude")

    @remote_gateway_longitude.setter
    def remote_gateway_longitude(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "remote_gateway_longitude", value)

    @property
    @pulumi.getter(name="remoteIdentifier")
    def remote_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Remote identifier. Required for Cert based authentication type.
        """
        return pulumi.get(self, "remote_identifier")

    @remote_identifier.setter
    def remote_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_identifier", value)

    @property
    @pulumi.getter(name="remoteSourceRealCidrs")
    def remote_source_real_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Remote Initiated Traffic Source Real CIDRs.
        """
        return pulumi.get(self, "remote_source_real_cidrs")

    @remote_source_real_cidrs.setter
    def remote_source_real_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "remote_source_real_cidrs", value)

    @property
    @pulumi.getter(name="remoteSourceVirtualCidrs")
    def remote_source_virtual_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Remote Initiated Traffic Source Virtual CIDRs.
        """
        return pulumi.get(self, "remote_source_virtual_cidrs")

    @remote_source_virtual_cidrs.setter
    def remote_source_virtual_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "remote_source_virtual_cidrs", value)

    @property
    @pulumi.getter(name="remoteSubnetCidr")
    def remote_subnet_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Remote Subnet CIDR.
        """
        return pulumi.get(self, "remote_subnet_cidr")

    @remote_subnet_cidr.setter
    def remote_subnet_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_subnet_cidr", value)

    @property
    @pulumi.getter(name="remoteSubnetVirtual")
    def remote_subnet_virtual(self) -> Optional[pulumi.Input[str]]:
        """
        Remote Subnet CIDR (Virtual).
        """
        return pulumi.get(self, "remote_subnet_virtual")

    @remote_subnet_virtual.setter
    def remote_subnet_virtual(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_subnet_virtual", value)

    @property
    @pulumi.getter(name="remoteTunnelIp")
    def remote_tunnel_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Remote tunnel IP address.
        """
        return pulumi.get(self, "remote_tunnel_ip")

    @remote_tunnel_ip.setter
    def remote_tunnel_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_tunnel_ip", value)

    @property
    @pulumi.getter(name="routeTableLists")
    def route_table_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Route tables to modify.
        """
        return pulumi.get(self, "route_table_lists")

    @route_table_lists.setter
    def route_table_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "route_table_lists", value)

    @property
    @pulumi.getter(name="sslServerPool")
    def ssl_server_pool(self) -> Optional[pulumi.Input[str]]:
        """
        Specify ssl_server_pool for tunnel_type 'tcp'. Default value is '192.168.44.0/24'
        """
        return pulumi.get(self, "ssl_server_pool")

    @ssl_server_pool.setter
    def ssl_server_pool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_server_pool", value)


@pulumi.input_type
class _AviatrixSite2CloudState:
    def __init__(__self__, *,
                 auth_type: Optional[pulumi.Input[str]] = None,
                 backup_gateway_name: Optional[pulumi.Input[str]] = None,
                 backup_local_tunnel_ip: Optional[pulumi.Input[str]] = None,
                 backup_pre_shared_key: Optional[pulumi.Input[str]] = None,
                 backup_remote_gateway_ip: Optional[pulumi.Input[str]] = None,
                 backup_remote_gateway_latitude: Optional[pulumi.Input[float]] = None,
                 backup_remote_gateway_longitude: Optional[pulumi.Input[float]] = None,
                 backup_remote_identifier: Optional[pulumi.Input[str]] = None,
                 backup_remote_tunnel_ip: Optional[pulumi.Input[str]] = None,
                 ca_cert_tag_name: Optional[pulumi.Input[str]] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 connection_type: Optional[pulumi.Input[str]] = None,
                 custom_algorithms: Optional[pulumi.Input[bool]] = None,
                 custom_mapped: Optional[pulumi.Input[bool]] = None,
                 enable_active_active: Optional[pulumi.Input[bool]] = None,
                 enable_dead_peer_detection: Optional[pulumi.Input[bool]] = None,
                 enable_event_triggered_ha: Optional[pulumi.Input[bool]] = None,
                 enable_ikev2: Optional[pulumi.Input[bool]] = None,
                 enable_single_ip_ha: Optional[pulumi.Input[bool]] = None,
                 forward_traffic_to_transit: Optional[pulumi.Input[bool]] = None,
                 ha_enabled: Optional[pulumi.Input[bool]] = None,
                 local_destination_real_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 local_destination_virtual_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 local_source_real_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 local_source_virtual_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 local_subnet_cidr: Optional[pulumi.Input[str]] = None,
                 local_subnet_virtual: Optional[pulumi.Input[str]] = None,
                 local_tunnel_ip: Optional[pulumi.Input[str]] = None,
                 phase1_authentication: Optional[pulumi.Input[str]] = None,
                 phase1_dh_groups: Optional[pulumi.Input[str]] = None,
                 phase1_encryption: Optional[pulumi.Input[str]] = None,
                 phase1_remote_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 phase2_authentication: Optional[pulumi.Input[str]] = None,
                 phase2_dh_groups: Optional[pulumi.Input[str]] = None,
                 phase2_encryption: Optional[pulumi.Input[str]] = None,
                 pre_shared_key: Optional[pulumi.Input[str]] = None,
                 primary_cloud_gateway_name: Optional[pulumi.Input[str]] = None,
                 private_route_encryption: Optional[pulumi.Input[bool]] = None,
                 remote_destination_real_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remote_destination_virtual_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remote_gateway_ip: Optional[pulumi.Input[str]] = None,
                 remote_gateway_latitude: Optional[pulumi.Input[float]] = None,
                 remote_gateway_longitude: Optional[pulumi.Input[float]] = None,
                 remote_gateway_type: Optional[pulumi.Input[str]] = None,
                 remote_identifier: Optional[pulumi.Input[str]] = None,
                 remote_source_real_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remote_source_virtual_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remote_subnet_cidr: Optional[pulumi.Input[str]] = None,
                 remote_subnet_virtual: Optional[pulumi.Input[str]] = None,
                 remote_tunnel_ip: Optional[pulumi.Input[str]] = None,
                 route_table_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ssl_server_pool: Optional[pulumi.Input[str]] = None,
                 tunnel_type: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixSite2Cloud resources.
        :param pulumi.Input[str] auth_type: Authentication Type. Valid values: 'PSK' and 'Cert'. Default value: 'PSK'.
        :param pulumi.Input[str] backup_gateway_name: Backup gateway name.
        :param pulumi.Input[str] backup_local_tunnel_ip: Backup local tunnel IP address.
        :param pulumi.Input[str] backup_pre_shared_key: Backup Pre-Shared Key.
        :param pulumi.Input[str] backup_remote_gateway_ip: Backup remote remote gateway IP.
        :param pulumi.Input[float] backup_remote_gateway_latitude: Latitude of backup remote gateway.
        :param pulumi.Input[float] backup_remote_gateway_longitude: Longitude of backup remote gateway.
        :param pulumi.Input[str] backup_remote_identifier: Backup remote identifier. Required for Cert based authentication type with HA enabled.
        :param pulumi.Input[str] backup_remote_tunnel_ip: Backup remote tunnel IP address.
        :param pulumi.Input[str] ca_cert_tag_name: Name of Remote CA Certificate Tag for creating Site2Cloud tunnels. Required for Cert based authentication type.
        :param pulumi.Input[str] connection_name: Site2Cloud Connection Name.
        :param pulumi.Input[str] connection_type: Connection Type. Valid values: 'mapped' and 'unmapped'.
        :param pulumi.Input[bool] custom_algorithms: Switch to enable custom/non-default algorithms for IPSec Authentication/Encryption.
        :param pulumi.Input[bool] custom_mapped: Enable custom mapped.
        :param pulumi.Input[bool] enable_active_active: Switch to Enable/Disable active_active_ha for an existing site2cloud connection.
        :param pulumi.Input[bool] enable_dead_peer_detection: Switch to Enable/Disable Deed Peer Detection for an existing site2cloud connection.
        :param pulumi.Input[bool] enable_event_triggered_ha: Enable Event Triggered HA.
        :param pulumi.Input[bool] enable_ikev2: Switch to enable IKEv2 for policy based site2cloud.
        :param pulumi.Input[bool] enable_single_ip_ha: Enable single IP HA on a site2cloud connection.
        :param pulumi.Input[bool] forward_traffic_to_transit: Enable spoke gateway with mapped site2cloud configurations to forward traffic from site2cloud connection to Aviatrix
               Transit Gateway.
        :param pulumi.Input[bool] ha_enabled: Specify whether enabling HA or not.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_destination_real_cidrs: Local Initiated Traffic Destination Real CIDRs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_destination_virtual_cidrs: Local Initiated Traffic Destination Virtual CIDRs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_source_real_cidrs: Local Initiated Traffic Source Real CIDRs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_source_virtual_cidrs: Local Initiated Traffic Source Virtual CIDRs.
        :param pulumi.Input[str] local_subnet_cidr: Local Subnet CIDR.
        :param pulumi.Input[str] local_subnet_virtual: Local Subnet CIDR (Virtual).
        :param pulumi.Input[str] local_tunnel_ip: Local tunnel IP address.
        :param pulumi.Input[str] phase1_authentication: Phase one Authentication. Valid values: 'SHA-1', 'SHA-256', 'SHA-384' and 'SHA-512'.
        :param pulumi.Input[str] phase1_dh_groups: Phase one DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        :param pulumi.Input[str] phase1_encryption: Phase one Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC' and 'AES-256-CBC', 'AES-128-GCM-64',
               'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', and 'AES-256-GCM-128'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] phase1_remote_identifiers: Phase 1 remote identifier of the IPsec tunnel.
        :param pulumi.Input[str] phase2_authentication: Phase two Authentication. Valid values: 'NO-AUTH', 'HMAC-SHA-1', 'HMAC-SHA-256', 'HMAC-SHA-384' and 'HMAC-SHA-512'.
        :param pulumi.Input[str] phase2_dh_groups: Phase two DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        :param pulumi.Input[str] phase2_encryption: Phase two Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC', 'AES-256-CBC', 'AES-128-GCM-64',
               'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', 'AES-256-GCM-128', and 'NULL-ENCR'.
        :param pulumi.Input[str] pre_shared_key: Pre-Shared Key.
        :param pulumi.Input[str] primary_cloud_gateway_name: Primary Cloud Gateway Name.
        :param pulumi.Input[bool] private_route_encryption: Private route encryption switch.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_destination_real_cidrs: Remote Initiated Traffic Destination Real CIDRs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_destination_virtual_cidrs: Remote Initiated Traffic Destination Virtual CIDRs.
        :param pulumi.Input[str] remote_gateway_ip: Remote Gateway IP.
        :param pulumi.Input[float] remote_gateway_latitude: Latitude of remote gateway.
        :param pulumi.Input[float] remote_gateway_longitude: Longitude of remote gateway.
        :param pulumi.Input[str] remote_gateway_type: Remote gateway type. Valid values: 'generic', 'avx', 'aws', 'azure', 'sonicwall' and 'oracle'.
        :param pulumi.Input[str] remote_identifier: Remote identifier. Required for Cert based authentication type.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_source_real_cidrs: Remote Initiated Traffic Source Real CIDRs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_source_virtual_cidrs: Remote Initiated Traffic Source Virtual CIDRs.
        :param pulumi.Input[str] remote_subnet_cidr: Remote Subnet CIDR.
        :param pulumi.Input[str] remote_subnet_virtual: Remote Subnet CIDR (Virtual).
        :param pulumi.Input[str] remote_tunnel_ip: Remote tunnel IP address.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] route_table_lists: Route tables to modify.
        :param pulumi.Input[str] ssl_server_pool: Specify ssl_server_pool for tunnel_type 'tcp'. Default value is '192.168.44.0/24'
        :param pulumi.Input[str] tunnel_type: Site2Cloud Tunnel Type. Valid values: 'policy' and 'route'.
        :param pulumi.Input[str] vpc_id: VPC Id of the cloud gateway.
        """
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if backup_gateway_name is not None:
            pulumi.set(__self__, "backup_gateway_name", backup_gateway_name)
        if backup_local_tunnel_ip is not None:
            pulumi.set(__self__, "backup_local_tunnel_ip", backup_local_tunnel_ip)
        if backup_pre_shared_key is not None:
            pulumi.set(__self__, "backup_pre_shared_key", backup_pre_shared_key)
        if backup_remote_gateway_ip is not None:
            pulumi.set(__self__, "backup_remote_gateway_ip", backup_remote_gateway_ip)
        if backup_remote_gateway_latitude is not None:
            pulumi.set(__self__, "backup_remote_gateway_latitude", backup_remote_gateway_latitude)
        if backup_remote_gateway_longitude is not None:
            pulumi.set(__self__, "backup_remote_gateway_longitude", backup_remote_gateway_longitude)
        if backup_remote_identifier is not None:
            pulumi.set(__self__, "backup_remote_identifier", backup_remote_identifier)
        if backup_remote_tunnel_ip is not None:
            pulumi.set(__self__, "backup_remote_tunnel_ip", backup_remote_tunnel_ip)
        if ca_cert_tag_name is not None:
            pulumi.set(__self__, "ca_cert_tag_name", ca_cert_tag_name)
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if custom_algorithms is not None:
            pulumi.set(__self__, "custom_algorithms", custom_algorithms)
        if custom_mapped is not None:
            pulumi.set(__self__, "custom_mapped", custom_mapped)
        if enable_active_active is not None:
            pulumi.set(__self__, "enable_active_active", enable_active_active)
        if enable_dead_peer_detection is not None:
            pulumi.set(__self__, "enable_dead_peer_detection", enable_dead_peer_detection)
        if enable_event_triggered_ha is not None:
            pulumi.set(__self__, "enable_event_triggered_ha", enable_event_triggered_ha)
        if enable_ikev2 is not None:
            pulumi.set(__self__, "enable_ikev2", enable_ikev2)
        if enable_single_ip_ha is not None:
            pulumi.set(__self__, "enable_single_ip_ha", enable_single_ip_ha)
        if forward_traffic_to_transit is not None:
            pulumi.set(__self__, "forward_traffic_to_transit", forward_traffic_to_transit)
        if ha_enabled is not None:
            pulumi.set(__self__, "ha_enabled", ha_enabled)
        if local_destination_real_cidrs is not None:
            pulumi.set(__self__, "local_destination_real_cidrs", local_destination_real_cidrs)
        if local_destination_virtual_cidrs is not None:
            pulumi.set(__self__, "local_destination_virtual_cidrs", local_destination_virtual_cidrs)
        if local_source_real_cidrs is not None:
            pulumi.set(__self__, "local_source_real_cidrs", local_source_real_cidrs)
        if local_source_virtual_cidrs is not None:
            pulumi.set(__self__, "local_source_virtual_cidrs", local_source_virtual_cidrs)
        if local_subnet_cidr is not None:
            pulumi.set(__self__, "local_subnet_cidr", local_subnet_cidr)
        if local_subnet_virtual is not None:
            pulumi.set(__self__, "local_subnet_virtual", local_subnet_virtual)
        if local_tunnel_ip is not None:
            pulumi.set(__self__, "local_tunnel_ip", local_tunnel_ip)
        if phase1_authentication is not None:
            pulumi.set(__self__, "phase1_authentication", phase1_authentication)
        if phase1_dh_groups is not None:
            pulumi.set(__self__, "phase1_dh_groups", phase1_dh_groups)
        if phase1_encryption is not None:
            pulumi.set(__self__, "phase1_encryption", phase1_encryption)
        if phase1_remote_identifiers is not None:
            pulumi.set(__self__, "phase1_remote_identifiers", phase1_remote_identifiers)
        if phase2_authentication is not None:
            pulumi.set(__self__, "phase2_authentication", phase2_authentication)
        if phase2_dh_groups is not None:
            pulumi.set(__self__, "phase2_dh_groups", phase2_dh_groups)
        if phase2_encryption is not None:
            pulumi.set(__self__, "phase2_encryption", phase2_encryption)
        if pre_shared_key is not None:
            pulumi.set(__self__, "pre_shared_key", pre_shared_key)
        if primary_cloud_gateway_name is not None:
            pulumi.set(__self__, "primary_cloud_gateway_name", primary_cloud_gateway_name)
        if private_route_encryption is not None:
            pulumi.set(__self__, "private_route_encryption", private_route_encryption)
        if remote_destination_real_cidrs is not None:
            pulumi.set(__self__, "remote_destination_real_cidrs", remote_destination_real_cidrs)
        if remote_destination_virtual_cidrs is not None:
            pulumi.set(__self__, "remote_destination_virtual_cidrs", remote_destination_virtual_cidrs)
        if remote_gateway_ip is not None:
            pulumi.set(__self__, "remote_gateway_ip", remote_gateway_ip)
        if remote_gateway_latitude is not None:
            pulumi.set(__self__, "remote_gateway_latitude", remote_gateway_latitude)
        if remote_gateway_longitude is not None:
            pulumi.set(__self__, "remote_gateway_longitude", remote_gateway_longitude)
        if remote_gateway_type is not None:
            pulumi.set(__self__, "remote_gateway_type", remote_gateway_type)
        if remote_identifier is not None:
            pulumi.set(__self__, "remote_identifier", remote_identifier)
        if remote_source_real_cidrs is not None:
            pulumi.set(__self__, "remote_source_real_cidrs", remote_source_real_cidrs)
        if remote_source_virtual_cidrs is not None:
            pulumi.set(__self__, "remote_source_virtual_cidrs", remote_source_virtual_cidrs)
        if remote_subnet_cidr is not None:
            pulumi.set(__self__, "remote_subnet_cidr", remote_subnet_cidr)
        if remote_subnet_virtual is not None:
            pulumi.set(__self__, "remote_subnet_virtual", remote_subnet_virtual)
        if remote_tunnel_ip is not None:
            pulumi.set(__self__, "remote_tunnel_ip", remote_tunnel_ip)
        if route_table_lists is not None:
            pulumi.set(__self__, "route_table_lists", route_table_lists)
        if ssl_server_pool is not None:
            pulumi.set(__self__, "ssl_server_pool", ssl_server_pool)
        if tunnel_type is not None:
            pulumi.set(__self__, "tunnel_type", tunnel_type)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[pulumi.Input[str]]:
        """
        Authentication Type. Valid values: 'PSK' and 'Cert'. Default value: 'PSK'.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter(name="backupGatewayName")
    def backup_gateway_name(self) -> Optional[pulumi.Input[str]]:
        """
        Backup gateway name.
        """
        return pulumi.get(self, "backup_gateway_name")

    @backup_gateway_name.setter
    def backup_gateway_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_gateway_name", value)

    @property
    @pulumi.getter(name="backupLocalTunnelIp")
    def backup_local_tunnel_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Backup local tunnel IP address.
        """
        return pulumi.get(self, "backup_local_tunnel_ip")

    @backup_local_tunnel_ip.setter
    def backup_local_tunnel_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_local_tunnel_ip", value)

    @property
    @pulumi.getter(name="backupPreSharedKey")
    def backup_pre_shared_key(self) -> Optional[pulumi.Input[str]]:
        """
        Backup Pre-Shared Key.
        """
        return pulumi.get(self, "backup_pre_shared_key")

    @backup_pre_shared_key.setter
    def backup_pre_shared_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_pre_shared_key", value)

    @property
    @pulumi.getter(name="backupRemoteGatewayIp")
    def backup_remote_gateway_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Backup remote remote gateway IP.
        """
        return pulumi.get(self, "backup_remote_gateway_ip")

    @backup_remote_gateway_ip.setter
    def backup_remote_gateway_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_remote_gateway_ip", value)

    @property
    @pulumi.getter(name="backupRemoteGatewayLatitude")
    def backup_remote_gateway_latitude(self) -> Optional[pulumi.Input[float]]:
        """
        Latitude of backup remote gateway.
        """
        return pulumi.get(self, "backup_remote_gateway_latitude")

    @backup_remote_gateway_latitude.setter
    def backup_remote_gateway_latitude(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "backup_remote_gateway_latitude", value)

    @property
    @pulumi.getter(name="backupRemoteGatewayLongitude")
    def backup_remote_gateway_longitude(self) -> Optional[pulumi.Input[float]]:
        """
        Longitude of backup remote gateway.
        """
        return pulumi.get(self, "backup_remote_gateway_longitude")

    @backup_remote_gateway_longitude.setter
    def backup_remote_gateway_longitude(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "backup_remote_gateway_longitude", value)

    @property
    @pulumi.getter(name="backupRemoteIdentifier")
    def backup_remote_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Backup remote identifier. Required for Cert based authentication type with HA enabled.
        """
        return pulumi.get(self, "backup_remote_identifier")

    @backup_remote_identifier.setter
    def backup_remote_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_remote_identifier", value)

    @property
    @pulumi.getter(name="backupRemoteTunnelIp")
    def backup_remote_tunnel_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Backup remote tunnel IP address.
        """
        return pulumi.get(self, "backup_remote_tunnel_ip")

    @backup_remote_tunnel_ip.setter
    def backup_remote_tunnel_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_remote_tunnel_ip", value)

    @property
    @pulumi.getter(name="caCertTagName")
    def ca_cert_tag_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of Remote CA Certificate Tag for creating Site2Cloud tunnels. Required for Cert based authentication type.
        """
        return pulumi.get(self, "ca_cert_tag_name")

    @ca_cert_tag_name.setter
    def ca_cert_tag_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_cert_tag_name", value)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        Site2Cloud Connection Name.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[pulumi.Input[str]]:
        """
        Connection Type. Valid values: 'mapped' and 'unmapped'.
        """
        return pulumi.get(self, "connection_type")

    @connection_type.setter
    def connection_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_type", value)

    @property
    @pulumi.getter(name="customAlgorithms")
    def custom_algorithms(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable custom/non-default algorithms for IPSec Authentication/Encryption.
        """
        return pulumi.get(self, "custom_algorithms")

    @custom_algorithms.setter
    def custom_algorithms(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "custom_algorithms", value)

    @property
    @pulumi.getter(name="customMapped")
    def custom_mapped(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable custom mapped.
        """
        return pulumi.get(self, "custom_mapped")

    @custom_mapped.setter
    def custom_mapped(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "custom_mapped", value)

    @property
    @pulumi.getter(name="enableActiveActive")
    def enable_active_active(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to Enable/Disable active_active_ha for an existing site2cloud connection.
        """
        return pulumi.get(self, "enable_active_active")

    @enable_active_active.setter
    def enable_active_active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_active_active", value)

    @property
    @pulumi.getter(name="enableDeadPeerDetection")
    def enable_dead_peer_detection(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to Enable/Disable Deed Peer Detection for an existing site2cloud connection.
        """
        return pulumi.get(self, "enable_dead_peer_detection")

    @enable_dead_peer_detection.setter
    def enable_dead_peer_detection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_dead_peer_detection", value)

    @property
    @pulumi.getter(name="enableEventTriggeredHa")
    def enable_event_triggered_ha(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Event Triggered HA.
        """
        return pulumi.get(self, "enable_event_triggered_ha")

    @enable_event_triggered_ha.setter
    def enable_event_triggered_ha(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_event_triggered_ha", value)

    @property
    @pulumi.getter(name="enableIkev2")
    def enable_ikev2(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable IKEv2 for policy based site2cloud.
        """
        return pulumi.get(self, "enable_ikev2")

    @enable_ikev2.setter
    def enable_ikev2(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ikev2", value)

    @property
    @pulumi.getter(name="enableSingleIpHa")
    def enable_single_ip_ha(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable single IP HA on a site2cloud connection.
        """
        return pulumi.get(self, "enable_single_ip_ha")

    @enable_single_ip_ha.setter
    def enable_single_ip_ha(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_single_ip_ha", value)

    @property
    @pulumi.getter(name="forwardTrafficToTransit")
    def forward_traffic_to_transit(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable spoke gateway with mapped site2cloud configurations to forward traffic from site2cloud connection to Aviatrix
        Transit Gateway.
        """
        return pulumi.get(self, "forward_traffic_to_transit")

    @forward_traffic_to_transit.setter
    def forward_traffic_to_transit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "forward_traffic_to_transit", value)

    @property
    @pulumi.getter(name="haEnabled")
    def ha_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify whether enabling HA or not.
        """
        return pulumi.get(self, "ha_enabled")

    @ha_enabled.setter
    def ha_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ha_enabled", value)

    @property
    @pulumi.getter(name="localDestinationRealCidrs")
    def local_destination_real_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Local Initiated Traffic Destination Real CIDRs.
        """
        return pulumi.get(self, "local_destination_real_cidrs")

    @local_destination_real_cidrs.setter
    def local_destination_real_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "local_destination_real_cidrs", value)

    @property
    @pulumi.getter(name="localDestinationVirtualCidrs")
    def local_destination_virtual_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Local Initiated Traffic Destination Virtual CIDRs.
        """
        return pulumi.get(self, "local_destination_virtual_cidrs")

    @local_destination_virtual_cidrs.setter
    def local_destination_virtual_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "local_destination_virtual_cidrs", value)

    @property
    @pulumi.getter(name="localSourceRealCidrs")
    def local_source_real_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Local Initiated Traffic Source Real CIDRs.
        """
        return pulumi.get(self, "local_source_real_cidrs")

    @local_source_real_cidrs.setter
    def local_source_real_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "local_source_real_cidrs", value)

    @property
    @pulumi.getter(name="localSourceVirtualCidrs")
    def local_source_virtual_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Local Initiated Traffic Source Virtual CIDRs.
        """
        return pulumi.get(self, "local_source_virtual_cidrs")

    @local_source_virtual_cidrs.setter
    def local_source_virtual_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "local_source_virtual_cidrs", value)

    @property
    @pulumi.getter(name="localSubnetCidr")
    def local_subnet_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Local Subnet CIDR.
        """
        return pulumi.get(self, "local_subnet_cidr")

    @local_subnet_cidr.setter
    def local_subnet_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_subnet_cidr", value)

    @property
    @pulumi.getter(name="localSubnetVirtual")
    def local_subnet_virtual(self) -> Optional[pulumi.Input[str]]:
        """
        Local Subnet CIDR (Virtual).
        """
        return pulumi.get(self, "local_subnet_virtual")

    @local_subnet_virtual.setter
    def local_subnet_virtual(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_subnet_virtual", value)

    @property
    @pulumi.getter(name="localTunnelIp")
    def local_tunnel_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Local tunnel IP address.
        """
        return pulumi.get(self, "local_tunnel_ip")

    @local_tunnel_ip.setter
    def local_tunnel_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_tunnel_ip", value)

    @property
    @pulumi.getter(name="phase1Authentication")
    def phase1_authentication(self) -> Optional[pulumi.Input[str]]:
        """
        Phase one Authentication. Valid values: 'SHA-1', 'SHA-256', 'SHA-384' and 'SHA-512'.
        """
        return pulumi.get(self, "phase1_authentication")

    @phase1_authentication.setter
    def phase1_authentication(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase1_authentication", value)

    @property
    @pulumi.getter(name="phase1DhGroups")
    def phase1_dh_groups(self) -> Optional[pulumi.Input[str]]:
        """
        Phase one DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        """
        return pulumi.get(self, "phase1_dh_groups")

    @phase1_dh_groups.setter
    def phase1_dh_groups(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase1_dh_groups", value)

    @property
    @pulumi.getter(name="phase1Encryption")
    def phase1_encryption(self) -> Optional[pulumi.Input[str]]:
        """
        Phase one Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC' and 'AES-256-CBC', 'AES-128-GCM-64',
        'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', and 'AES-256-GCM-128'.
        """
        return pulumi.get(self, "phase1_encryption")

    @phase1_encryption.setter
    def phase1_encryption(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase1_encryption", value)

    @property
    @pulumi.getter(name="phase1RemoteIdentifiers")
    def phase1_remote_identifiers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Phase 1 remote identifier of the IPsec tunnel.
        """
        return pulumi.get(self, "phase1_remote_identifiers")

    @phase1_remote_identifiers.setter
    def phase1_remote_identifiers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "phase1_remote_identifiers", value)

    @property
    @pulumi.getter(name="phase2Authentication")
    def phase2_authentication(self) -> Optional[pulumi.Input[str]]:
        """
        Phase two Authentication. Valid values: 'NO-AUTH', 'HMAC-SHA-1', 'HMAC-SHA-256', 'HMAC-SHA-384' and 'HMAC-SHA-512'.
        """
        return pulumi.get(self, "phase2_authentication")

    @phase2_authentication.setter
    def phase2_authentication(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase2_authentication", value)

    @property
    @pulumi.getter(name="phase2DhGroups")
    def phase2_dh_groups(self) -> Optional[pulumi.Input[str]]:
        """
        Phase two DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        """
        return pulumi.get(self, "phase2_dh_groups")

    @phase2_dh_groups.setter
    def phase2_dh_groups(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase2_dh_groups", value)

    @property
    @pulumi.getter(name="phase2Encryption")
    def phase2_encryption(self) -> Optional[pulumi.Input[str]]:
        """
        Phase two Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC', 'AES-256-CBC', 'AES-128-GCM-64',
        'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', 'AES-256-GCM-128', and 'NULL-ENCR'.
        """
        return pulumi.get(self, "phase2_encryption")

    @phase2_encryption.setter
    def phase2_encryption(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "phase2_encryption", value)

    @property
    @pulumi.getter(name="preSharedKey")
    def pre_shared_key(self) -> Optional[pulumi.Input[str]]:
        """
        Pre-Shared Key.
        """
        return pulumi.get(self, "pre_shared_key")

    @pre_shared_key.setter
    def pre_shared_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pre_shared_key", value)

    @property
    @pulumi.getter(name="primaryCloudGatewayName")
    def primary_cloud_gateway_name(self) -> Optional[pulumi.Input[str]]:
        """
        Primary Cloud Gateway Name.
        """
        return pulumi.get(self, "primary_cloud_gateway_name")

    @primary_cloud_gateway_name.setter
    def primary_cloud_gateway_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_cloud_gateway_name", value)

    @property
    @pulumi.getter(name="privateRouteEncryption")
    def private_route_encryption(self) -> Optional[pulumi.Input[bool]]:
        """
        Private route encryption switch.
        """
        return pulumi.get(self, "private_route_encryption")

    @private_route_encryption.setter
    def private_route_encryption(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "private_route_encryption", value)

    @property
    @pulumi.getter(name="remoteDestinationRealCidrs")
    def remote_destination_real_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Remote Initiated Traffic Destination Real CIDRs.
        """
        return pulumi.get(self, "remote_destination_real_cidrs")

    @remote_destination_real_cidrs.setter
    def remote_destination_real_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "remote_destination_real_cidrs", value)

    @property
    @pulumi.getter(name="remoteDestinationVirtualCidrs")
    def remote_destination_virtual_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Remote Initiated Traffic Destination Virtual CIDRs.
        """
        return pulumi.get(self, "remote_destination_virtual_cidrs")

    @remote_destination_virtual_cidrs.setter
    def remote_destination_virtual_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "remote_destination_virtual_cidrs", value)

    @property
    @pulumi.getter(name="remoteGatewayIp")
    def remote_gateway_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Remote Gateway IP.
        """
        return pulumi.get(self, "remote_gateway_ip")

    @remote_gateway_ip.setter
    def remote_gateway_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_gateway_ip", value)

    @property
    @pulumi.getter(name="remoteGatewayLatitude")
    def remote_gateway_latitude(self) -> Optional[pulumi.Input[float]]:
        """
        Latitude of remote gateway.
        """
        return pulumi.get(self, "remote_gateway_latitude")

    @remote_gateway_latitude.setter
    def remote_gateway_latitude(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "remote_gateway_latitude", value)

    @property
    @pulumi.getter(name="remoteGatewayLongitude")
    def remote_gateway_longitude(self) -> Optional[pulumi.Input[float]]:
        """
        Longitude of remote gateway.
        """
        return pulumi.get(self, "remote_gateway_longitude")

    @remote_gateway_longitude.setter
    def remote_gateway_longitude(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "remote_gateway_longitude", value)

    @property
    @pulumi.getter(name="remoteGatewayType")
    def remote_gateway_type(self) -> Optional[pulumi.Input[str]]:
        """
        Remote gateway type. Valid values: 'generic', 'avx', 'aws', 'azure', 'sonicwall' and 'oracle'.
        """
        return pulumi.get(self, "remote_gateway_type")

    @remote_gateway_type.setter
    def remote_gateway_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_gateway_type", value)

    @property
    @pulumi.getter(name="remoteIdentifier")
    def remote_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Remote identifier. Required for Cert based authentication type.
        """
        return pulumi.get(self, "remote_identifier")

    @remote_identifier.setter
    def remote_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_identifier", value)

    @property
    @pulumi.getter(name="remoteSourceRealCidrs")
    def remote_source_real_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Remote Initiated Traffic Source Real CIDRs.
        """
        return pulumi.get(self, "remote_source_real_cidrs")

    @remote_source_real_cidrs.setter
    def remote_source_real_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "remote_source_real_cidrs", value)

    @property
    @pulumi.getter(name="remoteSourceVirtualCidrs")
    def remote_source_virtual_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Remote Initiated Traffic Source Virtual CIDRs.
        """
        return pulumi.get(self, "remote_source_virtual_cidrs")

    @remote_source_virtual_cidrs.setter
    def remote_source_virtual_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "remote_source_virtual_cidrs", value)

    @property
    @pulumi.getter(name="remoteSubnetCidr")
    def remote_subnet_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Remote Subnet CIDR.
        """
        return pulumi.get(self, "remote_subnet_cidr")

    @remote_subnet_cidr.setter
    def remote_subnet_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_subnet_cidr", value)

    @property
    @pulumi.getter(name="remoteSubnetVirtual")
    def remote_subnet_virtual(self) -> Optional[pulumi.Input[str]]:
        """
        Remote Subnet CIDR (Virtual).
        """
        return pulumi.get(self, "remote_subnet_virtual")

    @remote_subnet_virtual.setter
    def remote_subnet_virtual(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_subnet_virtual", value)

    @property
    @pulumi.getter(name="remoteTunnelIp")
    def remote_tunnel_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Remote tunnel IP address.
        """
        return pulumi.get(self, "remote_tunnel_ip")

    @remote_tunnel_ip.setter
    def remote_tunnel_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_tunnel_ip", value)

    @property
    @pulumi.getter(name="routeTableLists")
    def route_table_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Route tables to modify.
        """
        return pulumi.get(self, "route_table_lists")

    @route_table_lists.setter
    def route_table_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "route_table_lists", value)

    @property
    @pulumi.getter(name="sslServerPool")
    def ssl_server_pool(self) -> Optional[pulumi.Input[str]]:
        """
        Specify ssl_server_pool for tunnel_type 'tcp'. Default value is '192.168.44.0/24'
        """
        return pulumi.get(self, "ssl_server_pool")

    @ssl_server_pool.setter
    def ssl_server_pool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_server_pool", value)

    @property
    @pulumi.getter(name="tunnelType")
    def tunnel_type(self) -> Optional[pulumi.Input[str]]:
        """
        Site2Cloud Tunnel Type. Valid values: 'policy' and 'route'.
        """
        return pulumi.get(self, "tunnel_type")

    @tunnel_type.setter
    def tunnel_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_type", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        VPC Id of the cloud gateway.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class AviatrixSite2Cloud(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_type: Optional[pulumi.Input[str]] = None,
                 backup_gateway_name: Optional[pulumi.Input[str]] = None,
                 backup_local_tunnel_ip: Optional[pulumi.Input[str]] = None,
                 backup_pre_shared_key: Optional[pulumi.Input[str]] = None,
                 backup_remote_gateway_ip: Optional[pulumi.Input[str]] = None,
                 backup_remote_gateway_latitude: Optional[pulumi.Input[float]] = None,
                 backup_remote_gateway_longitude: Optional[pulumi.Input[float]] = None,
                 backup_remote_identifier: Optional[pulumi.Input[str]] = None,
                 backup_remote_tunnel_ip: Optional[pulumi.Input[str]] = None,
                 ca_cert_tag_name: Optional[pulumi.Input[str]] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 connection_type: Optional[pulumi.Input[str]] = None,
                 custom_algorithms: Optional[pulumi.Input[bool]] = None,
                 custom_mapped: Optional[pulumi.Input[bool]] = None,
                 enable_active_active: Optional[pulumi.Input[bool]] = None,
                 enable_dead_peer_detection: Optional[pulumi.Input[bool]] = None,
                 enable_event_triggered_ha: Optional[pulumi.Input[bool]] = None,
                 enable_ikev2: Optional[pulumi.Input[bool]] = None,
                 enable_single_ip_ha: Optional[pulumi.Input[bool]] = None,
                 forward_traffic_to_transit: Optional[pulumi.Input[bool]] = None,
                 ha_enabled: Optional[pulumi.Input[bool]] = None,
                 local_destination_real_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 local_destination_virtual_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 local_source_real_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 local_source_virtual_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 local_subnet_cidr: Optional[pulumi.Input[str]] = None,
                 local_subnet_virtual: Optional[pulumi.Input[str]] = None,
                 local_tunnel_ip: Optional[pulumi.Input[str]] = None,
                 phase1_authentication: Optional[pulumi.Input[str]] = None,
                 phase1_dh_groups: Optional[pulumi.Input[str]] = None,
                 phase1_encryption: Optional[pulumi.Input[str]] = None,
                 phase1_remote_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 phase2_authentication: Optional[pulumi.Input[str]] = None,
                 phase2_dh_groups: Optional[pulumi.Input[str]] = None,
                 phase2_encryption: Optional[pulumi.Input[str]] = None,
                 pre_shared_key: Optional[pulumi.Input[str]] = None,
                 primary_cloud_gateway_name: Optional[pulumi.Input[str]] = None,
                 private_route_encryption: Optional[pulumi.Input[bool]] = None,
                 remote_destination_real_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remote_destination_virtual_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remote_gateway_ip: Optional[pulumi.Input[str]] = None,
                 remote_gateway_latitude: Optional[pulumi.Input[float]] = None,
                 remote_gateway_longitude: Optional[pulumi.Input[float]] = None,
                 remote_gateway_type: Optional[pulumi.Input[str]] = None,
                 remote_identifier: Optional[pulumi.Input[str]] = None,
                 remote_source_real_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remote_source_virtual_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remote_subnet_cidr: Optional[pulumi.Input[str]] = None,
                 remote_subnet_virtual: Optional[pulumi.Input[str]] = None,
                 remote_tunnel_ip: Optional[pulumi.Input[str]] = None,
                 route_table_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ssl_server_pool: Optional[pulumi.Input[str]] = None,
                 tunnel_type: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AviatrixSite2Cloud resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auth_type: Authentication Type. Valid values: 'PSK' and 'Cert'. Default value: 'PSK'.
        :param pulumi.Input[str] backup_gateway_name: Backup gateway name.
        :param pulumi.Input[str] backup_local_tunnel_ip: Backup local tunnel IP address.
        :param pulumi.Input[str] backup_pre_shared_key: Backup Pre-Shared Key.
        :param pulumi.Input[str] backup_remote_gateway_ip: Backup remote remote gateway IP.
        :param pulumi.Input[float] backup_remote_gateway_latitude: Latitude of backup remote gateway.
        :param pulumi.Input[float] backup_remote_gateway_longitude: Longitude of backup remote gateway.
        :param pulumi.Input[str] backup_remote_identifier: Backup remote identifier. Required for Cert based authentication type with HA enabled.
        :param pulumi.Input[str] backup_remote_tunnel_ip: Backup remote tunnel IP address.
        :param pulumi.Input[str] ca_cert_tag_name: Name of Remote CA Certificate Tag for creating Site2Cloud tunnels. Required for Cert based authentication type.
        :param pulumi.Input[str] connection_name: Site2Cloud Connection Name.
        :param pulumi.Input[str] connection_type: Connection Type. Valid values: 'mapped' and 'unmapped'.
        :param pulumi.Input[bool] custom_algorithms: Switch to enable custom/non-default algorithms for IPSec Authentication/Encryption.
        :param pulumi.Input[bool] custom_mapped: Enable custom mapped.
        :param pulumi.Input[bool] enable_active_active: Switch to Enable/Disable active_active_ha for an existing site2cloud connection.
        :param pulumi.Input[bool] enable_dead_peer_detection: Switch to Enable/Disable Deed Peer Detection for an existing site2cloud connection.
        :param pulumi.Input[bool] enable_event_triggered_ha: Enable Event Triggered HA.
        :param pulumi.Input[bool] enable_ikev2: Switch to enable IKEv2 for policy based site2cloud.
        :param pulumi.Input[bool] enable_single_ip_ha: Enable single IP HA on a site2cloud connection.
        :param pulumi.Input[bool] forward_traffic_to_transit: Enable spoke gateway with mapped site2cloud configurations to forward traffic from site2cloud connection to Aviatrix
               Transit Gateway.
        :param pulumi.Input[bool] ha_enabled: Specify whether enabling HA or not.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_destination_real_cidrs: Local Initiated Traffic Destination Real CIDRs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_destination_virtual_cidrs: Local Initiated Traffic Destination Virtual CIDRs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_source_real_cidrs: Local Initiated Traffic Source Real CIDRs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_source_virtual_cidrs: Local Initiated Traffic Source Virtual CIDRs.
        :param pulumi.Input[str] local_subnet_cidr: Local Subnet CIDR.
        :param pulumi.Input[str] local_subnet_virtual: Local Subnet CIDR (Virtual).
        :param pulumi.Input[str] local_tunnel_ip: Local tunnel IP address.
        :param pulumi.Input[str] phase1_authentication: Phase one Authentication. Valid values: 'SHA-1', 'SHA-256', 'SHA-384' and 'SHA-512'.
        :param pulumi.Input[str] phase1_dh_groups: Phase one DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        :param pulumi.Input[str] phase1_encryption: Phase one Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC' and 'AES-256-CBC', 'AES-128-GCM-64',
               'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', and 'AES-256-GCM-128'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] phase1_remote_identifiers: Phase 1 remote identifier of the IPsec tunnel.
        :param pulumi.Input[str] phase2_authentication: Phase two Authentication. Valid values: 'NO-AUTH', 'HMAC-SHA-1', 'HMAC-SHA-256', 'HMAC-SHA-384' and 'HMAC-SHA-512'.
        :param pulumi.Input[str] phase2_dh_groups: Phase two DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        :param pulumi.Input[str] phase2_encryption: Phase two Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC', 'AES-256-CBC', 'AES-128-GCM-64',
               'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', 'AES-256-GCM-128', and 'NULL-ENCR'.
        :param pulumi.Input[str] pre_shared_key: Pre-Shared Key.
        :param pulumi.Input[str] primary_cloud_gateway_name: Primary Cloud Gateway Name.
        :param pulumi.Input[bool] private_route_encryption: Private route encryption switch.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_destination_real_cidrs: Remote Initiated Traffic Destination Real CIDRs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_destination_virtual_cidrs: Remote Initiated Traffic Destination Virtual CIDRs.
        :param pulumi.Input[str] remote_gateway_ip: Remote Gateway IP.
        :param pulumi.Input[float] remote_gateway_latitude: Latitude of remote gateway.
        :param pulumi.Input[float] remote_gateway_longitude: Longitude of remote gateway.
        :param pulumi.Input[str] remote_gateway_type: Remote gateway type. Valid values: 'generic', 'avx', 'aws', 'azure', 'sonicwall' and 'oracle'.
        :param pulumi.Input[str] remote_identifier: Remote identifier. Required for Cert based authentication type.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_source_real_cidrs: Remote Initiated Traffic Source Real CIDRs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_source_virtual_cidrs: Remote Initiated Traffic Source Virtual CIDRs.
        :param pulumi.Input[str] remote_subnet_cidr: Remote Subnet CIDR.
        :param pulumi.Input[str] remote_subnet_virtual: Remote Subnet CIDR (Virtual).
        :param pulumi.Input[str] remote_tunnel_ip: Remote tunnel IP address.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] route_table_lists: Route tables to modify.
        :param pulumi.Input[str] ssl_server_pool: Specify ssl_server_pool for tunnel_type 'tcp'. Default value is '192.168.44.0/24'
        :param pulumi.Input[str] tunnel_type: Site2Cloud Tunnel Type. Valid values: 'policy' and 'route'.
        :param pulumi.Input[str] vpc_id: VPC Id of the cloud gateway.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixSite2CloudArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixSite2Cloud resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixSite2CloudArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixSite2CloudArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auth_type: Optional[pulumi.Input[str]] = None,
                 backup_gateway_name: Optional[pulumi.Input[str]] = None,
                 backup_local_tunnel_ip: Optional[pulumi.Input[str]] = None,
                 backup_pre_shared_key: Optional[pulumi.Input[str]] = None,
                 backup_remote_gateway_ip: Optional[pulumi.Input[str]] = None,
                 backup_remote_gateway_latitude: Optional[pulumi.Input[float]] = None,
                 backup_remote_gateway_longitude: Optional[pulumi.Input[float]] = None,
                 backup_remote_identifier: Optional[pulumi.Input[str]] = None,
                 backup_remote_tunnel_ip: Optional[pulumi.Input[str]] = None,
                 ca_cert_tag_name: Optional[pulumi.Input[str]] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 connection_type: Optional[pulumi.Input[str]] = None,
                 custom_algorithms: Optional[pulumi.Input[bool]] = None,
                 custom_mapped: Optional[pulumi.Input[bool]] = None,
                 enable_active_active: Optional[pulumi.Input[bool]] = None,
                 enable_dead_peer_detection: Optional[pulumi.Input[bool]] = None,
                 enable_event_triggered_ha: Optional[pulumi.Input[bool]] = None,
                 enable_ikev2: Optional[pulumi.Input[bool]] = None,
                 enable_single_ip_ha: Optional[pulumi.Input[bool]] = None,
                 forward_traffic_to_transit: Optional[pulumi.Input[bool]] = None,
                 ha_enabled: Optional[pulumi.Input[bool]] = None,
                 local_destination_real_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 local_destination_virtual_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 local_source_real_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 local_source_virtual_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 local_subnet_cidr: Optional[pulumi.Input[str]] = None,
                 local_subnet_virtual: Optional[pulumi.Input[str]] = None,
                 local_tunnel_ip: Optional[pulumi.Input[str]] = None,
                 phase1_authentication: Optional[pulumi.Input[str]] = None,
                 phase1_dh_groups: Optional[pulumi.Input[str]] = None,
                 phase1_encryption: Optional[pulumi.Input[str]] = None,
                 phase1_remote_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 phase2_authentication: Optional[pulumi.Input[str]] = None,
                 phase2_dh_groups: Optional[pulumi.Input[str]] = None,
                 phase2_encryption: Optional[pulumi.Input[str]] = None,
                 pre_shared_key: Optional[pulumi.Input[str]] = None,
                 primary_cloud_gateway_name: Optional[pulumi.Input[str]] = None,
                 private_route_encryption: Optional[pulumi.Input[bool]] = None,
                 remote_destination_real_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remote_destination_virtual_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remote_gateway_ip: Optional[pulumi.Input[str]] = None,
                 remote_gateway_latitude: Optional[pulumi.Input[float]] = None,
                 remote_gateway_longitude: Optional[pulumi.Input[float]] = None,
                 remote_gateway_type: Optional[pulumi.Input[str]] = None,
                 remote_identifier: Optional[pulumi.Input[str]] = None,
                 remote_source_real_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remote_source_virtual_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 remote_subnet_cidr: Optional[pulumi.Input[str]] = None,
                 remote_subnet_virtual: Optional[pulumi.Input[str]] = None,
                 remote_tunnel_ip: Optional[pulumi.Input[str]] = None,
                 route_table_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ssl_server_pool: Optional[pulumi.Input[str]] = None,
                 tunnel_type: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixSite2CloudArgs.__new__(AviatrixSite2CloudArgs)

            __props__.__dict__["auth_type"] = auth_type
            __props__.__dict__["backup_gateway_name"] = backup_gateway_name
            __props__.__dict__["backup_local_tunnel_ip"] = backup_local_tunnel_ip
            __props__.__dict__["backup_pre_shared_key"] = backup_pre_shared_key
            __props__.__dict__["backup_remote_gateway_ip"] = backup_remote_gateway_ip
            __props__.__dict__["backup_remote_gateway_latitude"] = backup_remote_gateway_latitude
            __props__.__dict__["backup_remote_gateway_longitude"] = backup_remote_gateway_longitude
            __props__.__dict__["backup_remote_identifier"] = backup_remote_identifier
            __props__.__dict__["backup_remote_tunnel_ip"] = backup_remote_tunnel_ip
            __props__.__dict__["ca_cert_tag_name"] = ca_cert_tag_name
            if connection_name is None and not opts.urn:
                raise TypeError("Missing required property 'connection_name'")
            __props__.__dict__["connection_name"] = connection_name
            if connection_type is None and not opts.urn:
                raise TypeError("Missing required property 'connection_type'")
            __props__.__dict__["connection_type"] = connection_type
            __props__.__dict__["custom_algorithms"] = custom_algorithms
            __props__.__dict__["custom_mapped"] = custom_mapped
            __props__.__dict__["enable_active_active"] = enable_active_active
            __props__.__dict__["enable_dead_peer_detection"] = enable_dead_peer_detection
            __props__.__dict__["enable_event_triggered_ha"] = enable_event_triggered_ha
            __props__.__dict__["enable_ikev2"] = enable_ikev2
            __props__.__dict__["enable_single_ip_ha"] = enable_single_ip_ha
            __props__.__dict__["forward_traffic_to_transit"] = forward_traffic_to_transit
            __props__.__dict__["ha_enabled"] = ha_enabled
            __props__.__dict__["local_destination_real_cidrs"] = local_destination_real_cidrs
            __props__.__dict__["local_destination_virtual_cidrs"] = local_destination_virtual_cidrs
            __props__.__dict__["local_source_real_cidrs"] = local_source_real_cidrs
            __props__.__dict__["local_source_virtual_cidrs"] = local_source_virtual_cidrs
            __props__.__dict__["local_subnet_cidr"] = local_subnet_cidr
            __props__.__dict__["local_subnet_virtual"] = local_subnet_virtual
            __props__.__dict__["local_tunnel_ip"] = local_tunnel_ip
            __props__.__dict__["phase1_authentication"] = phase1_authentication
            __props__.__dict__["phase1_dh_groups"] = phase1_dh_groups
            __props__.__dict__["phase1_encryption"] = phase1_encryption
            __props__.__dict__["phase1_remote_identifiers"] = phase1_remote_identifiers
            __props__.__dict__["phase2_authentication"] = phase2_authentication
            __props__.__dict__["phase2_dh_groups"] = phase2_dh_groups
            __props__.__dict__["phase2_encryption"] = phase2_encryption
            __props__.__dict__["pre_shared_key"] = pre_shared_key
            if primary_cloud_gateway_name is None and not opts.urn:
                raise TypeError("Missing required property 'primary_cloud_gateway_name'")
            __props__.__dict__["primary_cloud_gateway_name"] = primary_cloud_gateway_name
            __props__.__dict__["private_route_encryption"] = private_route_encryption
            __props__.__dict__["remote_destination_real_cidrs"] = remote_destination_real_cidrs
            __props__.__dict__["remote_destination_virtual_cidrs"] = remote_destination_virtual_cidrs
            if remote_gateway_ip is None and not opts.urn:
                raise TypeError("Missing required property 'remote_gateway_ip'")
            __props__.__dict__["remote_gateway_ip"] = remote_gateway_ip
            __props__.__dict__["remote_gateway_latitude"] = remote_gateway_latitude
            __props__.__dict__["remote_gateway_longitude"] = remote_gateway_longitude
            if remote_gateway_type is None and not opts.urn:
                raise TypeError("Missing required property 'remote_gateway_type'")
            __props__.__dict__["remote_gateway_type"] = remote_gateway_type
            __props__.__dict__["remote_identifier"] = remote_identifier
            __props__.__dict__["remote_source_real_cidrs"] = remote_source_real_cidrs
            __props__.__dict__["remote_source_virtual_cidrs"] = remote_source_virtual_cidrs
            __props__.__dict__["remote_subnet_cidr"] = remote_subnet_cidr
            __props__.__dict__["remote_subnet_virtual"] = remote_subnet_virtual
            __props__.__dict__["remote_tunnel_ip"] = remote_tunnel_ip
            __props__.__dict__["route_table_lists"] = route_table_lists
            __props__.__dict__["ssl_server_pool"] = ssl_server_pool
            if tunnel_type is None and not opts.urn:
                raise TypeError("Missing required property 'tunnel_type'")
            __props__.__dict__["tunnel_type"] = tunnel_type
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
        super(AviatrixSite2Cloud, __self__).__init__(
            'aviatrix:index/aviatrixSite2Cloud:AviatrixSite2Cloud',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auth_type: Optional[pulumi.Input[str]] = None,
            backup_gateway_name: Optional[pulumi.Input[str]] = None,
            backup_local_tunnel_ip: Optional[pulumi.Input[str]] = None,
            backup_pre_shared_key: Optional[pulumi.Input[str]] = None,
            backup_remote_gateway_ip: Optional[pulumi.Input[str]] = None,
            backup_remote_gateway_latitude: Optional[pulumi.Input[float]] = None,
            backup_remote_gateway_longitude: Optional[pulumi.Input[float]] = None,
            backup_remote_identifier: Optional[pulumi.Input[str]] = None,
            backup_remote_tunnel_ip: Optional[pulumi.Input[str]] = None,
            ca_cert_tag_name: Optional[pulumi.Input[str]] = None,
            connection_name: Optional[pulumi.Input[str]] = None,
            connection_type: Optional[pulumi.Input[str]] = None,
            custom_algorithms: Optional[pulumi.Input[bool]] = None,
            custom_mapped: Optional[pulumi.Input[bool]] = None,
            enable_active_active: Optional[pulumi.Input[bool]] = None,
            enable_dead_peer_detection: Optional[pulumi.Input[bool]] = None,
            enable_event_triggered_ha: Optional[pulumi.Input[bool]] = None,
            enable_ikev2: Optional[pulumi.Input[bool]] = None,
            enable_single_ip_ha: Optional[pulumi.Input[bool]] = None,
            forward_traffic_to_transit: Optional[pulumi.Input[bool]] = None,
            ha_enabled: Optional[pulumi.Input[bool]] = None,
            local_destination_real_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            local_destination_virtual_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            local_source_real_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            local_source_virtual_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            local_subnet_cidr: Optional[pulumi.Input[str]] = None,
            local_subnet_virtual: Optional[pulumi.Input[str]] = None,
            local_tunnel_ip: Optional[pulumi.Input[str]] = None,
            phase1_authentication: Optional[pulumi.Input[str]] = None,
            phase1_dh_groups: Optional[pulumi.Input[str]] = None,
            phase1_encryption: Optional[pulumi.Input[str]] = None,
            phase1_remote_identifiers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            phase2_authentication: Optional[pulumi.Input[str]] = None,
            phase2_dh_groups: Optional[pulumi.Input[str]] = None,
            phase2_encryption: Optional[pulumi.Input[str]] = None,
            pre_shared_key: Optional[pulumi.Input[str]] = None,
            primary_cloud_gateway_name: Optional[pulumi.Input[str]] = None,
            private_route_encryption: Optional[pulumi.Input[bool]] = None,
            remote_destination_real_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            remote_destination_virtual_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            remote_gateway_ip: Optional[pulumi.Input[str]] = None,
            remote_gateway_latitude: Optional[pulumi.Input[float]] = None,
            remote_gateway_longitude: Optional[pulumi.Input[float]] = None,
            remote_gateway_type: Optional[pulumi.Input[str]] = None,
            remote_identifier: Optional[pulumi.Input[str]] = None,
            remote_source_real_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            remote_source_virtual_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            remote_subnet_cidr: Optional[pulumi.Input[str]] = None,
            remote_subnet_virtual: Optional[pulumi.Input[str]] = None,
            remote_tunnel_ip: Optional[pulumi.Input[str]] = None,
            route_table_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ssl_server_pool: Optional[pulumi.Input[str]] = None,
            tunnel_type: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'AviatrixSite2Cloud':
        """
        Get an existing AviatrixSite2Cloud resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auth_type: Authentication Type. Valid values: 'PSK' and 'Cert'. Default value: 'PSK'.
        :param pulumi.Input[str] backup_gateway_name: Backup gateway name.
        :param pulumi.Input[str] backup_local_tunnel_ip: Backup local tunnel IP address.
        :param pulumi.Input[str] backup_pre_shared_key: Backup Pre-Shared Key.
        :param pulumi.Input[str] backup_remote_gateway_ip: Backup remote remote gateway IP.
        :param pulumi.Input[float] backup_remote_gateway_latitude: Latitude of backup remote gateway.
        :param pulumi.Input[float] backup_remote_gateway_longitude: Longitude of backup remote gateway.
        :param pulumi.Input[str] backup_remote_identifier: Backup remote identifier. Required for Cert based authentication type with HA enabled.
        :param pulumi.Input[str] backup_remote_tunnel_ip: Backup remote tunnel IP address.
        :param pulumi.Input[str] ca_cert_tag_name: Name of Remote CA Certificate Tag for creating Site2Cloud tunnels. Required for Cert based authentication type.
        :param pulumi.Input[str] connection_name: Site2Cloud Connection Name.
        :param pulumi.Input[str] connection_type: Connection Type. Valid values: 'mapped' and 'unmapped'.
        :param pulumi.Input[bool] custom_algorithms: Switch to enable custom/non-default algorithms for IPSec Authentication/Encryption.
        :param pulumi.Input[bool] custom_mapped: Enable custom mapped.
        :param pulumi.Input[bool] enable_active_active: Switch to Enable/Disable active_active_ha for an existing site2cloud connection.
        :param pulumi.Input[bool] enable_dead_peer_detection: Switch to Enable/Disable Deed Peer Detection for an existing site2cloud connection.
        :param pulumi.Input[bool] enable_event_triggered_ha: Enable Event Triggered HA.
        :param pulumi.Input[bool] enable_ikev2: Switch to enable IKEv2 for policy based site2cloud.
        :param pulumi.Input[bool] enable_single_ip_ha: Enable single IP HA on a site2cloud connection.
        :param pulumi.Input[bool] forward_traffic_to_transit: Enable spoke gateway with mapped site2cloud configurations to forward traffic from site2cloud connection to Aviatrix
               Transit Gateway.
        :param pulumi.Input[bool] ha_enabled: Specify whether enabling HA or not.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_destination_real_cidrs: Local Initiated Traffic Destination Real CIDRs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_destination_virtual_cidrs: Local Initiated Traffic Destination Virtual CIDRs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_source_real_cidrs: Local Initiated Traffic Source Real CIDRs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_source_virtual_cidrs: Local Initiated Traffic Source Virtual CIDRs.
        :param pulumi.Input[str] local_subnet_cidr: Local Subnet CIDR.
        :param pulumi.Input[str] local_subnet_virtual: Local Subnet CIDR (Virtual).
        :param pulumi.Input[str] local_tunnel_ip: Local tunnel IP address.
        :param pulumi.Input[str] phase1_authentication: Phase one Authentication. Valid values: 'SHA-1', 'SHA-256', 'SHA-384' and 'SHA-512'.
        :param pulumi.Input[str] phase1_dh_groups: Phase one DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        :param pulumi.Input[str] phase1_encryption: Phase one Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC' and 'AES-256-CBC', 'AES-128-GCM-64',
               'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', and 'AES-256-GCM-128'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] phase1_remote_identifiers: Phase 1 remote identifier of the IPsec tunnel.
        :param pulumi.Input[str] phase2_authentication: Phase two Authentication. Valid values: 'NO-AUTH', 'HMAC-SHA-1', 'HMAC-SHA-256', 'HMAC-SHA-384' and 'HMAC-SHA-512'.
        :param pulumi.Input[str] phase2_dh_groups: Phase two DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        :param pulumi.Input[str] phase2_encryption: Phase two Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC', 'AES-256-CBC', 'AES-128-GCM-64',
               'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', 'AES-256-GCM-128', and 'NULL-ENCR'.
        :param pulumi.Input[str] pre_shared_key: Pre-Shared Key.
        :param pulumi.Input[str] primary_cloud_gateway_name: Primary Cloud Gateway Name.
        :param pulumi.Input[bool] private_route_encryption: Private route encryption switch.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_destination_real_cidrs: Remote Initiated Traffic Destination Real CIDRs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_destination_virtual_cidrs: Remote Initiated Traffic Destination Virtual CIDRs.
        :param pulumi.Input[str] remote_gateway_ip: Remote Gateway IP.
        :param pulumi.Input[float] remote_gateway_latitude: Latitude of remote gateway.
        :param pulumi.Input[float] remote_gateway_longitude: Longitude of remote gateway.
        :param pulumi.Input[str] remote_gateway_type: Remote gateway type. Valid values: 'generic', 'avx', 'aws', 'azure', 'sonicwall' and 'oracle'.
        :param pulumi.Input[str] remote_identifier: Remote identifier. Required for Cert based authentication type.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_source_real_cidrs: Remote Initiated Traffic Source Real CIDRs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_source_virtual_cidrs: Remote Initiated Traffic Source Virtual CIDRs.
        :param pulumi.Input[str] remote_subnet_cidr: Remote Subnet CIDR.
        :param pulumi.Input[str] remote_subnet_virtual: Remote Subnet CIDR (Virtual).
        :param pulumi.Input[str] remote_tunnel_ip: Remote tunnel IP address.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] route_table_lists: Route tables to modify.
        :param pulumi.Input[str] ssl_server_pool: Specify ssl_server_pool for tunnel_type 'tcp'. Default value is '192.168.44.0/24'
        :param pulumi.Input[str] tunnel_type: Site2Cloud Tunnel Type. Valid values: 'policy' and 'route'.
        :param pulumi.Input[str] vpc_id: VPC Id of the cloud gateway.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixSite2CloudState.__new__(_AviatrixSite2CloudState)

        __props__.__dict__["auth_type"] = auth_type
        __props__.__dict__["backup_gateway_name"] = backup_gateway_name
        __props__.__dict__["backup_local_tunnel_ip"] = backup_local_tunnel_ip
        __props__.__dict__["backup_pre_shared_key"] = backup_pre_shared_key
        __props__.__dict__["backup_remote_gateway_ip"] = backup_remote_gateway_ip
        __props__.__dict__["backup_remote_gateway_latitude"] = backup_remote_gateway_latitude
        __props__.__dict__["backup_remote_gateway_longitude"] = backup_remote_gateway_longitude
        __props__.__dict__["backup_remote_identifier"] = backup_remote_identifier
        __props__.__dict__["backup_remote_tunnel_ip"] = backup_remote_tunnel_ip
        __props__.__dict__["ca_cert_tag_name"] = ca_cert_tag_name
        __props__.__dict__["connection_name"] = connection_name
        __props__.__dict__["connection_type"] = connection_type
        __props__.__dict__["custom_algorithms"] = custom_algorithms
        __props__.__dict__["custom_mapped"] = custom_mapped
        __props__.__dict__["enable_active_active"] = enable_active_active
        __props__.__dict__["enable_dead_peer_detection"] = enable_dead_peer_detection
        __props__.__dict__["enable_event_triggered_ha"] = enable_event_triggered_ha
        __props__.__dict__["enable_ikev2"] = enable_ikev2
        __props__.__dict__["enable_single_ip_ha"] = enable_single_ip_ha
        __props__.__dict__["forward_traffic_to_transit"] = forward_traffic_to_transit
        __props__.__dict__["ha_enabled"] = ha_enabled
        __props__.__dict__["local_destination_real_cidrs"] = local_destination_real_cidrs
        __props__.__dict__["local_destination_virtual_cidrs"] = local_destination_virtual_cidrs
        __props__.__dict__["local_source_real_cidrs"] = local_source_real_cidrs
        __props__.__dict__["local_source_virtual_cidrs"] = local_source_virtual_cidrs
        __props__.__dict__["local_subnet_cidr"] = local_subnet_cidr
        __props__.__dict__["local_subnet_virtual"] = local_subnet_virtual
        __props__.__dict__["local_tunnel_ip"] = local_tunnel_ip
        __props__.__dict__["phase1_authentication"] = phase1_authentication
        __props__.__dict__["phase1_dh_groups"] = phase1_dh_groups
        __props__.__dict__["phase1_encryption"] = phase1_encryption
        __props__.__dict__["phase1_remote_identifiers"] = phase1_remote_identifiers
        __props__.__dict__["phase2_authentication"] = phase2_authentication
        __props__.__dict__["phase2_dh_groups"] = phase2_dh_groups
        __props__.__dict__["phase2_encryption"] = phase2_encryption
        __props__.__dict__["pre_shared_key"] = pre_shared_key
        __props__.__dict__["primary_cloud_gateway_name"] = primary_cloud_gateway_name
        __props__.__dict__["private_route_encryption"] = private_route_encryption
        __props__.__dict__["remote_destination_real_cidrs"] = remote_destination_real_cidrs
        __props__.__dict__["remote_destination_virtual_cidrs"] = remote_destination_virtual_cidrs
        __props__.__dict__["remote_gateway_ip"] = remote_gateway_ip
        __props__.__dict__["remote_gateway_latitude"] = remote_gateway_latitude
        __props__.__dict__["remote_gateway_longitude"] = remote_gateway_longitude
        __props__.__dict__["remote_gateway_type"] = remote_gateway_type
        __props__.__dict__["remote_identifier"] = remote_identifier
        __props__.__dict__["remote_source_real_cidrs"] = remote_source_real_cidrs
        __props__.__dict__["remote_source_virtual_cidrs"] = remote_source_virtual_cidrs
        __props__.__dict__["remote_subnet_cidr"] = remote_subnet_cidr
        __props__.__dict__["remote_subnet_virtual"] = remote_subnet_virtual
        __props__.__dict__["remote_tunnel_ip"] = remote_tunnel_ip
        __props__.__dict__["route_table_lists"] = route_table_lists
        __props__.__dict__["ssl_server_pool"] = ssl_server_pool
        __props__.__dict__["tunnel_type"] = tunnel_type
        __props__.__dict__["vpc_id"] = vpc_id
        return AviatrixSite2Cloud(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Output[Optional[str]]:
        """
        Authentication Type. Valid values: 'PSK' and 'Cert'. Default value: 'PSK'.
        """
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter(name="backupGatewayName")
    def backup_gateway_name(self) -> pulumi.Output[Optional[str]]:
        """
        Backup gateway name.
        """
        return pulumi.get(self, "backup_gateway_name")

    @property
    @pulumi.getter(name="backupLocalTunnelIp")
    def backup_local_tunnel_ip(self) -> pulumi.Output[Optional[str]]:
        """
        Backup local tunnel IP address.
        """
        return pulumi.get(self, "backup_local_tunnel_ip")

    @property
    @pulumi.getter(name="backupPreSharedKey")
    def backup_pre_shared_key(self) -> pulumi.Output[Optional[str]]:
        """
        Backup Pre-Shared Key.
        """
        return pulumi.get(self, "backup_pre_shared_key")

    @property
    @pulumi.getter(name="backupRemoteGatewayIp")
    def backup_remote_gateway_ip(self) -> pulumi.Output[str]:
        """
        Backup remote remote gateway IP.
        """
        return pulumi.get(self, "backup_remote_gateway_ip")

    @property
    @pulumi.getter(name="backupRemoteGatewayLatitude")
    def backup_remote_gateway_latitude(self) -> pulumi.Output[Optional[float]]:
        """
        Latitude of backup remote gateway.
        """
        return pulumi.get(self, "backup_remote_gateway_latitude")

    @property
    @pulumi.getter(name="backupRemoteGatewayLongitude")
    def backup_remote_gateway_longitude(self) -> pulumi.Output[Optional[float]]:
        """
        Longitude of backup remote gateway.
        """
        return pulumi.get(self, "backup_remote_gateway_longitude")

    @property
    @pulumi.getter(name="backupRemoteIdentifier")
    def backup_remote_identifier(self) -> pulumi.Output[Optional[str]]:
        """
        Backup remote identifier. Required for Cert based authentication type with HA enabled.
        """
        return pulumi.get(self, "backup_remote_identifier")

    @property
    @pulumi.getter(name="backupRemoteTunnelIp")
    def backup_remote_tunnel_ip(self) -> pulumi.Output[Optional[str]]:
        """
        Backup remote tunnel IP address.
        """
        return pulumi.get(self, "backup_remote_tunnel_ip")

    @property
    @pulumi.getter(name="caCertTagName")
    def ca_cert_tag_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name of Remote CA Certificate Tag for creating Site2Cloud tunnels. Required for Cert based authentication type.
        """
        return pulumi.get(self, "ca_cert_tag_name")

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Output[str]:
        """
        Site2Cloud Connection Name.
        """
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> pulumi.Output[str]:
        """
        Connection Type. Valid values: 'mapped' and 'unmapped'.
        """
        return pulumi.get(self, "connection_type")

    @property
    @pulumi.getter(name="customAlgorithms")
    def custom_algorithms(self) -> pulumi.Output[Optional[bool]]:
        """
        Switch to enable custom/non-default algorithms for IPSec Authentication/Encryption.
        """
        return pulumi.get(self, "custom_algorithms")

    @property
    @pulumi.getter(name="customMapped")
    def custom_mapped(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable custom mapped.
        """
        return pulumi.get(self, "custom_mapped")

    @property
    @pulumi.getter(name="enableActiveActive")
    def enable_active_active(self) -> pulumi.Output[Optional[bool]]:
        """
        Switch to Enable/Disable active_active_ha for an existing site2cloud connection.
        """
        return pulumi.get(self, "enable_active_active")

    @property
    @pulumi.getter(name="enableDeadPeerDetection")
    def enable_dead_peer_detection(self) -> pulumi.Output[Optional[bool]]:
        """
        Switch to Enable/Disable Deed Peer Detection for an existing site2cloud connection.
        """
        return pulumi.get(self, "enable_dead_peer_detection")

    @property
    @pulumi.getter(name="enableEventTriggeredHa")
    def enable_event_triggered_ha(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable Event Triggered HA.
        """
        return pulumi.get(self, "enable_event_triggered_ha")

    @property
    @pulumi.getter(name="enableIkev2")
    def enable_ikev2(self) -> pulumi.Output[Optional[bool]]:
        """
        Switch to enable IKEv2 for policy based site2cloud.
        """
        return pulumi.get(self, "enable_ikev2")

    @property
    @pulumi.getter(name="enableSingleIpHa")
    def enable_single_ip_ha(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable single IP HA on a site2cloud connection.
        """
        return pulumi.get(self, "enable_single_ip_ha")

    @property
    @pulumi.getter(name="forwardTrafficToTransit")
    def forward_traffic_to_transit(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable spoke gateway with mapped site2cloud configurations to forward traffic from site2cloud connection to Aviatrix
        Transit Gateway.
        """
        return pulumi.get(self, "forward_traffic_to_transit")

    @property
    @pulumi.getter(name="haEnabled")
    def ha_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specify whether enabling HA or not.
        """
        return pulumi.get(self, "ha_enabled")

    @property
    @pulumi.getter(name="localDestinationRealCidrs")
    def local_destination_real_cidrs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Local Initiated Traffic Destination Real CIDRs.
        """
        return pulumi.get(self, "local_destination_real_cidrs")

    @property
    @pulumi.getter(name="localDestinationVirtualCidrs")
    def local_destination_virtual_cidrs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Local Initiated Traffic Destination Virtual CIDRs.
        """
        return pulumi.get(self, "local_destination_virtual_cidrs")

    @property
    @pulumi.getter(name="localSourceRealCidrs")
    def local_source_real_cidrs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Local Initiated Traffic Source Real CIDRs.
        """
        return pulumi.get(self, "local_source_real_cidrs")

    @property
    @pulumi.getter(name="localSourceVirtualCidrs")
    def local_source_virtual_cidrs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Local Initiated Traffic Source Virtual CIDRs.
        """
        return pulumi.get(self, "local_source_virtual_cidrs")

    @property
    @pulumi.getter(name="localSubnetCidr")
    def local_subnet_cidr(self) -> pulumi.Output[str]:
        """
        Local Subnet CIDR.
        """
        return pulumi.get(self, "local_subnet_cidr")

    @property
    @pulumi.getter(name="localSubnetVirtual")
    def local_subnet_virtual(self) -> pulumi.Output[Optional[str]]:
        """
        Local Subnet CIDR (Virtual).
        """
        return pulumi.get(self, "local_subnet_virtual")

    @property
    @pulumi.getter(name="localTunnelIp")
    def local_tunnel_ip(self) -> pulumi.Output[Optional[str]]:
        """
        Local tunnel IP address.
        """
        return pulumi.get(self, "local_tunnel_ip")

    @property
    @pulumi.getter(name="phase1Authentication")
    def phase1_authentication(self) -> pulumi.Output[Optional[str]]:
        """
        Phase one Authentication. Valid values: 'SHA-1', 'SHA-256', 'SHA-384' and 'SHA-512'.
        """
        return pulumi.get(self, "phase1_authentication")

    @property
    @pulumi.getter(name="phase1DhGroups")
    def phase1_dh_groups(self) -> pulumi.Output[Optional[str]]:
        """
        Phase one DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        """
        return pulumi.get(self, "phase1_dh_groups")

    @property
    @pulumi.getter(name="phase1Encryption")
    def phase1_encryption(self) -> pulumi.Output[Optional[str]]:
        """
        Phase one Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC' and 'AES-256-CBC', 'AES-128-GCM-64',
        'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', and 'AES-256-GCM-128'.
        """
        return pulumi.get(self, "phase1_encryption")

    @property
    @pulumi.getter(name="phase1RemoteIdentifiers")
    def phase1_remote_identifiers(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Phase 1 remote identifier of the IPsec tunnel.
        """
        return pulumi.get(self, "phase1_remote_identifiers")

    @property
    @pulumi.getter(name="phase2Authentication")
    def phase2_authentication(self) -> pulumi.Output[Optional[str]]:
        """
        Phase two Authentication. Valid values: 'NO-AUTH', 'HMAC-SHA-1', 'HMAC-SHA-256', 'HMAC-SHA-384' and 'HMAC-SHA-512'.
        """
        return pulumi.get(self, "phase2_authentication")

    @property
    @pulumi.getter(name="phase2DhGroups")
    def phase2_dh_groups(self) -> pulumi.Output[Optional[str]]:
        """
        Phase two DH Groups. Valid values: '1', '2', '5', '14', '15', '16', '17', '18', '19', '20' and '21'.
        """
        return pulumi.get(self, "phase2_dh_groups")

    @property
    @pulumi.getter(name="phase2Encryption")
    def phase2_encryption(self) -> pulumi.Output[Optional[str]]:
        """
        Phase two Encryption. Valid values: '3DES', 'AES-128-CBC', 'AES-192-CBC', 'AES-256-CBC', 'AES-128-GCM-64',
        'AES-128-GCM-96', 'AES-128-GCM-128', 'AES-256-GCM-64', 'AES-256-GCM-96', 'AES-256-GCM-128', and 'NULL-ENCR'.
        """
        return pulumi.get(self, "phase2_encryption")

    @property
    @pulumi.getter(name="preSharedKey")
    def pre_shared_key(self) -> pulumi.Output[Optional[str]]:
        """
        Pre-Shared Key.
        """
        return pulumi.get(self, "pre_shared_key")

    @property
    @pulumi.getter(name="primaryCloudGatewayName")
    def primary_cloud_gateway_name(self) -> pulumi.Output[str]:
        """
        Primary Cloud Gateway Name.
        """
        return pulumi.get(self, "primary_cloud_gateway_name")

    @property
    @pulumi.getter(name="privateRouteEncryption")
    def private_route_encryption(self) -> pulumi.Output[Optional[bool]]:
        """
        Private route encryption switch.
        """
        return pulumi.get(self, "private_route_encryption")

    @property
    @pulumi.getter(name="remoteDestinationRealCidrs")
    def remote_destination_real_cidrs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Remote Initiated Traffic Destination Real CIDRs.
        """
        return pulumi.get(self, "remote_destination_real_cidrs")

    @property
    @pulumi.getter(name="remoteDestinationVirtualCidrs")
    def remote_destination_virtual_cidrs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Remote Initiated Traffic Destination Virtual CIDRs.
        """
        return pulumi.get(self, "remote_destination_virtual_cidrs")

    @property
    @pulumi.getter(name="remoteGatewayIp")
    def remote_gateway_ip(self) -> pulumi.Output[str]:
        """
        Remote Gateway IP.
        """
        return pulumi.get(self, "remote_gateway_ip")

    @property
    @pulumi.getter(name="remoteGatewayLatitude")
    def remote_gateway_latitude(self) -> pulumi.Output[Optional[float]]:
        """
        Latitude of remote gateway.
        """
        return pulumi.get(self, "remote_gateway_latitude")

    @property
    @pulumi.getter(name="remoteGatewayLongitude")
    def remote_gateway_longitude(self) -> pulumi.Output[Optional[float]]:
        """
        Longitude of remote gateway.
        """
        return pulumi.get(self, "remote_gateway_longitude")

    @property
    @pulumi.getter(name="remoteGatewayType")
    def remote_gateway_type(self) -> pulumi.Output[str]:
        """
        Remote gateway type. Valid values: 'generic', 'avx', 'aws', 'azure', 'sonicwall' and 'oracle'.
        """
        return pulumi.get(self, "remote_gateway_type")

    @property
    @pulumi.getter(name="remoteIdentifier")
    def remote_identifier(self) -> pulumi.Output[Optional[str]]:
        """
        Remote identifier. Required for Cert based authentication type.
        """
        return pulumi.get(self, "remote_identifier")

    @property
    @pulumi.getter(name="remoteSourceRealCidrs")
    def remote_source_real_cidrs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Remote Initiated Traffic Source Real CIDRs.
        """
        return pulumi.get(self, "remote_source_real_cidrs")

    @property
    @pulumi.getter(name="remoteSourceVirtualCidrs")
    def remote_source_virtual_cidrs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Remote Initiated Traffic Source Virtual CIDRs.
        """
        return pulumi.get(self, "remote_source_virtual_cidrs")

    @property
    @pulumi.getter(name="remoteSubnetCidr")
    def remote_subnet_cidr(self) -> pulumi.Output[Optional[str]]:
        """
        Remote Subnet CIDR.
        """
        return pulumi.get(self, "remote_subnet_cidr")

    @property
    @pulumi.getter(name="remoteSubnetVirtual")
    def remote_subnet_virtual(self) -> pulumi.Output[Optional[str]]:
        """
        Remote Subnet CIDR (Virtual).
        """
        return pulumi.get(self, "remote_subnet_virtual")

    @property
    @pulumi.getter(name="remoteTunnelIp")
    def remote_tunnel_ip(self) -> pulumi.Output[Optional[str]]:
        """
        Remote tunnel IP address.
        """
        return pulumi.get(self, "remote_tunnel_ip")

    @property
    @pulumi.getter(name="routeTableLists")
    def route_table_lists(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Route tables to modify.
        """
        return pulumi.get(self, "route_table_lists")

    @property
    @pulumi.getter(name="sslServerPool")
    def ssl_server_pool(self) -> pulumi.Output[Optional[str]]:
        """
        Specify ssl_server_pool for tunnel_type 'tcp'. Default value is '192.168.44.0/24'
        """
        return pulumi.get(self, "ssl_server_pool")

    @property
    @pulumi.getter(name="tunnelType")
    def tunnel_type(self) -> pulumi.Output[str]:
        """
        Site2Cloud Tunnel Type. Valid values: 'policy' and 'route'.
        """
        return pulumi.get(self, "tunnel_type")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        VPC Id of the cloud gateway.
        """
        return pulumi.get(self, "vpc_id")

