# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixGeoVpnArgs', 'AviatrixGeoVpn']

@pulumi.input_type
class AviatrixGeoVpnArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[str],
                 cloud_type: pulumi.Input[int],
                 domain_name: pulumi.Input[str],
                 elb_dns_names: pulumi.Input[Sequence[pulumi.Input[str]]],
                 service_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a AviatrixGeoVpn resource.
        :param pulumi.Input[str] account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider, requires an integer value. Currently only AWS(1) is supported.
        :param pulumi.Input[str] domain_name: The hosted domain name. It must be hosted by AWS Route53 or Azure DNS in the selected account.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] elb_dns_names: List of ELB names to attach to this Geo VPN name.
        :param pulumi.Input[str] service_name: The hostname that users will connect to. A DNS record will be created for this name in the specified domain name.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "cloud_type", cloud_type)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "elb_dns_names", elb_dns_names)
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[str]:
        """
        This parameter represents the name of a Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> pulumi.Input[int]:
        """
        Type of cloud service provider, requires an integer value. Currently only AWS(1) is supported.
        """
        return pulumi.get(self, "cloud_type")

    @cloud_type.setter
    def cloud_type(self, value: pulumi.Input[int]):
        pulumi.set(self, "cloud_type", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        The hosted domain name. It must be hosted by AWS Route53 or Azure DNS in the selected account.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="elbDnsNames")
    def elb_dns_names(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of ELB names to attach to this Geo VPN name.
        """
        return pulumi.get(self, "elb_dns_names")

    @elb_dns_names.setter
    def elb_dns_names(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "elb_dns_names", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        The hostname that users will connect to. A DNS record will be created for this name in the specified domain name.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)


@pulumi.input_type
class _AviatrixGeoVpnState:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[str]] = None,
                 cloud_type: Optional[pulumi.Input[int]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 elb_dns_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixGeoVpn resources.
        :param pulumi.Input[str] account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider, requires an integer value. Currently only AWS(1) is supported.
        :param pulumi.Input[str] domain_name: The hosted domain name. It must be hosted by AWS Route53 or Azure DNS in the selected account.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] elb_dns_names: List of ELB names to attach to this Geo VPN name.
        :param pulumi.Input[str] service_name: The hostname that users will connect to. A DNS record will be created for this name in the specified domain name.
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if cloud_type is not None:
            pulumi.set(__self__, "cloud_type", cloud_type)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if elb_dns_names is not None:
            pulumi.set(__self__, "elb_dns_names", elb_dns_names)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter represents the name of a Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> Optional[pulumi.Input[int]]:
        """
        Type of cloud service provider, requires an integer value. Currently only AWS(1) is supported.
        """
        return pulumi.get(self, "cloud_type")

    @cloud_type.setter
    def cloud_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cloud_type", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The hosted domain name. It must be hosted by AWS Route53 or Azure DNS in the selected account.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="elbDnsNames")
    def elb_dns_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of ELB names to attach to this Geo VPN name.
        """
        return pulumi.get(self, "elb_dns_names")

    @elb_dns_names.setter
    def elb_dns_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "elb_dns_names", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname that users will connect to. A DNS record will be created for this name in the specified domain name.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)


class AviatrixGeoVpn(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 cloud_type: Optional[pulumi.Input[int]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 elb_dns_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AviatrixGeoVpn resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider, requires an integer value. Currently only AWS(1) is supported.
        :param pulumi.Input[str] domain_name: The hosted domain name. It must be hosted by AWS Route53 or Azure DNS in the selected account.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] elb_dns_names: List of ELB names to attach to this Geo VPN name.
        :param pulumi.Input[str] service_name: The hostname that users will connect to. A DNS record will be created for this name in the specified domain name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixGeoVpnArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixGeoVpn resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixGeoVpnArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixGeoVpnArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 cloud_type: Optional[pulumi.Input[int]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 elb_dns_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixGeoVpnArgs.__new__(AviatrixGeoVpnArgs)

            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            if cloud_type is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_type'")
            __props__.__dict__["cloud_type"] = cloud_type
            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            if elb_dns_names is None and not opts.urn:
                raise TypeError("Missing required property 'elb_dns_names'")
            __props__.__dict__["elb_dns_names"] = elb_dns_names
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
        super(AviatrixGeoVpn, __self__).__init__(
            'aviatrix:index/aviatrixGeoVpn:AviatrixGeoVpn',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name: Optional[pulumi.Input[str]] = None,
            cloud_type: Optional[pulumi.Input[int]] = None,
            domain_name: Optional[pulumi.Input[str]] = None,
            elb_dns_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            service_name: Optional[pulumi.Input[str]] = None) -> 'AviatrixGeoVpn':
        """
        Get an existing AviatrixGeoVpn resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider, requires an integer value. Currently only AWS(1) is supported.
        :param pulumi.Input[str] domain_name: The hosted domain name. It must be hosted by AWS Route53 or Azure DNS in the selected account.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] elb_dns_names: List of ELB names to attach to this Geo VPN name.
        :param pulumi.Input[str] service_name: The hostname that users will connect to. A DNS record will be created for this name in the specified domain name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixGeoVpnState.__new__(_AviatrixGeoVpnState)

        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["cloud_type"] = cloud_type
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["elb_dns_names"] = elb_dns_names
        __props__.__dict__["service_name"] = service_name
        return AviatrixGeoVpn(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[str]:
        """
        This parameter represents the name of a Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> pulumi.Output[int]:
        """
        Type of cloud service provider, requires an integer value. Currently only AWS(1) is supported.
        """
        return pulumi.get(self, "cloud_type")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        """
        The hosted domain name. It must be hosted by AWS Route53 or Azure DNS in the selected account.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="elbDnsNames")
    def elb_dns_names(self) -> pulumi.Output[Sequence[str]]:
        """
        List of ELB names to attach to this Geo VPN name.
        """
        return pulumi.get(self, "elb_dns_names")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        The hostname that users will connect to. A DNS record will be created for this name in the specified domain name.
        """
        return pulumi.get(self, "service_name")

