# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixFqdnPassThroughArgs', 'AviatrixFqdnPassThrough']

@pulumi.input_type
class AviatrixFqdnPassThroughArgs:
    def __init__(__self__, *,
                 gw_name: pulumi.Input[str],
                 pass_through_cidrs: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        The set of arguments for constructing a AviatrixFqdnPassThrough resource.
        :param pulumi.Input[str] gw_name: Gateway to apply FQDN pass-through rules to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pass_through_cidrs: CIDRs to allow originating requests to ignore FQDN filtering rules.
        """
        pulumi.set(__self__, "gw_name", gw_name)
        pulumi.set(__self__, "pass_through_cidrs", pass_through_cidrs)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Input[str]:
        """
        Gateway to apply FQDN pass-through rules to.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter(name="passThroughCidrs")
    def pass_through_cidrs(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        CIDRs to allow originating requests to ignore FQDN filtering rules.
        """
        return pulumi.get(self, "pass_through_cidrs")

    @pass_through_cidrs.setter
    def pass_through_cidrs(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "pass_through_cidrs", value)


@pulumi.input_type
class _AviatrixFqdnPassThroughState:
    def __init__(__self__, *,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 pass_through_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering AviatrixFqdnPassThrough resources.
        :param pulumi.Input[str] gw_name: Gateway to apply FQDN pass-through rules to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pass_through_cidrs: CIDRs to allow originating requests to ignore FQDN filtering rules.
        """
        if gw_name is not None:
            pulumi.set(__self__, "gw_name", gw_name)
        if pass_through_cidrs is not None:
            pulumi.set(__self__, "pass_through_cidrs", pass_through_cidrs)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> Optional[pulumi.Input[str]]:
        """
        Gateway to apply FQDN pass-through rules to.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter(name="passThroughCidrs")
    def pass_through_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        CIDRs to allow originating requests to ignore FQDN filtering rules.
        """
        return pulumi.get(self, "pass_through_cidrs")

    @pass_through_cidrs.setter
    def pass_through_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "pass_through_cidrs", value)


class AviatrixFqdnPassThrough(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 pass_through_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Create a AviatrixFqdnPassThrough resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] gw_name: Gateway to apply FQDN pass-through rules to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pass_through_cidrs: CIDRs to allow originating requests to ignore FQDN filtering rules.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixFqdnPassThroughArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixFqdnPassThrough resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixFqdnPassThroughArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixFqdnPassThroughArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 pass_through_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixFqdnPassThroughArgs.__new__(AviatrixFqdnPassThroughArgs)

            if gw_name is None and not opts.urn:
                raise TypeError("Missing required property 'gw_name'")
            __props__.__dict__["gw_name"] = gw_name
            if pass_through_cidrs is None and not opts.urn:
                raise TypeError("Missing required property 'pass_through_cidrs'")
            __props__.__dict__["pass_through_cidrs"] = pass_through_cidrs
        super(AviatrixFqdnPassThrough, __self__).__init__(
            'aviatrix:index/aviatrixFqdnPassThrough:AviatrixFqdnPassThrough',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            gw_name: Optional[pulumi.Input[str]] = None,
            pass_through_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'AviatrixFqdnPassThrough':
        """
        Get an existing AviatrixFqdnPassThrough resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] gw_name: Gateway to apply FQDN pass-through rules to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] pass_through_cidrs: CIDRs to allow originating requests to ignore FQDN filtering rules.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixFqdnPassThroughState.__new__(_AviatrixFqdnPassThroughState)

        __props__.__dict__["gw_name"] = gw_name
        __props__.__dict__["pass_through_cidrs"] = pass_through_cidrs
        return AviatrixFqdnPassThrough(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Output[str]:
        """
        Gateway to apply FQDN pass-through rules to.
        """
        return pulumi.get(self, "gw_name")

    @property
    @pulumi.getter(name="passThroughCidrs")
    def pass_through_cidrs(self) -> pulumi.Output[Sequence[str]]:
        """
        CIDRs to allow originating requests to ignore FQDN filtering rules.
        """
        return pulumi.get(self, "pass_through_cidrs")

