# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AviatrixFirenetArgs', 'AviatrixFirenet']

@pulumi.input_type
class AviatrixFirenetArgs:
    def __init__(__self__, *,
                 vpc_id: pulumi.Input[str],
                 east_west_inspection_excluded_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 egress_enabled: Optional[pulumi.Input[bool]] = None,
                 egress_static_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 firewall_instance_associations: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixFirenetFirewallInstanceAssociationArgs']]]] = None,
                 hashing_algorithm: Optional[pulumi.Input[str]] = None,
                 inspection_enabled: Optional[pulumi.Input[bool]] = None,
                 keep_alive_via_lan_interface_enabled: Optional[pulumi.Input[bool]] = None,
                 manage_firewall_instance_association: Optional[pulumi.Input[bool]] = None,
                 tgw_segmentation_for_egress_enabled: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a AviatrixFirenet resource.
        :param pulumi.Input[str] vpc_id: VPC ID.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] east_west_inspection_excluded_cidrs: Network List Excluded From East-West Inspection. CIDRs to be excluded from inspection. Type: Set(String). Available as
               of provider version R2.19.2+.
        :param pulumi.Input[bool] egress_enabled: Enable/Disable egress through firewall.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] egress_static_cidrs: List of egress static cidrs.
        :param pulumi.Input[Sequence[pulumi.Input['AviatrixFirenetFirewallInstanceAssociationArgs']]] firewall_instance_associations: List of firewall instances to be associated with fireNet.
        :param pulumi.Input[str] hashing_algorithm: Hashing algorithm to load balance traffic across the firewall.
        :param pulumi.Input[bool] inspection_enabled: Enable/Disable traffic inspection.
        :param pulumi.Input[bool] keep_alive_via_lan_interface_enabled: Enable Keep Alive via Firewall LAN Interface.
        :param pulumi.Input[bool] manage_firewall_instance_association: Enable this to manage firewall_instance_associations in-line. If this is false, associations must be managed via
               standalone aviatrix_firewall_instance_association resources. Type: boolean, Default: true, Valid values: true/false.
        :param pulumi.Input[bool] tgw_segmentation_for_egress_enabled: Enable TGW segmentation for egress.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        if east_west_inspection_excluded_cidrs is not None:
            pulumi.set(__self__, "east_west_inspection_excluded_cidrs", east_west_inspection_excluded_cidrs)
        if egress_enabled is not None:
            pulumi.set(__self__, "egress_enabled", egress_enabled)
        if egress_static_cidrs is not None:
            pulumi.set(__self__, "egress_static_cidrs", egress_static_cidrs)
        if firewall_instance_associations is not None:
            warnings.warn("""Please set `manage_firewall_instance_association` to false, and use the standalone aviatrix_firewall_instance_association resource instead.""", DeprecationWarning)
            pulumi.log.warn("""firewall_instance_associations is deprecated: Please set `manage_firewall_instance_association` to false, and use the standalone aviatrix_firewall_instance_association resource instead.""")
        if firewall_instance_associations is not None:
            pulumi.set(__self__, "firewall_instance_associations", firewall_instance_associations)
        if hashing_algorithm is not None:
            pulumi.set(__self__, "hashing_algorithm", hashing_algorithm)
        if inspection_enabled is not None:
            pulumi.set(__self__, "inspection_enabled", inspection_enabled)
        if keep_alive_via_lan_interface_enabled is not None:
            pulumi.set(__self__, "keep_alive_via_lan_interface_enabled", keep_alive_via_lan_interface_enabled)
        if manage_firewall_instance_association is not None:
            pulumi.set(__self__, "manage_firewall_instance_association", manage_firewall_instance_association)
        if tgw_segmentation_for_egress_enabled is not None:
            pulumi.set(__self__, "tgw_segmentation_for_egress_enabled", tgw_segmentation_for_egress_enabled)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="eastWestInspectionExcludedCidrs")
    def east_west_inspection_excluded_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Network List Excluded From East-West Inspection. CIDRs to be excluded from inspection. Type: Set(String). Available as
        of provider version R2.19.2+.
        """
        return pulumi.get(self, "east_west_inspection_excluded_cidrs")

    @east_west_inspection_excluded_cidrs.setter
    def east_west_inspection_excluded_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "east_west_inspection_excluded_cidrs", value)

    @property
    @pulumi.getter(name="egressEnabled")
    def egress_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable/Disable egress through firewall.
        """
        return pulumi.get(self, "egress_enabled")

    @egress_enabled.setter
    def egress_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "egress_enabled", value)

    @property
    @pulumi.getter(name="egressStaticCidrs")
    def egress_static_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of egress static cidrs.
        """
        return pulumi.get(self, "egress_static_cidrs")

    @egress_static_cidrs.setter
    def egress_static_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "egress_static_cidrs", value)

    @property
    @pulumi.getter(name="firewallInstanceAssociations")
    def firewall_instance_associations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixFirenetFirewallInstanceAssociationArgs']]]]:
        """
        List of firewall instances to be associated with fireNet.
        """
        return pulumi.get(self, "firewall_instance_associations")

    @firewall_instance_associations.setter
    def firewall_instance_associations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixFirenetFirewallInstanceAssociationArgs']]]]):
        pulumi.set(self, "firewall_instance_associations", value)

    @property
    @pulumi.getter(name="hashingAlgorithm")
    def hashing_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        Hashing algorithm to load balance traffic across the firewall.
        """
        return pulumi.get(self, "hashing_algorithm")

    @hashing_algorithm.setter
    def hashing_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hashing_algorithm", value)

    @property
    @pulumi.getter(name="inspectionEnabled")
    def inspection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable/Disable traffic inspection.
        """
        return pulumi.get(self, "inspection_enabled")

    @inspection_enabled.setter
    def inspection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "inspection_enabled", value)

    @property
    @pulumi.getter(name="keepAliveViaLanInterfaceEnabled")
    def keep_alive_via_lan_interface_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Keep Alive via Firewall LAN Interface.
        """
        return pulumi.get(self, "keep_alive_via_lan_interface_enabled")

    @keep_alive_via_lan_interface_enabled.setter
    def keep_alive_via_lan_interface_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "keep_alive_via_lan_interface_enabled", value)

    @property
    @pulumi.getter(name="manageFirewallInstanceAssociation")
    def manage_firewall_instance_association(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable this to manage firewall_instance_associations in-line. If this is false, associations must be managed via
        standalone aviatrix_firewall_instance_association resources. Type: boolean, Default: true, Valid values: true/false.
        """
        return pulumi.get(self, "manage_firewall_instance_association")

    @manage_firewall_instance_association.setter
    def manage_firewall_instance_association(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "manage_firewall_instance_association", value)

    @property
    @pulumi.getter(name="tgwSegmentationForEgressEnabled")
    def tgw_segmentation_for_egress_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable TGW segmentation for egress.
        """
        return pulumi.get(self, "tgw_segmentation_for_egress_enabled")

    @tgw_segmentation_for_egress_enabled.setter
    def tgw_segmentation_for_egress_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tgw_segmentation_for_egress_enabled", value)


@pulumi.input_type
class _AviatrixFirenetState:
    def __init__(__self__, *,
                 east_west_inspection_excluded_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 egress_enabled: Optional[pulumi.Input[bool]] = None,
                 egress_static_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 firewall_instance_associations: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixFirenetFirewallInstanceAssociationArgs']]]] = None,
                 hashing_algorithm: Optional[pulumi.Input[str]] = None,
                 inspection_enabled: Optional[pulumi.Input[bool]] = None,
                 keep_alive_via_lan_interface_enabled: Optional[pulumi.Input[bool]] = None,
                 manage_firewall_instance_association: Optional[pulumi.Input[bool]] = None,
                 tgw_segmentation_for_egress_enabled: Optional[pulumi.Input[bool]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixFirenet resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] east_west_inspection_excluded_cidrs: Network List Excluded From East-West Inspection. CIDRs to be excluded from inspection. Type: Set(String). Available as
               of provider version R2.19.2+.
        :param pulumi.Input[bool] egress_enabled: Enable/Disable egress through firewall.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] egress_static_cidrs: List of egress static cidrs.
        :param pulumi.Input[Sequence[pulumi.Input['AviatrixFirenetFirewallInstanceAssociationArgs']]] firewall_instance_associations: List of firewall instances to be associated with fireNet.
        :param pulumi.Input[str] hashing_algorithm: Hashing algorithm to load balance traffic across the firewall.
        :param pulumi.Input[bool] inspection_enabled: Enable/Disable traffic inspection.
        :param pulumi.Input[bool] keep_alive_via_lan_interface_enabled: Enable Keep Alive via Firewall LAN Interface.
        :param pulumi.Input[bool] manage_firewall_instance_association: Enable this to manage firewall_instance_associations in-line. If this is false, associations must be managed via
               standalone aviatrix_firewall_instance_association resources. Type: boolean, Default: true, Valid values: true/false.
        :param pulumi.Input[bool] tgw_segmentation_for_egress_enabled: Enable TGW segmentation for egress.
        :param pulumi.Input[str] vpc_id: VPC ID.
        """
        if east_west_inspection_excluded_cidrs is not None:
            pulumi.set(__self__, "east_west_inspection_excluded_cidrs", east_west_inspection_excluded_cidrs)
        if egress_enabled is not None:
            pulumi.set(__self__, "egress_enabled", egress_enabled)
        if egress_static_cidrs is not None:
            pulumi.set(__self__, "egress_static_cidrs", egress_static_cidrs)
        if firewall_instance_associations is not None:
            warnings.warn("""Please set `manage_firewall_instance_association` to false, and use the standalone aviatrix_firewall_instance_association resource instead.""", DeprecationWarning)
            pulumi.log.warn("""firewall_instance_associations is deprecated: Please set `manage_firewall_instance_association` to false, and use the standalone aviatrix_firewall_instance_association resource instead.""")
        if firewall_instance_associations is not None:
            pulumi.set(__self__, "firewall_instance_associations", firewall_instance_associations)
        if hashing_algorithm is not None:
            pulumi.set(__self__, "hashing_algorithm", hashing_algorithm)
        if inspection_enabled is not None:
            pulumi.set(__self__, "inspection_enabled", inspection_enabled)
        if keep_alive_via_lan_interface_enabled is not None:
            pulumi.set(__self__, "keep_alive_via_lan_interface_enabled", keep_alive_via_lan_interface_enabled)
        if manage_firewall_instance_association is not None:
            pulumi.set(__self__, "manage_firewall_instance_association", manage_firewall_instance_association)
        if tgw_segmentation_for_egress_enabled is not None:
            pulumi.set(__self__, "tgw_segmentation_for_egress_enabled", tgw_segmentation_for_egress_enabled)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="eastWestInspectionExcludedCidrs")
    def east_west_inspection_excluded_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Network List Excluded From East-West Inspection. CIDRs to be excluded from inspection. Type: Set(String). Available as
        of provider version R2.19.2+.
        """
        return pulumi.get(self, "east_west_inspection_excluded_cidrs")

    @east_west_inspection_excluded_cidrs.setter
    def east_west_inspection_excluded_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "east_west_inspection_excluded_cidrs", value)

    @property
    @pulumi.getter(name="egressEnabled")
    def egress_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable/Disable egress through firewall.
        """
        return pulumi.get(self, "egress_enabled")

    @egress_enabled.setter
    def egress_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "egress_enabled", value)

    @property
    @pulumi.getter(name="egressStaticCidrs")
    def egress_static_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of egress static cidrs.
        """
        return pulumi.get(self, "egress_static_cidrs")

    @egress_static_cidrs.setter
    def egress_static_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "egress_static_cidrs", value)

    @property
    @pulumi.getter(name="firewallInstanceAssociations")
    def firewall_instance_associations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixFirenetFirewallInstanceAssociationArgs']]]]:
        """
        List of firewall instances to be associated with fireNet.
        """
        return pulumi.get(self, "firewall_instance_associations")

    @firewall_instance_associations.setter
    def firewall_instance_associations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixFirenetFirewallInstanceAssociationArgs']]]]):
        pulumi.set(self, "firewall_instance_associations", value)

    @property
    @pulumi.getter(name="hashingAlgorithm")
    def hashing_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        Hashing algorithm to load balance traffic across the firewall.
        """
        return pulumi.get(self, "hashing_algorithm")

    @hashing_algorithm.setter
    def hashing_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hashing_algorithm", value)

    @property
    @pulumi.getter(name="inspectionEnabled")
    def inspection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable/Disable traffic inspection.
        """
        return pulumi.get(self, "inspection_enabled")

    @inspection_enabled.setter
    def inspection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "inspection_enabled", value)

    @property
    @pulumi.getter(name="keepAliveViaLanInterfaceEnabled")
    def keep_alive_via_lan_interface_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Keep Alive via Firewall LAN Interface.
        """
        return pulumi.get(self, "keep_alive_via_lan_interface_enabled")

    @keep_alive_via_lan_interface_enabled.setter
    def keep_alive_via_lan_interface_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "keep_alive_via_lan_interface_enabled", value)

    @property
    @pulumi.getter(name="manageFirewallInstanceAssociation")
    def manage_firewall_instance_association(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable this to manage firewall_instance_associations in-line. If this is false, associations must be managed via
        standalone aviatrix_firewall_instance_association resources. Type: boolean, Default: true, Valid values: true/false.
        """
        return pulumi.get(self, "manage_firewall_instance_association")

    @manage_firewall_instance_association.setter
    def manage_firewall_instance_association(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "manage_firewall_instance_association", value)

    @property
    @pulumi.getter(name="tgwSegmentationForEgressEnabled")
    def tgw_segmentation_for_egress_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable TGW segmentation for egress.
        """
        return pulumi.get(self, "tgw_segmentation_for_egress_enabled")

    @tgw_segmentation_for_egress_enabled.setter
    def tgw_segmentation_for_egress_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tgw_segmentation_for_egress_enabled", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class AviatrixFirenet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 east_west_inspection_excluded_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 egress_enabled: Optional[pulumi.Input[bool]] = None,
                 egress_static_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 firewall_instance_associations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixFirenetFirewallInstanceAssociationArgs']]]]] = None,
                 hashing_algorithm: Optional[pulumi.Input[str]] = None,
                 inspection_enabled: Optional[pulumi.Input[bool]] = None,
                 keep_alive_via_lan_interface_enabled: Optional[pulumi.Input[bool]] = None,
                 manage_firewall_instance_association: Optional[pulumi.Input[bool]] = None,
                 tgw_segmentation_for_egress_enabled: Optional[pulumi.Input[bool]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AviatrixFirenet resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] east_west_inspection_excluded_cidrs: Network List Excluded From East-West Inspection. CIDRs to be excluded from inspection. Type: Set(String). Available as
               of provider version R2.19.2+.
        :param pulumi.Input[bool] egress_enabled: Enable/Disable egress through firewall.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] egress_static_cidrs: List of egress static cidrs.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixFirenetFirewallInstanceAssociationArgs']]]] firewall_instance_associations: List of firewall instances to be associated with fireNet.
        :param pulumi.Input[str] hashing_algorithm: Hashing algorithm to load balance traffic across the firewall.
        :param pulumi.Input[bool] inspection_enabled: Enable/Disable traffic inspection.
        :param pulumi.Input[bool] keep_alive_via_lan_interface_enabled: Enable Keep Alive via Firewall LAN Interface.
        :param pulumi.Input[bool] manage_firewall_instance_association: Enable this to manage firewall_instance_associations in-line. If this is false, associations must be managed via
               standalone aviatrix_firewall_instance_association resources. Type: boolean, Default: true, Valid values: true/false.
        :param pulumi.Input[bool] tgw_segmentation_for_egress_enabled: Enable TGW segmentation for egress.
        :param pulumi.Input[str] vpc_id: VPC ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixFirenetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixFirenet resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixFirenetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixFirenetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 east_west_inspection_excluded_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 egress_enabled: Optional[pulumi.Input[bool]] = None,
                 egress_static_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 firewall_instance_associations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixFirenetFirewallInstanceAssociationArgs']]]]] = None,
                 hashing_algorithm: Optional[pulumi.Input[str]] = None,
                 inspection_enabled: Optional[pulumi.Input[bool]] = None,
                 keep_alive_via_lan_interface_enabled: Optional[pulumi.Input[bool]] = None,
                 manage_firewall_instance_association: Optional[pulumi.Input[bool]] = None,
                 tgw_segmentation_for_egress_enabled: Optional[pulumi.Input[bool]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixFirenetArgs.__new__(AviatrixFirenetArgs)

            __props__.__dict__["east_west_inspection_excluded_cidrs"] = east_west_inspection_excluded_cidrs
            __props__.__dict__["egress_enabled"] = egress_enabled
            __props__.__dict__["egress_static_cidrs"] = egress_static_cidrs
            if firewall_instance_associations is not None and not opts.urn:
                warnings.warn("""Please set `manage_firewall_instance_association` to false, and use the standalone aviatrix_firewall_instance_association resource instead.""", DeprecationWarning)
                pulumi.log.warn("""firewall_instance_associations is deprecated: Please set `manage_firewall_instance_association` to false, and use the standalone aviatrix_firewall_instance_association resource instead.""")
            __props__.__dict__["firewall_instance_associations"] = firewall_instance_associations
            __props__.__dict__["hashing_algorithm"] = hashing_algorithm
            __props__.__dict__["inspection_enabled"] = inspection_enabled
            __props__.__dict__["keep_alive_via_lan_interface_enabled"] = keep_alive_via_lan_interface_enabled
            __props__.__dict__["manage_firewall_instance_association"] = manage_firewall_instance_association
            __props__.__dict__["tgw_segmentation_for_egress_enabled"] = tgw_segmentation_for_egress_enabled
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
        super(AviatrixFirenet, __self__).__init__(
            'aviatrix:index/aviatrixFirenet:AviatrixFirenet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            east_west_inspection_excluded_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            egress_enabled: Optional[pulumi.Input[bool]] = None,
            egress_static_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            firewall_instance_associations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixFirenetFirewallInstanceAssociationArgs']]]]] = None,
            hashing_algorithm: Optional[pulumi.Input[str]] = None,
            inspection_enabled: Optional[pulumi.Input[bool]] = None,
            keep_alive_via_lan_interface_enabled: Optional[pulumi.Input[bool]] = None,
            manage_firewall_instance_association: Optional[pulumi.Input[bool]] = None,
            tgw_segmentation_for_egress_enabled: Optional[pulumi.Input[bool]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'AviatrixFirenet':
        """
        Get an existing AviatrixFirenet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] east_west_inspection_excluded_cidrs: Network List Excluded From East-West Inspection. CIDRs to be excluded from inspection. Type: Set(String). Available as
               of provider version R2.19.2+.
        :param pulumi.Input[bool] egress_enabled: Enable/Disable egress through firewall.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] egress_static_cidrs: List of egress static cidrs.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixFirenetFirewallInstanceAssociationArgs']]]] firewall_instance_associations: List of firewall instances to be associated with fireNet.
        :param pulumi.Input[str] hashing_algorithm: Hashing algorithm to load balance traffic across the firewall.
        :param pulumi.Input[bool] inspection_enabled: Enable/Disable traffic inspection.
        :param pulumi.Input[bool] keep_alive_via_lan_interface_enabled: Enable Keep Alive via Firewall LAN Interface.
        :param pulumi.Input[bool] manage_firewall_instance_association: Enable this to manage firewall_instance_associations in-line. If this is false, associations must be managed via
               standalone aviatrix_firewall_instance_association resources. Type: boolean, Default: true, Valid values: true/false.
        :param pulumi.Input[bool] tgw_segmentation_for_egress_enabled: Enable TGW segmentation for egress.
        :param pulumi.Input[str] vpc_id: VPC ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixFirenetState.__new__(_AviatrixFirenetState)

        __props__.__dict__["east_west_inspection_excluded_cidrs"] = east_west_inspection_excluded_cidrs
        __props__.__dict__["egress_enabled"] = egress_enabled
        __props__.__dict__["egress_static_cidrs"] = egress_static_cidrs
        __props__.__dict__["firewall_instance_associations"] = firewall_instance_associations
        __props__.__dict__["hashing_algorithm"] = hashing_algorithm
        __props__.__dict__["inspection_enabled"] = inspection_enabled
        __props__.__dict__["keep_alive_via_lan_interface_enabled"] = keep_alive_via_lan_interface_enabled
        __props__.__dict__["manage_firewall_instance_association"] = manage_firewall_instance_association
        __props__.__dict__["tgw_segmentation_for_egress_enabled"] = tgw_segmentation_for_egress_enabled
        __props__.__dict__["vpc_id"] = vpc_id
        return AviatrixFirenet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="eastWestInspectionExcludedCidrs")
    def east_west_inspection_excluded_cidrs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Network List Excluded From East-West Inspection. CIDRs to be excluded from inspection. Type: Set(String). Available as
        of provider version R2.19.2+.
        """
        return pulumi.get(self, "east_west_inspection_excluded_cidrs")

    @property
    @pulumi.getter(name="egressEnabled")
    def egress_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable/Disable egress through firewall.
        """
        return pulumi.get(self, "egress_enabled")

    @property
    @pulumi.getter(name="egressStaticCidrs")
    def egress_static_cidrs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of egress static cidrs.
        """
        return pulumi.get(self, "egress_static_cidrs")

    @property
    @pulumi.getter(name="firewallInstanceAssociations")
    def firewall_instance_associations(self) -> pulumi.Output[Optional[Sequence['outputs.AviatrixFirenetFirewallInstanceAssociation']]]:
        """
        List of firewall instances to be associated with fireNet.
        """
        return pulumi.get(self, "firewall_instance_associations")

    @property
    @pulumi.getter(name="hashingAlgorithm")
    def hashing_algorithm(self) -> pulumi.Output[Optional[str]]:
        """
        Hashing algorithm to load balance traffic across the firewall.
        """
        return pulumi.get(self, "hashing_algorithm")

    @property
    @pulumi.getter(name="inspectionEnabled")
    def inspection_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable/Disable traffic inspection.
        """
        return pulumi.get(self, "inspection_enabled")

    @property
    @pulumi.getter(name="keepAliveViaLanInterfaceEnabled")
    def keep_alive_via_lan_interface_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable Keep Alive via Firewall LAN Interface.
        """
        return pulumi.get(self, "keep_alive_via_lan_interface_enabled")

    @property
    @pulumi.getter(name="manageFirewallInstanceAssociation")
    def manage_firewall_instance_association(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable this to manage firewall_instance_associations in-line. If this is false, associations must be managed via
        standalone aviatrix_firewall_instance_association resources. Type: boolean, Default: true, Valid values: true/false.
        """
        return pulumi.get(self, "manage_firewall_instance_association")

    @property
    @pulumi.getter(name="tgwSegmentationForEgressEnabled")
    def tgw_segmentation_for_egress_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable TGW segmentation for egress.
        """
        return pulumi.get(self, "tgw_segmentation_for_egress_enabled")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        VPC ID.
        """
        return pulumi.get(self, "vpc_id")

