# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixEdgeSpokeTransitAttachmentArgs', 'AviatrixEdgeSpokeTransitAttachment']

@pulumi.input_type
class AviatrixEdgeSpokeTransitAttachmentArgs:
    def __init__(__self__, *,
                 spoke_gw_name: pulumi.Input[str],
                 transit_gw_name: pulumi.Input[str],
                 enable_insane_mode: Optional[pulumi.Input[bool]] = None,
                 enable_jumbo_frame: Optional[pulumi.Input[bool]] = None,
                 enable_over_private_network: Optional[pulumi.Input[bool]] = None,
                 insane_mode_tunnel_number: Optional[pulumi.Input[int]] = None,
                 spoke_prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transit_prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AviatrixEdgeSpokeTransitAttachment resource.
        :param pulumi.Input[str] spoke_gw_name: Name of the Edge as a Spoke to attach to the transit network.
        :param pulumi.Input[str] transit_gw_name: Name of the transit gateway to attach the Edge as a Spoke to.
        :param pulumi.Input[bool] enable_insane_mode: Enable jumbo frame.
        :param pulumi.Input[bool] enable_jumbo_frame: Enable jumbo frame.
        :param pulumi.Input[bool] enable_over_private_network: Enable over private network.
        :param pulumi.Input[int] insane_mode_tunnel_number: Insane mode tunnel number.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] spoke_prepend_as_paths: AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on Edge as a Spoke.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] transit_prepend_as_paths: AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit gateway.
        """
        pulumi.set(__self__, "spoke_gw_name", spoke_gw_name)
        pulumi.set(__self__, "transit_gw_name", transit_gw_name)
        if enable_insane_mode is not None:
            pulumi.set(__self__, "enable_insane_mode", enable_insane_mode)
        if enable_jumbo_frame is not None:
            pulumi.set(__self__, "enable_jumbo_frame", enable_jumbo_frame)
        if enable_over_private_network is not None:
            pulumi.set(__self__, "enable_over_private_network", enable_over_private_network)
        if insane_mode_tunnel_number is not None:
            pulumi.set(__self__, "insane_mode_tunnel_number", insane_mode_tunnel_number)
        if spoke_prepend_as_paths is not None:
            pulumi.set(__self__, "spoke_prepend_as_paths", spoke_prepend_as_paths)
        if transit_prepend_as_paths is not None:
            pulumi.set(__self__, "transit_prepend_as_paths", transit_prepend_as_paths)

    @property
    @pulumi.getter(name="spokeGwName")
    def spoke_gw_name(self) -> pulumi.Input[str]:
        """
        Name of the Edge as a Spoke to attach to the transit network.
        """
        return pulumi.get(self, "spoke_gw_name")

    @spoke_gw_name.setter
    def spoke_gw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "spoke_gw_name", value)

    @property
    @pulumi.getter(name="transitGwName")
    def transit_gw_name(self) -> pulumi.Input[str]:
        """
        Name of the transit gateway to attach the Edge as a Spoke to.
        """
        return pulumi.get(self, "transit_gw_name")

    @transit_gw_name.setter
    def transit_gw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "transit_gw_name", value)

    @property
    @pulumi.getter(name="enableInsaneMode")
    def enable_insane_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable jumbo frame.
        """
        return pulumi.get(self, "enable_insane_mode")

    @enable_insane_mode.setter
    def enable_insane_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_insane_mode", value)

    @property
    @pulumi.getter(name="enableJumboFrame")
    def enable_jumbo_frame(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable jumbo frame.
        """
        return pulumi.get(self, "enable_jumbo_frame")

    @enable_jumbo_frame.setter
    def enable_jumbo_frame(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_jumbo_frame", value)

    @property
    @pulumi.getter(name="enableOverPrivateNetwork")
    def enable_over_private_network(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable over private network.
        """
        return pulumi.get(self, "enable_over_private_network")

    @enable_over_private_network.setter
    def enable_over_private_network(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_over_private_network", value)

    @property
    @pulumi.getter(name="insaneModeTunnelNumber")
    def insane_mode_tunnel_number(self) -> Optional[pulumi.Input[int]]:
        """
        Insane mode tunnel number.
        """
        return pulumi.get(self, "insane_mode_tunnel_number")

    @insane_mode_tunnel_number.setter
    def insane_mode_tunnel_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "insane_mode_tunnel_number", value)

    @property
    @pulumi.getter(name="spokePrependAsPaths")
    def spoke_prepend_as_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on Edge as a Spoke.
        """
        return pulumi.get(self, "spoke_prepend_as_paths")

    @spoke_prepend_as_paths.setter
    def spoke_prepend_as_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "spoke_prepend_as_paths", value)

    @property
    @pulumi.getter(name="transitPrependAsPaths")
    def transit_prepend_as_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit gateway.
        """
        return pulumi.get(self, "transit_prepend_as_paths")

    @transit_prepend_as_paths.setter
    def transit_prepend_as_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "transit_prepend_as_paths", value)


@pulumi.input_type
class _AviatrixEdgeSpokeTransitAttachmentState:
    def __init__(__self__, *,
                 enable_insane_mode: Optional[pulumi.Input[bool]] = None,
                 enable_jumbo_frame: Optional[pulumi.Input[bool]] = None,
                 enable_over_private_network: Optional[pulumi.Input[bool]] = None,
                 insane_mode_tunnel_number: Optional[pulumi.Input[int]] = None,
                 spoke_gw_name: Optional[pulumi.Input[str]] = None,
                 spoke_prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transit_gw_name: Optional[pulumi.Input[str]] = None,
                 transit_prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering AviatrixEdgeSpokeTransitAttachment resources.
        :param pulumi.Input[bool] enable_insane_mode: Enable jumbo frame.
        :param pulumi.Input[bool] enable_jumbo_frame: Enable jumbo frame.
        :param pulumi.Input[bool] enable_over_private_network: Enable over private network.
        :param pulumi.Input[int] insane_mode_tunnel_number: Insane mode tunnel number.
        :param pulumi.Input[str] spoke_gw_name: Name of the Edge as a Spoke to attach to the transit network.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] spoke_prepend_as_paths: AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on Edge as a Spoke.
        :param pulumi.Input[str] transit_gw_name: Name of the transit gateway to attach the Edge as a Spoke to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] transit_prepend_as_paths: AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit gateway.
        """
        if enable_insane_mode is not None:
            pulumi.set(__self__, "enable_insane_mode", enable_insane_mode)
        if enable_jumbo_frame is not None:
            pulumi.set(__self__, "enable_jumbo_frame", enable_jumbo_frame)
        if enable_over_private_network is not None:
            pulumi.set(__self__, "enable_over_private_network", enable_over_private_network)
        if insane_mode_tunnel_number is not None:
            pulumi.set(__self__, "insane_mode_tunnel_number", insane_mode_tunnel_number)
        if spoke_gw_name is not None:
            pulumi.set(__self__, "spoke_gw_name", spoke_gw_name)
        if spoke_prepend_as_paths is not None:
            pulumi.set(__self__, "spoke_prepend_as_paths", spoke_prepend_as_paths)
        if transit_gw_name is not None:
            pulumi.set(__self__, "transit_gw_name", transit_gw_name)
        if transit_prepend_as_paths is not None:
            pulumi.set(__self__, "transit_prepend_as_paths", transit_prepend_as_paths)

    @property
    @pulumi.getter(name="enableInsaneMode")
    def enable_insane_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable jumbo frame.
        """
        return pulumi.get(self, "enable_insane_mode")

    @enable_insane_mode.setter
    def enable_insane_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_insane_mode", value)

    @property
    @pulumi.getter(name="enableJumboFrame")
    def enable_jumbo_frame(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable jumbo frame.
        """
        return pulumi.get(self, "enable_jumbo_frame")

    @enable_jumbo_frame.setter
    def enable_jumbo_frame(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_jumbo_frame", value)

    @property
    @pulumi.getter(name="enableOverPrivateNetwork")
    def enable_over_private_network(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable over private network.
        """
        return pulumi.get(self, "enable_over_private_network")

    @enable_over_private_network.setter
    def enable_over_private_network(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_over_private_network", value)

    @property
    @pulumi.getter(name="insaneModeTunnelNumber")
    def insane_mode_tunnel_number(self) -> Optional[pulumi.Input[int]]:
        """
        Insane mode tunnel number.
        """
        return pulumi.get(self, "insane_mode_tunnel_number")

    @insane_mode_tunnel_number.setter
    def insane_mode_tunnel_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "insane_mode_tunnel_number", value)

    @property
    @pulumi.getter(name="spokeGwName")
    def spoke_gw_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Edge as a Spoke to attach to the transit network.
        """
        return pulumi.get(self, "spoke_gw_name")

    @spoke_gw_name.setter
    def spoke_gw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spoke_gw_name", value)

    @property
    @pulumi.getter(name="spokePrependAsPaths")
    def spoke_prepend_as_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on Edge as a Spoke.
        """
        return pulumi.get(self, "spoke_prepend_as_paths")

    @spoke_prepend_as_paths.setter
    def spoke_prepend_as_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "spoke_prepend_as_paths", value)

    @property
    @pulumi.getter(name="transitGwName")
    def transit_gw_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the transit gateway to attach the Edge as a Spoke to.
        """
        return pulumi.get(self, "transit_gw_name")

    @transit_gw_name.setter
    def transit_gw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_gw_name", value)

    @property
    @pulumi.getter(name="transitPrependAsPaths")
    def transit_prepend_as_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit gateway.
        """
        return pulumi.get(self, "transit_prepend_as_paths")

    @transit_prepend_as_paths.setter
    def transit_prepend_as_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "transit_prepend_as_paths", value)


class AviatrixEdgeSpokeTransitAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_insane_mode: Optional[pulumi.Input[bool]] = None,
                 enable_jumbo_frame: Optional[pulumi.Input[bool]] = None,
                 enable_over_private_network: Optional[pulumi.Input[bool]] = None,
                 insane_mode_tunnel_number: Optional[pulumi.Input[int]] = None,
                 spoke_gw_name: Optional[pulumi.Input[str]] = None,
                 spoke_prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transit_gw_name: Optional[pulumi.Input[str]] = None,
                 transit_prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Create a AviatrixEdgeSpokeTransitAttachment resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_insane_mode: Enable jumbo frame.
        :param pulumi.Input[bool] enable_jumbo_frame: Enable jumbo frame.
        :param pulumi.Input[bool] enable_over_private_network: Enable over private network.
        :param pulumi.Input[int] insane_mode_tunnel_number: Insane mode tunnel number.
        :param pulumi.Input[str] spoke_gw_name: Name of the Edge as a Spoke to attach to the transit network.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] spoke_prepend_as_paths: AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on Edge as a Spoke.
        :param pulumi.Input[str] transit_gw_name: Name of the transit gateway to attach the Edge as a Spoke to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] transit_prepend_as_paths: AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit gateway.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixEdgeSpokeTransitAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixEdgeSpokeTransitAttachment resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixEdgeSpokeTransitAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixEdgeSpokeTransitAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enable_insane_mode: Optional[pulumi.Input[bool]] = None,
                 enable_jumbo_frame: Optional[pulumi.Input[bool]] = None,
                 enable_over_private_network: Optional[pulumi.Input[bool]] = None,
                 insane_mode_tunnel_number: Optional[pulumi.Input[int]] = None,
                 spoke_gw_name: Optional[pulumi.Input[str]] = None,
                 spoke_prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transit_gw_name: Optional[pulumi.Input[str]] = None,
                 transit_prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixEdgeSpokeTransitAttachmentArgs.__new__(AviatrixEdgeSpokeTransitAttachmentArgs)

            __props__.__dict__["enable_insane_mode"] = enable_insane_mode
            __props__.__dict__["enable_jumbo_frame"] = enable_jumbo_frame
            __props__.__dict__["enable_over_private_network"] = enable_over_private_network
            __props__.__dict__["insane_mode_tunnel_number"] = insane_mode_tunnel_number
            if spoke_gw_name is None and not opts.urn:
                raise TypeError("Missing required property 'spoke_gw_name'")
            __props__.__dict__["spoke_gw_name"] = spoke_gw_name
            __props__.__dict__["spoke_prepend_as_paths"] = spoke_prepend_as_paths
            if transit_gw_name is None and not opts.urn:
                raise TypeError("Missing required property 'transit_gw_name'")
            __props__.__dict__["transit_gw_name"] = transit_gw_name
            __props__.__dict__["transit_prepend_as_paths"] = transit_prepend_as_paths
        super(AviatrixEdgeSpokeTransitAttachment, __self__).__init__(
            'aviatrix:index/aviatrixEdgeSpokeTransitAttachment:AviatrixEdgeSpokeTransitAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enable_insane_mode: Optional[pulumi.Input[bool]] = None,
            enable_jumbo_frame: Optional[pulumi.Input[bool]] = None,
            enable_over_private_network: Optional[pulumi.Input[bool]] = None,
            insane_mode_tunnel_number: Optional[pulumi.Input[int]] = None,
            spoke_gw_name: Optional[pulumi.Input[str]] = None,
            spoke_prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            transit_gw_name: Optional[pulumi.Input[str]] = None,
            transit_prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'AviatrixEdgeSpokeTransitAttachment':
        """
        Get an existing AviatrixEdgeSpokeTransitAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enable_insane_mode: Enable jumbo frame.
        :param pulumi.Input[bool] enable_jumbo_frame: Enable jumbo frame.
        :param pulumi.Input[bool] enable_over_private_network: Enable over private network.
        :param pulumi.Input[int] insane_mode_tunnel_number: Insane mode tunnel number.
        :param pulumi.Input[str] spoke_gw_name: Name of the Edge as a Spoke to attach to the transit network.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] spoke_prepend_as_paths: AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on Edge as a Spoke.
        :param pulumi.Input[str] transit_gw_name: Name of the transit gateway to attach the Edge as a Spoke to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] transit_prepend_as_paths: AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit gateway.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixEdgeSpokeTransitAttachmentState.__new__(_AviatrixEdgeSpokeTransitAttachmentState)

        __props__.__dict__["enable_insane_mode"] = enable_insane_mode
        __props__.__dict__["enable_jumbo_frame"] = enable_jumbo_frame
        __props__.__dict__["enable_over_private_network"] = enable_over_private_network
        __props__.__dict__["insane_mode_tunnel_number"] = insane_mode_tunnel_number
        __props__.__dict__["spoke_gw_name"] = spoke_gw_name
        __props__.__dict__["spoke_prepend_as_paths"] = spoke_prepend_as_paths
        __props__.__dict__["transit_gw_name"] = transit_gw_name
        __props__.__dict__["transit_prepend_as_paths"] = transit_prepend_as_paths
        return AviatrixEdgeSpokeTransitAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="enableInsaneMode")
    def enable_insane_mode(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable jumbo frame.
        """
        return pulumi.get(self, "enable_insane_mode")

    @property
    @pulumi.getter(name="enableJumboFrame")
    def enable_jumbo_frame(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable jumbo frame.
        """
        return pulumi.get(self, "enable_jumbo_frame")

    @property
    @pulumi.getter(name="enableOverPrivateNetwork")
    def enable_over_private_network(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable over private network.
        """
        return pulumi.get(self, "enable_over_private_network")

    @property
    @pulumi.getter(name="insaneModeTunnelNumber")
    def insane_mode_tunnel_number(self) -> pulumi.Output[Optional[int]]:
        """
        Insane mode tunnel number.
        """
        return pulumi.get(self, "insane_mode_tunnel_number")

    @property
    @pulumi.getter(name="spokeGwName")
    def spoke_gw_name(self) -> pulumi.Output[str]:
        """
        Name of the Edge as a Spoke to attach to the transit network.
        """
        return pulumi.get(self, "spoke_gw_name")

    @property
    @pulumi.getter(name="spokePrependAsPaths")
    def spoke_prepend_as_paths(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on Edge as a Spoke.
        """
        return pulumi.get(self, "spoke_prepend_as_paths")

    @property
    @pulumi.getter(name="transitGwName")
    def transit_gw_name(self) -> pulumi.Output[str]:
        """
        Name of the transit gateway to attach the Edge as a Spoke to.
        """
        return pulumi.get(self, "transit_gw_name")

    @property
    @pulumi.getter(name="transitPrependAsPaths")
    def transit_prepend_as_paths(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        AS Path Prepend customized by specifying AS PATH for a BGP connection. Applies on transit gateway.
        """
        return pulumi.get(self, "transit_prepend_as_paths")

