# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixEdgeSpokeExternalDeviceConnArgs', 'AviatrixEdgeSpokeExternalDeviceConn']

@pulumi.input_type
class AviatrixEdgeSpokeExternalDeviceConnArgs:
    def __init__(__self__, *,
                 bgp_local_as_num: pulumi.Input[str],
                 bgp_remote_as_num: pulumi.Input[str],
                 connection_name: pulumi.Input[str],
                 gw_name: pulumi.Input[str],
                 local_lan_ip: pulumi.Input[str],
                 remote_lan_ip: pulumi.Input[str],
                 site_id: pulumi.Input[str],
                 connection_type: Optional[pulumi.Input[str]] = None,
                 tunnel_protocol: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AviatrixEdgeSpokeExternalDeviceConn resource.
        :param pulumi.Input[str] bgp_local_as_num: BGP local AS number.
        :param pulumi.Input[str] bgp_remote_as_num: BGP remote AS number.
        :param pulumi.Input[str] connection_name: The name of the spoke external device connection which is going to be created.
        :param pulumi.Input[str] gw_name: Name of the BGP Spoke Gateway.
        :param pulumi.Input[str] local_lan_ip: Local LAN IP.
        :param pulumi.Input[str] remote_lan_ip: Remote LAN IP.
        :param pulumi.Input[str] site_id: ID of the VPC where the BGP Spoke Gateway is located.
        :param pulumi.Input[str] connection_type: Connection type. Valid values: 'bgp'. Default value: 'bgp'.
        :param pulumi.Input[str] tunnel_protocol: Tunnel Protocol. Valid value: 'LAN'. Default value: 'LAN'. Case insensitive.
        """
        pulumi.set(__self__, "bgp_local_as_num", bgp_local_as_num)
        pulumi.set(__self__, "bgp_remote_as_num", bgp_remote_as_num)
        pulumi.set(__self__, "connection_name", connection_name)
        pulumi.set(__self__, "gw_name", gw_name)
        pulumi.set(__self__, "local_lan_ip", local_lan_ip)
        pulumi.set(__self__, "remote_lan_ip", remote_lan_ip)
        pulumi.set(__self__, "site_id", site_id)
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if tunnel_protocol is not None:
            pulumi.set(__self__, "tunnel_protocol", tunnel_protocol)

    @property
    @pulumi.getter(name="bgpLocalAsNum")
    def bgp_local_as_num(self) -> pulumi.Input[str]:
        """
        BGP local AS number.
        """
        return pulumi.get(self, "bgp_local_as_num")

    @bgp_local_as_num.setter
    def bgp_local_as_num(self, value: pulumi.Input[str]):
        pulumi.set(self, "bgp_local_as_num", value)

    @property
    @pulumi.getter(name="bgpRemoteAsNum")
    def bgp_remote_as_num(self) -> pulumi.Input[str]:
        """
        BGP remote AS number.
        """
        return pulumi.get(self, "bgp_remote_as_num")

    @bgp_remote_as_num.setter
    def bgp_remote_as_num(self, value: pulumi.Input[str]):
        pulumi.set(self, "bgp_remote_as_num", value)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Input[str]:
        """
        The name of the spoke external device connection which is going to be created.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Input[str]:
        """
        Name of the BGP Spoke Gateway.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter(name="localLanIp")
    def local_lan_ip(self) -> pulumi.Input[str]:
        """
        Local LAN IP.
        """
        return pulumi.get(self, "local_lan_ip")

    @local_lan_ip.setter
    def local_lan_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "local_lan_ip", value)

    @property
    @pulumi.getter(name="remoteLanIp")
    def remote_lan_ip(self) -> pulumi.Input[str]:
        """
        Remote LAN IP.
        """
        return pulumi.get(self, "remote_lan_ip")

    @remote_lan_ip.setter
    def remote_lan_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "remote_lan_ip", value)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[str]:
        """
        ID of the VPC where the BGP Spoke Gateway is located.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[pulumi.Input[str]]:
        """
        Connection type. Valid values: 'bgp'. Default value: 'bgp'.
        """
        return pulumi.get(self, "connection_type")

    @connection_type.setter
    def connection_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_type", value)

    @property
    @pulumi.getter(name="tunnelProtocol")
    def tunnel_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Tunnel Protocol. Valid value: 'LAN'. Default value: 'LAN'. Case insensitive.
        """
        return pulumi.get(self, "tunnel_protocol")

    @tunnel_protocol.setter
    def tunnel_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_protocol", value)


@pulumi.input_type
class _AviatrixEdgeSpokeExternalDeviceConnState:
    def __init__(__self__, *,
                 bgp_local_as_num: Optional[pulumi.Input[str]] = None,
                 bgp_remote_as_num: Optional[pulumi.Input[str]] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 connection_type: Optional[pulumi.Input[str]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 local_lan_ip: Optional[pulumi.Input[str]] = None,
                 remote_lan_ip: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[str]] = None,
                 tunnel_protocol: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixEdgeSpokeExternalDeviceConn resources.
        :param pulumi.Input[str] bgp_local_as_num: BGP local AS number.
        :param pulumi.Input[str] bgp_remote_as_num: BGP remote AS number.
        :param pulumi.Input[str] connection_name: The name of the spoke external device connection which is going to be created.
        :param pulumi.Input[str] connection_type: Connection type. Valid values: 'bgp'. Default value: 'bgp'.
        :param pulumi.Input[str] gw_name: Name of the BGP Spoke Gateway.
        :param pulumi.Input[str] local_lan_ip: Local LAN IP.
        :param pulumi.Input[str] remote_lan_ip: Remote LAN IP.
        :param pulumi.Input[str] site_id: ID of the VPC where the BGP Spoke Gateway is located.
        :param pulumi.Input[str] tunnel_protocol: Tunnel Protocol. Valid value: 'LAN'. Default value: 'LAN'. Case insensitive.
        """
        if bgp_local_as_num is not None:
            pulumi.set(__self__, "bgp_local_as_num", bgp_local_as_num)
        if bgp_remote_as_num is not None:
            pulumi.set(__self__, "bgp_remote_as_num", bgp_remote_as_num)
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if gw_name is not None:
            pulumi.set(__self__, "gw_name", gw_name)
        if local_lan_ip is not None:
            pulumi.set(__self__, "local_lan_ip", local_lan_ip)
        if remote_lan_ip is not None:
            pulumi.set(__self__, "remote_lan_ip", remote_lan_ip)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if tunnel_protocol is not None:
            pulumi.set(__self__, "tunnel_protocol", tunnel_protocol)

    @property
    @pulumi.getter(name="bgpLocalAsNum")
    def bgp_local_as_num(self) -> Optional[pulumi.Input[str]]:
        """
        BGP local AS number.
        """
        return pulumi.get(self, "bgp_local_as_num")

    @bgp_local_as_num.setter
    def bgp_local_as_num(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bgp_local_as_num", value)

    @property
    @pulumi.getter(name="bgpRemoteAsNum")
    def bgp_remote_as_num(self) -> Optional[pulumi.Input[str]]:
        """
        BGP remote AS number.
        """
        return pulumi.get(self, "bgp_remote_as_num")

    @bgp_remote_as_num.setter
    def bgp_remote_as_num(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bgp_remote_as_num", value)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the spoke external device connection which is going to be created.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[pulumi.Input[str]]:
        """
        Connection type. Valid values: 'bgp'. Default value: 'bgp'.
        """
        return pulumi.get(self, "connection_type")

    @connection_type.setter
    def connection_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_type", value)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the BGP Spoke Gateway.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter(name="localLanIp")
    def local_lan_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Local LAN IP.
        """
        return pulumi.get(self, "local_lan_ip")

    @local_lan_ip.setter
    def local_lan_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_lan_ip", value)

    @property
    @pulumi.getter(name="remoteLanIp")
    def remote_lan_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Remote LAN IP.
        """
        return pulumi.get(self, "remote_lan_ip")

    @remote_lan_ip.setter
    def remote_lan_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_lan_ip", value)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the VPC where the BGP Spoke Gateway is located.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter(name="tunnelProtocol")
    def tunnel_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Tunnel Protocol. Valid value: 'LAN'. Default value: 'LAN'. Case insensitive.
        """
        return pulumi.get(self, "tunnel_protocol")

    @tunnel_protocol.setter
    def tunnel_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_protocol", value)


class AviatrixEdgeSpokeExternalDeviceConn(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bgp_local_as_num: Optional[pulumi.Input[str]] = None,
                 bgp_remote_as_num: Optional[pulumi.Input[str]] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 connection_type: Optional[pulumi.Input[str]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 local_lan_ip: Optional[pulumi.Input[str]] = None,
                 remote_lan_ip: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[str]] = None,
                 tunnel_protocol: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AviatrixEdgeSpokeExternalDeviceConn resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bgp_local_as_num: BGP local AS number.
        :param pulumi.Input[str] bgp_remote_as_num: BGP remote AS number.
        :param pulumi.Input[str] connection_name: The name of the spoke external device connection which is going to be created.
        :param pulumi.Input[str] connection_type: Connection type. Valid values: 'bgp'. Default value: 'bgp'.
        :param pulumi.Input[str] gw_name: Name of the BGP Spoke Gateway.
        :param pulumi.Input[str] local_lan_ip: Local LAN IP.
        :param pulumi.Input[str] remote_lan_ip: Remote LAN IP.
        :param pulumi.Input[str] site_id: ID of the VPC where the BGP Spoke Gateway is located.
        :param pulumi.Input[str] tunnel_protocol: Tunnel Protocol. Valid value: 'LAN'. Default value: 'LAN'. Case insensitive.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixEdgeSpokeExternalDeviceConnArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixEdgeSpokeExternalDeviceConn resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixEdgeSpokeExternalDeviceConnArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixEdgeSpokeExternalDeviceConnArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bgp_local_as_num: Optional[pulumi.Input[str]] = None,
                 bgp_remote_as_num: Optional[pulumi.Input[str]] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 connection_type: Optional[pulumi.Input[str]] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 local_lan_ip: Optional[pulumi.Input[str]] = None,
                 remote_lan_ip: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[str]] = None,
                 tunnel_protocol: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixEdgeSpokeExternalDeviceConnArgs.__new__(AviatrixEdgeSpokeExternalDeviceConnArgs)

            if bgp_local_as_num is None and not opts.urn:
                raise TypeError("Missing required property 'bgp_local_as_num'")
            __props__.__dict__["bgp_local_as_num"] = bgp_local_as_num
            if bgp_remote_as_num is None and not opts.urn:
                raise TypeError("Missing required property 'bgp_remote_as_num'")
            __props__.__dict__["bgp_remote_as_num"] = bgp_remote_as_num
            if connection_name is None and not opts.urn:
                raise TypeError("Missing required property 'connection_name'")
            __props__.__dict__["connection_name"] = connection_name
            __props__.__dict__["connection_type"] = connection_type
            if gw_name is None and not opts.urn:
                raise TypeError("Missing required property 'gw_name'")
            __props__.__dict__["gw_name"] = gw_name
            if local_lan_ip is None and not opts.urn:
                raise TypeError("Missing required property 'local_lan_ip'")
            __props__.__dict__["local_lan_ip"] = local_lan_ip
            if remote_lan_ip is None and not opts.urn:
                raise TypeError("Missing required property 'remote_lan_ip'")
            __props__.__dict__["remote_lan_ip"] = remote_lan_ip
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["tunnel_protocol"] = tunnel_protocol
        super(AviatrixEdgeSpokeExternalDeviceConn, __self__).__init__(
            'aviatrix:index/aviatrixEdgeSpokeExternalDeviceConn:AviatrixEdgeSpokeExternalDeviceConn',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bgp_local_as_num: Optional[pulumi.Input[str]] = None,
            bgp_remote_as_num: Optional[pulumi.Input[str]] = None,
            connection_name: Optional[pulumi.Input[str]] = None,
            connection_type: Optional[pulumi.Input[str]] = None,
            gw_name: Optional[pulumi.Input[str]] = None,
            local_lan_ip: Optional[pulumi.Input[str]] = None,
            remote_lan_ip: Optional[pulumi.Input[str]] = None,
            site_id: Optional[pulumi.Input[str]] = None,
            tunnel_protocol: Optional[pulumi.Input[str]] = None) -> 'AviatrixEdgeSpokeExternalDeviceConn':
        """
        Get an existing AviatrixEdgeSpokeExternalDeviceConn resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bgp_local_as_num: BGP local AS number.
        :param pulumi.Input[str] bgp_remote_as_num: BGP remote AS number.
        :param pulumi.Input[str] connection_name: The name of the spoke external device connection which is going to be created.
        :param pulumi.Input[str] connection_type: Connection type. Valid values: 'bgp'. Default value: 'bgp'.
        :param pulumi.Input[str] gw_name: Name of the BGP Spoke Gateway.
        :param pulumi.Input[str] local_lan_ip: Local LAN IP.
        :param pulumi.Input[str] remote_lan_ip: Remote LAN IP.
        :param pulumi.Input[str] site_id: ID of the VPC where the BGP Spoke Gateway is located.
        :param pulumi.Input[str] tunnel_protocol: Tunnel Protocol. Valid value: 'LAN'. Default value: 'LAN'. Case insensitive.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixEdgeSpokeExternalDeviceConnState.__new__(_AviatrixEdgeSpokeExternalDeviceConnState)

        __props__.__dict__["bgp_local_as_num"] = bgp_local_as_num
        __props__.__dict__["bgp_remote_as_num"] = bgp_remote_as_num
        __props__.__dict__["connection_name"] = connection_name
        __props__.__dict__["connection_type"] = connection_type
        __props__.__dict__["gw_name"] = gw_name
        __props__.__dict__["local_lan_ip"] = local_lan_ip
        __props__.__dict__["remote_lan_ip"] = remote_lan_ip
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["tunnel_protocol"] = tunnel_protocol
        return AviatrixEdgeSpokeExternalDeviceConn(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bgpLocalAsNum")
    def bgp_local_as_num(self) -> pulumi.Output[str]:
        """
        BGP local AS number.
        """
        return pulumi.get(self, "bgp_local_as_num")

    @property
    @pulumi.getter(name="bgpRemoteAsNum")
    def bgp_remote_as_num(self) -> pulumi.Output[str]:
        """
        BGP remote AS number.
        """
        return pulumi.get(self, "bgp_remote_as_num")

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Output[str]:
        """
        The name of the spoke external device connection which is going to be created.
        """
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> pulumi.Output[Optional[str]]:
        """
        Connection type. Valid values: 'bgp'. Default value: 'bgp'.
        """
        return pulumi.get(self, "connection_type")

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Output[str]:
        """
        Name of the BGP Spoke Gateway.
        """
        return pulumi.get(self, "gw_name")

    @property
    @pulumi.getter(name="localLanIp")
    def local_lan_ip(self) -> pulumi.Output[str]:
        """
        Local LAN IP.
        """
        return pulumi.get(self, "local_lan_ip")

    @property
    @pulumi.getter(name="remoteLanIp")
    def remote_lan_ip(self) -> pulumi.Output[str]:
        """
        Remote LAN IP.
        """
        return pulumi.get(self, "remote_lan_ip")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[str]:
        """
        ID of the VPC where the BGP Spoke Gateway is located.
        """
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter(name="tunnelProtocol")
    def tunnel_protocol(self) -> pulumi.Output[Optional[str]]:
        """
        Tunnel Protocol. Valid value: 'LAN'. Default value: 'LAN'. Case insensitive.
        """
        return pulumi.get(self, "tunnel_protocol")

