# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixControllerEmailConfigArgs', 'AviatrixControllerEmailConfig']

@pulumi.input_type
class AviatrixControllerEmailConfigArgs:
    def __init__(__self__, *,
                 admin_alert_email: pulumi.Input[str],
                 critical_alert_email: pulumi.Input[str],
                 security_event_email: pulumi.Input[str],
                 status_change_email: pulumi.Input[str],
                 status_change_notification_interval: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a AviatrixControllerEmailConfig resource.
        :param pulumi.Input[str] admin_alert_email: Email to receive important account and certification information.
        :param pulumi.Input[str] critical_alert_email: Email to receive field notices and critical notices.
        :param pulumi.Input[str] security_event_email: Email to receive security and CVE (Common Vulnerabilities and Exposures) notification emails.
        :param pulumi.Input[str] status_change_email: Email to receive system/tunnel status notification emails.
        :param pulumi.Input[int] status_change_notification_interval: Status change notification interval in seconds.
        """
        pulumi.set(__self__, "admin_alert_email", admin_alert_email)
        pulumi.set(__self__, "critical_alert_email", critical_alert_email)
        pulumi.set(__self__, "security_event_email", security_event_email)
        pulumi.set(__self__, "status_change_email", status_change_email)
        if status_change_notification_interval is not None:
            pulumi.set(__self__, "status_change_notification_interval", status_change_notification_interval)

    @property
    @pulumi.getter(name="adminAlertEmail")
    def admin_alert_email(self) -> pulumi.Input[str]:
        """
        Email to receive important account and certification information.
        """
        return pulumi.get(self, "admin_alert_email")

    @admin_alert_email.setter
    def admin_alert_email(self, value: pulumi.Input[str]):
        pulumi.set(self, "admin_alert_email", value)

    @property
    @pulumi.getter(name="criticalAlertEmail")
    def critical_alert_email(self) -> pulumi.Input[str]:
        """
        Email to receive field notices and critical notices.
        """
        return pulumi.get(self, "critical_alert_email")

    @critical_alert_email.setter
    def critical_alert_email(self, value: pulumi.Input[str]):
        pulumi.set(self, "critical_alert_email", value)

    @property
    @pulumi.getter(name="securityEventEmail")
    def security_event_email(self) -> pulumi.Input[str]:
        """
        Email to receive security and CVE (Common Vulnerabilities and Exposures) notification emails.
        """
        return pulumi.get(self, "security_event_email")

    @security_event_email.setter
    def security_event_email(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_event_email", value)

    @property
    @pulumi.getter(name="statusChangeEmail")
    def status_change_email(self) -> pulumi.Input[str]:
        """
        Email to receive system/tunnel status notification emails.
        """
        return pulumi.get(self, "status_change_email")

    @status_change_email.setter
    def status_change_email(self, value: pulumi.Input[str]):
        pulumi.set(self, "status_change_email", value)

    @property
    @pulumi.getter(name="statusChangeNotificationInterval")
    def status_change_notification_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Status change notification interval in seconds.
        """
        return pulumi.get(self, "status_change_notification_interval")

    @status_change_notification_interval.setter
    def status_change_notification_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "status_change_notification_interval", value)


@pulumi.input_type
class _AviatrixControllerEmailConfigState:
    def __init__(__self__, *,
                 admin_alert_email: Optional[pulumi.Input[str]] = None,
                 admin_alert_email_verified: Optional[pulumi.Input[bool]] = None,
                 critical_alert_email: Optional[pulumi.Input[str]] = None,
                 critical_alert_email_verified: Optional[pulumi.Input[bool]] = None,
                 security_event_email: Optional[pulumi.Input[str]] = None,
                 security_event_email_verified: Optional[pulumi.Input[bool]] = None,
                 status_change_email: Optional[pulumi.Input[str]] = None,
                 status_change_email_verified: Optional[pulumi.Input[bool]] = None,
                 status_change_notification_interval: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering AviatrixControllerEmailConfig resources.
        :param pulumi.Input[str] admin_alert_email: Email to receive important account and certification information.
        :param pulumi.Input[bool] admin_alert_email_verified: Whether admin alert notification email is verified.
        :param pulumi.Input[str] critical_alert_email: Email to receive field notices and critical notices.
        :param pulumi.Input[bool] critical_alert_email_verified: Whether critical alert notification email is verified.
        :param pulumi.Input[str] security_event_email: Email to receive security and CVE (Common Vulnerabilities and Exposures) notification emails.
        :param pulumi.Input[bool] security_event_email_verified: Whether security event notification email is verified.
        :param pulumi.Input[str] status_change_email: Email to receive system/tunnel status notification emails.
        :param pulumi.Input[bool] status_change_email_verified: Whether status change notification email is verified.
        :param pulumi.Input[int] status_change_notification_interval: Status change notification interval in seconds.
        """
        if admin_alert_email is not None:
            pulumi.set(__self__, "admin_alert_email", admin_alert_email)
        if admin_alert_email_verified is not None:
            pulumi.set(__self__, "admin_alert_email_verified", admin_alert_email_verified)
        if critical_alert_email is not None:
            pulumi.set(__self__, "critical_alert_email", critical_alert_email)
        if critical_alert_email_verified is not None:
            pulumi.set(__self__, "critical_alert_email_verified", critical_alert_email_verified)
        if security_event_email is not None:
            pulumi.set(__self__, "security_event_email", security_event_email)
        if security_event_email_verified is not None:
            pulumi.set(__self__, "security_event_email_verified", security_event_email_verified)
        if status_change_email is not None:
            pulumi.set(__self__, "status_change_email", status_change_email)
        if status_change_email_verified is not None:
            pulumi.set(__self__, "status_change_email_verified", status_change_email_verified)
        if status_change_notification_interval is not None:
            pulumi.set(__self__, "status_change_notification_interval", status_change_notification_interval)

    @property
    @pulumi.getter(name="adminAlertEmail")
    def admin_alert_email(self) -> Optional[pulumi.Input[str]]:
        """
        Email to receive important account and certification information.
        """
        return pulumi.get(self, "admin_alert_email")

    @admin_alert_email.setter
    def admin_alert_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_alert_email", value)

    @property
    @pulumi.getter(name="adminAlertEmailVerified")
    def admin_alert_email_verified(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether admin alert notification email is verified.
        """
        return pulumi.get(self, "admin_alert_email_verified")

    @admin_alert_email_verified.setter
    def admin_alert_email_verified(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "admin_alert_email_verified", value)

    @property
    @pulumi.getter(name="criticalAlertEmail")
    def critical_alert_email(self) -> Optional[pulumi.Input[str]]:
        """
        Email to receive field notices and critical notices.
        """
        return pulumi.get(self, "critical_alert_email")

    @critical_alert_email.setter
    def critical_alert_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "critical_alert_email", value)

    @property
    @pulumi.getter(name="criticalAlertEmailVerified")
    def critical_alert_email_verified(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether critical alert notification email is verified.
        """
        return pulumi.get(self, "critical_alert_email_verified")

    @critical_alert_email_verified.setter
    def critical_alert_email_verified(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "critical_alert_email_verified", value)

    @property
    @pulumi.getter(name="securityEventEmail")
    def security_event_email(self) -> Optional[pulumi.Input[str]]:
        """
        Email to receive security and CVE (Common Vulnerabilities and Exposures) notification emails.
        """
        return pulumi.get(self, "security_event_email")

    @security_event_email.setter
    def security_event_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_event_email", value)

    @property
    @pulumi.getter(name="securityEventEmailVerified")
    def security_event_email_verified(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether security event notification email is verified.
        """
        return pulumi.get(self, "security_event_email_verified")

    @security_event_email_verified.setter
    def security_event_email_verified(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "security_event_email_verified", value)

    @property
    @pulumi.getter(name="statusChangeEmail")
    def status_change_email(self) -> Optional[pulumi.Input[str]]:
        """
        Email to receive system/tunnel status notification emails.
        """
        return pulumi.get(self, "status_change_email")

    @status_change_email.setter
    def status_change_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status_change_email", value)

    @property
    @pulumi.getter(name="statusChangeEmailVerified")
    def status_change_email_verified(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether status change notification email is verified.
        """
        return pulumi.get(self, "status_change_email_verified")

    @status_change_email_verified.setter
    def status_change_email_verified(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "status_change_email_verified", value)

    @property
    @pulumi.getter(name="statusChangeNotificationInterval")
    def status_change_notification_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Status change notification interval in seconds.
        """
        return pulumi.get(self, "status_change_notification_interval")

    @status_change_notification_interval.setter
    def status_change_notification_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "status_change_notification_interval", value)


class AviatrixControllerEmailConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_alert_email: Optional[pulumi.Input[str]] = None,
                 critical_alert_email: Optional[pulumi.Input[str]] = None,
                 security_event_email: Optional[pulumi.Input[str]] = None,
                 status_change_email: Optional[pulumi.Input[str]] = None,
                 status_change_notification_interval: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Create a AviatrixControllerEmailConfig resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_alert_email: Email to receive important account and certification information.
        :param pulumi.Input[str] critical_alert_email: Email to receive field notices and critical notices.
        :param pulumi.Input[str] security_event_email: Email to receive security and CVE (Common Vulnerabilities and Exposures) notification emails.
        :param pulumi.Input[str] status_change_email: Email to receive system/tunnel status notification emails.
        :param pulumi.Input[int] status_change_notification_interval: Status change notification interval in seconds.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixControllerEmailConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixControllerEmailConfig resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixControllerEmailConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixControllerEmailConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_alert_email: Optional[pulumi.Input[str]] = None,
                 critical_alert_email: Optional[pulumi.Input[str]] = None,
                 security_event_email: Optional[pulumi.Input[str]] = None,
                 status_change_email: Optional[pulumi.Input[str]] = None,
                 status_change_notification_interval: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixControllerEmailConfigArgs.__new__(AviatrixControllerEmailConfigArgs)

            if admin_alert_email is None and not opts.urn:
                raise TypeError("Missing required property 'admin_alert_email'")
            __props__.__dict__["admin_alert_email"] = admin_alert_email
            if critical_alert_email is None and not opts.urn:
                raise TypeError("Missing required property 'critical_alert_email'")
            __props__.__dict__["critical_alert_email"] = critical_alert_email
            if security_event_email is None and not opts.urn:
                raise TypeError("Missing required property 'security_event_email'")
            __props__.__dict__["security_event_email"] = security_event_email
            if status_change_email is None and not opts.urn:
                raise TypeError("Missing required property 'status_change_email'")
            __props__.__dict__["status_change_email"] = status_change_email
            __props__.__dict__["status_change_notification_interval"] = status_change_notification_interval
            __props__.__dict__["admin_alert_email_verified"] = None
            __props__.__dict__["critical_alert_email_verified"] = None
            __props__.__dict__["security_event_email_verified"] = None
            __props__.__dict__["status_change_email_verified"] = None
        super(AviatrixControllerEmailConfig, __self__).__init__(
            'aviatrix:index/aviatrixControllerEmailConfig:AviatrixControllerEmailConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_alert_email: Optional[pulumi.Input[str]] = None,
            admin_alert_email_verified: Optional[pulumi.Input[bool]] = None,
            critical_alert_email: Optional[pulumi.Input[str]] = None,
            critical_alert_email_verified: Optional[pulumi.Input[bool]] = None,
            security_event_email: Optional[pulumi.Input[str]] = None,
            security_event_email_verified: Optional[pulumi.Input[bool]] = None,
            status_change_email: Optional[pulumi.Input[str]] = None,
            status_change_email_verified: Optional[pulumi.Input[bool]] = None,
            status_change_notification_interval: Optional[pulumi.Input[int]] = None) -> 'AviatrixControllerEmailConfig':
        """
        Get an existing AviatrixControllerEmailConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_alert_email: Email to receive important account and certification information.
        :param pulumi.Input[bool] admin_alert_email_verified: Whether admin alert notification email is verified.
        :param pulumi.Input[str] critical_alert_email: Email to receive field notices and critical notices.
        :param pulumi.Input[bool] critical_alert_email_verified: Whether critical alert notification email is verified.
        :param pulumi.Input[str] security_event_email: Email to receive security and CVE (Common Vulnerabilities and Exposures) notification emails.
        :param pulumi.Input[bool] security_event_email_verified: Whether security event notification email is verified.
        :param pulumi.Input[str] status_change_email: Email to receive system/tunnel status notification emails.
        :param pulumi.Input[bool] status_change_email_verified: Whether status change notification email is verified.
        :param pulumi.Input[int] status_change_notification_interval: Status change notification interval in seconds.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixControllerEmailConfigState.__new__(_AviatrixControllerEmailConfigState)

        __props__.__dict__["admin_alert_email"] = admin_alert_email
        __props__.__dict__["admin_alert_email_verified"] = admin_alert_email_verified
        __props__.__dict__["critical_alert_email"] = critical_alert_email
        __props__.__dict__["critical_alert_email_verified"] = critical_alert_email_verified
        __props__.__dict__["security_event_email"] = security_event_email
        __props__.__dict__["security_event_email_verified"] = security_event_email_verified
        __props__.__dict__["status_change_email"] = status_change_email
        __props__.__dict__["status_change_email_verified"] = status_change_email_verified
        __props__.__dict__["status_change_notification_interval"] = status_change_notification_interval
        return AviatrixControllerEmailConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminAlertEmail")
    def admin_alert_email(self) -> pulumi.Output[str]:
        """
        Email to receive important account and certification information.
        """
        return pulumi.get(self, "admin_alert_email")

    @property
    @pulumi.getter(name="adminAlertEmailVerified")
    def admin_alert_email_verified(self) -> pulumi.Output[bool]:
        """
        Whether admin alert notification email is verified.
        """
        return pulumi.get(self, "admin_alert_email_verified")

    @property
    @pulumi.getter(name="criticalAlertEmail")
    def critical_alert_email(self) -> pulumi.Output[str]:
        """
        Email to receive field notices and critical notices.
        """
        return pulumi.get(self, "critical_alert_email")

    @property
    @pulumi.getter(name="criticalAlertEmailVerified")
    def critical_alert_email_verified(self) -> pulumi.Output[bool]:
        """
        Whether critical alert notification email is verified.
        """
        return pulumi.get(self, "critical_alert_email_verified")

    @property
    @pulumi.getter(name="securityEventEmail")
    def security_event_email(self) -> pulumi.Output[str]:
        """
        Email to receive security and CVE (Common Vulnerabilities and Exposures) notification emails.
        """
        return pulumi.get(self, "security_event_email")

    @property
    @pulumi.getter(name="securityEventEmailVerified")
    def security_event_email_verified(self) -> pulumi.Output[bool]:
        """
        Whether security event notification email is verified.
        """
        return pulumi.get(self, "security_event_email_verified")

    @property
    @pulumi.getter(name="statusChangeEmail")
    def status_change_email(self) -> pulumi.Output[str]:
        """
        Email to receive system/tunnel status notification emails.
        """
        return pulumi.get(self, "status_change_email")

    @property
    @pulumi.getter(name="statusChangeEmailVerified")
    def status_change_email_verified(self) -> pulumi.Output[bool]:
        """
        Whether status change notification email is verified.
        """
        return pulumi.get(self, "status_change_email_verified")

    @property
    @pulumi.getter(name="statusChangeNotificationInterval")
    def status_change_notification_interval(self) -> pulumi.Output[Optional[int]]:
        """
        Status change notification interval in seconds.
        """
        return pulumi.get(self, "status_change_notification_interval")

