# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixControllerConfigArgs', 'AviatrixControllerConfig']

@pulumi.input_type
class AviatrixControllerConfigArgs:
    def __init__(__self__, *,
                 aws_guard_duty_scanning_interval: Optional[pulumi.Input[int]] = None,
                 backup_account_name: Optional[pulumi.Input[str]] = None,
                 backup_bucket_name: Optional[pulumi.Input[str]] = None,
                 backup_cloud_type: Optional[pulumi.Input[int]] = None,
                 backup_configuration: Optional[pulumi.Input[bool]] = None,
                 backup_container_name: Optional[pulumi.Input[str]] = None,
                 backup_region: Optional[pulumi.Input[str]] = None,
                 backup_storage_name: Optional[pulumi.Input[str]] = None,
                 ca_certificate_file: Optional[pulumi.Input[str]] = None,
                 ca_certificate_file_path: Optional[pulumi.Input[str]] = None,
                 enable_vpc_dns_server: Optional[pulumi.Input[bool]] = None,
                 fqdn_exception_rule: Optional[pulumi.Input[bool]] = None,
                 http_access: Optional[pulumi.Input[bool]] = None,
                 manage_gateway_upgrades: Optional[pulumi.Input[bool]] = None,
                 multiple_backups: Optional[pulumi.Input[bool]] = None,
                 server_private_key_file: Optional[pulumi.Input[str]] = None,
                 server_private_key_file_path: Optional[pulumi.Input[str]] = None,
                 server_public_certificate_file: Optional[pulumi.Input[str]] = None,
                 server_public_certificate_file_path: Optional[pulumi.Input[str]] = None,
                 target_version: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AviatrixControllerConfig resource.
        :param pulumi.Input[int] aws_guard_duty_scanning_interval: Scanning Interval for AWS Guard Duty.
        :param pulumi.Input[str] backup_account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[str] backup_bucket_name: Bucket name. Required for AWS, AWSGov, GCP and OCI.
        :param pulumi.Input[int] backup_cloud_type: Type of cloud service provider, requires an integer value. Use 1 for AWS.
        :param pulumi.Input[bool] backup_configuration: Switch to enable/disable controller cloudn backup config.
        :param pulumi.Input[str] backup_container_name: Container name. Required for Azure.
        :param pulumi.Input[str] backup_region: Name of region. Required for Azure and OCI.
        :param pulumi.Input[str] backup_storage_name: Storage name. Required for Azure.
        :param pulumi.Input[str] ca_certificate_file: CA certificate file.
        :param pulumi.Input[str] ca_certificate_file_path: File path to the CA certificate.
        :param pulumi.Input[bool] enable_vpc_dns_server: Enable VPC/VNET DNS Server.
        :param pulumi.Input[bool] fqdn_exception_rule: A system-wide mode. Default: true.
        :param pulumi.Input[bool] http_access: Switch for http access. Default: false.
        :param pulumi.Input[bool] manage_gateway_upgrades: If true, aviatrix_controller_config will upgrade all gateways when target_version is set. If false, only the controller
               will be upgraded when target_version is set. In that case gateway upgrades should be handled in each gateway resource
               individually using the software_version and image_version attributes.
        :param pulumi.Input[bool] multiple_backups: Switch to enable the controller to backup up to a maximum of 3 rotating backups.
        :param pulumi.Input[str] server_private_key_file: Server private key file.
        :param pulumi.Input[str] server_private_key_file_path: File path to the server private key.
        :param pulumi.Input[str] server_public_certificate_file: Server public certificate file.
        :param pulumi.Input[str] server_public_certificate_file_path: File path to the server public certificate.
        :param pulumi.Input[str] target_version: The release version number to which the controller will be upgraded to.
        """
        if aws_guard_duty_scanning_interval is not None:
            pulumi.set(__self__, "aws_guard_duty_scanning_interval", aws_guard_duty_scanning_interval)
        if backup_account_name is not None:
            pulumi.set(__self__, "backup_account_name", backup_account_name)
        if backup_bucket_name is not None:
            pulumi.set(__self__, "backup_bucket_name", backup_bucket_name)
        if backup_cloud_type is not None:
            pulumi.set(__self__, "backup_cloud_type", backup_cloud_type)
        if backup_configuration is not None:
            pulumi.set(__self__, "backup_configuration", backup_configuration)
        if backup_container_name is not None:
            pulumi.set(__self__, "backup_container_name", backup_container_name)
        if backup_region is not None:
            pulumi.set(__self__, "backup_region", backup_region)
        if backup_storage_name is not None:
            pulumi.set(__self__, "backup_storage_name", backup_storage_name)
        if ca_certificate_file is not None:
            pulumi.set(__self__, "ca_certificate_file", ca_certificate_file)
        if ca_certificate_file_path is not None:
            pulumi.set(__self__, "ca_certificate_file_path", ca_certificate_file_path)
        if enable_vpc_dns_server is not None:
            pulumi.set(__self__, "enable_vpc_dns_server", enable_vpc_dns_server)
        if fqdn_exception_rule is not None:
            pulumi.set(__self__, "fqdn_exception_rule", fqdn_exception_rule)
        if http_access is not None:
            pulumi.set(__self__, "http_access", http_access)
        if manage_gateway_upgrades is not None:
            pulumi.set(__self__, "manage_gateway_upgrades", manage_gateway_upgrades)
        if multiple_backups is not None:
            pulumi.set(__self__, "multiple_backups", multiple_backups)
        if server_private_key_file is not None:
            pulumi.set(__self__, "server_private_key_file", server_private_key_file)
        if server_private_key_file_path is not None:
            pulumi.set(__self__, "server_private_key_file_path", server_private_key_file_path)
        if server_public_certificate_file is not None:
            pulumi.set(__self__, "server_public_certificate_file", server_public_certificate_file)
        if server_public_certificate_file_path is not None:
            pulumi.set(__self__, "server_public_certificate_file_path", server_public_certificate_file_path)
        if target_version is not None:
            pulumi.set(__self__, "target_version", target_version)

    @property
    @pulumi.getter(name="awsGuardDutyScanningInterval")
    def aws_guard_duty_scanning_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Scanning Interval for AWS Guard Duty.
        """
        return pulumi.get(self, "aws_guard_duty_scanning_interval")

    @aws_guard_duty_scanning_interval.setter
    def aws_guard_duty_scanning_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "aws_guard_duty_scanning_interval", value)

    @property
    @pulumi.getter(name="backupAccountName")
    def backup_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter represents the name of a Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "backup_account_name")

    @backup_account_name.setter
    def backup_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_account_name", value)

    @property
    @pulumi.getter(name="backupBucketName")
    def backup_bucket_name(self) -> Optional[pulumi.Input[str]]:
        """
        Bucket name. Required for AWS, AWSGov, GCP and OCI.
        """
        return pulumi.get(self, "backup_bucket_name")

    @backup_bucket_name.setter
    def backup_bucket_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_bucket_name", value)

    @property
    @pulumi.getter(name="backupCloudType")
    def backup_cloud_type(self) -> Optional[pulumi.Input[int]]:
        """
        Type of cloud service provider, requires an integer value. Use 1 for AWS.
        """
        return pulumi.get(self, "backup_cloud_type")

    @backup_cloud_type.setter
    def backup_cloud_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_cloud_type", value)

    @property
    @pulumi.getter(name="backupConfiguration")
    def backup_configuration(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable/disable controller cloudn backup config.
        """
        return pulumi.get(self, "backup_configuration")

    @backup_configuration.setter
    def backup_configuration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "backup_configuration", value)

    @property
    @pulumi.getter(name="backupContainerName")
    def backup_container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Container name. Required for Azure.
        """
        return pulumi.get(self, "backup_container_name")

    @backup_container_name.setter
    def backup_container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_container_name", value)

    @property
    @pulumi.getter(name="backupRegion")
    def backup_region(self) -> Optional[pulumi.Input[str]]:
        """
        Name of region. Required for Azure and OCI.
        """
        return pulumi.get(self, "backup_region")

    @backup_region.setter
    def backup_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_region", value)

    @property
    @pulumi.getter(name="backupStorageName")
    def backup_storage_name(self) -> Optional[pulumi.Input[str]]:
        """
        Storage name. Required for Azure.
        """
        return pulumi.get(self, "backup_storage_name")

    @backup_storage_name.setter
    def backup_storage_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_storage_name", value)

    @property
    @pulumi.getter(name="caCertificateFile")
    def ca_certificate_file(self) -> Optional[pulumi.Input[str]]:
        """
        CA certificate file.
        """
        return pulumi.get(self, "ca_certificate_file")

    @ca_certificate_file.setter
    def ca_certificate_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_certificate_file", value)

    @property
    @pulumi.getter(name="caCertificateFilePath")
    def ca_certificate_file_path(self) -> Optional[pulumi.Input[str]]:
        """
        File path to the CA certificate.
        """
        return pulumi.get(self, "ca_certificate_file_path")

    @ca_certificate_file_path.setter
    def ca_certificate_file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_certificate_file_path", value)

    @property
    @pulumi.getter(name="enableVpcDnsServer")
    def enable_vpc_dns_server(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable VPC/VNET DNS Server.
        """
        return pulumi.get(self, "enable_vpc_dns_server")

    @enable_vpc_dns_server.setter
    def enable_vpc_dns_server(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_vpc_dns_server", value)

    @property
    @pulumi.getter(name="fqdnExceptionRule")
    def fqdn_exception_rule(self) -> Optional[pulumi.Input[bool]]:
        """
        A system-wide mode. Default: true.
        """
        return pulumi.get(self, "fqdn_exception_rule")

    @fqdn_exception_rule.setter
    def fqdn_exception_rule(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fqdn_exception_rule", value)

    @property
    @pulumi.getter(name="httpAccess")
    def http_access(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch for http access. Default: false.
        """
        return pulumi.get(self, "http_access")

    @http_access.setter
    def http_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "http_access", value)

    @property
    @pulumi.getter(name="manageGatewayUpgrades")
    def manage_gateway_upgrades(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, aviatrix_controller_config will upgrade all gateways when target_version is set. If false, only the controller
        will be upgraded when target_version is set. In that case gateway upgrades should be handled in each gateway resource
        individually using the software_version and image_version attributes.
        """
        return pulumi.get(self, "manage_gateway_upgrades")

    @manage_gateway_upgrades.setter
    def manage_gateway_upgrades(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "manage_gateway_upgrades", value)

    @property
    @pulumi.getter(name="multipleBackups")
    def multiple_backups(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable the controller to backup up to a maximum of 3 rotating backups.
        """
        return pulumi.get(self, "multiple_backups")

    @multiple_backups.setter
    def multiple_backups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multiple_backups", value)

    @property
    @pulumi.getter(name="serverPrivateKeyFile")
    def server_private_key_file(self) -> Optional[pulumi.Input[str]]:
        """
        Server private key file.
        """
        return pulumi.get(self, "server_private_key_file")

    @server_private_key_file.setter
    def server_private_key_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_private_key_file", value)

    @property
    @pulumi.getter(name="serverPrivateKeyFilePath")
    def server_private_key_file_path(self) -> Optional[pulumi.Input[str]]:
        """
        File path to the server private key.
        """
        return pulumi.get(self, "server_private_key_file_path")

    @server_private_key_file_path.setter
    def server_private_key_file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_private_key_file_path", value)

    @property
    @pulumi.getter(name="serverPublicCertificateFile")
    def server_public_certificate_file(self) -> Optional[pulumi.Input[str]]:
        """
        Server public certificate file.
        """
        return pulumi.get(self, "server_public_certificate_file")

    @server_public_certificate_file.setter
    def server_public_certificate_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_public_certificate_file", value)

    @property
    @pulumi.getter(name="serverPublicCertificateFilePath")
    def server_public_certificate_file_path(self) -> Optional[pulumi.Input[str]]:
        """
        File path to the server public certificate.
        """
        return pulumi.get(self, "server_public_certificate_file_path")

    @server_public_certificate_file_path.setter
    def server_public_certificate_file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_public_certificate_file_path", value)

    @property
    @pulumi.getter(name="targetVersion")
    def target_version(self) -> Optional[pulumi.Input[str]]:
        """
        The release version number to which the controller will be upgraded to.
        """
        return pulumi.get(self, "target_version")

    @target_version.setter
    def target_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_version", value)


@pulumi.input_type
class _AviatrixControllerConfigState:
    def __init__(__self__, *,
                 aws_guard_duty_scanning_interval: Optional[pulumi.Input[int]] = None,
                 backup_account_name: Optional[pulumi.Input[str]] = None,
                 backup_bucket_name: Optional[pulumi.Input[str]] = None,
                 backup_cloud_type: Optional[pulumi.Input[int]] = None,
                 backup_configuration: Optional[pulumi.Input[bool]] = None,
                 backup_container_name: Optional[pulumi.Input[str]] = None,
                 backup_region: Optional[pulumi.Input[str]] = None,
                 backup_storage_name: Optional[pulumi.Input[str]] = None,
                 ca_certificate_file: Optional[pulumi.Input[str]] = None,
                 ca_certificate_file_path: Optional[pulumi.Input[str]] = None,
                 current_version: Optional[pulumi.Input[str]] = None,
                 enable_vpc_dns_server: Optional[pulumi.Input[bool]] = None,
                 fqdn_exception_rule: Optional[pulumi.Input[bool]] = None,
                 http_access: Optional[pulumi.Input[bool]] = None,
                 manage_gateway_upgrades: Optional[pulumi.Input[bool]] = None,
                 multiple_backups: Optional[pulumi.Input[bool]] = None,
                 previous_version: Optional[pulumi.Input[str]] = None,
                 server_private_key_file: Optional[pulumi.Input[str]] = None,
                 server_private_key_file_path: Optional[pulumi.Input[str]] = None,
                 server_public_certificate_file: Optional[pulumi.Input[str]] = None,
                 server_public_certificate_file_path: Optional[pulumi.Input[str]] = None,
                 target_version: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixControllerConfig resources.
        :param pulumi.Input[int] aws_guard_duty_scanning_interval: Scanning Interval for AWS Guard Duty.
        :param pulumi.Input[str] backup_account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[str] backup_bucket_name: Bucket name. Required for AWS, AWSGov, GCP and OCI.
        :param pulumi.Input[int] backup_cloud_type: Type of cloud service provider, requires an integer value. Use 1 for AWS.
        :param pulumi.Input[bool] backup_configuration: Switch to enable/disable controller cloudn backup config.
        :param pulumi.Input[str] backup_container_name: Container name. Required for Azure.
        :param pulumi.Input[str] backup_region: Name of region. Required for Azure and OCI.
        :param pulumi.Input[str] backup_storage_name: Storage name. Required for Azure.
        :param pulumi.Input[str] ca_certificate_file: CA certificate file.
        :param pulumi.Input[str] ca_certificate_file_path: File path to the CA certificate.
        :param pulumi.Input[str] current_version: Current version of the controller.
        :param pulumi.Input[bool] enable_vpc_dns_server: Enable VPC/VNET DNS Server.
        :param pulumi.Input[bool] fqdn_exception_rule: A system-wide mode. Default: true.
        :param pulumi.Input[bool] http_access: Switch for http access. Default: false.
        :param pulumi.Input[bool] manage_gateway_upgrades: If true, aviatrix_controller_config will upgrade all gateways when target_version is set. If false, only the controller
               will be upgraded when target_version is set. In that case gateway upgrades should be handled in each gateway resource
               individually using the software_version and image_version attributes.
        :param pulumi.Input[bool] multiple_backups: Switch to enable the controller to backup up to a maximum of 3 rotating backups.
        :param pulumi.Input[str] previous_version: Previous version of the controller.
        :param pulumi.Input[str] server_private_key_file: Server private key file.
        :param pulumi.Input[str] server_private_key_file_path: File path to the server private key.
        :param pulumi.Input[str] server_public_certificate_file: Server public certificate file.
        :param pulumi.Input[str] server_public_certificate_file_path: File path to the server public certificate.
        :param pulumi.Input[str] target_version: The release version number to which the controller will be upgraded to.
        :param pulumi.Input[str] version: Current version of the controller without the build number.
        """
        if aws_guard_duty_scanning_interval is not None:
            pulumi.set(__self__, "aws_guard_duty_scanning_interval", aws_guard_duty_scanning_interval)
        if backup_account_name is not None:
            pulumi.set(__self__, "backup_account_name", backup_account_name)
        if backup_bucket_name is not None:
            pulumi.set(__self__, "backup_bucket_name", backup_bucket_name)
        if backup_cloud_type is not None:
            pulumi.set(__self__, "backup_cloud_type", backup_cloud_type)
        if backup_configuration is not None:
            pulumi.set(__self__, "backup_configuration", backup_configuration)
        if backup_container_name is not None:
            pulumi.set(__self__, "backup_container_name", backup_container_name)
        if backup_region is not None:
            pulumi.set(__self__, "backup_region", backup_region)
        if backup_storage_name is not None:
            pulumi.set(__self__, "backup_storage_name", backup_storage_name)
        if ca_certificate_file is not None:
            pulumi.set(__self__, "ca_certificate_file", ca_certificate_file)
        if ca_certificate_file_path is not None:
            pulumi.set(__self__, "ca_certificate_file_path", ca_certificate_file_path)
        if current_version is not None:
            pulumi.set(__self__, "current_version", current_version)
        if enable_vpc_dns_server is not None:
            pulumi.set(__self__, "enable_vpc_dns_server", enable_vpc_dns_server)
        if fqdn_exception_rule is not None:
            pulumi.set(__self__, "fqdn_exception_rule", fqdn_exception_rule)
        if http_access is not None:
            pulumi.set(__self__, "http_access", http_access)
        if manage_gateway_upgrades is not None:
            pulumi.set(__self__, "manage_gateway_upgrades", manage_gateway_upgrades)
        if multiple_backups is not None:
            pulumi.set(__self__, "multiple_backups", multiple_backups)
        if previous_version is not None:
            pulumi.set(__self__, "previous_version", previous_version)
        if server_private_key_file is not None:
            pulumi.set(__self__, "server_private_key_file", server_private_key_file)
        if server_private_key_file_path is not None:
            pulumi.set(__self__, "server_private_key_file_path", server_private_key_file_path)
        if server_public_certificate_file is not None:
            pulumi.set(__self__, "server_public_certificate_file", server_public_certificate_file)
        if server_public_certificate_file_path is not None:
            pulumi.set(__self__, "server_public_certificate_file_path", server_public_certificate_file_path)
        if target_version is not None:
            pulumi.set(__self__, "target_version", target_version)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="awsGuardDutyScanningInterval")
    def aws_guard_duty_scanning_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Scanning Interval for AWS Guard Duty.
        """
        return pulumi.get(self, "aws_guard_duty_scanning_interval")

    @aws_guard_duty_scanning_interval.setter
    def aws_guard_duty_scanning_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "aws_guard_duty_scanning_interval", value)

    @property
    @pulumi.getter(name="backupAccountName")
    def backup_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter represents the name of a Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "backup_account_name")

    @backup_account_name.setter
    def backup_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_account_name", value)

    @property
    @pulumi.getter(name="backupBucketName")
    def backup_bucket_name(self) -> Optional[pulumi.Input[str]]:
        """
        Bucket name. Required for AWS, AWSGov, GCP and OCI.
        """
        return pulumi.get(self, "backup_bucket_name")

    @backup_bucket_name.setter
    def backup_bucket_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_bucket_name", value)

    @property
    @pulumi.getter(name="backupCloudType")
    def backup_cloud_type(self) -> Optional[pulumi.Input[int]]:
        """
        Type of cloud service provider, requires an integer value. Use 1 for AWS.
        """
        return pulumi.get(self, "backup_cloud_type")

    @backup_cloud_type.setter
    def backup_cloud_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_cloud_type", value)

    @property
    @pulumi.getter(name="backupConfiguration")
    def backup_configuration(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable/disable controller cloudn backup config.
        """
        return pulumi.get(self, "backup_configuration")

    @backup_configuration.setter
    def backup_configuration(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "backup_configuration", value)

    @property
    @pulumi.getter(name="backupContainerName")
    def backup_container_name(self) -> Optional[pulumi.Input[str]]:
        """
        Container name. Required for Azure.
        """
        return pulumi.get(self, "backup_container_name")

    @backup_container_name.setter
    def backup_container_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_container_name", value)

    @property
    @pulumi.getter(name="backupRegion")
    def backup_region(self) -> Optional[pulumi.Input[str]]:
        """
        Name of region. Required for Azure and OCI.
        """
        return pulumi.get(self, "backup_region")

    @backup_region.setter
    def backup_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_region", value)

    @property
    @pulumi.getter(name="backupStorageName")
    def backup_storage_name(self) -> Optional[pulumi.Input[str]]:
        """
        Storage name. Required for Azure.
        """
        return pulumi.get(self, "backup_storage_name")

    @backup_storage_name.setter
    def backup_storage_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_storage_name", value)

    @property
    @pulumi.getter(name="caCertificateFile")
    def ca_certificate_file(self) -> Optional[pulumi.Input[str]]:
        """
        CA certificate file.
        """
        return pulumi.get(self, "ca_certificate_file")

    @ca_certificate_file.setter
    def ca_certificate_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_certificate_file", value)

    @property
    @pulumi.getter(name="caCertificateFilePath")
    def ca_certificate_file_path(self) -> Optional[pulumi.Input[str]]:
        """
        File path to the CA certificate.
        """
        return pulumi.get(self, "ca_certificate_file_path")

    @ca_certificate_file_path.setter
    def ca_certificate_file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_certificate_file_path", value)

    @property
    @pulumi.getter(name="currentVersion")
    def current_version(self) -> Optional[pulumi.Input[str]]:
        """
        Current version of the controller.
        """
        return pulumi.get(self, "current_version")

    @current_version.setter
    def current_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_version", value)

    @property
    @pulumi.getter(name="enableVpcDnsServer")
    def enable_vpc_dns_server(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable VPC/VNET DNS Server.
        """
        return pulumi.get(self, "enable_vpc_dns_server")

    @enable_vpc_dns_server.setter
    def enable_vpc_dns_server(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_vpc_dns_server", value)

    @property
    @pulumi.getter(name="fqdnExceptionRule")
    def fqdn_exception_rule(self) -> Optional[pulumi.Input[bool]]:
        """
        A system-wide mode. Default: true.
        """
        return pulumi.get(self, "fqdn_exception_rule")

    @fqdn_exception_rule.setter
    def fqdn_exception_rule(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fqdn_exception_rule", value)

    @property
    @pulumi.getter(name="httpAccess")
    def http_access(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch for http access. Default: false.
        """
        return pulumi.get(self, "http_access")

    @http_access.setter
    def http_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "http_access", value)

    @property
    @pulumi.getter(name="manageGatewayUpgrades")
    def manage_gateway_upgrades(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, aviatrix_controller_config will upgrade all gateways when target_version is set. If false, only the controller
        will be upgraded when target_version is set. In that case gateway upgrades should be handled in each gateway resource
        individually using the software_version and image_version attributes.
        """
        return pulumi.get(self, "manage_gateway_upgrades")

    @manage_gateway_upgrades.setter
    def manage_gateway_upgrades(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "manage_gateway_upgrades", value)

    @property
    @pulumi.getter(name="multipleBackups")
    def multiple_backups(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable the controller to backup up to a maximum of 3 rotating backups.
        """
        return pulumi.get(self, "multiple_backups")

    @multiple_backups.setter
    def multiple_backups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multiple_backups", value)

    @property
    @pulumi.getter(name="previousVersion")
    def previous_version(self) -> Optional[pulumi.Input[str]]:
        """
        Previous version of the controller.
        """
        return pulumi.get(self, "previous_version")

    @previous_version.setter
    def previous_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "previous_version", value)

    @property
    @pulumi.getter(name="serverPrivateKeyFile")
    def server_private_key_file(self) -> Optional[pulumi.Input[str]]:
        """
        Server private key file.
        """
        return pulumi.get(self, "server_private_key_file")

    @server_private_key_file.setter
    def server_private_key_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_private_key_file", value)

    @property
    @pulumi.getter(name="serverPrivateKeyFilePath")
    def server_private_key_file_path(self) -> Optional[pulumi.Input[str]]:
        """
        File path to the server private key.
        """
        return pulumi.get(self, "server_private_key_file_path")

    @server_private_key_file_path.setter
    def server_private_key_file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_private_key_file_path", value)

    @property
    @pulumi.getter(name="serverPublicCertificateFile")
    def server_public_certificate_file(self) -> Optional[pulumi.Input[str]]:
        """
        Server public certificate file.
        """
        return pulumi.get(self, "server_public_certificate_file")

    @server_public_certificate_file.setter
    def server_public_certificate_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_public_certificate_file", value)

    @property
    @pulumi.getter(name="serverPublicCertificateFilePath")
    def server_public_certificate_file_path(self) -> Optional[pulumi.Input[str]]:
        """
        File path to the server public certificate.
        """
        return pulumi.get(self, "server_public_certificate_file_path")

    @server_public_certificate_file_path.setter
    def server_public_certificate_file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server_public_certificate_file_path", value)

    @property
    @pulumi.getter(name="targetVersion")
    def target_version(self) -> Optional[pulumi.Input[str]]:
        """
        The release version number to which the controller will be upgraded to.
        """
        return pulumi.get(self, "target_version")

    @target_version.setter
    def target_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_version", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Current version of the controller without the build number.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class AviatrixControllerConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_guard_duty_scanning_interval: Optional[pulumi.Input[int]] = None,
                 backup_account_name: Optional[pulumi.Input[str]] = None,
                 backup_bucket_name: Optional[pulumi.Input[str]] = None,
                 backup_cloud_type: Optional[pulumi.Input[int]] = None,
                 backup_configuration: Optional[pulumi.Input[bool]] = None,
                 backup_container_name: Optional[pulumi.Input[str]] = None,
                 backup_region: Optional[pulumi.Input[str]] = None,
                 backup_storage_name: Optional[pulumi.Input[str]] = None,
                 ca_certificate_file: Optional[pulumi.Input[str]] = None,
                 ca_certificate_file_path: Optional[pulumi.Input[str]] = None,
                 enable_vpc_dns_server: Optional[pulumi.Input[bool]] = None,
                 fqdn_exception_rule: Optional[pulumi.Input[bool]] = None,
                 http_access: Optional[pulumi.Input[bool]] = None,
                 manage_gateway_upgrades: Optional[pulumi.Input[bool]] = None,
                 multiple_backups: Optional[pulumi.Input[bool]] = None,
                 server_private_key_file: Optional[pulumi.Input[str]] = None,
                 server_private_key_file_path: Optional[pulumi.Input[str]] = None,
                 server_public_certificate_file: Optional[pulumi.Input[str]] = None,
                 server_public_certificate_file_path: Optional[pulumi.Input[str]] = None,
                 target_version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AviatrixControllerConfig resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] aws_guard_duty_scanning_interval: Scanning Interval for AWS Guard Duty.
        :param pulumi.Input[str] backup_account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[str] backup_bucket_name: Bucket name. Required for AWS, AWSGov, GCP and OCI.
        :param pulumi.Input[int] backup_cloud_type: Type of cloud service provider, requires an integer value. Use 1 for AWS.
        :param pulumi.Input[bool] backup_configuration: Switch to enable/disable controller cloudn backup config.
        :param pulumi.Input[str] backup_container_name: Container name. Required for Azure.
        :param pulumi.Input[str] backup_region: Name of region. Required for Azure and OCI.
        :param pulumi.Input[str] backup_storage_name: Storage name. Required for Azure.
        :param pulumi.Input[str] ca_certificate_file: CA certificate file.
        :param pulumi.Input[str] ca_certificate_file_path: File path to the CA certificate.
        :param pulumi.Input[bool] enable_vpc_dns_server: Enable VPC/VNET DNS Server.
        :param pulumi.Input[bool] fqdn_exception_rule: A system-wide mode. Default: true.
        :param pulumi.Input[bool] http_access: Switch for http access. Default: false.
        :param pulumi.Input[bool] manage_gateway_upgrades: If true, aviatrix_controller_config will upgrade all gateways when target_version is set. If false, only the controller
               will be upgraded when target_version is set. In that case gateway upgrades should be handled in each gateway resource
               individually using the software_version and image_version attributes.
        :param pulumi.Input[bool] multiple_backups: Switch to enable the controller to backup up to a maximum of 3 rotating backups.
        :param pulumi.Input[str] server_private_key_file: Server private key file.
        :param pulumi.Input[str] server_private_key_file_path: File path to the server private key.
        :param pulumi.Input[str] server_public_certificate_file: Server public certificate file.
        :param pulumi.Input[str] server_public_certificate_file_path: File path to the server public certificate.
        :param pulumi.Input[str] target_version: The release version number to which the controller will be upgraded to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AviatrixControllerConfigArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixControllerConfig resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixControllerConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixControllerConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_guard_duty_scanning_interval: Optional[pulumi.Input[int]] = None,
                 backup_account_name: Optional[pulumi.Input[str]] = None,
                 backup_bucket_name: Optional[pulumi.Input[str]] = None,
                 backup_cloud_type: Optional[pulumi.Input[int]] = None,
                 backup_configuration: Optional[pulumi.Input[bool]] = None,
                 backup_container_name: Optional[pulumi.Input[str]] = None,
                 backup_region: Optional[pulumi.Input[str]] = None,
                 backup_storage_name: Optional[pulumi.Input[str]] = None,
                 ca_certificate_file: Optional[pulumi.Input[str]] = None,
                 ca_certificate_file_path: Optional[pulumi.Input[str]] = None,
                 enable_vpc_dns_server: Optional[pulumi.Input[bool]] = None,
                 fqdn_exception_rule: Optional[pulumi.Input[bool]] = None,
                 http_access: Optional[pulumi.Input[bool]] = None,
                 manage_gateway_upgrades: Optional[pulumi.Input[bool]] = None,
                 multiple_backups: Optional[pulumi.Input[bool]] = None,
                 server_private_key_file: Optional[pulumi.Input[str]] = None,
                 server_private_key_file_path: Optional[pulumi.Input[str]] = None,
                 server_public_certificate_file: Optional[pulumi.Input[str]] = None,
                 server_public_certificate_file_path: Optional[pulumi.Input[str]] = None,
                 target_version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixControllerConfigArgs.__new__(AviatrixControllerConfigArgs)

            __props__.__dict__["aws_guard_duty_scanning_interval"] = aws_guard_duty_scanning_interval
            __props__.__dict__["backup_account_name"] = backup_account_name
            __props__.__dict__["backup_bucket_name"] = backup_bucket_name
            __props__.__dict__["backup_cloud_type"] = backup_cloud_type
            __props__.__dict__["backup_configuration"] = backup_configuration
            __props__.__dict__["backup_container_name"] = backup_container_name
            __props__.__dict__["backup_region"] = backup_region
            __props__.__dict__["backup_storage_name"] = backup_storage_name
            __props__.__dict__["ca_certificate_file"] = ca_certificate_file
            __props__.__dict__["ca_certificate_file_path"] = ca_certificate_file_path
            __props__.__dict__["enable_vpc_dns_server"] = enable_vpc_dns_server
            __props__.__dict__["fqdn_exception_rule"] = fqdn_exception_rule
            __props__.__dict__["http_access"] = http_access
            __props__.__dict__["manage_gateway_upgrades"] = manage_gateway_upgrades
            __props__.__dict__["multiple_backups"] = multiple_backups
            __props__.__dict__["server_private_key_file"] = server_private_key_file
            __props__.__dict__["server_private_key_file_path"] = server_private_key_file_path
            __props__.__dict__["server_public_certificate_file"] = server_public_certificate_file
            __props__.__dict__["server_public_certificate_file_path"] = server_public_certificate_file_path
            __props__.__dict__["target_version"] = target_version
            __props__.__dict__["current_version"] = None
            __props__.__dict__["previous_version"] = None
            __props__.__dict__["version"] = None
        super(AviatrixControllerConfig, __self__).__init__(
            'aviatrix:index/aviatrixControllerConfig:AviatrixControllerConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_guard_duty_scanning_interval: Optional[pulumi.Input[int]] = None,
            backup_account_name: Optional[pulumi.Input[str]] = None,
            backup_bucket_name: Optional[pulumi.Input[str]] = None,
            backup_cloud_type: Optional[pulumi.Input[int]] = None,
            backup_configuration: Optional[pulumi.Input[bool]] = None,
            backup_container_name: Optional[pulumi.Input[str]] = None,
            backup_region: Optional[pulumi.Input[str]] = None,
            backup_storage_name: Optional[pulumi.Input[str]] = None,
            ca_certificate_file: Optional[pulumi.Input[str]] = None,
            ca_certificate_file_path: Optional[pulumi.Input[str]] = None,
            current_version: Optional[pulumi.Input[str]] = None,
            enable_vpc_dns_server: Optional[pulumi.Input[bool]] = None,
            fqdn_exception_rule: Optional[pulumi.Input[bool]] = None,
            http_access: Optional[pulumi.Input[bool]] = None,
            manage_gateway_upgrades: Optional[pulumi.Input[bool]] = None,
            multiple_backups: Optional[pulumi.Input[bool]] = None,
            previous_version: Optional[pulumi.Input[str]] = None,
            server_private_key_file: Optional[pulumi.Input[str]] = None,
            server_private_key_file_path: Optional[pulumi.Input[str]] = None,
            server_public_certificate_file: Optional[pulumi.Input[str]] = None,
            server_public_certificate_file_path: Optional[pulumi.Input[str]] = None,
            target_version: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'AviatrixControllerConfig':
        """
        Get an existing AviatrixControllerConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] aws_guard_duty_scanning_interval: Scanning Interval for AWS Guard Duty.
        :param pulumi.Input[str] backup_account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[str] backup_bucket_name: Bucket name. Required for AWS, AWSGov, GCP and OCI.
        :param pulumi.Input[int] backup_cloud_type: Type of cloud service provider, requires an integer value. Use 1 for AWS.
        :param pulumi.Input[bool] backup_configuration: Switch to enable/disable controller cloudn backup config.
        :param pulumi.Input[str] backup_container_name: Container name. Required for Azure.
        :param pulumi.Input[str] backup_region: Name of region. Required for Azure and OCI.
        :param pulumi.Input[str] backup_storage_name: Storage name. Required for Azure.
        :param pulumi.Input[str] ca_certificate_file: CA certificate file.
        :param pulumi.Input[str] ca_certificate_file_path: File path to the CA certificate.
        :param pulumi.Input[str] current_version: Current version of the controller.
        :param pulumi.Input[bool] enable_vpc_dns_server: Enable VPC/VNET DNS Server.
        :param pulumi.Input[bool] fqdn_exception_rule: A system-wide mode. Default: true.
        :param pulumi.Input[bool] http_access: Switch for http access. Default: false.
        :param pulumi.Input[bool] manage_gateway_upgrades: If true, aviatrix_controller_config will upgrade all gateways when target_version is set. If false, only the controller
               will be upgraded when target_version is set. In that case gateway upgrades should be handled in each gateway resource
               individually using the software_version and image_version attributes.
        :param pulumi.Input[bool] multiple_backups: Switch to enable the controller to backup up to a maximum of 3 rotating backups.
        :param pulumi.Input[str] previous_version: Previous version of the controller.
        :param pulumi.Input[str] server_private_key_file: Server private key file.
        :param pulumi.Input[str] server_private_key_file_path: File path to the server private key.
        :param pulumi.Input[str] server_public_certificate_file: Server public certificate file.
        :param pulumi.Input[str] server_public_certificate_file_path: File path to the server public certificate.
        :param pulumi.Input[str] target_version: The release version number to which the controller will be upgraded to.
        :param pulumi.Input[str] version: Current version of the controller without the build number.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixControllerConfigState.__new__(_AviatrixControllerConfigState)

        __props__.__dict__["aws_guard_duty_scanning_interval"] = aws_guard_duty_scanning_interval
        __props__.__dict__["backup_account_name"] = backup_account_name
        __props__.__dict__["backup_bucket_name"] = backup_bucket_name
        __props__.__dict__["backup_cloud_type"] = backup_cloud_type
        __props__.__dict__["backup_configuration"] = backup_configuration
        __props__.__dict__["backup_container_name"] = backup_container_name
        __props__.__dict__["backup_region"] = backup_region
        __props__.__dict__["backup_storage_name"] = backup_storage_name
        __props__.__dict__["ca_certificate_file"] = ca_certificate_file
        __props__.__dict__["ca_certificate_file_path"] = ca_certificate_file_path
        __props__.__dict__["current_version"] = current_version
        __props__.__dict__["enable_vpc_dns_server"] = enable_vpc_dns_server
        __props__.__dict__["fqdn_exception_rule"] = fqdn_exception_rule
        __props__.__dict__["http_access"] = http_access
        __props__.__dict__["manage_gateway_upgrades"] = manage_gateway_upgrades
        __props__.__dict__["multiple_backups"] = multiple_backups
        __props__.__dict__["previous_version"] = previous_version
        __props__.__dict__["server_private_key_file"] = server_private_key_file
        __props__.__dict__["server_private_key_file_path"] = server_private_key_file_path
        __props__.__dict__["server_public_certificate_file"] = server_public_certificate_file
        __props__.__dict__["server_public_certificate_file_path"] = server_public_certificate_file_path
        __props__.__dict__["target_version"] = target_version
        __props__.__dict__["version"] = version
        return AviatrixControllerConfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="awsGuardDutyScanningInterval")
    def aws_guard_duty_scanning_interval(self) -> pulumi.Output[Optional[int]]:
        """
        Scanning Interval for AWS Guard Duty.
        """
        return pulumi.get(self, "aws_guard_duty_scanning_interval")

    @property
    @pulumi.getter(name="backupAccountName")
    def backup_account_name(self) -> pulumi.Output[Optional[str]]:
        """
        This parameter represents the name of a Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "backup_account_name")

    @property
    @pulumi.getter(name="backupBucketName")
    def backup_bucket_name(self) -> pulumi.Output[Optional[str]]:
        """
        Bucket name. Required for AWS, AWSGov, GCP and OCI.
        """
        return pulumi.get(self, "backup_bucket_name")

    @property
    @pulumi.getter(name="backupCloudType")
    def backup_cloud_type(self) -> pulumi.Output[Optional[int]]:
        """
        Type of cloud service provider, requires an integer value. Use 1 for AWS.
        """
        return pulumi.get(self, "backup_cloud_type")

    @property
    @pulumi.getter(name="backupConfiguration")
    def backup_configuration(self) -> pulumi.Output[Optional[bool]]:
        """
        Switch to enable/disable controller cloudn backup config.
        """
        return pulumi.get(self, "backup_configuration")

    @property
    @pulumi.getter(name="backupContainerName")
    def backup_container_name(self) -> pulumi.Output[Optional[str]]:
        """
        Container name. Required for Azure.
        """
        return pulumi.get(self, "backup_container_name")

    @property
    @pulumi.getter(name="backupRegion")
    def backup_region(self) -> pulumi.Output[Optional[str]]:
        """
        Name of region. Required for Azure and OCI.
        """
        return pulumi.get(self, "backup_region")

    @property
    @pulumi.getter(name="backupStorageName")
    def backup_storage_name(self) -> pulumi.Output[Optional[str]]:
        """
        Storage name. Required for Azure.
        """
        return pulumi.get(self, "backup_storage_name")

    @property
    @pulumi.getter(name="caCertificateFile")
    def ca_certificate_file(self) -> pulumi.Output[Optional[str]]:
        """
        CA certificate file.
        """
        return pulumi.get(self, "ca_certificate_file")

    @property
    @pulumi.getter(name="caCertificateFilePath")
    def ca_certificate_file_path(self) -> pulumi.Output[Optional[str]]:
        """
        File path to the CA certificate.
        """
        return pulumi.get(self, "ca_certificate_file_path")

    @property
    @pulumi.getter(name="currentVersion")
    def current_version(self) -> pulumi.Output[str]:
        """
        Current version of the controller.
        """
        return pulumi.get(self, "current_version")

    @property
    @pulumi.getter(name="enableVpcDnsServer")
    def enable_vpc_dns_server(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable VPC/VNET DNS Server.
        """
        return pulumi.get(self, "enable_vpc_dns_server")

    @property
    @pulumi.getter(name="fqdnExceptionRule")
    def fqdn_exception_rule(self) -> pulumi.Output[Optional[bool]]:
        """
        A system-wide mode. Default: true.
        """
        return pulumi.get(self, "fqdn_exception_rule")

    @property
    @pulumi.getter(name="httpAccess")
    def http_access(self) -> pulumi.Output[Optional[bool]]:
        """
        Switch for http access. Default: false.
        """
        return pulumi.get(self, "http_access")

    @property
    @pulumi.getter(name="manageGatewayUpgrades")
    def manage_gateway_upgrades(self) -> pulumi.Output[Optional[bool]]:
        """
        If true, aviatrix_controller_config will upgrade all gateways when target_version is set. If false, only the controller
        will be upgraded when target_version is set. In that case gateway upgrades should be handled in each gateway resource
        individually using the software_version and image_version attributes.
        """
        return pulumi.get(self, "manage_gateway_upgrades")

    @property
    @pulumi.getter(name="multipleBackups")
    def multiple_backups(self) -> pulumi.Output[Optional[bool]]:
        """
        Switch to enable the controller to backup up to a maximum of 3 rotating backups.
        """
        return pulumi.get(self, "multiple_backups")

    @property
    @pulumi.getter(name="previousVersion")
    def previous_version(self) -> pulumi.Output[str]:
        """
        Previous version of the controller.
        """
        return pulumi.get(self, "previous_version")

    @property
    @pulumi.getter(name="serverPrivateKeyFile")
    def server_private_key_file(self) -> pulumi.Output[Optional[str]]:
        """
        Server private key file.
        """
        return pulumi.get(self, "server_private_key_file")

    @property
    @pulumi.getter(name="serverPrivateKeyFilePath")
    def server_private_key_file_path(self) -> pulumi.Output[Optional[str]]:
        """
        File path to the server private key.
        """
        return pulumi.get(self, "server_private_key_file_path")

    @property
    @pulumi.getter(name="serverPublicCertificateFile")
    def server_public_certificate_file(self) -> pulumi.Output[Optional[str]]:
        """
        Server public certificate file.
        """
        return pulumi.get(self, "server_public_certificate_file")

    @property
    @pulumi.getter(name="serverPublicCertificateFilePath")
    def server_public_certificate_file_path(self) -> pulumi.Output[Optional[str]]:
        """
        File path to the server public certificate.
        """
        return pulumi.get(self, "server_public_certificate_file_path")

    @property
    @pulumi.getter(name="targetVersion")
    def target_version(self) -> pulumi.Output[Optional[str]]:
        """
        The release version number to which the controller will be upgraded to.
        """
        return pulumi.get(self, "target_version")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Current version of the controller without the build number.
        """
        return pulumi.get(self, "version")

