# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixCloudnRegistrationArgs', 'AviatrixCloudnRegistration']

@pulumi.input_type
class AviatrixCloudnRegistrationArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 password: pulumi.Input[str],
                 username: pulumi.Input[str],
                 local_as_number: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AviatrixCloudnRegistration resource.
        :param pulumi.Input[str] address: CloudN IP Address or FQDN.
        :param pulumi.Input[str] password: CloudN password.
        :param pulumi.Input[str] username: CloudN username.
        :param pulumi.Input[str] local_as_number: Changes the Aviatrix CloudN ASN number before you setup Aviatrix Transit Gateway connection configurations.
        :param pulumi.Input[str] name: CloudN name to register on controller.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_paths: AS path prepend.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)
        if local_as_number is not None:
            pulumi.set(__self__, "local_as_number", local_as_number)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if prepend_as_paths is not None:
            pulumi.set(__self__, "prepend_as_paths", prepend_as_paths)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        CloudN IP Address or FQDN.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        CloudN password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        CloudN username.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="localAsNumber")
    def local_as_number(self) -> Optional[pulumi.Input[str]]:
        """
        Changes the Aviatrix CloudN ASN number before you setup Aviatrix Transit Gateway connection configurations.
        """
        return pulumi.get(self, "local_as_number")

    @local_as_number.setter
    def local_as_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_as_number", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        CloudN name to register on controller.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="prependAsPaths")
    def prepend_as_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        AS path prepend.
        """
        return pulumi.get(self, "prepend_as_paths")

    @prepend_as_paths.setter
    def prepend_as_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prepend_as_paths", value)


@pulumi.input_type
class _AviatrixCloudnRegistrationState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 local_as_number: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixCloudnRegistration resources.
        :param pulumi.Input[str] address: CloudN IP Address or FQDN.
        :param pulumi.Input[str] local_as_number: Changes the Aviatrix CloudN ASN number before you setup Aviatrix Transit Gateway connection configurations.
        :param pulumi.Input[str] name: CloudN name to register on controller.
        :param pulumi.Input[str] password: CloudN password.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_paths: AS path prepend.
        :param pulumi.Input[str] username: CloudN username.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if local_as_number is not None:
            pulumi.set(__self__, "local_as_number", local_as_number)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if prepend_as_paths is not None:
            pulumi.set(__self__, "prepend_as_paths", prepend_as_paths)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        CloudN IP Address or FQDN.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="localAsNumber")
    def local_as_number(self) -> Optional[pulumi.Input[str]]:
        """
        Changes the Aviatrix CloudN ASN number before you setup Aviatrix Transit Gateway connection configurations.
        """
        return pulumi.get(self, "local_as_number")

    @local_as_number.setter
    def local_as_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_as_number", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        CloudN name to register on controller.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        CloudN password.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="prependAsPaths")
    def prepend_as_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        AS path prepend.
        """
        return pulumi.get(self, "prepend_as_paths")

    @prepend_as_paths.setter
    def prepend_as_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prepend_as_paths", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        CloudN username.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


class AviatrixCloudnRegistration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[str]] = None,
                 local_as_number: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AviatrixCloudnRegistration resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address: CloudN IP Address or FQDN.
        :param pulumi.Input[str] local_as_number: Changes the Aviatrix CloudN ASN number before you setup Aviatrix Transit Gateway connection configurations.
        :param pulumi.Input[str] name: CloudN name to register on controller.
        :param pulumi.Input[str] password: CloudN password.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_paths: AS path prepend.
        :param pulumi.Input[str] username: CloudN username.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixCloudnRegistrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixCloudnRegistration resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixCloudnRegistrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixCloudnRegistrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[str]] = None,
                 local_as_number: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixCloudnRegistrationArgs.__new__(AviatrixCloudnRegistrationArgs)

            if address is None and not opts.urn:
                raise TypeError("Missing required property 'address'")
            __props__.__dict__["address"] = address
            __props__.__dict__["local_as_number"] = local_as_number
            __props__.__dict__["name"] = name
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = password
            __props__.__dict__["prepend_as_paths"] = prepend_as_paths
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
        super(AviatrixCloudnRegistration, __self__).__init__(
            'aviatrix:index/aviatrixCloudnRegistration:AviatrixCloudnRegistration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[str]] = None,
            local_as_number: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            prepend_as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'AviatrixCloudnRegistration':
        """
        Get an existing AviatrixCloudnRegistration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address: CloudN IP Address or FQDN.
        :param pulumi.Input[str] local_as_number: Changes the Aviatrix CloudN ASN number before you setup Aviatrix Transit Gateway connection configurations.
        :param pulumi.Input[str] name: CloudN name to register on controller.
        :param pulumi.Input[str] password: CloudN password.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prepend_as_paths: AS path prepend.
        :param pulumi.Input[str] username: CloudN username.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixCloudnRegistrationState.__new__(_AviatrixCloudnRegistrationState)

        __props__.__dict__["address"] = address
        __props__.__dict__["local_as_number"] = local_as_number
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["prepend_as_paths"] = prepend_as_paths
        __props__.__dict__["username"] = username
        return AviatrixCloudnRegistration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Output[str]:
        """
        CloudN IP Address or FQDN.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="localAsNumber")
    def local_as_number(self) -> pulumi.Output[str]:
        """
        Changes the Aviatrix CloudN ASN number before you setup Aviatrix Transit Gateway connection configurations.
        """
        return pulumi.get(self, "local_as_number")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        CloudN name to register on controller.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        CloudN password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="prependAsPaths")
    def prepend_as_paths(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        AS path prepend.
        """
        return pulumi.get(self, "prepend_as_paths")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        CloudN username.
        """
        return pulumi.get(self, "username")

