# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixAzureSpokeNativePeeringArgs', 'AviatrixAzureSpokeNativePeering']

@pulumi.input_type
class AviatrixAzureSpokeNativePeeringArgs:
    def __init__(__self__, *,
                 spoke_account_name: pulumi.Input[str],
                 spoke_region: pulumi.Input[str],
                 spoke_vpc_id: pulumi.Input[str],
                 transit_gateway_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a AviatrixAzureSpokeNativePeering resource.
        :param pulumi.Input[str] spoke_account_name: An Aviatrix account that corresponds to a subscription in Azure.
        :param pulumi.Input[str] spoke_region: Spoke VNet region.
        :param pulumi.Input[str] spoke_vpc_id: Combination of the Spoke VNet name and resource group.
        :param pulumi.Input[str] transit_gateway_name: Name of an azure transit gateway with transit firenet enabled.
        """
        pulumi.set(__self__, "spoke_account_name", spoke_account_name)
        pulumi.set(__self__, "spoke_region", spoke_region)
        pulumi.set(__self__, "spoke_vpc_id", spoke_vpc_id)
        pulumi.set(__self__, "transit_gateway_name", transit_gateway_name)

    @property
    @pulumi.getter(name="spokeAccountName")
    def spoke_account_name(self) -> pulumi.Input[str]:
        """
        An Aviatrix account that corresponds to a subscription in Azure.
        """
        return pulumi.get(self, "spoke_account_name")

    @spoke_account_name.setter
    def spoke_account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "spoke_account_name", value)

    @property
    @pulumi.getter(name="spokeRegion")
    def spoke_region(self) -> pulumi.Input[str]:
        """
        Spoke VNet region.
        """
        return pulumi.get(self, "spoke_region")

    @spoke_region.setter
    def spoke_region(self, value: pulumi.Input[str]):
        pulumi.set(self, "spoke_region", value)

    @property
    @pulumi.getter(name="spokeVpcId")
    def spoke_vpc_id(self) -> pulumi.Input[str]:
        """
        Combination of the Spoke VNet name and resource group.
        """
        return pulumi.get(self, "spoke_vpc_id")

    @spoke_vpc_id.setter
    def spoke_vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "spoke_vpc_id", value)

    @property
    @pulumi.getter(name="transitGatewayName")
    def transit_gateway_name(self) -> pulumi.Input[str]:
        """
        Name of an azure transit gateway with transit firenet enabled.
        """
        return pulumi.get(self, "transit_gateway_name")

    @transit_gateway_name.setter
    def transit_gateway_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "transit_gateway_name", value)


@pulumi.input_type
class _AviatrixAzureSpokeNativePeeringState:
    def __init__(__self__, *,
                 spoke_account_name: Optional[pulumi.Input[str]] = None,
                 spoke_region: Optional[pulumi.Input[str]] = None,
                 spoke_vpc_id: Optional[pulumi.Input[str]] = None,
                 transit_gateway_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixAzureSpokeNativePeering resources.
        :param pulumi.Input[str] spoke_account_name: An Aviatrix account that corresponds to a subscription in Azure.
        :param pulumi.Input[str] spoke_region: Spoke VNet region.
        :param pulumi.Input[str] spoke_vpc_id: Combination of the Spoke VNet name and resource group.
        :param pulumi.Input[str] transit_gateway_name: Name of an azure transit gateway with transit firenet enabled.
        """
        if spoke_account_name is not None:
            pulumi.set(__self__, "spoke_account_name", spoke_account_name)
        if spoke_region is not None:
            pulumi.set(__self__, "spoke_region", spoke_region)
        if spoke_vpc_id is not None:
            pulumi.set(__self__, "spoke_vpc_id", spoke_vpc_id)
        if transit_gateway_name is not None:
            pulumi.set(__self__, "transit_gateway_name", transit_gateway_name)

    @property
    @pulumi.getter(name="spokeAccountName")
    def spoke_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        An Aviatrix account that corresponds to a subscription in Azure.
        """
        return pulumi.get(self, "spoke_account_name")

    @spoke_account_name.setter
    def spoke_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spoke_account_name", value)

    @property
    @pulumi.getter(name="spokeRegion")
    def spoke_region(self) -> Optional[pulumi.Input[str]]:
        """
        Spoke VNet region.
        """
        return pulumi.get(self, "spoke_region")

    @spoke_region.setter
    def spoke_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spoke_region", value)

    @property
    @pulumi.getter(name="spokeVpcId")
    def spoke_vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Combination of the Spoke VNet name and resource group.
        """
        return pulumi.get(self, "spoke_vpc_id")

    @spoke_vpc_id.setter
    def spoke_vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spoke_vpc_id", value)

    @property
    @pulumi.getter(name="transitGatewayName")
    def transit_gateway_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of an azure transit gateway with transit firenet enabled.
        """
        return pulumi.get(self, "transit_gateway_name")

    @transit_gateway_name.setter
    def transit_gateway_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_gateway_name", value)


class AviatrixAzureSpokeNativePeering(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 spoke_account_name: Optional[pulumi.Input[str]] = None,
                 spoke_region: Optional[pulumi.Input[str]] = None,
                 spoke_vpc_id: Optional[pulumi.Input[str]] = None,
                 transit_gateway_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AviatrixAzureSpokeNativePeering resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] spoke_account_name: An Aviatrix account that corresponds to a subscription in Azure.
        :param pulumi.Input[str] spoke_region: Spoke VNet region.
        :param pulumi.Input[str] spoke_vpc_id: Combination of the Spoke VNet name and resource group.
        :param pulumi.Input[str] transit_gateway_name: Name of an azure transit gateway with transit firenet enabled.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixAzureSpokeNativePeeringArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixAzureSpokeNativePeering resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixAzureSpokeNativePeeringArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixAzureSpokeNativePeeringArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 spoke_account_name: Optional[pulumi.Input[str]] = None,
                 spoke_region: Optional[pulumi.Input[str]] = None,
                 spoke_vpc_id: Optional[pulumi.Input[str]] = None,
                 transit_gateway_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixAzureSpokeNativePeeringArgs.__new__(AviatrixAzureSpokeNativePeeringArgs)

            if spoke_account_name is None and not opts.urn:
                raise TypeError("Missing required property 'spoke_account_name'")
            __props__.__dict__["spoke_account_name"] = spoke_account_name
            if spoke_region is None and not opts.urn:
                raise TypeError("Missing required property 'spoke_region'")
            __props__.__dict__["spoke_region"] = spoke_region
            if spoke_vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'spoke_vpc_id'")
            __props__.__dict__["spoke_vpc_id"] = spoke_vpc_id
            if transit_gateway_name is None and not opts.urn:
                raise TypeError("Missing required property 'transit_gateway_name'")
            __props__.__dict__["transit_gateway_name"] = transit_gateway_name
        super(AviatrixAzureSpokeNativePeering, __self__).__init__(
            'aviatrix:index/aviatrixAzureSpokeNativePeering:AviatrixAzureSpokeNativePeering',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            spoke_account_name: Optional[pulumi.Input[str]] = None,
            spoke_region: Optional[pulumi.Input[str]] = None,
            spoke_vpc_id: Optional[pulumi.Input[str]] = None,
            transit_gateway_name: Optional[pulumi.Input[str]] = None) -> 'AviatrixAzureSpokeNativePeering':
        """
        Get an existing AviatrixAzureSpokeNativePeering resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] spoke_account_name: An Aviatrix account that corresponds to a subscription in Azure.
        :param pulumi.Input[str] spoke_region: Spoke VNet region.
        :param pulumi.Input[str] spoke_vpc_id: Combination of the Spoke VNet name and resource group.
        :param pulumi.Input[str] transit_gateway_name: Name of an azure transit gateway with transit firenet enabled.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixAzureSpokeNativePeeringState.__new__(_AviatrixAzureSpokeNativePeeringState)

        __props__.__dict__["spoke_account_name"] = spoke_account_name
        __props__.__dict__["spoke_region"] = spoke_region
        __props__.__dict__["spoke_vpc_id"] = spoke_vpc_id
        __props__.__dict__["transit_gateway_name"] = transit_gateway_name
        return AviatrixAzureSpokeNativePeering(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="spokeAccountName")
    def spoke_account_name(self) -> pulumi.Output[str]:
        """
        An Aviatrix account that corresponds to a subscription in Azure.
        """
        return pulumi.get(self, "spoke_account_name")

    @property
    @pulumi.getter(name="spokeRegion")
    def spoke_region(self) -> pulumi.Output[str]:
        """
        Spoke VNet region.
        """
        return pulumi.get(self, "spoke_region")

    @property
    @pulumi.getter(name="spokeVpcId")
    def spoke_vpc_id(self) -> pulumi.Output[str]:
        """
        Combination of the Spoke VNet name and resource group.
        """
        return pulumi.get(self, "spoke_vpc_id")

    @property
    @pulumi.getter(name="transitGatewayName")
    def transit_gateway_name(self) -> pulumi.Output[str]:
        """
        Name of an azure transit gateway with transit firenet enabled.
        """
        return pulumi.get(self, "transit_gateway_name")

