# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixAzurePeerArgs', 'AviatrixAzurePeer']

@pulumi.input_type
class AviatrixAzurePeerArgs:
    def __init__(__self__, *,
                 account_name1: pulumi.Input[str],
                 account_name2: pulumi.Input[str],
                 vnet_name_resource_group1: pulumi.Input[str],
                 vnet_name_resource_group2: pulumi.Input[str],
                 vnet_reg1: pulumi.Input[str],
                 vnet_reg2: pulumi.Input[str]):
        """
        The set of arguments for constructing a AviatrixAzurePeer resource.
        :param pulumi.Input[str] account_name1: This parameter represents the name of an Azure Cloud-Account in Aviatrix controller.
        :param pulumi.Input[str] account_name2: This parameter represents the name of an Azure Cloud-Account in Aviatrix controller.
        :param pulumi.Input[str] vnet_name_resource_group1: VNet-Name of Azure cloud.
        :param pulumi.Input[str] vnet_name_resource_group2: VNet-Name of Azure cloud.
        :param pulumi.Input[str] vnet_reg1: Region of Azure cloud.
        :param pulumi.Input[str] vnet_reg2: Region of Azure cloud.
        """
        pulumi.set(__self__, "account_name1", account_name1)
        pulumi.set(__self__, "account_name2", account_name2)
        pulumi.set(__self__, "vnet_name_resource_group1", vnet_name_resource_group1)
        pulumi.set(__self__, "vnet_name_resource_group2", vnet_name_resource_group2)
        pulumi.set(__self__, "vnet_reg1", vnet_reg1)
        pulumi.set(__self__, "vnet_reg2", vnet_reg2)

    @property
    @pulumi.getter(name="accountName1")
    def account_name1(self) -> pulumi.Input[str]:
        """
        This parameter represents the name of an Azure Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name1")

    @account_name1.setter
    def account_name1(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name1", value)

    @property
    @pulumi.getter(name="accountName2")
    def account_name2(self) -> pulumi.Input[str]:
        """
        This parameter represents the name of an Azure Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name2")

    @account_name2.setter
    def account_name2(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name2", value)

    @property
    @pulumi.getter(name="vnetNameResourceGroup1")
    def vnet_name_resource_group1(self) -> pulumi.Input[str]:
        """
        VNet-Name of Azure cloud.
        """
        return pulumi.get(self, "vnet_name_resource_group1")

    @vnet_name_resource_group1.setter
    def vnet_name_resource_group1(self, value: pulumi.Input[str]):
        pulumi.set(self, "vnet_name_resource_group1", value)

    @property
    @pulumi.getter(name="vnetNameResourceGroup2")
    def vnet_name_resource_group2(self) -> pulumi.Input[str]:
        """
        VNet-Name of Azure cloud.
        """
        return pulumi.get(self, "vnet_name_resource_group2")

    @vnet_name_resource_group2.setter
    def vnet_name_resource_group2(self, value: pulumi.Input[str]):
        pulumi.set(self, "vnet_name_resource_group2", value)

    @property
    @pulumi.getter(name="vnetReg1")
    def vnet_reg1(self) -> pulumi.Input[str]:
        """
        Region of Azure cloud.
        """
        return pulumi.get(self, "vnet_reg1")

    @vnet_reg1.setter
    def vnet_reg1(self, value: pulumi.Input[str]):
        pulumi.set(self, "vnet_reg1", value)

    @property
    @pulumi.getter(name="vnetReg2")
    def vnet_reg2(self) -> pulumi.Input[str]:
        """
        Region of Azure cloud.
        """
        return pulumi.get(self, "vnet_reg2")

    @vnet_reg2.setter
    def vnet_reg2(self, value: pulumi.Input[str]):
        pulumi.set(self, "vnet_reg2", value)


@pulumi.input_type
class _AviatrixAzurePeerState:
    def __init__(__self__, *,
                 account_name1: Optional[pulumi.Input[str]] = None,
                 account_name2: Optional[pulumi.Input[str]] = None,
                 vnet_cidr1s: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vnet_cidr2s: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vnet_name_resource_group1: Optional[pulumi.Input[str]] = None,
                 vnet_name_resource_group2: Optional[pulumi.Input[str]] = None,
                 vnet_reg1: Optional[pulumi.Input[str]] = None,
                 vnet_reg2: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixAzurePeer resources.
        :param pulumi.Input[str] account_name1: This parameter represents the name of an Azure Cloud-Account in Aviatrix controller.
        :param pulumi.Input[str] account_name2: This parameter represents the name of an Azure Cloud-Account in Aviatrix controller.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vnet_cidr1s: List of VNet CIDR of vnet_name_resource_group1.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vnet_cidr2s: List of VNet CIDR of vnet_name_resource_group2.
        :param pulumi.Input[str] vnet_name_resource_group1: VNet-Name of Azure cloud.
        :param pulumi.Input[str] vnet_name_resource_group2: VNet-Name of Azure cloud.
        :param pulumi.Input[str] vnet_reg1: Region of Azure cloud.
        :param pulumi.Input[str] vnet_reg2: Region of Azure cloud.
        """
        if account_name1 is not None:
            pulumi.set(__self__, "account_name1", account_name1)
        if account_name2 is not None:
            pulumi.set(__self__, "account_name2", account_name2)
        if vnet_cidr1s is not None:
            pulumi.set(__self__, "vnet_cidr1s", vnet_cidr1s)
        if vnet_cidr2s is not None:
            pulumi.set(__self__, "vnet_cidr2s", vnet_cidr2s)
        if vnet_name_resource_group1 is not None:
            pulumi.set(__self__, "vnet_name_resource_group1", vnet_name_resource_group1)
        if vnet_name_resource_group2 is not None:
            pulumi.set(__self__, "vnet_name_resource_group2", vnet_name_resource_group2)
        if vnet_reg1 is not None:
            pulumi.set(__self__, "vnet_reg1", vnet_reg1)
        if vnet_reg2 is not None:
            pulumi.set(__self__, "vnet_reg2", vnet_reg2)

    @property
    @pulumi.getter(name="accountName1")
    def account_name1(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter represents the name of an Azure Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name1")

    @account_name1.setter
    def account_name1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name1", value)

    @property
    @pulumi.getter(name="accountName2")
    def account_name2(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter represents the name of an Azure Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name2")

    @account_name2.setter
    def account_name2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name2", value)

    @property
    @pulumi.getter(name="vnetCidr1s")
    def vnet_cidr1s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of VNet CIDR of vnet_name_resource_group1.
        """
        return pulumi.get(self, "vnet_cidr1s")

    @vnet_cidr1s.setter
    def vnet_cidr1s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vnet_cidr1s", value)

    @property
    @pulumi.getter(name="vnetCidr2s")
    def vnet_cidr2s(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of VNet CIDR of vnet_name_resource_group2.
        """
        return pulumi.get(self, "vnet_cidr2s")

    @vnet_cidr2s.setter
    def vnet_cidr2s(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vnet_cidr2s", value)

    @property
    @pulumi.getter(name="vnetNameResourceGroup1")
    def vnet_name_resource_group1(self) -> Optional[pulumi.Input[str]]:
        """
        VNet-Name of Azure cloud.
        """
        return pulumi.get(self, "vnet_name_resource_group1")

    @vnet_name_resource_group1.setter
    def vnet_name_resource_group1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vnet_name_resource_group1", value)

    @property
    @pulumi.getter(name="vnetNameResourceGroup2")
    def vnet_name_resource_group2(self) -> Optional[pulumi.Input[str]]:
        """
        VNet-Name of Azure cloud.
        """
        return pulumi.get(self, "vnet_name_resource_group2")

    @vnet_name_resource_group2.setter
    def vnet_name_resource_group2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vnet_name_resource_group2", value)

    @property
    @pulumi.getter(name="vnetReg1")
    def vnet_reg1(self) -> Optional[pulumi.Input[str]]:
        """
        Region of Azure cloud.
        """
        return pulumi.get(self, "vnet_reg1")

    @vnet_reg1.setter
    def vnet_reg1(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vnet_reg1", value)

    @property
    @pulumi.getter(name="vnetReg2")
    def vnet_reg2(self) -> Optional[pulumi.Input[str]]:
        """
        Region of Azure cloud.
        """
        return pulumi.get(self, "vnet_reg2")

    @vnet_reg2.setter
    def vnet_reg2(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vnet_reg2", value)


class AviatrixAzurePeer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name1: Optional[pulumi.Input[str]] = None,
                 account_name2: Optional[pulumi.Input[str]] = None,
                 vnet_name_resource_group1: Optional[pulumi.Input[str]] = None,
                 vnet_name_resource_group2: Optional[pulumi.Input[str]] = None,
                 vnet_reg1: Optional[pulumi.Input[str]] = None,
                 vnet_reg2: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AviatrixAzurePeer resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name1: This parameter represents the name of an Azure Cloud-Account in Aviatrix controller.
        :param pulumi.Input[str] account_name2: This parameter represents the name of an Azure Cloud-Account in Aviatrix controller.
        :param pulumi.Input[str] vnet_name_resource_group1: VNet-Name of Azure cloud.
        :param pulumi.Input[str] vnet_name_resource_group2: VNet-Name of Azure cloud.
        :param pulumi.Input[str] vnet_reg1: Region of Azure cloud.
        :param pulumi.Input[str] vnet_reg2: Region of Azure cloud.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixAzurePeerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixAzurePeer resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixAzurePeerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixAzurePeerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name1: Optional[pulumi.Input[str]] = None,
                 account_name2: Optional[pulumi.Input[str]] = None,
                 vnet_name_resource_group1: Optional[pulumi.Input[str]] = None,
                 vnet_name_resource_group2: Optional[pulumi.Input[str]] = None,
                 vnet_reg1: Optional[pulumi.Input[str]] = None,
                 vnet_reg2: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixAzurePeerArgs.__new__(AviatrixAzurePeerArgs)

            if account_name1 is None and not opts.urn:
                raise TypeError("Missing required property 'account_name1'")
            __props__.__dict__["account_name1"] = account_name1
            if account_name2 is None and not opts.urn:
                raise TypeError("Missing required property 'account_name2'")
            __props__.__dict__["account_name2"] = account_name2
            if vnet_name_resource_group1 is None and not opts.urn:
                raise TypeError("Missing required property 'vnet_name_resource_group1'")
            __props__.__dict__["vnet_name_resource_group1"] = vnet_name_resource_group1
            if vnet_name_resource_group2 is None and not opts.urn:
                raise TypeError("Missing required property 'vnet_name_resource_group2'")
            __props__.__dict__["vnet_name_resource_group2"] = vnet_name_resource_group2
            if vnet_reg1 is None and not opts.urn:
                raise TypeError("Missing required property 'vnet_reg1'")
            __props__.__dict__["vnet_reg1"] = vnet_reg1
            if vnet_reg2 is None and not opts.urn:
                raise TypeError("Missing required property 'vnet_reg2'")
            __props__.__dict__["vnet_reg2"] = vnet_reg2
            __props__.__dict__["vnet_cidr1s"] = None
            __props__.__dict__["vnet_cidr2s"] = None
        super(AviatrixAzurePeer, __self__).__init__(
            'aviatrix:index/aviatrixAzurePeer:AviatrixAzurePeer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name1: Optional[pulumi.Input[str]] = None,
            account_name2: Optional[pulumi.Input[str]] = None,
            vnet_cidr1s: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            vnet_cidr2s: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            vnet_name_resource_group1: Optional[pulumi.Input[str]] = None,
            vnet_name_resource_group2: Optional[pulumi.Input[str]] = None,
            vnet_reg1: Optional[pulumi.Input[str]] = None,
            vnet_reg2: Optional[pulumi.Input[str]] = None) -> 'AviatrixAzurePeer':
        """
        Get an existing AviatrixAzurePeer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name1: This parameter represents the name of an Azure Cloud-Account in Aviatrix controller.
        :param pulumi.Input[str] account_name2: This parameter represents the name of an Azure Cloud-Account in Aviatrix controller.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vnet_cidr1s: List of VNet CIDR of vnet_name_resource_group1.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vnet_cidr2s: List of VNet CIDR of vnet_name_resource_group2.
        :param pulumi.Input[str] vnet_name_resource_group1: VNet-Name of Azure cloud.
        :param pulumi.Input[str] vnet_name_resource_group2: VNet-Name of Azure cloud.
        :param pulumi.Input[str] vnet_reg1: Region of Azure cloud.
        :param pulumi.Input[str] vnet_reg2: Region of Azure cloud.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixAzurePeerState.__new__(_AviatrixAzurePeerState)

        __props__.__dict__["account_name1"] = account_name1
        __props__.__dict__["account_name2"] = account_name2
        __props__.__dict__["vnet_cidr1s"] = vnet_cidr1s
        __props__.__dict__["vnet_cidr2s"] = vnet_cidr2s
        __props__.__dict__["vnet_name_resource_group1"] = vnet_name_resource_group1
        __props__.__dict__["vnet_name_resource_group2"] = vnet_name_resource_group2
        __props__.__dict__["vnet_reg1"] = vnet_reg1
        __props__.__dict__["vnet_reg2"] = vnet_reg2
        return AviatrixAzurePeer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountName1")
    def account_name1(self) -> pulumi.Output[str]:
        """
        This parameter represents the name of an Azure Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name1")

    @property
    @pulumi.getter(name="accountName2")
    def account_name2(self) -> pulumi.Output[str]:
        """
        This parameter represents the name of an Azure Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name2")

    @property
    @pulumi.getter(name="vnetCidr1s")
    def vnet_cidr1s(self) -> pulumi.Output[Sequence[str]]:
        """
        List of VNet CIDR of vnet_name_resource_group1.
        """
        return pulumi.get(self, "vnet_cidr1s")

    @property
    @pulumi.getter(name="vnetCidr2s")
    def vnet_cidr2s(self) -> pulumi.Output[Sequence[str]]:
        """
        List of VNet CIDR of vnet_name_resource_group2.
        """
        return pulumi.get(self, "vnet_cidr2s")

    @property
    @pulumi.getter(name="vnetNameResourceGroup1")
    def vnet_name_resource_group1(self) -> pulumi.Output[str]:
        """
        VNet-Name of Azure cloud.
        """
        return pulumi.get(self, "vnet_name_resource_group1")

    @property
    @pulumi.getter(name="vnetNameResourceGroup2")
    def vnet_name_resource_group2(self) -> pulumi.Output[str]:
        """
        VNet-Name of Azure cloud.
        """
        return pulumi.get(self, "vnet_name_resource_group2")

    @property
    @pulumi.getter(name="vnetReg1")
    def vnet_reg1(self) -> pulumi.Output[str]:
        """
        Region of Azure cloud.
        """
        return pulumi.get(self, "vnet_reg1")

    @property
    @pulumi.getter(name="vnetReg2")
    def vnet_reg2(self) -> pulumi.Output[str]:
        """
        Region of Azure cloud.
        """
        return pulumi.get(self, "vnet_reg2")

