# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixAwsTgwVpcAttachmentArgs', 'AviatrixAwsTgwVpcAttachment']

@pulumi.input_type
class AviatrixAwsTgwVpcAttachmentArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[str],
                 tgw_name: pulumi.Input[str],
                 vpc_account_name: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 customized_route_advertisement: Optional[pulumi.Input[str]] = None,
                 customized_routes: Optional[pulumi.Input[str]] = None,
                 disable_local_route_propagation: Optional[pulumi.Input[bool]] = None,
                 edge_attachment: Optional[pulumi.Input[str]] = None,
                 network_domain_name: Optional[pulumi.Input[str]] = None,
                 route_tables: Optional[pulumi.Input[str]] = None,
                 security_domain_name: Optional[pulumi.Input[str]] = None,
                 subnets: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AviatrixAwsTgwVpcAttachment resource.
        :param pulumi.Input[str] region: Region of cloud provider.
        :param pulumi.Input[str] tgw_name: Name of the AWS TGW.
        :param pulumi.Input[str] vpc_account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[str] vpc_id: This parameter represents the ID of the VPC.
        :param pulumi.Input[str] customized_route_advertisement: Advanced option. Customized route(s) to be advertised to other VPCs that are connected to the same TGW.
        :param pulumi.Input[str] customized_routes: Advanced option. Customized Spoke VPC Routes. It allows the admin to enter non-RFC1918 routes in the VPC route table
               targeting the TGW.
        :param pulumi.Input[bool] disable_local_route_propagation: Advanced option. If set to true, it disables automatic route propagation of this VPC to other VPCs within the same
               network domain.
        :param pulumi.Input[str] edge_attachment: Edge attachment ID. To allow access to the private IP of the MGMT interface of the Firewalls, set this attribute to
               enable Management Access From Onprem. This feature advertises the Firewalls private MGMT subnet to your Edge domain.
        :param pulumi.Input[str] network_domain_name: The name of the network domain.
        :param pulumi.Input[str] route_tables: Advanced option. Route tables separated by ',' to participate in TGW Orchestrator, i.e., learned routes will be
               propagated to these route tables.
        :param pulumi.Input[str] security_domain_name: The name of the security domain.
        :param pulumi.Input[str] subnets: Advanced option. VPC subnets separated by ',' to attach to the VPC. If left blank, Aviatrix Controller automatically
               selects a subnet representing each AZ for the VPC attachment.
        """
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "tgw_name", tgw_name)
        pulumi.set(__self__, "vpc_account_name", vpc_account_name)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if customized_route_advertisement is not None:
            pulumi.set(__self__, "customized_route_advertisement", customized_route_advertisement)
        if customized_routes is not None:
            pulumi.set(__self__, "customized_routes", customized_routes)
        if disable_local_route_propagation is not None:
            pulumi.set(__self__, "disable_local_route_propagation", disable_local_route_propagation)
        if edge_attachment is not None:
            pulumi.set(__self__, "edge_attachment", edge_attachment)
        if network_domain_name is not None:
            pulumi.set(__self__, "network_domain_name", network_domain_name)
        if route_tables is not None:
            pulumi.set(__self__, "route_tables", route_tables)
        if security_domain_name is not None:
            warnings.warn("""Please use network_domain_name instead.""", DeprecationWarning)
            pulumi.log.warn("""security_domain_name is deprecated: Please use network_domain_name instead.""")
        if security_domain_name is not None:
            pulumi.set(__self__, "security_domain_name", security_domain_name)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        Region of cloud provider.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="tgwName")
    def tgw_name(self) -> pulumi.Input[str]:
        """
        Name of the AWS TGW.
        """
        return pulumi.get(self, "tgw_name")

    @tgw_name.setter
    def tgw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "tgw_name", value)

    @property
    @pulumi.getter(name="vpcAccountName")
    def vpc_account_name(self) -> pulumi.Input[str]:
        """
        This parameter represents the name of a Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "vpc_account_name")

    @vpc_account_name.setter
    def vpc_account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_account_name", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        This parameter represents the ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="customizedRouteAdvertisement")
    def customized_route_advertisement(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. Customized route(s) to be advertised to other VPCs that are connected to the same TGW.
        """
        return pulumi.get(self, "customized_route_advertisement")

    @customized_route_advertisement.setter
    def customized_route_advertisement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customized_route_advertisement", value)

    @property
    @pulumi.getter(name="customizedRoutes")
    def customized_routes(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. Customized Spoke VPC Routes. It allows the admin to enter non-RFC1918 routes in the VPC route table
        targeting the TGW.
        """
        return pulumi.get(self, "customized_routes")

    @customized_routes.setter
    def customized_routes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customized_routes", value)

    @property
    @pulumi.getter(name="disableLocalRoutePropagation")
    def disable_local_route_propagation(self) -> Optional[pulumi.Input[bool]]:
        """
        Advanced option. If set to true, it disables automatic route propagation of this VPC to other VPCs within the same
        network domain.
        """
        return pulumi.get(self, "disable_local_route_propagation")

    @disable_local_route_propagation.setter
    def disable_local_route_propagation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_route_propagation", value)

    @property
    @pulumi.getter(name="edgeAttachment")
    def edge_attachment(self) -> Optional[pulumi.Input[str]]:
        """
        Edge attachment ID. To allow access to the private IP of the MGMT interface of the Firewalls, set this attribute to
        enable Management Access From Onprem. This feature advertises the Firewalls private MGMT subnet to your Edge domain.
        """
        return pulumi.get(self, "edge_attachment")

    @edge_attachment.setter
    def edge_attachment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edge_attachment", value)

    @property
    @pulumi.getter(name="networkDomainName")
    def network_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the network domain.
        """
        return pulumi.get(self, "network_domain_name")

    @network_domain_name.setter
    def network_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_domain_name", value)

    @property
    @pulumi.getter(name="routeTables")
    def route_tables(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. Route tables separated by ',' to participate in TGW Orchestrator, i.e., learned routes will be
        propagated to these route tables.
        """
        return pulumi.get(self, "route_tables")

    @route_tables.setter
    def route_tables(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "route_tables", value)

    @property
    @pulumi.getter(name="securityDomainName")
    def security_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the security domain.
        """
        return pulumi.get(self, "security_domain_name")

    @security_domain_name.setter
    def security_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_domain_name", value)

    @property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. VPC subnets separated by ',' to attach to the VPC. If left blank, Aviatrix Controller automatically
        selects a subnet representing each AZ for the VPC attachment.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnets", value)


@pulumi.input_type
class _AviatrixAwsTgwVpcAttachmentState:
    def __init__(__self__, *,
                 customized_route_advertisement: Optional[pulumi.Input[str]] = None,
                 customized_routes: Optional[pulumi.Input[str]] = None,
                 disable_local_route_propagation: Optional[pulumi.Input[bool]] = None,
                 edge_attachment: Optional[pulumi.Input[str]] = None,
                 network_domain_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 route_tables: Optional[pulumi.Input[str]] = None,
                 security_domain_name: Optional[pulumi.Input[str]] = None,
                 subnets: Optional[pulumi.Input[str]] = None,
                 tgw_name: Optional[pulumi.Input[str]] = None,
                 vpc_account_name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixAwsTgwVpcAttachment resources.
        :param pulumi.Input[str] customized_route_advertisement: Advanced option. Customized route(s) to be advertised to other VPCs that are connected to the same TGW.
        :param pulumi.Input[str] customized_routes: Advanced option. Customized Spoke VPC Routes. It allows the admin to enter non-RFC1918 routes in the VPC route table
               targeting the TGW.
        :param pulumi.Input[bool] disable_local_route_propagation: Advanced option. If set to true, it disables automatic route propagation of this VPC to other VPCs within the same
               network domain.
        :param pulumi.Input[str] edge_attachment: Edge attachment ID. To allow access to the private IP of the MGMT interface of the Firewalls, set this attribute to
               enable Management Access From Onprem. This feature advertises the Firewalls private MGMT subnet to your Edge domain.
        :param pulumi.Input[str] network_domain_name: The name of the network domain.
        :param pulumi.Input[str] region: Region of cloud provider.
        :param pulumi.Input[str] route_tables: Advanced option. Route tables separated by ',' to participate in TGW Orchestrator, i.e., learned routes will be
               propagated to these route tables.
        :param pulumi.Input[str] security_domain_name: The name of the security domain.
        :param pulumi.Input[str] subnets: Advanced option. VPC subnets separated by ',' to attach to the VPC. If left blank, Aviatrix Controller automatically
               selects a subnet representing each AZ for the VPC attachment.
        :param pulumi.Input[str] tgw_name: Name of the AWS TGW.
        :param pulumi.Input[str] vpc_account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[str] vpc_id: This parameter represents the ID of the VPC.
        """
        if customized_route_advertisement is not None:
            pulumi.set(__self__, "customized_route_advertisement", customized_route_advertisement)
        if customized_routes is not None:
            pulumi.set(__self__, "customized_routes", customized_routes)
        if disable_local_route_propagation is not None:
            pulumi.set(__self__, "disable_local_route_propagation", disable_local_route_propagation)
        if edge_attachment is not None:
            pulumi.set(__self__, "edge_attachment", edge_attachment)
        if network_domain_name is not None:
            pulumi.set(__self__, "network_domain_name", network_domain_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if route_tables is not None:
            pulumi.set(__self__, "route_tables", route_tables)
        if security_domain_name is not None:
            warnings.warn("""Please use network_domain_name instead.""", DeprecationWarning)
            pulumi.log.warn("""security_domain_name is deprecated: Please use network_domain_name instead.""")
        if security_domain_name is not None:
            pulumi.set(__self__, "security_domain_name", security_domain_name)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)
        if tgw_name is not None:
            pulumi.set(__self__, "tgw_name", tgw_name)
        if vpc_account_name is not None:
            pulumi.set(__self__, "vpc_account_name", vpc_account_name)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="customizedRouteAdvertisement")
    def customized_route_advertisement(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. Customized route(s) to be advertised to other VPCs that are connected to the same TGW.
        """
        return pulumi.get(self, "customized_route_advertisement")

    @customized_route_advertisement.setter
    def customized_route_advertisement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customized_route_advertisement", value)

    @property
    @pulumi.getter(name="customizedRoutes")
    def customized_routes(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. Customized Spoke VPC Routes. It allows the admin to enter non-RFC1918 routes in the VPC route table
        targeting the TGW.
        """
        return pulumi.get(self, "customized_routes")

    @customized_routes.setter
    def customized_routes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customized_routes", value)

    @property
    @pulumi.getter(name="disableLocalRoutePropagation")
    def disable_local_route_propagation(self) -> Optional[pulumi.Input[bool]]:
        """
        Advanced option. If set to true, it disables automatic route propagation of this VPC to other VPCs within the same
        network domain.
        """
        return pulumi.get(self, "disable_local_route_propagation")

    @disable_local_route_propagation.setter
    def disable_local_route_propagation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_route_propagation", value)

    @property
    @pulumi.getter(name="edgeAttachment")
    def edge_attachment(self) -> Optional[pulumi.Input[str]]:
        """
        Edge attachment ID. To allow access to the private IP of the MGMT interface of the Firewalls, set this attribute to
        enable Management Access From Onprem. This feature advertises the Firewalls private MGMT subnet to your Edge domain.
        """
        return pulumi.get(self, "edge_attachment")

    @edge_attachment.setter
    def edge_attachment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edge_attachment", value)

    @property
    @pulumi.getter(name="networkDomainName")
    def network_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the network domain.
        """
        return pulumi.get(self, "network_domain_name")

    @network_domain_name.setter
    def network_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_domain_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region of cloud provider.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="routeTables")
    def route_tables(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. Route tables separated by ',' to participate in TGW Orchestrator, i.e., learned routes will be
        propagated to these route tables.
        """
        return pulumi.get(self, "route_tables")

    @route_tables.setter
    def route_tables(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "route_tables", value)

    @property
    @pulumi.getter(name="securityDomainName")
    def security_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the security domain.
        """
        return pulumi.get(self, "security_domain_name")

    @security_domain_name.setter
    def security_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_domain_name", value)

    @property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. VPC subnets separated by ',' to attach to the VPC. If left blank, Aviatrix Controller automatically
        selects a subnet representing each AZ for the VPC attachment.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnets", value)

    @property
    @pulumi.getter(name="tgwName")
    def tgw_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the AWS TGW.
        """
        return pulumi.get(self, "tgw_name")

    @tgw_name.setter
    def tgw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tgw_name", value)

    @property
    @pulumi.getter(name="vpcAccountName")
    def vpc_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter represents the name of a Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "vpc_account_name")

    @vpc_account_name.setter
    def vpc_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_account_name", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter represents the ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class AviatrixAwsTgwVpcAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customized_route_advertisement: Optional[pulumi.Input[str]] = None,
                 customized_routes: Optional[pulumi.Input[str]] = None,
                 disable_local_route_propagation: Optional[pulumi.Input[bool]] = None,
                 edge_attachment: Optional[pulumi.Input[str]] = None,
                 network_domain_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 route_tables: Optional[pulumi.Input[str]] = None,
                 security_domain_name: Optional[pulumi.Input[str]] = None,
                 subnets: Optional[pulumi.Input[str]] = None,
                 tgw_name: Optional[pulumi.Input[str]] = None,
                 vpc_account_name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AviatrixAwsTgwVpcAttachment resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] customized_route_advertisement: Advanced option. Customized route(s) to be advertised to other VPCs that are connected to the same TGW.
        :param pulumi.Input[str] customized_routes: Advanced option. Customized Spoke VPC Routes. It allows the admin to enter non-RFC1918 routes in the VPC route table
               targeting the TGW.
        :param pulumi.Input[bool] disable_local_route_propagation: Advanced option. If set to true, it disables automatic route propagation of this VPC to other VPCs within the same
               network domain.
        :param pulumi.Input[str] edge_attachment: Edge attachment ID. To allow access to the private IP of the MGMT interface of the Firewalls, set this attribute to
               enable Management Access From Onprem. This feature advertises the Firewalls private MGMT subnet to your Edge domain.
        :param pulumi.Input[str] network_domain_name: The name of the network domain.
        :param pulumi.Input[str] region: Region of cloud provider.
        :param pulumi.Input[str] route_tables: Advanced option. Route tables separated by ',' to participate in TGW Orchestrator, i.e., learned routes will be
               propagated to these route tables.
        :param pulumi.Input[str] security_domain_name: The name of the security domain.
        :param pulumi.Input[str] subnets: Advanced option. VPC subnets separated by ',' to attach to the VPC. If left blank, Aviatrix Controller automatically
               selects a subnet representing each AZ for the VPC attachment.
        :param pulumi.Input[str] tgw_name: Name of the AWS TGW.
        :param pulumi.Input[str] vpc_account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[str] vpc_id: This parameter represents the ID of the VPC.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixAwsTgwVpcAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixAwsTgwVpcAttachment resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixAwsTgwVpcAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixAwsTgwVpcAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 customized_route_advertisement: Optional[pulumi.Input[str]] = None,
                 customized_routes: Optional[pulumi.Input[str]] = None,
                 disable_local_route_propagation: Optional[pulumi.Input[bool]] = None,
                 edge_attachment: Optional[pulumi.Input[str]] = None,
                 network_domain_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 route_tables: Optional[pulumi.Input[str]] = None,
                 security_domain_name: Optional[pulumi.Input[str]] = None,
                 subnets: Optional[pulumi.Input[str]] = None,
                 tgw_name: Optional[pulumi.Input[str]] = None,
                 vpc_account_name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixAwsTgwVpcAttachmentArgs.__new__(AviatrixAwsTgwVpcAttachmentArgs)

            __props__.__dict__["customized_route_advertisement"] = customized_route_advertisement
            __props__.__dict__["customized_routes"] = customized_routes
            __props__.__dict__["disable_local_route_propagation"] = disable_local_route_propagation
            __props__.__dict__["edge_attachment"] = edge_attachment
            __props__.__dict__["network_domain_name"] = network_domain_name
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["route_tables"] = route_tables
            if security_domain_name is not None and not opts.urn:
                warnings.warn("""Please use network_domain_name instead.""", DeprecationWarning)
                pulumi.log.warn("""security_domain_name is deprecated: Please use network_domain_name instead.""")
            __props__.__dict__["security_domain_name"] = security_domain_name
            __props__.__dict__["subnets"] = subnets
            if tgw_name is None and not opts.urn:
                raise TypeError("Missing required property 'tgw_name'")
            __props__.__dict__["tgw_name"] = tgw_name
            if vpc_account_name is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_account_name'")
            __props__.__dict__["vpc_account_name"] = vpc_account_name
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
        super(AviatrixAwsTgwVpcAttachment, __self__).__init__(
            'aviatrix:index/aviatrixAwsTgwVpcAttachment:AviatrixAwsTgwVpcAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            customized_route_advertisement: Optional[pulumi.Input[str]] = None,
            customized_routes: Optional[pulumi.Input[str]] = None,
            disable_local_route_propagation: Optional[pulumi.Input[bool]] = None,
            edge_attachment: Optional[pulumi.Input[str]] = None,
            network_domain_name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            route_tables: Optional[pulumi.Input[str]] = None,
            security_domain_name: Optional[pulumi.Input[str]] = None,
            subnets: Optional[pulumi.Input[str]] = None,
            tgw_name: Optional[pulumi.Input[str]] = None,
            vpc_account_name: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'AviatrixAwsTgwVpcAttachment':
        """
        Get an existing AviatrixAwsTgwVpcAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] customized_route_advertisement: Advanced option. Customized route(s) to be advertised to other VPCs that are connected to the same TGW.
        :param pulumi.Input[str] customized_routes: Advanced option. Customized Spoke VPC Routes. It allows the admin to enter non-RFC1918 routes in the VPC route table
               targeting the TGW.
        :param pulumi.Input[bool] disable_local_route_propagation: Advanced option. If set to true, it disables automatic route propagation of this VPC to other VPCs within the same
               network domain.
        :param pulumi.Input[str] edge_attachment: Edge attachment ID. To allow access to the private IP of the MGMT interface of the Firewalls, set this attribute to
               enable Management Access From Onprem. This feature advertises the Firewalls private MGMT subnet to your Edge domain.
        :param pulumi.Input[str] network_domain_name: The name of the network domain.
        :param pulumi.Input[str] region: Region of cloud provider.
        :param pulumi.Input[str] route_tables: Advanced option. Route tables separated by ',' to participate in TGW Orchestrator, i.e., learned routes will be
               propagated to these route tables.
        :param pulumi.Input[str] security_domain_name: The name of the security domain.
        :param pulumi.Input[str] subnets: Advanced option. VPC subnets separated by ',' to attach to the VPC. If left blank, Aviatrix Controller automatically
               selects a subnet representing each AZ for the VPC attachment.
        :param pulumi.Input[str] tgw_name: Name of the AWS TGW.
        :param pulumi.Input[str] vpc_account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[str] vpc_id: This parameter represents the ID of the VPC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixAwsTgwVpcAttachmentState.__new__(_AviatrixAwsTgwVpcAttachmentState)

        __props__.__dict__["customized_route_advertisement"] = customized_route_advertisement
        __props__.__dict__["customized_routes"] = customized_routes
        __props__.__dict__["disable_local_route_propagation"] = disable_local_route_propagation
        __props__.__dict__["edge_attachment"] = edge_attachment
        __props__.__dict__["network_domain_name"] = network_domain_name
        __props__.__dict__["region"] = region
        __props__.__dict__["route_tables"] = route_tables
        __props__.__dict__["security_domain_name"] = security_domain_name
        __props__.__dict__["subnets"] = subnets
        __props__.__dict__["tgw_name"] = tgw_name
        __props__.__dict__["vpc_account_name"] = vpc_account_name
        __props__.__dict__["vpc_id"] = vpc_id
        return AviatrixAwsTgwVpcAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="customizedRouteAdvertisement")
    def customized_route_advertisement(self) -> pulumi.Output[Optional[str]]:
        """
        Advanced option. Customized route(s) to be advertised to other VPCs that are connected to the same TGW.
        """
        return pulumi.get(self, "customized_route_advertisement")

    @property
    @pulumi.getter(name="customizedRoutes")
    def customized_routes(self) -> pulumi.Output[Optional[str]]:
        """
        Advanced option. Customized Spoke VPC Routes. It allows the admin to enter non-RFC1918 routes in the VPC route table
        targeting the TGW.
        """
        return pulumi.get(self, "customized_routes")

    @property
    @pulumi.getter(name="disableLocalRoutePropagation")
    def disable_local_route_propagation(self) -> pulumi.Output[Optional[bool]]:
        """
        Advanced option. If set to true, it disables automatic route propagation of this VPC to other VPCs within the same
        network domain.
        """
        return pulumi.get(self, "disable_local_route_propagation")

    @property
    @pulumi.getter(name="edgeAttachment")
    def edge_attachment(self) -> pulumi.Output[Optional[str]]:
        """
        Edge attachment ID. To allow access to the private IP of the MGMT interface of the Firewalls, set this attribute to
        enable Management Access From Onprem. This feature advertises the Firewalls private MGMT subnet to your Edge domain.
        """
        return pulumi.get(self, "edge_attachment")

    @property
    @pulumi.getter(name="networkDomainName")
    def network_domain_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the network domain.
        """
        return pulumi.get(self, "network_domain_name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Region of cloud provider.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="routeTables")
    def route_tables(self) -> pulumi.Output[str]:
        """
        Advanced option. Route tables separated by ',' to participate in TGW Orchestrator, i.e., learned routes will be
        propagated to these route tables.
        """
        return pulumi.get(self, "route_tables")

    @property
    @pulumi.getter(name="securityDomainName")
    def security_domain_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the security domain.
        """
        return pulumi.get(self, "security_domain_name")

    @property
    @pulumi.getter
    def subnets(self) -> pulumi.Output[str]:
        """
        Advanced option. VPC subnets separated by ',' to attach to the VPC. If left blank, Aviatrix Controller automatically
        selects a subnet representing each AZ for the VPC attachment.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter(name="tgwName")
    def tgw_name(self) -> pulumi.Output[str]:
        """
        Name of the AWS TGW.
        """
        return pulumi.get(self, "tgw_name")

    @property
    @pulumi.getter(name="vpcAccountName")
    def vpc_account_name(self) -> pulumi.Output[str]:
        """
        This parameter represents the name of a Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "vpc_account_name")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        This parameter represents the ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

