# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixAwsTgwNetworkDomainArgs', 'AviatrixAwsTgwNetworkDomain']

@pulumi.input_type
class AviatrixAwsTgwNetworkDomainArgs:
    def __init__(__self__, *,
                 tgw_name: pulumi.Input[str],
                 aviatrix_firewall: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 native_egress: Optional[pulumi.Input[bool]] = None,
                 native_firewall: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a AviatrixAwsTgwNetworkDomain resource.
        :param pulumi.Input[str] tgw_name: AWS TGW name.
        :param pulumi.Input[bool] aviatrix_firewall: Set to true if the network domain is an aviatrix firewall domain.
        :param pulumi.Input[str] name: Network domain name.
        :param pulumi.Input[bool] native_egress: Set to true if the network domain is a native egress domain.
        :param pulumi.Input[bool] native_firewall: Set to true if the network domain is a native firewall domain.
        """
        pulumi.set(__self__, "tgw_name", tgw_name)
        if aviatrix_firewall is not None:
            pulumi.set(__self__, "aviatrix_firewall", aviatrix_firewall)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if native_egress is not None:
            pulumi.set(__self__, "native_egress", native_egress)
        if native_firewall is not None:
            pulumi.set(__self__, "native_firewall", native_firewall)

    @property
    @pulumi.getter(name="tgwName")
    def tgw_name(self) -> pulumi.Input[str]:
        """
        AWS TGW name.
        """
        return pulumi.get(self, "tgw_name")

    @tgw_name.setter
    def tgw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "tgw_name", value)

    @property
    @pulumi.getter(name="aviatrixFirewall")
    def aviatrix_firewall(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if the network domain is an aviatrix firewall domain.
        """
        return pulumi.get(self, "aviatrix_firewall")

    @aviatrix_firewall.setter
    def aviatrix_firewall(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "aviatrix_firewall", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Network domain name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nativeEgress")
    def native_egress(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if the network domain is a native egress domain.
        """
        return pulumi.get(self, "native_egress")

    @native_egress.setter
    def native_egress(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "native_egress", value)

    @property
    @pulumi.getter(name="nativeFirewall")
    def native_firewall(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if the network domain is a native firewall domain.
        """
        return pulumi.get(self, "native_firewall")

    @native_firewall.setter
    def native_firewall(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "native_firewall", value)


@pulumi.input_type
class _AviatrixAwsTgwNetworkDomainState:
    def __init__(__self__, *,
                 aviatrix_firewall: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 native_egress: Optional[pulumi.Input[bool]] = None,
                 native_firewall: Optional[pulumi.Input[bool]] = None,
                 tgw_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixAwsTgwNetworkDomain resources.
        :param pulumi.Input[bool] aviatrix_firewall: Set to true if the network domain is an aviatrix firewall domain.
        :param pulumi.Input[str] name: Network domain name.
        :param pulumi.Input[bool] native_egress: Set to true if the network domain is a native egress domain.
        :param pulumi.Input[bool] native_firewall: Set to true if the network domain is a native firewall domain.
        :param pulumi.Input[str] tgw_name: AWS TGW name.
        """
        if aviatrix_firewall is not None:
            pulumi.set(__self__, "aviatrix_firewall", aviatrix_firewall)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if native_egress is not None:
            pulumi.set(__self__, "native_egress", native_egress)
        if native_firewall is not None:
            pulumi.set(__self__, "native_firewall", native_firewall)
        if tgw_name is not None:
            pulumi.set(__self__, "tgw_name", tgw_name)

    @property
    @pulumi.getter(name="aviatrixFirewall")
    def aviatrix_firewall(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if the network domain is an aviatrix firewall domain.
        """
        return pulumi.get(self, "aviatrix_firewall")

    @aviatrix_firewall.setter
    def aviatrix_firewall(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "aviatrix_firewall", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Network domain name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nativeEgress")
    def native_egress(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if the network domain is a native egress domain.
        """
        return pulumi.get(self, "native_egress")

    @native_egress.setter
    def native_egress(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "native_egress", value)

    @property
    @pulumi.getter(name="nativeFirewall")
    def native_firewall(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if the network domain is a native firewall domain.
        """
        return pulumi.get(self, "native_firewall")

    @native_firewall.setter
    def native_firewall(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "native_firewall", value)

    @property
    @pulumi.getter(name="tgwName")
    def tgw_name(self) -> Optional[pulumi.Input[str]]:
        """
        AWS TGW name.
        """
        return pulumi.get(self, "tgw_name")

    @tgw_name.setter
    def tgw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tgw_name", value)


class AviatrixAwsTgwNetworkDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aviatrix_firewall: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 native_egress: Optional[pulumi.Input[bool]] = None,
                 native_firewall: Optional[pulumi.Input[bool]] = None,
                 tgw_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AviatrixAwsTgwNetworkDomain resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] aviatrix_firewall: Set to true if the network domain is an aviatrix firewall domain.
        :param pulumi.Input[str] name: Network domain name.
        :param pulumi.Input[bool] native_egress: Set to true if the network domain is a native egress domain.
        :param pulumi.Input[bool] native_firewall: Set to true if the network domain is a native firewall domain.
        :param pulumi.Input[str] tgw_name: AWS TGW name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixAwsTgwNetworkDomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixAwsTgwNetworkDomain resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixAwsTgwNetworkDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixAwsTgwNetworkDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aviatrix_firewall: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 native_egress: Optional[pulumi.Input[bool]] = None,
                 native_firewall: Optional[pulumi.Input[bool]] = None,
                 tgw_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixAwsTgwNetworkDomainArgs.__new__(AviatrixAwsTgwNetworkDomainArgs)

            __props__.__dict__["aviatrix_firewall"] = aviatrix_firewall
            __props__.__dict__["name"] = name
            __props__.__dict__["native_egress"] = native_egress
            __props__.__dict__["native_firewall"] = native_firewall
            if tgw_name is None and not opts.urn:
                raise TypeError("Missing required property 'tgw_name'")
            __props__.__dict__["tgw_name"] = tgw_name
        super(AviatrixAwsTgwNetworkDomain, __self__).__init__(
            'aviatrix:index/aviatrixAwsTgwNetworkDomain:AviatrixAwsTgwNetworkDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aviatrix_firewall: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            native_egress: Optional[pulumi.Input[bool]] = None,
            native_firewall: Optional[pulumi.Input[bool]] = None,
            tgw_name: Optional[pulumi.Input[str]] = None) -> 'AviatrixAwsTgwNetworkDomain':
        """
        Get an existing AviatrixAwsTgwNetworkDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] aviatrix_firewall: Set to true if the network domain is an aviatrix firewall domain.
        :param pulumi.Input[str] name: Network domain name.
        :param pulumi.Input[bool] native_egress: Set to true if the network domain is a native egress domain.
        :param pulumi.Input[bool] native_firewall: Set to true if the network domain is a native firewall domain.
        :param pulumi.Input[str] tgw_name: AWS TGW name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixAwsTgwNetworkDomainState.__new__(_AviatrixAwsTgwNetworkDomainState)

        __props__.__dict__["aviatrix_firewall"] = aviatrix_firewall
        __props__.__dict__["name"] = name
        __props__.__dict__["native_egress"] = native_egress
        __props__.__dict__["native_firewall"] = native_firewall
        __props__.__dict__["tgw_name"] = tgw_name
        return AviatrixAwsTgwNetworkDomain(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aviatrixFirewall")
    def aviatrix_firewall(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to true if the network domain is an aviatrix firewall domain.
        """
        return pulumi.get(self, "aviatrix_firewall")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Network domain name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nativeEgress")
    def native_egress(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to true if the network domain is a native egress domain.
        """
        return pulumi.get(self, "native_egress")

    @property
    @pulumi.getter(name="nativeFirewall")
    def native_firewall(self) -> pulumi.Output[Optional[bool]]:
        """
        Set to true if the network domain is a native firewall domain.
        """
        return pulumi.get(self, "native_firewall")

    @property
    @pulumi.getter(name="tgwName")
    def tgw_name(self) -> pulumi.Output[str]:
        """
        AWS TGW name.
        """
        return pulumi.get(self, "tgw_name")

