# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixAwsTgwDirectconnectArgs', 'AviatrixAwsTgwDirectconnect']

@pulumi.input_type
class AviatrixAwsTgwDirectconnectArgs:
    def __init__(__self__, *,
                 allowed_prefix: pulumi.Input[str],
                 directconnect_account_name: pulumi.Input[str],
                 dx_gateway_id: pulumi.Input[str],
                 tgw_name: pulumi.Input[str],
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 network_domain_name: Optional[pulumi.Input[str]] = None,
                 security_domain_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AviatrixAwsTgwDirectconnect resource.
        :param pulumi.Input[str] allowed_prefix: Public IP address. Example: '40.0.0.0'.
        :param pulumi.Input[str] directconnect_account_name: This parameter represents the name of an Account in Aviatrix controller.
        :param pulumi.Input[str] dx_gateway_id: This parameter represents the name of a Direct Connect Gateway ID.
        :param pulumi.Input[str] tgw_name: This parameter represents the name of an AWS TGW.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Switch to enable/disable encrypted transit approval for direct connection. Valid values: true, false.
        :param pulumi.Input[str] network_domain_name: The name of an Aviatrix network domain, to which the direct connect gateway will be attached.
        :param pulumi.Input[str] security_domain_name: The name of an Aviatrix security domain, to which the direct connect gateway will be attached.
        """
        pulumi.set(__self__, "allowed_prefix", allowed_prefix)
        pulumi.set(__self__, "directconnect_account_name", directconnect_account_name)
        pulumi.set(__self__, "dx_gateway_id", dx_gateway_id)
        pulumi.set(__self__, "tgw_name", tgw_name)
        if enable_learned_cidrs_approval is not None:
            pulumi.set(__self__, "enable_learned_cidrs_approval", enable_learned_cidrs_approval)
        if network_domain_name is not None:
            pulumi.set(__self__, "network_domain_name", network_domain_name)
        if security_domain_name is not None:
            warnings.warn("""Please use network_domain_name instead.""", DeprecationWarning)
            pulumi.log.warn("""security_domain_name is deprecated: Please use network_domain_name instead.""")
        if security_domain_name is not None:
            pulumi.set(__self__, "security_domain_name", security_domain_name)

    @property
    @pulumi.getter(name="allowedPrefix")
    def allowed_prefix(self) -> pulumi.Input[str]:
        """
        Public IP address. Example: '40.0.0.0'.
        """
        return pulumi.get(self, "allowed_prefix")

    @allowed_prefix.setter
    def allowed_prefix(self, value: pulumi.Input[str]):
        pulumi.set(self, "allowed_prefix", value)

    @property
    @pulumi.getter(name="directconnectAccountName")
    def directconnect_account_name(self) -> pulumi.Input[str]:
        """
        This parameter represents the name of an Account in Aviatrix controller.
        """
        return pulumi.get(self, "directconnect_account_name")

    @directconnect_account_name.setter
    def directconnect_account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "directconnect_account_name", value)

    @property
    @pulumi.getter(name="dxGatewayId")
    def dx_gateway_id(self) -> pulumi.Input[str]:
        """
        This parameter represents the name of a Direct Connect Gateway ID.
        """
        return pulumi.get(self, "dx_gateway_id")

    @dx_gateway_id.setter
    def dx_gateway_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "dx_gateway_id", value)

    @property
    @pulumi.getter(name="tgwName")
    def tgw_name(self) -> pulumi.Input[str]:
        """
        This parameter represents the name of an AWS TGW.
        """
        return pulumi.get(self, "tgw_name")

    @tgw_name.setter
    def tgw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "tgw_name", value)

    @property
    @pulumi.getter(name="enableLearnedCidrsApproval")
    def enable_learned_cidrs_approval(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable/disable encrypted transit approval for direct connection. Valid values: true, false.
        """
        return pulumi.get(self, "enable_learned_cidrs_approval")

    @enable_learned_cidrs_approval.setter
    def enable_learned_cidrs_approval(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_learned_cidrs_approval", value)

    @property
    @pulumi.getter(name="networkDomainName")
    def network_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an Aviatrix network domain, to which the direct connect gateway will be attached.
        """
        return pulumi.get(self, "network_domain_name")

    @network_domain_name.setter
    def network_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_domain_name", value)

    @property
    @pulumi.getter(name="securityDomainName")
    def security_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an Aviatrix security domain, to which the direct connect gateway will be attached.
        """
        return pulumi.get(self, "security_domain_name")

    @security_domain_name.setter
    def security_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_domain_name", value)


@pulumi.input_type
class _AviatrixAwsTgwDirectconnectState:
    def __init__(__self__, *,
                 allowed_prefix: Optional[pulumi.Input[str]] = None,
                 directconnect_account_name: Optional[pulumi.Input[str]] = None,
                 dx_gateway_id: Optional[pulumi.Input[str]] = None,
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 network_domain_name: Optional[pulumi.Input[str]] = None,
                 security_domain_name: Optional[pulumi.Input[str]] = None,
                 tgw_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixAwsTgwDirectconnect resources.
        :param pulumi.Input[str] allowed_prefix: Public IP address. Example: '40.0.0.0'.
        :param pulumi.Input[str] directconnect_account_name: This parameter represents the name of an Account in Aviatrix controller.
        :param pulumi.Input[str] dx_gateway_id: This parameter represents the name of a Direct Connect Gateway ID.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Switch to enable/disable encrypted transit approval for direct connection. Valid values: true, false.
        :param pulumi.Input[str] network_domain_name: The name of an Aviatrix network domain, to which the direct connect gateway will be attached.
        :param pulumi.Input[str] security_domain_name: The name of an Aviatrix security domain, to which the direct connect gateway will be attached.
        :param pulumi.Input[str] tgw_name: This parameter represents the name of an AWS TGW.
        """
        if allowed_prefix is not None:
            pulumi.set(__self__, "allowed_prefix", allowed_prefix)
        if directconnect_account_name is not None:
            pulumi.set(__self__, "directconnect_account_name", directconnect_account_name)
        if dx_gateway_id is not None:
            pulumi.set(__self__, "dx_gateway_id", dx_gateway_id)
        if enable_learned_cidrs_approval is not None:
            pulumi.set(__self__, "enable_learned_cidrs_approval", enable_learned_cidrs_approval)
        if network_domain_name is not None:
            pulumi.set(__self__, "network_domain_name", network_domain_name)
        if security_domain_name is not None:
            warnings.warn("""Please use network_domain_name instead.""", DeprecationWarning)
            pulumi.log.warn("""security_domain_name is deprecated: Please use network_domain_name instead.""")
        if security_domain_name is not None:
            pulumi.set(__self__, "security_domain_name", security_domain_name)
        if tgw_name is not None:
            pulumi.set(__self__, "tgw_name", tgw_name)

    @property
    @pulumi.getter(name="allowedPrefix")
    def allowed_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Public IP address. Example: '40.0.0.0'.
        """
        return pulumi.get(self, "allowed_prefix")

    @allowed_prefix.setter
    def allowed_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_prefix", value)

    @property
    @pulumi.getter(name="directconnectAccountName")
    def directconnect_account_name(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter represents the name of an Account in Aviatrix controller.
        """
        return pulumi.get(self, "directconnect_account_name")

    @directconnect_account_name.setter
    def directconnect_account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "directconnect_account_name", value)

    @property
    @pulumi.getter(name="dxGatewayId")
    def dx_gateway_id(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter represents the name of a Direct Connect Gateway ID.
        """
        return pulumi.get(self, "dx_gateway_id")

    @dx_gateway_id.setter
    def dx_gateway_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dx_gateway_id", value)

    @property
    @pulumi.getter(name="enableLearnedCidrsApproval")
    def enable_learned_cidrs_approval(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to enable/disable encrypted transit approval for direct connection. Valid values: true, false.
        """
        return pulumi.get(self, "enable_learned_cidrs_approval")

    @enable_learned_cidrs_approval.setter
    def enable_learned_cidrs_approval(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_learned_cidrs_approval", value)

    @property
    @pulumi.getter(name="networkDomainName")
    def network_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an Aviatrix network domain, to which the direct connect gateway will be attached.
        """
        return pulumi.get(self, "network_domain_name")

    @network_domain_name.setter
    def network_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_domain_name", value)

    @property
    @pulumi.getter(name="securityDomainName")
    def security_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of an Aviatrix security domain, to which the direct connect gateway will be attached.
        """
        return pulumi.get(self, "security_domain_name")

    @security_domain_name.setter
    def security_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_domain_name", value)

    @property
    @pulumi.getter(name="tgwName")
    def tgw_name(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter represents the name of an AWS TGW.
        """
        return pulumi.get(self, "tgw_name")

    @tgw_name.setter
    def tgw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tgw_name", value)


class AviatrixAwsTgwDirectconnect(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_prefix: Optional[pulumi.Input[str]] = None,
                 directconnect_account_name: Optional[pulumi.Input[str]] = None,
                 dx_gateway_id: Optional[pulumi.Input[str]] = None,
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 network_domain_name: Optional[pulumi.Input[str]] = None,
                 security_domain_name: Optional[pulumi.Input[str]] = None,
                 tgw_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AviatrixAwsTgwDirectconnect resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] allowed_prefix: Public IP address. Example: '40.0.0.0'.
        :param pulumi.Input[str] directconnect_account_name: This parameter represents the name of an Account in Aviatrix controller.
        :param pulumi.Input[str] dx_gateway_id: This parameter represents the name of a Direct Connect Gateway ID.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Switch to enable/disable encrypted transit approval for direct connection. Valid values: true, false.
        :param pulumi.Input[str] network_domain_name: The name of an Aviatrix network domain, to which the direct connect gateway will be attached.
        :param pulumi.Input[str] security_domain_name: The name of an Aviatrix security domain, to which the direct connect gateway will be attached.
        :param pulumi.Input[str] tgw_name: This parameter represents the name of an AWS TGW.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixAwsTgwDirectconnectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixAwsTgwDirectconnect resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixAwsTgwDirectconnectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixAwsTgwDirectconnectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_prefix: Optional[pulumi.Input[str]] = None,
                 directconnect_account_name: Optional[pulumi.Input[str]] = None,
                 dx_gateway_id: Optional[pulumi.Input[str]] = None,
                 enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
                 network_domain_name: Optional[pulumi.Input[str]] = None,
                 security_domain_name: Optional[pulumi.Input[str]] = None,
                 tgw_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixAwsTgwDirectconnectArgs.__new__(AviatrixAwsTgwDirectconnectArgs)

            if allowed_prefix is None and not opts.urn:
                raise TypeError("Missing required property 'allowed_prefix'")
            __props__.__dict__["allowed_prefix"] = allowed_prefix
            if directconnect_account_name is None and not opts.urn:
                raise TypeError("Missing required property 'directconnect_account_name'")
            __props__.__dict__["directconnect_account_name"] = directconnect_account_name
            if dx_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'dx_gateway_id'")
            __props__.__dict__["dx_gateway_id"] = dx_gateway_id
            __props__.__dict__["enable_learned_cidrs_approval"] = enable_learned_cidrs_approval
            __props__.__dict__["network_domain_name"] = network_domain_name
            if security_domain_name is not None and not opts.urn:
                warnings.warn("""Please use network_domain_name instead.""", DeprecationWarning)
                pulumi.log.warn("""security_domain_name is deprecated: Please use network_domain_name instead.""")
            __props__.__dict__["security_domain_name"] = security_domain_name
            if tgw_name is None and not opts.urn:
                raise TypeError("Missing required property 'tgw_name'")
            __props__.__dict__["tgw_name"] = tgw_name
        super(AviatrixAwsTgwDirectconnect, __self__).__init__(
            'aviatrix:index/aviatrixAwsTgwDirectconnect:AviatrixAwsTgwDirectconnect',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_prefix: Optional[pulumi.Input[str]] = None,
            directconnect_account_name: Optional[pulumi.Input[str]] = None,
            dx_gateway_id: Optional[pulumi.Input[str]] = None,
            enable_learned_cidrs_approval: Optional[pulumi.Input[bool]] = None,
            network_domain_name: Optional[pulumi.Input[str]] = None,
            security_domain_name: Optional[pulumi.Input[str]] = None,
            tgw_name: Optional[pulumi.Input[str]] = None) -> 'AviatrixAwsTgwDirectconnect':
        """
        Get an existing AviatrixAwsTgwDirectconnect resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] allowed_prefix: Public IP address. Example: '40.0.0.0'.
        :param pulumi.Input[str] directconnect_account_name: This parameter represents the name of an Account in Aviatrix controller.
        :param pulumi.Input[str] dx_gateway_id: This parameter represents the name of a Direct Connect Gateway ID.
        :param pulumi.Input[bool] enable_learned_cidrs_approval: Switch to enable/disable encrypted transit approval for direct connection. Valid values: true, false.
        :param pulumi.Input[str] network_domain_name: The name of an Aviatrix network domain, to which the direct connect gateway will be attached.
        :param pulumi.Input[str] security_domain_name: The name of an Aviatrix security domain, to which the direct connect gateway will be attached.
        :param pulumi.Input[str] tgw_name: This parameter represents the name of an AWS TGW.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixAwsTgwDirectconnectState.__new__(_AviatrixAwsTgwDirectconnectState)

        __props__.__dict__["allowed_prefix"] = allowed_prefix
        __props__.__dict__["directconnect_account_name"] = directconnect_account_name
        __props__.__dict__["dx_gateway_id"] = dx_gateway_id
        __props__.__dict__["enable_learned_cidrs_approval"] = enable_learned_cidrs_approval
        __props__.__dict__["network_domain_name"] = network_domain_name
        __props__.__dict__["security_domain_name"] = security_domain_name
        __props__.__dict__["tgw_name"] = tgw_name
        return AviatrixAwsTgwDirectconnect(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedPrefix")
    def allowed_prefix(self) -> pulumi.Output[str]:
        """
        Public IP address. Example: '40.0.0.0'.
        """
        return pulumi.get(self, "allowed_prefix")

    @property
    @pulumi.getter(name="directconnectAccountName")
    def directconnect_account_name(self) -> pulumi.Output[str]:
        """
        This parameter represents the name of an Account in Aviatrix controller.
        """
        return pulumi.get(self, "directconnect_account_name")

    @property
    @pulumi.getter(name="dxGatewayId")
    def dx_gateway_id(self) -> pulumi.Output[str]:
        """
        This parameter represents the name of a Direct Connect Gateway ID.
        """
        return pulumi.get(self, "dx_gateway_id")

    @property
    @pulumi.getter(name="enableLearnedCidrsApproval")
    def enable_learned_cidrs_approval(self) -> pulumi.Output[Optional[bool]]:
        """
        Switch to enable/disable encrypted transit approval for direct connection. Valid values: true, false.
        """
        return pulumi.get(self, "enable_learned_cidrs_approval")

    @property
    @pulumi.getter(name="networkDomainName")
    def network_domain_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of an Aviatrix network domain, to which the direct connect gateway will be attached.
        """
        return pulumi.get(self, "network_domain_name")

    @property
    @pulumi.getter(name="securityDomainName")
    def security_domain_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of an Aviatrix security domain, to which the direct connect gateway will be attached.
        """
        return pulumi.get(self, "security_domain_name")

    @property
    @pulumi.getter(name="tgwName")
    def tgw_name(self) -> pulumi.Output[str]:
        """
        This parameter represents the name of an AWS TGW.
        """
        return pulumi.get(self, "tgw_name")

