# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixAwsTgwConnectPeerArgs', 'AviatrixAwsTgwConnectPeer']

@pulumi.input_type
class AviatrixAwsTgwConnectPeerArgs:
    def __init__(__self__, *,
                 bgp_inside_cidrs: pulumi.Input[Sequence[pulumi.Input[str]]],
                 connect_attachment_id: pulumi.Input[str],
                 connect_peer_name: pulumi.Input[str],
                 connection_name: pulumi.Input[str],
                 peer_as_number: pulumi.Input[str],
                 peer_gre_address: pulumi.Input[str],
                 tgw_name: pulumi.Input[str],
                 tgw_gre_address: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AviatrixAwsTgwConnectPeer resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bgp_inside_cidrs: Set of BGP Inside CIDR Blocks.
        :param pulumi.Input[str] connect_attachment_id: Connect Attachment ID.
        :param pulumi.Input[str] connect_peer_name: Connect Peer Name.
        :param pulumi.Input[str] connection_name: AWS TGW Connect connection name.
        :param pulumi.Input[str] peer_as_number: Peer AS Number.
        :param pulumi.Input[str] peer_gre_address: Peer GRE IP Address.
        :param pulumi.Input[str] tgw_name: AWS TGW Name.
        :param pulumi.Input[str] tgw_gre_address: AWS TGW GRE IP Address.
        """
        pulumi.set(__self__, "bgp_inside_cidrs", bgp_inside_cidrs)
        pulumi.set(__self__, "connect_attachment_id", connect_attachment_id)
        pulumi.set(__self__, "connect_peer_name", connect_peer_name)
        pulumi.set(__self__, "connection_name", connection_name)
        pulumi.set(__self__, "peer_as_number", peer_as_number)
        pulumi.set(__self__, "peer_gre_address", peer_gre_address)
        pulumi.set(__self__, "tgw_name", tgw_name)
        if tgw_gre_address is not None:
            pulumi.set(__self__, "tgw_gre_address", tgw_gre_address)

    @property
    @pulumi.getter(name="bgpInsideCidrs")
    def bgp_inside_cidrs(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Set of BGP Inside CIDR Blocks.
        """
        return pulumi.get(self, "bgp_inside_cidrs")

    @bgp_inside_cidrs.setter
    def bgp_inside_cidrs(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "bgp_inside_cidrs", value)

    @property
    @pulumi.getter(name="connectAttachmentId")
    def connect_attachment_id(self) -> pulumi.Input[str]:
        """
        Connect Attachment ID.
        """
        return pulumi.get(self, "connect_attachment_id")

    @connect_attachment_id.setter
    def connect_attachment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "connect_attachment_id", value)

    @property
    @pulumi.getter(name="connectPeerName")
    def connect_peer_name(self) -> pulumi.Input[str]:
        """
        Connect Peer Name.
        """
        return pulumi.get(self, "connect_peer_name")

    @connect_peer_name.setter
    def connect_peer_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "connect_peer_name", value)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Input[str]:
        """
        AWS TGW Connect connection name.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter(name="peerAsNumber")
    def peer_as_number(self) -> pulumi.Input[str]:
        """
        Peer AS Number.
        """
        return pulumi.get(self, "peer_as_number")

    @peer_as_number.setter
    def peer_as_number(self, value: pulumi.Input[str]):
        pulumi.set(self, "peer_as_number", value)

    @property
    @pulumi.getter(name="peerGreAddress")
    def peer_gre_address(self) -> pulumi.Input[str]:
        """
        Peer GRE IP Address.
        """
        return pulumi.get(self, "peer_gre_address")

    @peer_gre_address.setter
    def peer_gre_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "peer_gre_address", value)

    @property
    @pulumi.getter(name="tgwName")
    def tgw_name(self) -> pulumi.Input[str]:
        """
        AWS TGW Name.
        """
        return pulumi.get(self, "tgw_name")

    @tgw_name.setter
    def tgw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "tgw_name", value)

    @property
    @pulumi.getter(name="tgwGreAddress")
    def tgw_gre_address(self) -> Optional[pulumi.Input[str]]:
        """
        AWS TGW GRE IP Address.
        """
        return pulumi.get(self, "tgw_gre_address")

    @tgw_gre_address.setter
    def tgw_gre_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tgw_gre_address", value)


@pulumi.input_type
class _AviatrixAwsTgwConnectPeerState:
    def __init__(__self__, *,
                 bgp_inside_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 connect_attachment_id: Optional[pulumi.Input[str]] = None,
                 connect_peer_id: Optional[pulumi.Input[str]] = None,
                 connect_peer_name: Optional[pulumi.Input[str]] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 peer_as_number: Optional[pulumi.Input[str]] = None,
                 peer_gre_address: Optional[pulumi.Input[str]] = None,
                 tgw_gre_address: Optional[pulumi.Input[str]] = None,
                 tgw_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixAwsTgwConnectPeer resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bgp_inside_cidrs: Set of BGP Inside CIDR Blocks.
        :param pulumi.Input[str] connect_attachment_id: Connect Attachment ID.
        :param pulumi.Input[str] connect_peer_id: Connect Peer ID.
        :param pulumi.Input[str] connect_peer_name: Connect Peer Name.
        :param pulumi.Input[str] connection_name: AWS TGW Connect connection name.
        :param pulumi.Input[str] peer_as_number: Peer AS Number.
        :param pulumi.Input[str] peer_gre_address: Peer GRE IP Address.
        :param pulumi.Input[str] tgw_gre_address: AWS TGW GRE IP Address.
        :param pulumi.Input[str] tgw_name: AWS TGW Name.
        """
        if bgp_inside_cidrs is not None:
            pulumi.set(__self__, "bgp_inside_cidrs", bgp_inside_cidrs)
        if connect_attachment_id is not None:
            pulumi.set(__self__, "connect_attachment_id", connect_attachment_id)
        if connect_peer_id is not None:
            pulumi.set(__self__, "connect_peer_id", connect_peer_id)
        if connect_peer_name is not None:
            pulumi.set(__self__, "connect_peer_name", connect_peer_name)
        if connection_name is not None:
            pulumi.set(__self__, "connection_name", connection_name)
        if peer_as_number is not None:
            pulumi.set(__self__, "peer_as_number", peer_as_number)
        if peer_gre_address is not None:
            pulumi.set(__self__, "peer_gre_address", peer_gre_address)
        if tgw_gre_address is not None:
            pulumi.set(__self__, "tgw_gre_address", tgw_gre_address)
        if tgw_name is not None:
            pulumi.set(__self__, "tgw_name", tgw_name)

    @property
    @pulumi.getter(name="bgpInsideCidrs")
    def bgp_inside_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of BGP Inside CIDR Blocks.
        """
        return pulumi.get(self, "bgp_inside_cidrs")

    @bgp_inside_cidrs.setter
    def bgp_inside_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "bgp_inside_cidrs", value)

    @property
    @pulumi.getter(name="connectAttachmentId")
    def connect_attachment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Connect Attachment ID.
        """
        return pulumi.get(self, "connect_attachment_id")

    @connect_attachment_id.setter
    def connect_attachment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connect_attachment_id", value)

    @property
    @pulumi.getter(name="connectPeerId")
    def connect_peer_id(self) -> Optional[pulumi.Input[str]]:
        """
        Connect Peer ID.
        """
        return pulumi.get(self, "connect_peer_id")

    @connect_peer_id.setter
    def connect_peer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connect_peer_id", value)

    @property
    @pulumi.getter(name="connectPeerName")
    def connect_peer_name(self) -> Optional[pulumi.Input[str]]:
        """
        Connect Peer Name.
        """
        return pulumi.get(self, "connect_peer_name")

    @connect_peer_name.setter
    def connect_peer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connect_peer_name", value)

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        AWS TGW Connect connection name.
        """
        return pulumi.get(self, "connection_name")

    @connection_name.setter
    def connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_name", value)

    @property
    @pulumi.getter(name="peerAsNumber")
    def peer_as_number(self) -> Optional[pulumi.Input[str]]:
        """
        Peer AS Number.
        """
        return pulumi.get(self, "peer_as_number")

    @peer_as_number.setter
    def peer_as_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_as_number", value)

    @property
    @pulumi.getter(name="peerGreAddress")
    def peer_gre_address(self) -> Optional[pulumi.Input[str]]:
        """
        Peer GRE IP Address.
        """
        return pulumi.get(self, "peer_gre_address")

    @peer_gre_address.setter
    def peer_gre_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_gre_address", value)

    @property
    @pulumi.getter(name="tgwGreAddress")
    def tgw_gre_address(self) -> Optional[pulumi.Input[str]]:
        """
        AWS TGW GRE IP Address.
        """
        return pulumi.get(self, "tgw_gre_address")

    @tgw_gre_address.setter
    def tgw_gre_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tgw_gre_address", value)

    @property
    @pulumi.getter(name="tgwName")
    def tgw_name(self) -> Optional[pulumi.Input[str]]:
        """
        AWS TGW Name.
        """
        return pulumi.get(self, "tgw_name")

    @tgw_name.setter
    def tgw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tgw_name", value)


class AviatrixAwsTgwConnectPeer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bgp_inside_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 connect_attachment_id: Optional[pulumi.Input[str]] = None,
                 connect_peer_name: Optional[pulumi.Input[str]] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 peer_as_number: Optional[pulumi.Input[str]] = None,
                 peer_gre_address: Optional[pulumi.Input[str]] = None,
                 tgw_gre_address: Optional[pulumi.Input[str]] = None,
                 tgw_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AviatrixAwsTgwConnectPeer resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bgp_inside_cidrs: Set of BGP Inside CIDR Blocks.
        :param pulumi.Input[str] connect_attachment_id: Connect Attachment ID.
        :param pulumi.Input[str] connect_peer_name: Connect Peer Name.
        :param pulumi.Input[str] connection_name: AWS TGW Connect connection name.
        :param pulumi.Input[str] peer_as_number: Peer AS Number.
        :param pulumi.Input[str] peer_gre_address: Peer GRE IP Address.
        :param pulumi.Input[str] tgw_gre_address: AWS TGW GRE IP Address.
        :param pulumi.Input[str] tgw_name: AWS TGW Name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixAwsTgwConnectPeerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixAwsTgwConnectPeer resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixAwsTgwConnectPeerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixAwsTgwConnectPeerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bgp_inside_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 connect_attachment_id: Optional[pulumi.Input[str]] = None,
                 connect_peer_name: Optional[pulumi.Input[str]] = None,
                 connection_name: Optional[pulumi.Input[str]] = None,
                 peer_as_number: Optional[pulumi.Input[str]] = None,
                 peer_gre_address: Optional[pulumi.Input[str]] = None,
                 tgw_gre_address: Optional[pulumi.Input[str]] = None,
                 tgw_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixAwsTgwConnectPeerArgs.__new__(AviatrixAwsTgwConnectPeerArgs)

            if bgp_inside_cidrs is None and not opts.urn:
                raise TypeError("Missing required property 'bgp_inside_cidrs'")
            __props__.__dict__["bgp_inside_cidrs"] = bgp_inside_cidrs
            if connect_attachment_id is None and not opts.urn:
                raise TypeError("Missing required property 'connect_attachment_id'")
            __props__.__dict__["connect_attachment_id"] = connect_attachment_id
            if connect_peer_name is None and not opts.urn:
                raise TypeError("Missing required property 'connect_peer_name'")
            __props__.__dict__["connect_peer_name"] = connect_peer_name
            if connection_name is None and not opts.urn:
                raise TypeError("Missing required property 'connection_name'")
            __props__.__dict__["connection_name"] = connection_name
            if peer_as_number is None and not opts.urn:
                raise TypeError("Missing required property 'peer_as_number'")
            __props__.__dict__["peer_as_number"] = peer_as_number
            if peer_gre_address is None and not opts.urn:
                raise TypeError("Missing required property 'peer_gre_address'")
            __props__.__dict__["peer_gre_address"] = peer_gre_address
            __props__.__dict__["tgw_gre_address"] = tgw_gre_address
            if tgw_name is None and not opts.urn:
                raise TypeError("Missing required property 'tgw_name'")
            __props__.__dict__["tgw_name"] = tgw_name
            __props__.__dict__["connect_peer_id"] = None
        super(AviatrixAwsTgwConnectPeer, __self__).__init__(
            'aviatrix:index/aviatrixAwsTgwConnectPeer:AviatrixAwsTgwConnectPeer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bgp_inside_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            connect_attachment_id: Optional[pulumi.Input[str]] = None,
            connect_peer_id: Optional[pulumi.Input[str]] = None,
            connect_peer_name: Optional[pulumi.Input[str]] = None,
            connection_name: Optional[pulumi.Input[str]] = None,
            peer_as_number: Optional[pulumi.Input[str]] = None,
            peer_gre_address: Optional[pulumi.Input[str]] = None,
            tgw_gre_address: Optional[pulumi.Input[str]] = None,
            tgw_name: Optional[pulumi.Input[str]] = None) -> 'AviatrixAwsTgwConnectPeer':
        """
        Get an existing AviatrixAwsTgwConnectPeer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bgp_inside_cidrs: Set of BGP Inside CIDR Blocks.
        :param pulumi.Input[str] connect_attachment_id: Connect Attachment ID.
        :param pulumi.Input[str] connect_peer_id: Connect Peer ID.
        :param pulumi.Input[str] connect_peer_name: Connect Peer Name.
        :param pulumi.Input[str] connection_name: AWS TGW Connect connection name.
        :param pulumi.Input[str] peer_as_number: Peer AS Number.
        :param pulumi.Input[str] peer_gre_address: Peer GRE IP Address.
        :param pulumi.Input[str] tgw_gre_address: AWS TGW GRE IP Address.
        :param pulumi.Input[str] tgw_name: AWS TGW Name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixAwsTgwConnectPeerState.__new__(_AviatrixAwsTgwConnectPeerState)

        __props__.__dict__["bgp_inside_cidrs"] = bgp_inside_cidrs
        __props__.__dict__["connect_attachment_id"] = connect_attachment_id
        __props__.__dict__["connect_peer_id"] = connect_peer_id
        __props__.__dict__["connect_peer_name"] = connect_peer_name
        __props__.__dict__["connection_name"] = connection_name
        __props__.__dict__["peer_as_number"] = peer_as_number
        __props__.__dict__["peer_gre_address"] = peer_gre_address
        __props__.__dict__["tgw_gre_address"] = tgw_gre_address
        __props__.__dict__["tgw_name"] = tgw_name
        return AviatrixAwsTgwConnectPeer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bgpInsideCidrs")
    def bgp_inside_cidrs(self) -> pulumi.Output[Sequence[str]]:
        """
        Set of BGP Inside CIDR Blocks.
        """
        return pulumi.get(self, "bgp_inside_cidrs")

    @property
    @pulumi.getter(name="connectAttachmentId")
    def connect_attachment_id(self) -> pulumi.Output[str]:
        """
        Connect Attachment ID.
        """
        return pulumi.get(self, "connect_attachment_id")

    @property
    @pulumi.getter(name="connectPeerId")
    def connect_peer_id(self) -> pulumi.Output[str]:
        """
        Connect Peer ID.
        """
        return pulumi.get(self, "connect_peer_id")

    @property
    @pulumi.getter(name="connectPeerName")
    def connect_peer_name(self) -> pulumi.Output[str]:
        """
        Connect Peer Name.
        """
        return pulumi.get(self, "connect_peer_name")

    @property
    @pulumi.getter(name="connectionName")
    def connection_name(self) -> pulumi.Output[str]:
        """
        AWS TGW Connect connection name.
        """
        return pulumi.get(self, "connection_name")

    @property
    @pulumi.getter(name="peerAsNumber")
    def peer_as_number(self) -> pulumi.Output[str]:
        """
        Peer AS Number.
        """
        return pulumi.get(self, "peer_as_number")

    @property
    @pulumi.getter(name="peerGreAddress")
    def peer_gre_address(self) -> pulumi.Output[str]:
        """
        Peer GRE IP Address.
        """
        return pulumi.get(self, "peer_gre_address")

    @property
    @pulumi.getter(name="tgwGreAddress")
    def tgw_gre_address(self) -> pulumi.Output[Optional[str]]:
        """
        AWS TGW GRE IP Address.
        """
        return pulumi.get(self, "tgw_gre_address")

    @property
    @pulumi.getter(name="tgwName")
    def tgw_name(self) -> pulumi.Output[str]:
        """
        AWS TGW Name.
        """
        return pulumi.get(self, "tgw_name")

