# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AviatrixAwsTgwArgs', 'AviatrixAwsTgw']

@pulumi.input_type
class AviatrixAwsTgwArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[str],
                 aws_side_as_number: pulumi.Input[str],
                 region: pulumi.Input[str],
                 tgw_name: pulumi.Input[str],
                 attached_aviatrix_transit_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cloud_type: Optional[pulumi.Input[int]] = None,
                 enable_multicast: Optional[pulumi.Input[bool]] = None,
                 inspection_mode: Optional[pulumi.Input[str]] = None,
                 manage_security_domain: Optional[pulumi.Input[bool]] = None,
                 manage_transit_gateway_attachment: Optional[pulumi.Input[bool]] = None,
                 manage_vpc_attachment: Optional[pulumi.Input[bool]] = None,
                 security_domains: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixAwsTgwSecurityDomainArgs']]]] = None):
        """
        The set of arguments for constructing a AviatrixAwsTgw resource.
        :param pulumi.Input[str] account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[str] aws_side_as_number: BGP Local ASN (Autonomous System Number), Integer between 1-4294967294.
        :param pulumi.Input[str] region: Region of cloud provider.
        :param pulumi.Input[str] tgw_name: Name of the AWS TGW which is going to be created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attached_aviatrix_transit_gateways: A list of Names of Aviatrix Transit Gateway to attach to one of the three default domains.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cidrs: TGW CIDRs.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider, requires an integer value. Supported for AWS (1) and AWS GOV (256). Default value: 1.
        :param pulumi.Input[bool] enable_multicast: Enable Multicast.
        :param pulumi.Input[str] inspection_mode: Inspection mode. Valid values: 'Domain-based' and 'Connection-based'.
        :param pulumi.Input[bool] manage_security_domain: This parameter is a switch used to determine whether or not to manage security domains to the TGW using the
               aviatrix_aws_tgw resource. If this is set to false, security domains must be managed using the
               aviatrix_aws_tgw_security_domain resource. Valid values: true, false. Default value: true.
        :param pulumi.Input[bool] manage_transit_gateway_attachment: This parameter is a switch used to determine whether or not to manage transit gateway attachments to the TGW using the
               aviatrix_aws_tgw resource. If this is set to false, attachment of transit gateways must be done using the
               aviatrix_aws_tgw_transit_gateway_attachment resource. Valid values: true, false. Default value: true.
        :param pulumi.Input[bool] manage_vpc_attachment: This parameter is a switch used to determine whether or not to manage VPC attachments to the TGW using the
               aviatrix_aws_tgw resource. If this is set to false, attachment of VPCs must be done using the
               aviatrix_aws_tgw_vpc_attachment resource. Valid values: true, false. Default value: true.
        :param pulumi.Input[Sequence[pulumi.Input['AviatrixAwsTgwSecurityDomainArgs']]] security_domains: Security Domains to create together with AWS TGW's creation.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "aws_side_as_number", aws_side_as_number)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "tgw_name", tgw_name)
        if attached_aviatrix_transit_gateways is not None:
            warnings.warn("""Please set `manage_transit_gateway_attachment` to false, and use the standalone aviatrix_aws_tgw_transit_gateway_attachment resource instead.""", DeprecationWarning)
            pulumi.log.warn("""attached_aviatrix_transit_gateways is deprecated: Please set `manage_transit_gateway_attachment` to false, and use the standalone aviatrix_aws_tgw_transit_gateway_attachment resource instead.""")
        if attached_aviatrix_transit_gateways is not None:
            pulumi.set(__self__, "attached_aviatrix_transit_gateways", attached_aviatrix_transit_gateways)
        if cidrs is not None:
            pulumi.set(__self__, "cidrs", cidrs)
        if cloud_type is not None:
            pulumi.set(__self__, "cloud_type", cloud_type)
        if enable_multicast is not None:
            pulumi.set(__self__, "enable_multicast", enable_multicast)
        if inspection_mode is not None:
            pulumi.set(__self__, "inspection_mode", inspection_mode)
        if manage_security_domain is not None:
            pulumi.set(__self__, "manage_security_domain", manage_security_domain)
        if manage_transit_gateway_attachment is not None:
            pulumi.set(__self__, "manage_transit_gateway_attachment", manage_transit_gateway_attachment)
        if manage_vpc_attachment is not None:
            pulumi.set(__self__, "manage_vpc_attachment", manage_vpc_attachment)
        if security_domains is not None:
            warnings.warn("""Please set `manage_security_domain` to false, and use the standalone aviatrix_aws_tgw_network_domain resource instead.""", DeprecationWarning)
            pulumi.log.warn("""security_domains is deprecated: Please set `manage_security_domain` to false, and use the standalone aviatrix_aws_tgw_network_domain resource instead.""")
        if security_domains is not None:
            pulumi.set(__self__, "security_domains", security_domains)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[str]:
        """
        This parameter represents the name of a Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="awsSideAsNumber")
    def aws_side_as_number(self) -> pulumi.Input[str]:
        """
        BGP Local ASN (Autonomous System Number), Integer between 1-4294967294.
        """
        return pulumi.get(self, "aws_side_as_number")

    @aws_side_as_number.setter
    def aws_side_as_number(self, value: pulumi.Input[str]):
        pulumi.set(self, "aws_side_as_number", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        Region of cloud provider.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="tgwName")
    def tgw_name(self) -> pulumi.Input[str]:
        """
        Name of the AWS TGW which is going to be created.
        """
        return pulumi.get(self, "tgw_name")

    @tgw_name.setter
    def tgw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "tgw_name", value)

    @property
    @pulumi.getter(name="attachedAviatrixTransitGateways")
    def attached_aviatrix_transit_gateways(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of Names of Aviatrix Transit Gateway to attach to one of the three default domains.
        """
        return pulumi.get(self, "attached_aviatrix_transit_gateways")

    @attached_aviatrix_transit_gateways.setter
    def attached_aviatrix_transit_gateways(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attached_aviatrix_transit_gateways", value)

    @property
    @pulumi.getter
    def cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        TGW CIDRs.
        """
        return pulumi.get(self, "cidrs")

    @cidrs.setter
    def cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "cidrs", value)

    @property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> Optional[pulumi.Input[int]]:
        """
        Type of cloud service provider, requires an integer value. Supported for AWS (1) and AWS GOV (256). Default value: 1.
        """
        return pulumi.get(self, "cloud_type")

    @cloud_type.setter
    def cloud_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cloud_type", value)

    @property
    @pulumi.getter(name="enableMulticast")
    def enable_multicast(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Multicast.
        """
        return pulumi.get(self, "enable_multicast")

    @enable_multicast.setter
    def enable_multicast(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_multicast", value)

    @property
    @pulumi.getter(name="inspectionMode")
    def inspection_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Inspection mode. Valid values: 'Domain-based' and 'Connection-based'.
        """
        return pulumi.get(self, "inspection_mode")

    @inspection_mode.setter
    def inspection_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inspection_mode", value)

    @property
    @pulumi.getter(name="manageSecurityDomain")
    def manage_security_domain(self) -> Optional[pulumi.Input[bool]]:
        """
        This parameter is a switch used to determine whether or not to manage security domains to the TGW using the
        aviatrix_aws_tgw resource. If this is set to false, security domains must be managed using the
        aviatrix_aws_tgw_security_domain resource. Valid values: true, false. Default value: true.
        """
        return pulumi.get(self, "manage_security_domain")

    @manage_security_domain.setter
    def manage_security_domain(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "manage_security_domain", value)

    @property
    @pulumi.getter(name="manageTransitGatewayAttachment")
    def manage_transit_gateway_attachment(self) -> Optional[pulumi.Input[bool]]:
        """
        This parameter is a switch used to determine whether or not to manage transit gateway attachments to the TGW using the
        aviatrix_aws_tgw resource. If this is set to false, attachment of transit gateways must be done using the
        aviatrix_aws_tgw_transit_gateway_attachment resource. Valid values: true, false. Default value: true.
        """
        return pulumi.get(self, "manage_transit_gateway_attachment")

    @manage_transit_gateway_attachment.setter
    def manage_transit_gateway_attachment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "manage_transit_gateway_attachment", value)

    @property
    @pulumi.getter(name="manageVpcAttachment")
    def manage_vpc_attachment(self) -> Optional[pulumi.Input[bool]]:
        """
        This parameter is a switch used to determine whether or not to manage VPC attachments to the TGW using the
        aviatrix_aws_tgw resource. If this is set to false, attachment of VPCs must be done using the
        aviatrix_aws_tgw_vpc_attachment resource. Valid values: true, false. Default value: true.
        """
        return pulumi.get(self, "manage_vpc_attachment")

    @manage_vpc_attachment.setter
    def manage_vpc_attachment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "manage_vpc_attachment", value)

    @property
    @pulumi.getter(name="securityDomains")
    def security_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixAwsTgwSecurityDomainArgs']]]]:
        """
        Security Domains to create together with AWS TGW's creation.
        """
        return pulumi.get(self, "security_domains")

    @security_domains.setter
    def security_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixAwsTgwSecurityDomainArgs']]]]):
        pulumi.set(self, "security_domains", value)


@pulumi.input_type
class _AviatrixAwsTgwState:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[str]] = None,
                 attached_aviatrix_transit_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 aws_side_as_number: Optional[pulumi.Input[str]] = None,
                 cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cloud_type: Optional[pulumi.Input[int]] = None,
                 enable_multicast: Optional[pulumi.Input[bool]] = None,
                 inspection_mode: Optional[pulumi.Input[str]] = None,
                 manage_security_domain: Optional[pulumi.Input[bool]] = None,
                 manage_transit_gateway_attachment: Optional[pulumi.Input[bool]] = None,
                 manage_vpc_attachment: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_domains: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixAwsTgwSecurityDomainArgs']]]] = None,
                 tgw_id: Optional[pulumi.Input[str]] = None,
                 tgw_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixAwsTgw resources.
        :param pulumi.Input[str] account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attached_aviatrix_transit_gateways: A list of Names of Aviatrix Transit Gateway to attach to one of the three default domains.
        :param pulumi.Input[str] aws_side_as_number: BGP Local ASN (Autonomous System Number), Integer between 1-4294967294.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cidrs: TGW CIDRs.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider, requires an integer value. Supported for AWS (1) and AWS GOV (256). Default value: 1.
        :param pulumi.Input[bool] enable_multicast: Enable Multicast.
        :param pulumi.Input[str] inspection_mode: Inspection mode. Valid values: 'Domain-based' and 'Connection-based'.
        :param pulumi.Input[bool] manage_security_domain: This parameter is a switch used to determine whether or not to manage security domains to the TGW using the
               aviatrix_aws_tgw resource. If this is set to false, security domains must be managed using the
               aviatrix_aws_tgw_security_domain resource. Valid values: true, false. Default value: true.
        :param pulumi.Input[bool] manage_transit_gateway_attachment: This parameter is a switch used to determine whether or not to manage transit gateway attachments to the TGW using the
               aviatrix_aws_tgw resource. If this is set to false, attachment of transit gateways must be done using the
               aviatrix_aws_tgw_transit_gateway_attachment resource. Valid values: true, false. Default value: true.
        :param pulumi.Input[bool] manage_vpc_attachment: This parameter is a switch used to determine whether or not to manage VPC attachments to the TGW using the
               aviatrix_aws_tgw resource. If this is set to false, attachment of VPCs must be done using the
               aviatrix_aws_tgw_vpc_attachment resource. Valid values: true, false. Default value: true.
        :param pulumi.Input[str] region: Region of cloud provider.
        :param pulumi.Input[Sequence[pulumi.Input['AviatrixAwsTgwSecurityDomainArgs']]] security_domains: Security Domains to create together with AWS TGW's creation.
        :param pulumi.Input[str] tgw_id: TGW ID.
        :param pulumi.Input[str] tgw_name: Name of the AWS TGW which is going to be created.
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if attached_aviatrix_transit_gateways is not None:
            warnings.warn("""Please set `manage_transit_gateway_attachment` to false, and use the standalone aviatrix_aws_tgw_transit_gateway_attachment resource instead.""", DeprecationWarning)
            pulumi.log.warn("""attached_aviatrix_transit_gateways is deprecated: Please set `manage_transit_gateway_attachment` to false, and use the standalone aviatrix_aws_tgw_transit_gateway_attachment resource instead.""")
        if attached_aviatrix_transit_gateways is not None:
            pulumi.set(__self__, "attached_aviatrix_transit_gateways", attached_aviatrix_transit_gateways)
        if aws_side_as_number is not None:
            pulumi.set(__self__, "aws_side_as_number", aws_side_as_number)
        if cidrs is not None:
            pulumi.set(__self__, "cidrs", cidrs)
        if cloud_type is not None:
            pulumi.set(__self__, "cloud_type", cloud_type)
        if enable_multicast is not None:
            pulumi.set(__self__, "enable_multicast", enable_multicast)
        if inspection_mode is not None:
            pulumi.set(__self__, "inspection_mode", inspection_mode)
        if manage_security_domain is not None:
            pulumi.set(__self__, "manage_security_domain", manage_security_domain)
        if manage_transit_gateway_attachment is not None:
            pulumi.set(__self__, "manage_transit_gateway_attachment", manage_transit_gateway_attachment)
        if manage_vpc_attachment is not None:
            pulumi.set(__self__, "manage_vpc_attachment", manage_vpc_attachment)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_domains is not None:
            warnings.warn("""Please set `manage_security_domain` to false, and use the standalone aviatrix_aws_tgw_network_domain resource instead.""", DeprecationWarning)
            pulumi.log.warn("""security_domains is deprecated: Please set `manage_security_domain` to false, and use the standalone aviatrix_aws_tgw_network_domain resource instead.""")
        if security_domains is not None:
            pulumi.set(__self__, "security_domains", security_domains)
        if tgw_id is not None:
            pulumi.set(__self__, "tgw_id", tgw_id)
        if tgw_name is not None:
            pulumi.set(__self__, "tgw_name", tgw_name)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        This parameter represents the name of a Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter(name="attachedAviatrixTransitGateways")
    def attached_aviatrix_transit_gateways(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of Names of Aviatrix Transit Gateway to attach to one of the three default domains.
        """
        return pulumi.get(self, "attached_aviatrix_transit_gateways")

    @attached_aviatrix_transit_gateways.setter
    def attached_aviatrix_transit_gateways(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attached_aviatrix_transit_gateways", value)

    @property
    @pulumi.getter(name="awsSideAsNumber")
    def aws_side_as_number(self) -> Optional[pulumi.Input[str]]:
        """
        BGP Local ASN (Autonomous System Number), Integer between 1-4294967294.
        """
        return pulumi.get(self, "aws_side_as_number")

    @aws_side_as_number.setter
    def aws_side_as_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aws_side_as_number", value)

    @property
    @pulumi.getter
    def cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        TGW CIDRs.
        """
        return pulumi.get(self, "cidrs")

    @cidrs.setter
    def cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "cidrs", value)

    @property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> Optional[pulumi.Input[int]]:
        """
        Type of cloud service provider, requires an integer value. Supported for AWS (1) and AWS GOV (256). Default value: 1.
        """
        return pulumi.get(self, "cloud_type")

    @cloud_type.setter
    def cloud_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cloud_type", value)

    @property
    @pulumi.getter(name="enableMulticast")
    def enable_multicast(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Multicast.
        """
        return pulumi.get(self, "enable_multicast")

    @enable_multicast.setter
    def enable_multicast(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_multicast", value)

    @property
    @pulumi.getter(name="inspectionMode")
    def inspection_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Inspection mode. Valid values: 'Domain-based' and 'Connection-based'.
        """
        return pulumi.get(self, "inspection_mode")

    @inspection_mode.setter
    def inspection_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inspection_mode", value)

    @property
    @pulumi.getter(name="manageSecurityDomain")
    def manage_security_domain(self) -> Optional[pulumi.Input[bool]]:
        """
        This parameter is a switch used to determine whether or not to manage security domains to the TGW using the
        aviatrix_aws_tgw resource. If this is set to false, security domains must be managed using the
        aviatrix_aws_tgw_security_domain resource. Valid values: true, false. Default value: true.
        """
        return pulumi.get(self, "manage_security_domain")

    @manage_security_domain.setter
    def manage_security_domain(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "manage_security_domain", value)

    @property
    @pulumi.getter(name="manageTransitGatewayAttachment")
    def manage_transit_gateway_attachment(self) -> Optional[pulumi.Input[bool]]:
        """
        This parameter is a switch used to determine whether or not to manage transit gateway attachments to the TGW using the
        aviatrix_aws_tgw resource. If this is set to false, attachment of transit gateways must be done using the
        aviatrix_aws_tgw_transit_gateway_attachment resource. Valid values: true, false. Default value: true.
        """
        return pulumi.get(self, "manage_transit_gateway_attachment")

    @manage_transit_gateway_attachment.setter
    def manage_transit_gateway_attachment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "manage_transit_gateway_attachment", value)

    @property
    @pulumi.getter(name="manageVpcAttachment")
    def manage_vpc_attachment(self) -> Optional[pulumi.Input[bool]]:
        """
        This parameter is a switch used to determine whether or not to manage VPC attachments to the TGW using the
        aviatrix_aws_tgw resource. If this is set to false, attachment of VPCs must be done using the
        aviatrix_aws_tgw_vpc_attachment resource. Valid values: true, false. Default value: true.
        """
        return pulumi.get(self, "manage_vpc_attachment")

    @manage_vpc_attachment.setter
    def manage_vpc_attachment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "manage_vpc_attachment", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region of cloud provider.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityDomains")
    def security_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixAwsTgwSecurityDomainArgs']]]]:
        """
        Security Domains to create together with AWS TGW's creation.
        """
        return pulumi.get(self, "security_domains")

    @security_domains.setter
    def security_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixAwsTgwSecurityDomainArgs']]]]):
        pulumi.set(self, "security_domains", value)

    @property
    @pulumi.getter(name="tgwId")
    def tgw_id(self) -> Optional[pulumi.Input[str]]:
        """
        TGW ID.
        """
        return pulumi.get(self, "tgw_id")

    @tgw_id.setter
    def tgw_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tgw_id", value)

    @property
    @pulumi.getter(name="tgwName")
    def tgw_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the AWS TGW which is going to be created.
        """
        return pulumi.get(self, "tgw_name")

    @tgw_name.setter
    def tgw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tgw_name", value)


class AviatrixAwsTgw(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 attached_aviatrix_transit_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 aws_side_as_number: Optional[pulumi.Input[str]] = None,
                 cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cloud_type: Optional[pulumi.Input[int]] = None,
                 enable_multicast: Optional[pulumi.Input[bool]] = None,
                 inspection_mode: Optional[pulumi.Input[str]] = None,
                 manage_security_domain: Optional[pulumi.Input[bool]] = None,
                 manage_transit_gateway_attachment: Optional[pulumi.Input[bool]] = None,
                 manage_vpc_attachment: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_domains: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixAwsTgwSecurityDomainArgs']]]]] = None,
                 tgw_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a AviatrixAwsTgw resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attached_aviatrix_transit_gateways: A list of Names of Aviatrix Transit Gateway to attach to one of the three default domains.
        :param pulumi.Input[str] aws_side_as_number: BGP Local ASN (Autonomous System Number), Integer between 1-4294967294.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cidrs: TGW CIDRs.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider, requires an integer value. Supported for AWS (1) and AWS GOV (256). Default value: 1.
        :param pulumi.Input[bool] enable_multicast: Enable Multicast.
        :param pulumi.Input[str] inspection_mode: Inspection mode. Valid values: 'Domain-based' and 'Connection-based'.
        :param pulumi.Input[bool] manage_security_domain: This parameter is a switch used to determine whether or not to manage security domains to the TGW using the
               aviatrix_aws_tgw resource. If this is set to false, security domains must be managed using the
               aviatrix_aws_tgw_security_domain resource. Valid values: true, false. Default value: true.
        :param pulumi.Input[bool] manage_transit_gateway_attachment: This parameter is a switch used to determine whether or not to manage transit gateway attachments to the TGW using the
               aviatrix_aws_tgw resource. If this is set to false, attachment of transit gateways must be done using the
               aviatrix_aws_tgw_transit_gateway_attachment resource. Valid values: true, false. Default value: true.
        :param pulumi.Input[bool] manage_vpc_attachment: This parameter is a switch used to determine whether or not to manage VPC attachments to the TGW using the
               aviatrix_aws_tgw resource. If this is set to false, attachment of VPCs must be done using the
               aviatrix_aws_tgw_vpc_attachment resource. Valid values: true, false. Default value: true.
        :param pulumi.Input[str] region: Region of cloud provider.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixAwsTgwSecurityDomainArgs']]]] security_domains: Security Domains to create together with AWS TGW's creation.
        :param pulumi.Input[str] tgw_name: Name of the AWS TGW which is going to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixAwsTgwArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AviatrixAwsTgw resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AviatrixAwsTgwArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixAwsTgwArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 attached_aviatrix_transit_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 aws_side_as_number: Optional[pulumi.Input[str]] = None,
                 cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cloud_type: Optional[pulumi.Input[int]] = None,
                 enable_multicast: Optional[pulumi.Input[bool]] = None,
                 inspection_mode: Optional[pulumi.Input[str]] = None,
                 manage_security_domain: Optional[pulumi.Input[bool]] = None,
                 manage_transit_gateway_attachment: Optional[pulumi.Input[bool]] = None,
                 manage_vpc_attachment: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_domains: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixAwsTgwSecurityDomainArgs']]]]] = None,
                 tgw_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixAwsTgwArgs.__new__(AviatrixAwsTgwArgs)

            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            if attached_aviatrix_transit_gateways is not None and not opts.urn:
                warnings.warn("""Please set `manage_transit_gateway_attachment` to false, and use the standalone aviatrix_aws_tgw_transit_gateway_attachment resource instead.""", DeprecationWarning)
                pulumi.log.warn("""attached_aviatrix_transit_gateways is deprecated: Please set `manage_transit_gateway_attachment` to false, and use the standalone aviatrix_aws_tgw_transit_gateway_attachment resource instead.""")
            __props__.__dict__["attached_aviatrix_transit_gateways"] = attached_aviatrix_transit_gateways
            if aws_side_as_number is None and not opts.urn:
                raise TypeError("Missing required property 'aws_side_as_number'")
            __props__.__dict__["aws_side_as_number"] = aws_side_as_number
            __props__.__dict__["cidrs"] = cidrs
            __props__.__dict__["cloud_type"] = cloud_type
            __props__.__dict__["enable_multicast"] = enable_multicast
            __props__.__dict__["inspection_mode"] = inspection_mode
            __props__.__dict__["manage_security_domain"] = manage_security_domain
            __props__.__dict__["manage_transit_gateway_attachment"] = manage_transit_gateway_attachment
            __props__.__dict__["manage_vpc_attachment"] = manage_vpc_attachment
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            if security_domains is not None and not opts.urn:
                warnings.warn("""Please set `manage_security_domain` to false, and use the standalone aviatrix_aws_tgw_network_domain resource instead.""", DeprecationWarning)
                pulumi.log.warn("""security_domains is deprecated: Please set `manage_security_domain` to false, and use the standalone aviatrix_aws_tgw_network_domain resource instead.""")
            __props__.__dict__["security_domains"] = security_domains
            if tgw_name is None and not opts.urn:
                raise TypeError("Missing required property 'tgw_name'")
            __props__.__dict__["tgw_name"] = tgw_name
            __props__.__dict__["tgw_id"] = None
        super(AviatrixAwsTgw, __self__).__init__(
            'aviatrix:index/aviatrixAwsTgw:AviatrixAwsTgw',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name: Optional[pulumi.Input[str]] = None,
            attached_aviatrix_transit_gateways: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            aws_side_as_number: Optional[pulumi.Input[str]] = None,
            cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            cloud_type: Optional[pulumi.Input[int]] = None,
            enable_multicast: Optional[pulumi.Input[bool]] = None,
            inspection_mode: Optional[pulumi.Input[str]] = None,
            manage_security_domain: Optional[pulumi.Input[bool]] = None,
            manage_transit_gateway_attachment: Optional[pulumi.Input[bool]] = None,
            manage_vpc_attachment: Optional[pulumi.Input[bool]] = None,
            region: Optional[pulumi.Input[str]] = None,
            security_domains: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixAwsTgwSecurityDomainArgs']]]]] = None,
            tgw_id: Optional[pulumi.Input[str]] = None,
            tgw_name: Optional[pulumi.Input[str]] = None) -> 'AviatrixAwsTgw':
        """
        Get an existing AviatrixAwsTgw resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_name: This parameter represents the name of a Cloud-Account in Aviatrix controller.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attached_aviatrix_transit_gateways: A list of Names of Aviatrix Transit Gateway to attach to one of the three default domains.
        :param pulumi.Input[str] aws_side_as_number: BGP Local ASN (Autonomous System Number), Integer between 1-4294967294.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cidrs: TGW CIDRs.
        :param pulumi.Input[int] cloud_type: Type of cloud service provider, requires an integer value. Supported for AWS (1) and AWS GOV (256). Default value: 1.
        :param pulumi.Input[bool] enable_multicast: Enable Multicast.
        :param pulumi.Input[str] inspection_mode: Inspection mode. Valid values: 'Domain-based' and 'Connection-based'.
        :param pulumi.Input[bool] manage_security_domain: This parameter is a switch used to determine whether or not to manage security domains to the TGW using the
               aviatrix_aws_tgw resource. If this is set to false, security domains must be managed using the
               aviatrix_aws_tgw_security_domain resource. Valid values: true, false. Default value: true.
        :param pulumi.Input[bool] manage_transit_gateway_attachment: This parameter is a switch used to determine whether or not to manage transit gateway attachments to the TGW using the
               aviatrix_aws_tgw resource. If this is set to false, attachment of transit gateways must be done using the
               aviatrix_aws_tgw_transit_gateway_attachment resource. Valid values: true, false. Default value: true.
        :param pulumi.Input[bool] manage_vpc_attachment: This parameter is a switch used to determine whether or not to manage VPC attachments to the TGW using the
               aviatrix_aws_tgw resource. If this is set to false, attachment of VPCs must be done using the
               aviatrix_aws_tgw_vpc_attachment resource. Valid values: true, false. Default value: true.
        :param pulumi.Input[str] region: Region of cloud provider.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AviatrixAwsTgwSecurityDomainArgs']]]] security_domains: Security Domains to create together with AWS TGW's creation.
        :param pulumi.Input[str] tgw_id: TGW ID.
        :param pulumi.Input[str] tgw_name: Name of the AWS TGW which is going to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixAwsTgwState.__new__(_AviatrixAwsTgwState)

        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["attached_aviatrix_transit_gateways"] = attached_aviatrix_transit_gateways
        __props__.__dict__["aws_side_as_number"] = aws_side_as_number
        __props__.__dict__["cidrs"] = cidrs
        __props__.__dict__["cloud_type"] = cloud_type
        __props__.__dict__["enable_multicast"] = enable_multicast
        __props__.__dict__["inspection_mode"] = inspection_mode
        __props__.__dict__["manage_security_domain"] = manage_security_domain
        __props__.__dict__["manage_transit_gateway_attachment"] = manage_transit_gateway_attachment
        __props__.__dict__["manage_vpc_attachment"] = manage_vpc_attachment
        __props__.__dict__["region"] = region
        __props__.__dict__["security_domains"] = security_domains
        __props__.__dict__["tgw_id"] = tgw_id
        __props__.__dict__["tgw_name"] = tgw_name
        return AviatrixAwsTgw(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[str]:
        """
        This parameter represents the name of a Cloud-Account in Aviatrix controller.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="attachedAviatrixTransitGateways")
    def attached_aviatrix_transit_gateways(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of Names of Aviatrix Transit Gateway to attach to one of the three default domains.
        """
        return pulumi.get(self, "attached_aviatrix_transit_gateways")

    @property
    @pulumi.getter(name="awsSideAsNumber")
    def aws_side_as_number(self) -> pulumi.Output[str]:
        """
        BGP Local ASN (Autonomous System Number), Integer between 1-4294967294.
        """
        return pulumi.get(self, "aws_side_as_number")

    @property
    @pulumi.getter
    def cidrs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        TGW CIDRs.
        """
        return pulumi.get(self, "cidrs")

    @property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> pulumi.Output[Optional[int]]:
        """
        Type of cloud service provider, requires an integer value. Supported for AWS (1) and AWS GOV (256). Default value: 1.
        """
        return pulumi.get(self, "cloud_type")

    @property
    @pulumi.getter(name="enableMulticast")
    def enable_multicast(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable Multicast.
        """
        return pulumi.get(self, "enable_multicast")

    @property
    @pulumi.getter(name="inspectionMode")
    def inspection_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Inspection mode. Valid values: 'Domain-based' and 'Connection-based'.
        """
        return pulumi.get(self, "inspection_mode")

    @property
    @pulumi.getter(name="manageSecurityDomain")
    def manage_security_domain(self) -> pulumi.Output[Optional[bool]]:
        """
        This parameter is a switch used to determine whether or not to manage security domains to the TGW using the
        aviatrix_aws_tgw resource. If this is set to false, security domains must be managed using the
        aviatrix_aws_tgw_security_domain resource. Valid values: true, false. Default value: true.
        """
        return pulumi.get(self, "manage_security_domain")

    @property
    @pulumi.getter(name="manageTransitGatewayAttachment")
    def manage_transit_gateway_attachment(self) -> pulumi.Output[Optional[bool]]:
        """
        This parameter is a switch used to determine whether or not to manage transit gateway attachments to the TGW using the
        aviatrix_aws_tgw resource. If this is set to false, attachment of transit gateways must be done using the
        aviatrix_aws_tgw_transit_gateway_attachment resource. Valid values: true, false. Default value: true.
        """
        return pulumi.get(self, "manage_transit_gateway_attachment")

    @property
    @pulumi.getter(name="manageVpcAttachment")
    def manage_vpc_attachment(self) -> pulumi.Output[Optional[bool]]:
        """
        This parameter is a switch used to determine whether or not to manage VPC attachments to the TGW using the
        aviatrix_aws_tgw resource. If this is set to false, attachment of VPCs must be done using the
        aviatrix_aws_tgw_vpc_attachment resource. Valid values: true, false. Default value: true.
        """
        return pulumi.get(self, "manage_vpc_attachment")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Region of cloud provider.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityDomains")
    def security_domains(self) -> pulumi.Output[Optional[Sequence['outputs.AviatrixAwsTgwSecurityDomain']]]:
        """
        Security Domains to create together with AWS TGW's creation.
        """
        return pulumi.get(self, "security_domains")

    @property
    @pulumi.getter(name="tgwId")
    def tgw_id(self) -> pulumi.Output[str]:
        """
        TGW ID.
        """
        return pulumi.get(self, "tgw_id")

    @property
    @pulumi.getter(name="tgwName")
    def tgw_name(self) -> pulumi.Output[str]:
        """
        Name of the AWS TGW which is going to be created.
        """
        return pulumi.get(self, "tgw_name")

