# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'VaultClusterAuditLogConfig',
    'VaultClusterMajorVersionUpgradeConfig',
    'VaultClusterMetricsConfig',
    'GetPackerImageIterationBuildResult',
    'GetPackerImageIterationBuildImageResult',
    'GetVaultClusterAuditLogConfigResult',
    'GetVaultClusterMajorVersionUpgradeConfigResult',
    'GetVaultClusterMetricsConfigResult',
]

@pulumi.output_type
class VaultClusterAuditLogConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datadogApiKey":
            suggest = "datadog_api_key"
        elif key == "datadogRegion":
            suggest = "datadog_region"
        elif key == "grafanaEndpoint":
            suggest = "grafana_endpoint"
        elif key == "grafanaPassword":
            suggest = "grafana_password"
        elif key == "grafanaUser":
            suggest = "grafana_user"
        elif key == "splunkHecendpoint":
            suggest = "splunk_hecendpoint"
        elif key == "splunkToken":
            suggest = "splunk_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultClusterAuditLogConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultClusterAuditLogConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultClusterAuditLogConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datadog_api_key: Optional[str] = None,
                 datadog_region: Optional[str] = None,
                 grafana_endpoint: Optional[str] = None,
                 grafana_password: Optional[str] = None,
                 grafana_user: Optional[str] = None,
                 splunk_hecendpoint: Optional[str] = None,
                 splunk_token: Optional[str] = None):
        """
        :param str datadog_api_key: Datadog api key for streaming audit logs
        :param str datadog_region: Datadog region for streaming audit logs
        :param str grafana_endpoint: Grafana endpoint for streaming audit logs
        :param str grafana_password: Grafana password for streaming audit logs
        :param str grafana_user: Grafana user for streaming audit logs
        :param str splunk_hecendpoint: Splunk endpoint for streaming audit logs
        :param str splunk_token: Splunk token for streaming audit logs
        """
        if datadog_api_key is not None:
            pulumi.set(__self__, "datadog_api_key", datadog_api_key)
        if datadog_region is not None:
            pulumi.set(__self__, "datadog_region", datadog_region)
        if grafana_endpoint is not None:
            pulumi.set(__self__, "grafana_endpoint", grafana_endpoint)
        if grafana_password is not None:
            pulumi.set(__self__, "grafana_password", grafana_password)
        if grafana_user is not None:
            pulumi.set(__self__, "grafana_user", grafana_user)
        if splunk_hecendpoint is not None:
            pulumi.set(__self__, "splunk_hecendpoint", splunk_hecendpoint)
        if splunk_token is not None:
            pulumi.set(__self__, "splunk_token", splunk_token)

    @property
    @pulumi.getter(name="datadogApiKey")
    def datadog_api_key(self) -> Optional[str]:
        """
        Datadog api key for streaming audit logs
        """
        return pulumi.get(self, "datadog_api_key")

    @property
    @pulumi.getter(name="datadogRegion")
    def datadog_region(self) -> Optional[str]:
        """
        Datadog region for streaming audit logs
        """
        return pulumi.get(self, "datadog_region")

    @property
    @pulumi.getter(name="grafanaEndpoint")
    def grafana_endpoint(self) -> Optional[str]:
        """
        Grafana endpoint for streaming audit logs
        """
        return pulumi.get(self, "grafana_endpoint")

    @property
    @pulumi.getter(name="grafanaPassword")
    def grafana_password(self) -> Optional[str]:
        """
        Grafana password for streaming audit logs
        """
        return pulumi.get(self, "grafana_password")

    @property
    @pulumi.getter(name="grafanaUser")
    def grafana_user(self) -> Optional[str]:
        """
        Grafana user for streaming audit logs
        """
        return pulumi.get(self, "grafana_user")

    @property
    @pulumi.getter(name="splunkHecendpoint")
    def splunk_hecendpoint(self) -> Optional[str]:
        """
        Splunk endpoint for streaming audit logs
        """
        return pulumi.get(self, "splunk_hecendpoint")

    @property
    @pulumi.getter(name="splunkToken")
    def splunk_token(self) -> Optional[str]:
        """
        Splunk token for streaming audit logs
        """
        return pulumi.get(self, "splunk_token")


@pulumi.output_type
class VaultClusterMajorVersionUpgradeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "upgradeType":
            suggest = "upgrade_type"
        elif key == "maintenanceWindowDay":
            suggest = "maintenance_window_day"
        elif key == "maintenanceWindowTime":
            suggest = "maintenance_window_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultClusterMajorVersionUpgradeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultClusterMajorVersionUpgradeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultClusterMajorVersionUpgradeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 upgrade_type: str,
                 maintenance_window_day: Optional[str] = None,
                 maintenance_window_time: Optional[str] = None):
        """
        :param str upgrade_type: The major upgrade type for the cluster. Valid options for upgrade type - `AUTOMATIC`, `SCHEDULED`, `MANUAL`
        :param str maintenance_window_day: The maintenance day of the week for scheduled upgrades. Valid options for maintenance window day - `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`
        :param str maintenance_window_time: The maintenance time frame for scheduled upgrades. Valid options for maintenance window time - `WINDOW_12AM_4AM`, `WINDOW_6AM_10AM`, `WINDOW_12PM_4PM`, `WINDOW_6PM_10PM`
        """
        pulumi.set(__self__, "upgrade_type", upgrade_type)
        if maintenance_window_day is not None:
            pulumi.set(__self__, "maintenance_window_day", maintenance_window_day)
        if maintenance_window_time is not None:
            pulumi.set(__self__, "maintenance_window_time", maintenance_window_time)

    @property
    @pulumi.getter(name="upgradeType")
    def upgrade_type(self) -> str:
        """
        The major upgrade type for the cluster. Valid options for upgrade type - `AUTOMATIC`, `SCHEDULED`, `MANUAL`
        """
        return pulumi.get(self, "upgrade_type")

    @property
    @pulumi.getter(name="maintenanceWindowDay")
    def maintenance_window_day(self) -> Optional[str]:
        """
        The maintenance day of the week for scheduled upgrades. Valid options for maintenance window day - `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`, `SATURDAY`, `SUNDAY`
        """
        return pulumi.get(self, "maintenance_window_day")

    @property
    @pulumi.getter(name="maintenanceWindowTime")
    def maintenance_window_time(self) -> Optional[str]:
        """
        The maintenance time frame for scheduled upgrades. Valid options for maintenance window time - `WINDOW_12AM_4AM`, `WINDOW_6AM_10AM`, `WINDOW_12PM_4PM`, `WINDOW_6PM_10PM`
        """
        return pulumi.get(self, "maintenance_window_time")


@pulumi.output_type
class VaultClusterMetricsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datadogApiKey":
            suggest = "datadog_api_key"
        elif key == "datadogRegion":
            suggest = "datadog_region"
        elif key == "grafanaEndpoint":
            suggest = "grafana_endpoint"
        elif key == "grafanaPassword":
            suggest = "grafana_password"
        elif key == "grafanaUser":
            suggest = "grafana_user"
        elif key == "splunkHecendpoint":
            suggest = "splunk_hecendpoint"
        elif key == "splunkToken":
            suggest = "splunk_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VaultClusterMetricsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VaultClusterMetricsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VaultClusterMetricsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datadog_api_key: Optional[str] = None,
                 datadog_region: Optional[str] = None,
                 grafana_endpoint: Optional[str] = None,
                 grafana_password: Optional[str] = None,
                 grafana_user: Optional[str] = None,
                 splunk_hecendpoint: Optional[str] = None,
                 splunk_token: Optional[str] = None):
        """
        :param str datadog_api_key: Datadog api key for streaming metrics
        :param str datadog_region: Datadog region for streaming metrics
        :param str grafana_endpoint: Grafana endpoint for streaming metrics
        :param str grafana_password: Grafana password for streaming metrics
        :param str grafana_user: Grafana user for streaming metrics
        :param str splunk_hecendpoint: Splunk endpoint for streaming metrics
        :param str splunk_token: Splunk token for streaming metrics
        """
        if datadog_api_key is not None:
            pulumi.set(__self__, "datadog_api_key", datadog_api_key)
        if datadog_region is not None:
            pulumi.set(__self__, "datadog_region", datadog_region)
        if grafana_endpoint is not None:
            pulumi.set(__self__, "grafana_endpoint", grafana_endpoint)
        if grafana_password is not None:
            pulumi.set(__self__, "grafana_password", grafana_password)
        if grafana_user is not None:
            pulumi.set(__self__, "grafana_user", grafana_user)
        if splunk_hecendpoint is not None:
            pulumi.set(__self__, "splunk_hecendpoint", splunk_hecendpoint)
        if splunk_token is not None:
            pulumi.set(__self__, "splunk_token", splunk_token)

    @property
    @pulumi.getter(name="datadogApiKey")
    def datadog_api_key(self) -> Optional[str]:
        """
        Datadog api key for streaming metrics
        """
        return pulumi.get(self, "datadog_api_key")

    @property
    @pulumi.getter(name="datadogRegion")
    def datadog_region(self) -> Optional[str]:
        """
        Datadog region for streaming metrics
        """
        return pulumi.get(self, "datadog_region")

    @property
    @pulumi.getter(name="grafanaEndpoint")
    def grafana_endpoint(self) -> Optional[str]:
        """
        Grafana endpoint for streaming metrics
        """
        return pulumi.get(self, "grafana_endpoint")

    @property
    @pulumi.getter(name="grafanaPassword")
    def grafana_password(self) -> Optional[str]:
        """
        Grafana password for streaming metrics
        """
        return pulumi.get(self, "grafana_password")

    @property
    @pulumi.getter(name="grafanaUser")
    def grafana_user(self) -> Optional[str]:
        """
        Grafana user for streaming metrics
        """
        return pulumi.get(self, "grafana_user")

    @property
    @pulumi.getter(name="splunkHecendpoint")
    def splunk_hecendpoint(self) -> Optional[str]:
        """
        Splunk endpoint for streaming metrics
        """
        return pulumi.get(self, "splunk_hecendpoint")

    @property
    @pulumi.getter(name="splunkToken")
    def splunk_token(self) -> Optional[str]:
        """
        Splunk token for streaming metrics
        """
        return pulumi.get(self, "splunk_token")


@pulumi.output_type
class GetPackerImageIterationBuildResult(dict):
    def __init__(__self__, *,
                 cloud_provider: str,
                 component_type: str,
                 created_at: str,
                 id: str,
                 images: Sequence['outputs.GetPackerImageIterationBuildImageResult'],
                 labels: Mapping[str, str],
                 packer_run_uuid: str,
                 status: str,
                 updated_at: str):
        """
        :param str cloud_provider: Name of the cloud provider this image is stored-in, if any.
        :param str component_type: Name of the builder that built this. Ex: 'amazon-ebs.example'.
        :param str created_at: Creation time of this build.
        :param str id: HCP ID of this build.
        :param Mapping[str, str] labels: Labels for this build.
        :param str packer_run_uuid: Packer generated UUID of this build.
        :param str status: Status of this build. DONE means that all images tied to this build were successfully built.
        :param str updated_at: Time this build was last updated.
        """
        pulumi.set(__self__, "cloud_provider", cloud_provider)
        pulumi.set(__self__, "component_type", component_type)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "images", images)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "packer_run_uuid", packer_run_uuid)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="cloudProvider")
    def cloud_provider(self) -> str:
        """
        Name of the cloud provider this image is stored-in, if any.
        """
        return pulumi.get(self, "cloud_provider")

    @property
    @pulumi.getter(name="componentType")
    def component_type(self) -> str:
        """
        Name of the builder that built this. Ex: 'amazon-ebs.example'.
        """
        return pulumi.get(self, "component_type")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Creation time of this build.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        HCP ID of this build.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def images(self) -> Sequence['outputs.GetPackerImageIterationBuildImageResult']:
        return pulumi.get(self, "images")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels for this build.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="packerRunUuid")
    def packer_run_uuid(self) -> str:
        """
        Packer generated UUID of this build.
        """
        return pulumi.get(self, "packer_run_uuid")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of this build. DONE means that all images tied to this build were successfully built.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        Time this build was last updated.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetPackerImageIterationBuildImageResult(dict):
    def __init__(__self__, *,
                 created_at: str,
                 id: str,
                 image_id: str,
                 region: str):
        """
        :param str created_at: Creation time of this iteration
        :param str id: The ID of this resource.
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Creation time of this iteration
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of this resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")


@pulumi.output_type
class GetVaultClusterAuditLogConfigResult(dict):
    def __init__(__self__, *,
                 datadog_region: str,
                 grafana_endpoint: str,
                 grafana_user: str,
                 splunk_hecendpoint: str):
        """
        :param str datadog_region: Datadog region for streaming audit logs
        :param str grafana_endpoint: Grafana endpoint for streaming audit logs
        :param str grafana_user: Grafana user for streaming audit logs
        :param str splunk_hecendpoint: Splunk endpoint for streaming audit logs
        """
        pulumi.set(__self__, "datadog_region", datadog_region)
        pulumi.set(__self__, "grafana_endpoint", grafana_endpoint)
        pulumi.set(__self__, "grafana_user", grafana_user)
        pulumi.set(__self__, "splunk_hecendpoint", splunk_hecendpoint)

    @property
    @pulumi.getter(name="datadogRegion")
    def datadog_region(self) -> str:
        """
        Datadog region for streaming audit logs
        """
        return pulumi.get(self, "datadog_region")

    @property
    @pulumi.getter(name="grafanaEndpoint")
    def grafana_endpoint(self) -> str:
        """
        Grafana endpoint for streaming audit logs
        """
        return pulumi.get(self, "grafana_endpoint")

    @property
    @pulumi.getter(name="grafanaUser")
    def grafana_user(self) -> str:
        """
        Grafana user for streaming audit logs
        """
        return pulumi.get(self, "grafana_user")

    @property
    @pulumi.getter(name="splunkHecendpoint")
    def splunk_hecendpoint(self) -> str:
        """
        Splunk endpoint for streaming audit logs
        """
        return pulumi.get(self, "splunk_hecendpoint")


@pulumi.output_type
class GetVaultClusterMajorVersionUpgradeConfigResult(dict):
    def __init__(__self__, *,
                 maintenance_window_day: str,
                 maintenance_window_time: str,
                 upgrade_type: str):
        pulumi.set(__self__, "maintenance_window_day", maintenance_window_day)
        pulumi.set(__self__, "maintenance_window_time", maintenance_window_time)
        pulumi.set(__self__, "upgrade_type", upgrade_type)

    @property
    @pulumi.getter(name="maintenanceWindowDay")
    def maintenance_window_day(self) -> str:
        return pulumi.get(self, "maintenance_window_day")

    @property
    @pulumi.getter(name="maintenanceWindowTime")
    def maintenance_window_time(self) -> str:
        return pulumi.get(self, "maintenance_window_time")

    @property
    @pulumi.getter(name="upgradeType")
    def upgrade_type(self) -> str:
        return pulumi.get(self, "upgrade_type")


@pulumi.output_type
class GetVaultClusterMetricsConfigResult(dict):
    def __init__(__self__, *,
                 datadog_region: str,
                 grafana_endpoint: str,
                 grafana_user: str,
                 splunk_hecendpoint: str):
        """
        :param str datadog_region: Datadog region for streaming metrics
        :param str grafana_endpoint: Grafana endpoint for streaming metrics
        :param str grafana_user: Grafana user for streaming metrics
        :param str splunk_hecendpoint: Splunk endpoint for streaming metrics
        """
        pulumi.set(__self__, "datadog_region", datadog_region)
        pulumi.set(__self__, "grafana_endpoint", grafana_endpoint)
        pulumi.set(__self__, "grafana_user", grafana_user)
        pulumi.set(__self__, "splunk_hecendpoint", splunk_hecendpoint)

    @property
    @pulumi.getter(name="datadogRegion")
    def datadog_region(self) -> str:
        """
        Datadog region for streaming metrics
        """
        return pulumi.get(self, "datadog_region")

    @property
    @pulumi.getter(name="grafanaEndpoint")
    def grafana_endpoint(self) -> str:
        """
        Grafana endpoint for streaming metrics
        """
        return pulumi.get(self, "grafana_endpoint")

    @property
    @pulumi.getter(name="grafanaUser")
    def grafana_user(self) -> str:
        """
        Grafana user for streaming metrics
        """
        return pulumi.get(self, "grafana_user")

    @property
    @pulumi.getter(name="splunkHecendpoint")
    def splunk_hecendpoint(self) -> str:
        """
        Splunk endpoint for streaming metrics
        """
        return pulumi.get(self, "splunk_hecendpoint")


