# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import DataShareManagementClientConfiguration
from .operations import AccountsOperations
from .operations import ConsumerInvitationsOperations
from .operations import DataSetsOperations
from .operations import DataSetMappingsOperations
from .operations import InvitationsOperations
from .operations import Operations
from .operations import SharesOperations
from .operations import ProviderShareSubscriptionsOperations
from .operations import ShareSubscriptionsOperations
from .operations import ConsumerSourceDataSetsOperations
from .operations import SynchronizationSettingsOperations
from .operations import TriggersOperations
from . import models


class DataShareManagementClient(SDKClient):
    """Creates a Microsoft.DataShare management client.

    :ivar config: Configuration for client.
    :vartype config: DataShareManagementClientConfiguration

    :ivar accounts: Accounts operations
    :vartype accounts: azure.mgmt.datashare.operations.AccountsOperations
    :ivar consumer_invitations: ConsumerInvitations operations
    :vartype consumer_invitations: azure.mgmt.datashare.operations.ConsumerInvitationsOperations
    :ivar data_sets: DataSets operations
    :vartype data_sets: azure.mgmt.datashare.operations.DataSetsOperations
    :ivar data_set_mappings: DataSetMappings operations
    :vartype data_set_mappings: azure.mgmt.datashare.operations.DataSetMappingsOperations
    :ivar invitations: Invitations operations
    :vartype invitations: azure.mgmt.datashare.operations.InvitationsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.datashare.operations.Operations
    :ivar shares: Shares operations
    :vartype shares: azure.mgmt.datashare.operations.SharesOperations
    :ivar provider_share_subscriptions: ProviderShareSubscriptions operations
    :vartype provider_share_subscriptions: azure.mgmt.datashare.operations.ProviderShareSubscriptionsOperations
    :ivar share_subscriptions: ShareSubscriptions operations
    :vartype share_subscriptions: azure.mgmt.datashare.operations.ShareSubscriptionsOperations
    :ivar consumer_source_data_sets: ConsumerSourceDataSets operations
    :vartype consumer_source_data_sets: azure.mgmt.datashare.operations.ConsumerSourceDataSetsOperations
    :ivar synchronization_settings: SynchronizationSettings operations
    :vartype synchronization_settings: azure.mgmt.datashare.operations.SynchronizationSettingsOperations
    :ivar triggers: Triggers operations
    :vartype triggers: azure.mgmt.datashare.operations.TriggersOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The subscription identifier
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = DataShareManagementClientConfiguration(credentials, subscription_id, base_url)
        super(DataShareManagementClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2019-11-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.accounts = AccountsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.consumer_invitations = ConsumerInvitationsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.data_sets = DataSetsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.data_set_mappings = DataSetMappingsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.invitations = InvitationsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.shares = SharesOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.provider_share_subscriptions = ProviderShareSubscriptionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.share_subscriptions = ShareSubscriptionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.consumer_source_data_sets = ConsumerSourceDataSetsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.synchronization_settings = SynchronizationSettingsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.triggers = TriggersOperations(
            self._client, self.config, self._serialize, self._deserialize)
