import typing, abc
from System.Numerics import Vector3, Vector2
from System import IFormattable, IEquatable_1, IFormatProvider, Array_1

class MathHelpers(abc.ABC):
    @staticmethod
    def ClampBounds(v: Vector3Int, max: int) -> Vector3Int: ...
    @staticmethod
    def Rotate(vector: Vector2Int, angle: float) -> Vector2Int: ...
    @staticmethod
    def RoundToInt(v: Vector3) -> Vector3Int: ...
    # Skipped NormalizedSafe due to it being static, abstract and generic.

    NormalizedSafe : NormalizedSafe_MethodGroup
    class NormalizedSafe_MethodGroup:
        @typing.overload
        def __call__(self, v: Vector3) -> Vector3:...
        @typing.overload
        def __call__(self, v: Vector3Int) -> Vector3:...

    # Skipped ToUnitDirection due to it being static, abstract and generic.

    ToUnitDirection : ToUnitDirection_MethodGroup
    class ToUnitDirection_MethodGroup:
        @typing.overload
        def __call__(self, v: Vector3Int) -> Vector3Int:...
        @typing.overload
        def __call__(self, v1: Vector3) -> Vector3Int:...



class Vector2Int(IFormattable, IEquatable_1[Vector2Int]):
    def __init__(self, x: int, y: int) -> None: ...
    m_X : int
    m_Y : int
    @classmethod
    @property
    def down(cls) -> Vector2Int: ...
    @property
    def Item(self) -> int: ...
    @Item.setter
    def Item(self, value: int) -> int: ...
    @classmethod
    @property
    def left(cls) -> Vector2Int: ...
    @property
    def magnitude(self) -> float: ...
    @classmethod
    @property
    def one(cls) -> Vector2Int: ...
    @classmethod
    @property
    def right(cls) -> Vector2Int: ...
    @property
    def sqrMagnitude(self) -> int: ...
    @classmethod
    @property
    def up(cls) -> Vector2Int: ...
    @property
    def x(self) -> int: ...
    @x.setter
    def x(self, value: int) -> int: ...
    @property
    def y(self) -> int: ...
    @y.setter
    def y(self, value: int) -> int: ...
    @classmethod
    @property
    def zero(cls) -> Vector2Int: ...
    @staticmethod
    def CeilToInt(v: Vector2) -> Vector2Int: ...
    def Clamp(self, min: Vector2Int, max: Vector2Int) -> None: ...
    @staticmethod
    def Distance(a: Vector2Int, b: Vector2Int) -> float: ...
    @staticmethod
    def FloorToInt(v: Vector2) -> Vector2Int: ...
    def GetHashCode(self) -> int: ...
    @staticmethod
    def ManhattanDistance(a: Vector2Int, b: Vector2Int) -> int: ...
    @staticmethod
    def Max(lhs: Vector2Int, rhs: Vector2Int) -> Vector2Int: ...
    @staticmethod
    def Min(lhs: Vector2Int, rhs: Vector2Int) -> Vector2Int: ...
    def __add__(self, a: Vector2Int, b: Vector2Int) -> Vector2Int: ...
    def __truediv__(self, a: Vector2Int, b: int) -> Vector2Int: ...
    def __eq__(self, lhs: Vector2Int, rhs: Vector2Int) -> bool: ...
    # Operator not supported op_Explicit(v: Vector2Int)
    # Operator not supported op_Implicit(v: Vector2Int)
    def __ne__(self, lhs: Vector2Int, rhs: Vector2Int) -> bool: ...
    @typing.overload
    def __mul__(self, a: int, b: Vector2Int) -> Vector2Int: ...
    @typing.overload
    def __mul__(self, a: Vector2Int, b: int) -> Vector2Int: ...
    @typing.overload
    def __mul__(self, a: Vector2Int, b: Vector2Int) -> Vector2Int: ...
    def __sub__(self, a: Vector2Int, b: Vector2Int) -> Vector2Int: ...
    def __neg__(self, v: Vector2Int) -> Vector2Int: ...
    @staticmethod
    def RoundToInt(v: Vector2) -> Vector2Int: ...
    def Set(self, x: int, y: int) -> None: ...
    def ToVector3IntXZ(self) -> Vector3Int: ...
    # Skipped Equals due to it being static, abstract and generic.

    Equals : Equals_MethodGroup
    class Equals_MethodGroup:
        @typing.overload
        def __call__(self, other: Vector2Int) -> bool:...
        @typing.overload
        def __call__(self, other: typing.Any) -> bool:...

    # Skipped Scale due to it being static, abstract and generic.

    Scale : Scale_MethodGroup
    class Scale_MethodGroup:
        @typing.overload
        def __call__(self, scale: Vector2Int) -> None:...
        @typing.overload
        def __call__(self, a: Vector2Int, b: Vector2Int) -> Vector2Int:...

    # Skipped ToString due to it being static, abstract and generic.

    ToString : ToString_MethodGroup
    class ToString_MethodGroup:
        @typing.overload
        def __call__(self) -> str:...
        @typing.overload
        def __call__(self, format: str) -> str:...
        @typing.overload
        def __call__(self, format: str, formatProvider: IFormatProvider) -> str:...



class Vector3Int(IFormattable, IEquatable_1[Vector3Int]):
    def __init__(self, x: int, y: int, z: int) -> None: ...
    AdjacentDirectionsXZ : Array_1[Vector3Int]
    m_X : int
    m_Y : int
    m_Z : int
    UnitDirectionsXZ : Array_1[Vector3Int]
    @classmethod
    @property
    def back(cls) -> Vector3Int: ...
    @classmethod
    @property
    def down(cls) -> Vector3Int: ...
    @classmethod
    @property
    def forward(cls) -> Vector3Int: ...
    @property
    def Item(self) -> int: ...
    @Item.setter
    def Item(self, value: int) -> int: ...
    @classmethod
    @property
    def left(cls) -> Vector3Int: ...
    @property
    def magnitude(self) -> float: ...
    @classmethod
    @property
    def one(cls) -> Vector3Int: ...
    @classmethod
    @property
    def right(cls) -> Vector3Int: ...
    @property
    def sqrMagnitude(self) -> int: ...
    @classmethod
    @property
    def up(cls) -> Vector3Int: ...
    @property
    def x(self) -> int: ...
    @x.setter
    def x(self, value: int) -> int: ...
    @property
    def y(self) -> int: ...
    @y.setter
    def y(self, value: int) -> int: ...
    @property
    def z(self) -> int: ...
    @z.setter
    def z(self, value: int) -> int: ...
    @classmethod
    @property
    def zero(cls) -> Vector3Int: ...
    @staticmethod
    def CeilToInt(v: Vector3) -> Vector3Int: ...
    def Clamp(self, min: Vector3Int, max: Vector3Int) -> None: ...
    @staticmethod
    def Distance(a: Vector3Int, b: Vector3Int) -> float: ...
    @staticmethod
    def FloorToInt(v: Vector3) -> Vector3Int: ...
    def GetHashCode(self) -> int: ...
    @staticmethod
    def Max(lhs: Vector3Int, rhs: Vector3Int) -> Vector3Int: ...
    @staticmethod
    def Min(lhs: Vector3Int, rhs: Vector3Int) -> Vector3Int: ...
    def MinComponent(self) -> int: ...
    def __add__(self, a: Vector3Int, b: Vector3Int) -> Vector3Int: ...
    def __truediv__(self, a: Vector3Int, b: int) -> Vector3Int: ...
    def __eq__(self, lhs: Vector3Int, rhs: Vector3Int) -> bool: ...
    # Operator not supported op_Explicit(v: Vector3Int)
    # Operator not supported op_Implicit(v: Vector3Int)
    def __ne__(self, lhs: Vector3Int, rhs: Vector3Int) -> bool: ...
    @typing.overload
    def __mul__(self, a: int, b: Vector3Int) -> Vector3Int: ...
    @typing.overload
    def __mul__(self, a: Vector3Int, b: int) -> Vector3Int: ...
    @typing.overload
    def __mul__(self, a: Vector3Int, b: Vector3Int) -> Vector3Int: ...
    def __sub__(self, a: Vector3Int, b: Vector3Int) -> Vector3Int: ...
    def __neg__(self, a: Vector3Int) -> Vector3Int: ...
    @staticmethod
    def RoundToInt(v: Vector3) -> Vector3Int: ...
    def Set(self, x: int, y: int, z: int) -> None: ...
    def WithX(self, newX: int) -> Vector3Int: ...
    def WithY(self, newY: int) -> Vector3Int: ...
    def WithZ(self, newZ: int) -> Vector3Int: ...
    def XZ(self) -> Vector2Int: ...
    # Skipped Equals due to it being static, abstract and generic.

    Equals : Equals_MethodGroup
    class Equals_MethodGroup:
        @typing.overload
        def __call__(self, other: Vector3Int) -> bool:...
        @typing.overload
        def __call__(self, other: typing.Any) -> bool:...

    # Skipped Scale due to it being static, abstract and generic.

    Scale : Scale_MethodGroup
    class Scale_MethodGroup:
        @typing.overload
        def __call__(self, scale: Vector3Int) -> None:...
        @typing.overload
        def __call__(self, a: Vector3Int, b: Vector3Int) -> Vector3Int:...

    # Skipped ToString due to it being static, abstract and generic.

    ToString : ToString_MethodGroup
    class ToString_MethodGroup:
        @typing.overload
        def __call__(self) -> str:...
        @typing.overload
        def __call__(self, format: str) -> str:...
        @typing.overload
        def __call__(self, format: str, formatProvider: IFormatProvider) -> str:...


