import typing, clr, abc
from System import IDisposable, Array_1, Decimal, Half, Span_1, IAsyncDisposable, ReadOnlySpan_1, IAsyncResult, AsyncCallback, Memory_1, ReadOnlyMemory_1, DateTime, Exception, MarshalByRefObject, SystemException, ArraySegment_1, IFormatProvider
from System.Text import Encoding, StringBuilder
from System.Threading.Tasks import ValueTask, Task, ValueTask_1, Task_1
from System.Threading import CancellationToken
from System.Collections.Generic import IEnumerable_1, IReadOnlyList_1
from System.Collections import IDictionary
from System.Reflection import MethodBase
from Microsoft.Win32.SafeHandles import SafeFileHandle
from System.Runtime.Serialization import SerializationInfo, StreamingContext, ISerializable
from System.Runtime.InteropServices import SafeBuffer

class BinaryReader(IDisposable):
    @typing.overload
    def __init__(self, input: Stream) -> None: ...
    @typing.overload
    def __init__(self, input: Stream, encoding: Encoding) -> None: ...
    @typing.overload
    def __init__(self, input: Stream, encoding: Encoding, leaveOpen: bool) -> None: ...
    @property
    def BaseStream(self) -> Stream: ...
    def Close(self) -> None: ...
    def Dispose(self) -> None: ...
    def PeekChar(self) -> int: ...
    def Read7BitEncodedInt(self) -> int: ...
    def Read7BitEncodedInt64(self) -> int: ...
    def ReadBoolean(self) -> bool: ...
    def ReadByte(self) -> int: ...
    def ReadBytes(self, count: int) -> Array_1[int]: ...
    def ReadChar(self) -> str: ...
    def ReadChars(self, count: int) -> Array_1[str]: ...
    def ReadDecimal(self) -> Decimal: ...
    def ReadDouble(self) -> float: ...
    def ReadHalf(self) -> Half: ...
    def ReadInt16(self) -> int: ...
    def ReadInt32(self) -> int: ...
    def ReadInt64(self) -> int: ...
    def ReadSByte(self) -> int: ...
    def ReadSingle(self) -> float: ...
    def ReadString(self) -> str: ...
    def ReadUInt16(self) -> int: ...
    def ReadUInt32(self) -> int: ...
    def ReadUInt64(self) -> int: ...
    # Skipped Read due to it being static, abstract and generic.

    Read : Read_MethodGroup
    class Read_MethodGroup:
        @typing.overload
        def __call__(self) -> int:...
        @typing.overload
        def __call__(self, buffer: Span_1[str]) -> int:...
        @typing.overload
        def __call__(self, buffer: Span_1[int]) -> int:...
        @typing.overload
        def __call__(self, buffer: Array_1[str], index: int, count: int) -> int:...
        @typing.overload
        def __call__(self, buffer: Array_1[int], index: int, count: int) -> int:...



class BinaryWriter(IAsyncDisposable, IDisposable):
    @typing.overload
    def __init__(self, output: Stream) -> None: ...
    @typing.overload
    def __init__(self, output: Stream, encoding: Encoding) -> None: ...
    @typing.overload
    def __init__(self, output: Stream, encoding: Encoding, leaveOpen: bool) -> None: ...
    Null : BinaryWriter
    @property
    def BaseStream(self) -> Stream: ...
    def Close(self) -> None: ...
    def Dispose(self) -> None: ...
    def DisposeAsync(self) -> ValueTask: ...
    def Flush(self) -> None: ...
    def Seek(self, offset: int, origin: SeekOrigin) -> int: ...
    def Write7BitEncodedInt(self, value: int) -> None: ...
    def Write7BitEncodedInt64(self, value: int) -> None: ...
    # Skipped Write due to it being static, abstract and generic.

    Write : Write_MethodGroup
    class Write_MethodGroup:
        @typing.overload
        def __call__(self, value: float) -> None:...
        # Method Write(value : Single) was skipped since it collides with above method
        @typing.overload
        def __call__(self, value: Half) -> None:...
        @typing.overload
        def __call__(self, ch: str) -> None:...
        # Method Write(value : Byte) was skipped since it collides with above method
        # Method Write(value : SByte) was skipped since it collides with above method
        # Method Write(value : Int16) was skipped since it collides with above method
        # Method Write(value : UInt16) was skipped since it collides with above method
        # Method Write(value : Int32) was skipped since it collides with above method
        # Method Write(value : UInt32) was skipped since it collides with above method
        # Method Write(value : Int64) was skipped since it collides with above method
        # Method Write(value : UInt64) was skipped since it collides with above method
        @typing.overload
        def __call__(self, value: Decimal) -> None:...
        @typing.overload
        def __call__(self, buffer: Array_1[int]) -> None:...
        @typing.overload
        def __call__(self, chars: Array_1[str]) -> None:...
        @typing.overload
        def __call__(self, buffer: ReadOnlySpan_1[int]) -> None:...
        @typing.overload
        def __call__(self, chars: ReadOnlySpan_1[str]) -> None:...
        # Method Write(value : Boolean) was skipped since it collides with above method
        # Method Write(value : String) was skipped since it collides with above method
        @typing.overload
        def __call__(self, buffer: Array_1[int], index: int, count: int) -> None:...
        @typing.overload
        def __call__(self, chars: Array_1[str], index: int, count: int) -> None:...



class BufferedStream(Stream):
    @typing.overload
    def __init__(self, stream: Stream) -> None: ...
    @typing.overload
    def __init__(self, stream: Stream, bufferSize: int) -> None: ...
    @property
    def BufferSize(self) -> int: ...
    @property
    def CanRead(self) -> bool: ...
    @property
    def CanSeek(self) -> bool: ...
    @property
    def CanTimeout(self) -> bool: ...
    @property
    def CanWrite(self) -> bool: ...
    @property
    def Length(self) -> int: ...
    @property
    def Position(self) -> int: ...
    @Position.setter
    def Position(self, value: int) -> int: ...
    @property
    def ReadTimeout(self) -> int: ...
    @ReadTimeout.setter
    def ReadTimeout(self, value: int) -> int: ...
    @property
    def UnderlyingStream(self) -> Stream: ...
    @property
    def WriteTimeout(self) -> int: ...
    @WriteTimeout.setter
    def WriteTimeout(self, value: int) -> int: ...
    def BeginRead(self, buffer: Array_1[int], offset: int, count: int, callback: AsyncCallback, state: typing.Any) -> IAsyncResult: ...
    def BeginWrite(self, buffer: Array_1[int], offset: int, count: int, callback: AsyncCallback, state: typing.Any) -> IAsyncResult: ...
    def CopyTo(self, destination: Stream, bufferSize: int) -> None: ...
    def CopyToAsync(self, destination: Stream, bufferSize: int, cancellationToken: CancellationToken) -> Task: ...
    def DisposeAsync(self) -> ValueTask: ...
    def EndRead(self, asyncResult: IAsyncResult) -> int: ...
    def EndWrite(self, asyncResult: IAsyncResult) -> None: ...
    def Flush(self) -> None: ...
    def FlushAsync(self, cancellationToken: CancellationToken) -> Task: ...
    def ReadByte(self) -> int: ...
    def Seek(self, offset: int, origin: SeekOrigin) -> int: ...
    def SetLength(self, value: int) -> None: ...
    def WriteByte(self, value: int) -> None: ...
    # Skipped Read due to it being static, abstract and generic.

    Read : Read_MethodGroup
    class Read_MethodGroup:
        @typing.overload
        def __call__(self, destination: Span_1[int]) -> int:...
        @typing.overload
        def __call__(self, buffer: Array_1[int], offset: int, count: int) -> int:...

    # Skipped ReadAsync due to it being static, abstract and generic.

    ReadAsync : ReadAsync_MethodGroup
    class ReadAsync_MethodGroup:
        @typing.overload
        def __call__(self, buffer: Memory_1[int], cancellationToken: CancellationToken = ...) -> ValueTask_1[int]:...
        @typing.overload
        def __call__(self, buffer: Array_1[int], offset: int, count: int, cancellationToken: CancellationToken) -> Task_1[int]:...

    # Skipped Write due to it being static, abstract and generic.

    Write : Write_MethodGroup
    class Write_MethodGroup:
        @typing.overload
        def __call__(self, buffer: ReadOnlySpan_1[int]) -> None:...
        @typing.overload
        def __call__(self, buffer: Array_1[int], offset: int, count: int) -> None:...

    # Skipped WriteAsync due to it being static, abstract and generic.

    WriteAsync : WriteAsync_MethodGroup
    class WriteAsync_MethodGroup:
        @typing.overload
        def __call__(self, buffer: ReadOnlyMemory_1[int], cancellationToken: CancellationToken = ...) -> ValueTask:...
        @typing.overload
        def __call__(self, buffer: Array_1[int], offset: int, count: int, cancellationToken: CancellationToken) -> Task:...



class Directory(abc.ABC):
    @staticmethod
    def CreateDirectory(path: str) -> DirectoryInfo: ...
    @staticmethod
    def CreateSymbolicLink(path: str, pathToTarget: str) -> FileSystemInfo: ...
    @staticmethod
    def Exists(path: str) -> bool: ...
    @staticmethod
    def GetCreationTime(path: str) -> DateTime: ...
    @staticmethod
    def GetCreationTimeUtc(path: str) -> DateTime: ...
    @staticmethod
    def GetCurrentDirectory() -> str: ...
    @staticmethod
    def GetDirectoryRoot(path: str) -> str: ...
    @staticmethod
    def GetLastAccessTime(path: str) -> DateTime: ...
    @staticmethod
    def GetLastAccessTimeUtc(path: str) -> DateTime: ...
    @staticmethod
    def GetLastWriteTime(path: str) -> DateTime: ...
    @staticmethod
    def GetLastWriteTimeUtc(path: str) -> DateTime: ...
    @staticmethod
    def GetLogicalDrives() -> Array_1[str]: ...
    @staticmethod
    def GetParent(path: str) -> DirectoryInfo: ...
    @staticmethod
    def Move(sourceDirName: str, destDirName: str) -> None: ...
    @staticmethod
    def ResolveLinkTarget(linkPath: str, returnFinalTarget: bool) -> FileSystemInfo: ...
    @staticmethod
    def SetCreationTime(path: str, creationTime: DateTime) -> None: ...
    @staticmethod
    def SetCreationTimeUtc(path: str, creationTimeUtc: DateTime) -> None: ...
    @staticmethod
    def SetCurrentDirectory(path: str) -> None: ...
    @staticmethod
    def SetLastAccessTime(path: str, lastAccessTime: DateTime) -> None: ...
    @staticmethod
    def SetLastAccessTimeUtc(path: str, lastAccessTimeUtc: DateTime) -> None: ...
    @staticmethod
    def SetLastWriteTime(path: str, lastWriteTime: DateTime) -> None: ...
    @staticmethod
    def SetLastWriteTimeUtc(path: str, lastWriteTimeUtc: DateTime) -> None: ...
    # Skipped Delete due to it being static, abstract and generic.

    Delete : Delete_MethodGroup
    class Delete_MethodGroup:
        @typing.overload
        def __call__(self, path: str) -> None:...
        @typing.overload
        def __call__(self, path: str, recursive: bool) -> None:...

    # Skipped EnumerateDirectories due to it being static, abstract and generic.

    EnumerateDirectories : EnumerateDirectories_MethodGroup
    class EnumerateDirectories_MethodGroup:
        @typing.overload
        def __call__(self, path: str) -> IEnumerable_1[str]:...
        @typing.overload
        def __call__(self, path: str, searchPattern: str) -> IEnumerable_1[str]:...
        @typing.overload
        def __call__(self, path: str, searchPattern: str, searchOption: SearchOption) -> IEnumerable_1[str]:...
        @typing.overload
        def __call__(self, path: str, searchPattern: str, enumerationOptions: EnumerationOptions) -> IEnumerable_1[str]:...

    # Skipped EnumerateFiles due to it being static, abstract and generic.

    EnumerateFiles : EnumerateFiles_MethodGroup
    class EnumerateFiles_MethodGroup:
        @typing.overload
        def __call__(self, path: str) -> IEnumerable_1[str]:...
        @typing.overload
        def __call__(self, path: str, searchPattern: str) -> IEnumerable_1[str]:...
        @typing.overload
        def __call__(self, path: str, searchPattern: str, searchOption: SearchOption) -> IEnumerable_1[str]:...
        @typing.overload
        def __call__(self, path: str, searchPattern: str, enumerationOptions: EnumerationOptions) -> IEnumerable_1[str]:...

    # Skipped EnumerateFileSystemEntries due to it being static, abstract and generic.

    EnumerateFileSystemEntries : EnumerateFileSystemEntries_MethodGroup
    class EnumerateFileSystemEntries_MethodGroup:
        @typing.overload
        def __call__(self, path: str) -> IEnumerable_1[str]:...
        @typing.overload
        def __call__(self, path: str, searchPattern: str) -> IEnumerable_1[str]:...
        @typing.overload
        def __call__(self, path: str, searchPattern: str, searchOption: SearchOption) -> IEnumerable_1[str]:...
        @typing.overload
        def __call__(self, path: str, searchPattern: str, enumerationOptions: EnumerationOptions) -> IEnumerable_1[str]:...

    # Skipped GetDirectories due to it being static, abstract and generic.

    GetDirectories : GetDirectories_MethodGroup
    class GetDirectories_MethodGroup:
        @typing.overload
        def __call__(self, path: str) -> Array_1[str]:...
        @typing.overload
        def __call__(self, path: str, searchPattern: str) -> Array_1[str]:...
        @typing.overload
        def __call__(self, path: str, searchPattern: str, searchOption: SearchOption) -> Array_1[str]:...
        @typing.overload
        def __call__(self, path: str, searchPattern: str, enumerationOptions: EnumerationOptions) -> Array_1[str]:...

    # Skipped GetFiles due to it being static, abstract and generic.

    GetFiles : GetFiles_MethodGroup
    class GetFiles_MethodGroup:
        @typing.overload
        def __call__(self, path: str) -> Array_1[str]:...
        @typing.overload
        def __call__(self, path: str, searchPattern: str) -> Array_1[str]:...
        @typing.overload
        def __call__(self, path: str, searchPattern: str, searchOption: SearchOption) -> Array_1[str]:...
        @typing.overload
        def __call__(self, path: str, searchPattern: str, enumerationOptions: EnumerationOptions) -> Array_1[str]:...

    # Skipped GetFileSystemEntries due to it being static, abstract and generic.

    GetFileSystemEntries : GetFileSystemEntries_MethodGroup
    class GetFileSystemEntries_MethodGroup:
        @typing.overload
        def __call__(self, path: str) -> Array_1[str]:...
        @typing.overload
        def __call__(self, path: str, searchPattern: str) -> Array_1[str]:...
        @typing.overload
        def __call__(self, path: str, searchPattern: str, searchOption: SearchOption) -> Array_1[str]:...
        @typing.overload
        def __call__(self, path: str, searchPattern: str, enumerationOptions: EnumerationOptions) -> Array_1[str]:...



class DirectoryInfo(FileSystemInfo):
    def __init__(self, path: str) -> None: ...
    @property
    def Attributes(self) -> FileAttributes: ...
    @Attributes.setter
    def Attributes(self, value: FileAttributes) -> FileAttributes: ...
    @property
    def CreationTime(self) -> DateTime: ...
    @CreationTime.setter
    def CreationTime(self, value: DateTime) -> DateTime: ...
    @property
    def CreationTimeUtc(self) -> DateTime: ...
    @CreationTimeUtc.setter
    def CreationTimeUtc(self, value: DateTime) -> DateTime: ...
    @property
    def Exists(self) -> bool: ...
    @property
    def Extension(self) -> str: ...
    @property
    def FullName(self) -> str: ...
    @property
    def LastAccessTime(self) -> DateTime: ...
    @LastAccessTime.setter
    def LastAccessTime(self, value: DateTime) -> DateTime: ...
    @property
    def LastAccessTimeUtc(self) -> DateTime: ...
    @LastAccessTimeUtc.setter
    def LastAccessTimeUtc(self, value: DateTime) -> DateTime: ...
    @property
    def LastWriteTime(self) -> DateTime: ...
    @LastWriteTime.setter
    def LastWriteTime(self, value: DateTime) -> DateTime: ...
    @property
    def LastWriteTimeUtc(self) -> DateTime: ...
    @LastWriteTimeUtc.setter
    def LastWriteTimeUtc(self, value: DateTime) -> DateTime: ...
    @property
    def LinkTarget(self) -> str: ...
    @property
    def Name(self) -> str: ...
    @property
    def Parent(self) -> DirectoryInfo: ...
    @property
    def Root(self) -> DirectoryInfo: ...
    def Create(self) -> None: ...
    def CreateSubdirectory(self, path: str) -> DirectoryInfo: ...
    def MoveTo(self, destDirName: str) -> None: ...
    # Skipped Delete due to it being static, abstract and generic.

    Delete : Delete_MethodGroup
    class Delete_MethodGroup:
        @typing.overload
        def __call__(self) -> None:...
        @typing.overload
        def __call__(self, recursive: bool) -> None:...

    # Skipped EnumerateDirectories due to it being static, abstract and generic.

    EnumerateDirectories : EnumerateDirectories_MethodGroup
    class EnumerateDirectories_MethodGroup:
        @typing.overload
        def __call__(self) -> IEnumerable_1[DirectoryInfo]:...
        @typing.overload
        def __call__(self, searchPattern: str) -> IEnumerable_1[DirectoryInfo]:...
        @typing.overload
        def __call__(self, searchPattern: str, searchOption: SearchOption) -> IEnumerable_1[DirectoryInfo]:...
        @typing.overload
        def __call__(self, searchPattern: str, enumerationOptions: EnumerationOptions) -> IEnumerable_1[DirectoryInfo]:...

    # Skipped EnumerateFiles due to it being static, abstract and generic.

    EnumerateFiles : EnumerateFiles_MethodGroup
    class EnumerateFiles_MethodGroup:
        @typing.overload
        def __call__(self) -> IEnumerable_1[FileInfo]:...
        @typing.overload
        def __call__(self, searchPattern: str) -> IEnumerable_1[FileInfo]:...
        @typing.overload
        def __call__(self, searchPattern: str, searchOption: SearchOption) -> IEnumerable_1[FileInfo]:...
        @typing.overload
        def __call__(self, searchPattern: str, enumerationOptions: EnumerationOptions) -> IEnumerable_1[FileInfo]:...

    # Skipped EnumerateFileSystemInfos due to it being static, abstract and generic.

    EnumerateFileSystemInfos : EnumerateFileSystemInfos_MethodGroup
    class EnumerateFileSystemInfos_MethodGroup:
        @typing.overload
        def __call__(self) -> IEnumerable_1[FileSystemInfo]:...
        @typing.overload
        def __call__(self, searchPattern: str) -> IEnumerable_1[FileSystemInfo]:...
        @typing.overload
        def __call__(self, searchPattern: str, searchOption: SearchOption) -> IEnumerable_1[FileSystemInfo]:...
        @typing.overload
        def __call__(self, searchPattern: str, enumerationOptions: EnumerationOptions) -> IEnumerable_1[FileSystemInfo]:...

    # Skipped GetDirectories due to it being static, abstract and generic.

    GetDirectories : GetDirectories_MethodGroup
    class GetDirectories_MethodGroup:
        @typing.overload
        def __call__(self) -> Array_1[DirectoryInfo]:...
        @typing.overload
        def __call__(self, searchPattern: str) -> Array_1[DirectoryInfo]:...
        @typing.overload
        def __call__(self, searchPattern: str, searchOption: SearchOption) -> Array_1[DirectoryInfo]:...
        @typing.overload
        def __call__(self, searchPattern: str, enumerationOptions: EnumerationOptions) -> Array_1[DirectoryInfo]:...

    # Skipped GetFiles due to it being static, abstract and generic.

    GetFiles : GetFiles_MethodGroup
    class GetFiles_MethodGroup:
        @typing.overload
        def __call__(self) -> Array_1[FileInfo]:...
        @typing.overload
        def __call__(self, searchPattern: str) -> Array_1[FileInfo]:...
        @typing.overload
        def __call__(self, searchPattern: str, searchOption: SearchOption) -> Array_1[FileInfo]:...
        @typing.overload
        def __call__(self, searchPattern: str, enumerationOptions: EnumerationOptions) -> Array_1[FileInfo]:...

    # Skipped GetFileSystemInfos due to it being static, abstract and generic.

    GetFileSystemInfos : GetFileSystemInfos_MethodGroup
    class GetFileSystemInfos_MethodGroup:
        @typing.overload
        def __call__(self) -> Array_1[FileSystemInfo]:...
        @typing.overload
        def __call__(self, searchPattern: str) -> Array_1[FileSystemInfo]:...
        @typing.overload
        def __call__(self, searchPattern: str, searchOption: SearchOption) -> Array_1[FileSystemInfo]:...
        @typing.overload
        def __call__(self, searchPattern: str, enumerationOptions: EnumerationOptions) -> Array_1[FileSystemInfo]:...



class DirectoryNotFoundException(IOException):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, innerException: Exception) -> None: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...


class EndOfStreamException(IOException):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, innerException: Exception) -> None: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...


class EnumerationOptions:
    def __init__(self) -> None: ...
    @property
    def AttributesToSkip(self) -> FileAttributes: ...
    @AttributesToSkip.setter
    def AttributesToSkip(self, value: FileAttributes) -> FileAttributes: ...
    @property
    def BufferSize(self) -> int: ...
    @BufferSize.setter
    def BufferSize(self, value: int) -> int: ...
    @property
    def IgnoreInaccessible(self) -> bool: ...
    @IgnoreInaccessible.setter
    def IgnoreInaccessible(self, value: bool) -> bool: ...
    @property
    def MatchCasing(self) -> MatchCasing: ...
    @MatchCasing.setter
    def MatchCasing(self, value: MatchCasing) -> MatchCasing: ...
    @property
    def MatchType(self) -> MatchType: ...
    @MatchType.setter
    def MatchType(self, value: MatchType) -> MatchType: ...
    @property
    def MaxRecursionDepth(self) -> int: ...
    @MaxRecursionDepth.setter
    def MaxRecursionDepth(self, value: int) -> int: ...
    @property
    def RecurseSubdirectories(self) -> bool: ...
    @RecurseSubdirectories.setter
    def RecurseSubdirectories(self, value: bool) -> bool: ...
    @property
    def ReturnSpecialDirectories(self) -> bool: ...
    @ReturnSpecialDirectories.setter
    def ReturnSpecialDirectories(self, value: bool) -> bool: ...


class File(abc.ABC):
    @staticmethod
    def AppendText(path: str) -> StreamWriter: ...
    @staticmethod
    def CreateSymbolicLink(path: str, pathToTarget: str) -> FileSystemInfo: ...
    @staticmethod
    def CreateText(path: str) -> StreamWriter: ...
    @staticmethod
    def Decrypt(path: str) -> None: ...
    @staticmethod
    def Delete(path: str) -> None: ...
    @staticmethod
    def Encrypt(path: str) -> None: ...
    @staticmethod
    def Exists(path: str) -> bool: ...
    @staticmethod
    def GetAttributes(path: str) -> FileAttributes: ...
    @staticmethod
    def GetCreationTime(path: str) -> DateTime: ...
    @staticmethod
    def GetCreationTimeUtc(path: str) -> DateTime: ...
    @staticmethod
    def GetLastAccessTime(path: str) -> DateTime: ...
    @staticmethod
    def GetLastAccessTimeUtc(path: str) -> DateTime: ...
    @staticmethod
    def GetLastWriteTime(path: str) -> DateTime: ...
    @staticmethod
    def GetLastWriteTimeUtc(path: str) -> DateTime: ...
    @staticmethod
    def OpenHandle(path: str, mode: FileMode = ..., access: FileAccess = ..., share: FileShare = ..., options: FileOptions = ..., preallocationSize: int = ...) -> SafeFileHandle: ...
    @staticmethod
    def OpenRead(path: str) -> FileStream: ...
    @staticmethod
    def OpenText(path: str) -> StreamReader: ...
    @staticmethod
    def OpenWrite(path: str) -> FileStream: ...
    @staticmethod
    def ReadAllBytes(path: str) -> Array_1[int]: ...
    @staticmethod
    def ReadAllBytesAsync(path: str, cancellationToken: CancellationToken = ...) -> Task_1[Array_1[int]]: ...
    @staticmethod
    def ResolveLinkTarget(linkPath: str, returnFinalTarget: bool) -> FileSystemInfo: ...
    @staticmethod
    def SetAttributes(path: str, fileAttributes: FileAttributes) -> None: ...
    @staticmethod
    def SetCreationTime(path: str, creationTime: DateTime) -> None: ...
    @staticmethod
    def SetCreationTimeUtc(path: str, creationTimeUtc: DateTime) -> None: ...
    @staticmethod
    def SetLastAccessTime(path: str, lastAccessTime: DateTime) -> None: ...
    @staticmethod
    def SetLastAccessTimeUtc(path: str, lastAccessTimeUtc: DateTime) -> None: ...
    @staticmethod
    def SetLastWriteTime(path: str, lastWriteTime: DateTime) -> None: ...
    @staticmethod
    def SetLastWriteTimeUtc(path: str, lastWriteTimeUtc: DateTime) -> None: ...
    @staticmethod
    def WriteAllBytes(path: str, bytes: Array_1[int]) -> None: ...
    @staticmethod
    def WriteAllBytesAsync(path: str, bytes: Array_1[int], cancellationToken: CancellationToken = ...) -> Task: ...
    # Skipped AppendAllLines due to it being static, abstract and generic.

    AppendAllLines : AppendAllLines_MethodGroup
    class AppendAllLines_MethodGroup:
        @typing.overload
        def __call__(self, path: str, contents: IEnumerable_1[str]) -> None:...
        @typing.overload
        def __call__(self, path: str, contents: IEnumerable_1[str], encoding: Encoding) -> None:...

    # Skipped AppendAllLinesAsync due to it being static, abstract and generic.

    AppendAllLinesAsync : AppendAllLinesAsync_MethodGroup
    class AppendAllLinesAsync_MethodGroup:
        @typing.overload
        def __call__(self, path: str, contents: IEnumerable_1[str], cancellationToken: CancellationToken = ...) -> Task:...
        @typing.overload
        def __call__(self, path: str, contents: IEnumerable_1[str], encoding: Encoding, cancellationToken: CancellationToken = ...) -> Task:...

    # Skipped AppendAllText due to it being static, abstract and generic.

    AppendAllText : AppendAllText_MethodGroup
    class AppendAllText_MethodGroup:
        @typing.overload
        def __call__(self, path: str, contents: str) -> None:...
        @typing.overload
        def __call__(self, path: str, contents: str, encoding: Encoding) -> None:...

    # Skipped AppendAllTextAsync due to it being static, abstract and generic.

    AppendAllTextAsync : AppendAllTextAsync_MethodGroup
    class AppendAllTextAsync_MethodGroup:
        @typing.overload
        def __call__(self, path: str, contents: str, cancellationToken: CancellationToken = ...) -> Task:...
        @typing.overload
        def __call__(self, path: str, contents: str, encoding: Encoding, cancellationToken: CancellationToken = ...) -> Task:...

    # Skipped Copy due to it being static, abstract and generic.

    Copy : Copy_MethodGroup
    class Copy_MethodGroup:
        @typing.overload
        def __call__(self, sourceFileName: str, destFileName: str) -> None:...
        @typing.overload
        def __call__(self, sourceFileName: str, destFileName: str, overwrite: bool) -> None:...

    # Skipped Create due to it being static, abstract and generic.

    Create : Create_MethodGroup
    class Create_MethodGroup:
        @typing.overload
        def __call__(self, path: str) -> FileStream:...
        @typing.overload
        def __call__(self, path: str, bufferSize: int) -> FileStream:...
        @typing.overload
        def __call__(self, path: str, bufferSize: int, options: FileOptions) -> FileStream:...

    # Skipped Move due to it being static, abstract and generic.

    Move : Move_MethodGroup
    class Move_MethodGroup:
        @typing.overload
        def __call__(self, sourceFileName: str, destFileName: str) -> None:...
        @typing.overload
        def __call__(self, sourceFileName: str, destFileName: str, overwrite: bool) -> None:...

    # Skipped Open due to it being static, abstract and generic.

    Open : Open_MethodGroup
    class Open_MethodGroup:
        @typing.overload
        def __call__(self, path: str, mode: FileMode) -> FileStream:...
        @typing.overload
        def __call__(self, path: str, options: FileStreamOptions) -> FileStream:...
        @typing.overload
        def __call__(self, path: str, mode: FileMode, access: FileAccess) -> FileStream:...
        @typing.overload
        def __call__(self, path: str, mode: FileMode, access: FileAccess, share: FileShare) -> FileStream:...

    # Skipped ReadAllLines due to it being static, abstract and generic.

    ReadAllLines : ReadAllLines_MethodGroup
    class ReadAllLines_MethodGroup:
        @typing.overload
        def __call__(self, path: str) -> Array_1[str]:...
        @typing.overload
        def __call__(self, path: str, encoding: Encoding) -> Array_1[str]:...

    # Skipped ReadAllLinesAsync due to it being static, abstract and generic.

    ReadAllLinesAsync : ReadAllLinesAsync_MethodGroup
    class ReadAllLinesAsync_MethodGroup:
        @typing.overload
        def __call__(self, path: str, cancellationToken: CancellationToken = ...) -> Task_1[Array_1[str]]:...
        @typing.overload
        def __call__(self, path: str, encoding: Encoding, cancellationToken: CancellationToken = ...) -> Task_1[Array_1[str]]:...

    # Skipped ReadAllText due to it being static, abstract and generic.

    ReadAllText : ReadAllText_MethodGroup
    class ReadAllText_MethodGroup:
        @typing.overload
        def __call__(self, path: str) -> str:...
        @typing.overload
        def __call__(self, path: str, encoding: Encoding) -> str:...

    # Skipped ReadAllTextAsync due to it being static, abstract and generic.

    ReadAllTextAsync : ReadAllTextAsync_MethodGroup
    class ReadAllTextAsync_MethodGroup:
        @typing.overload
        def __call__(self, path: str, cancellationToken: CancellationToken = ...) -> Task_1[str]:...
        @typing.overload
        def __call__(self, path: str, encoding: Encoding, cancellationToken: CancellationToken = ...) -> Task_1[str]:...

    # Skipped ReadLines due to it being static, abstract and generic.

    ReadLines : ReadLines_MethodGroup
    class ReadLines_MethodGroup:
        @typing.overload
        def __call__(self, path: str) -> IEnumerable_1[str]:...
        @typing.overload
        def __call__(self, path: str, encoding: Encoding) -> IEnumerable_1[str]:...

    # Skipped Replace due to it being static, abstract and generic.

    Replace : Replace_MethodGroup
    class Replace_MethodGroup:
        @typing.overload
        def __call__(self, sourceFileName: str, destinationFileName: str, destinationBackupFileName: str) -> None:...
        @typing.overload
        def __call__(self, sourceFileName: str, destinationFileName: str, destinationBackupFileName: str, ignoreMetadataErrors: bool) -> None:...

    # Skipped WriteAllLines due to it being static, abstract and generic.

    WriteAllLines : WriteAllLines_MethodGroup
    class WriteAllLines_MethodGroup:
        @typing.overload
        def __call__(self, path: str, contents: Array_1[str]) -> None:...
        @typing.overload
        def __call__(self, path: str, contents: IEnumerable_1[str]) -> None:...
        @typing.overload
        def __call__(self, path: str, contents: Array_1[str], encoding: Encoding) -> None:...
        @typing.overload
        def __call__(self, path: str, contents: IEnumerable_1[str], encoding: Encoding) -> None:...

    # Skipped WriteAllLinesAsync due to it being static, abstract and generic.

    WriteAllLinesAsync : WriteAllLinesAsync_MethodGroup
    class WriteAllLinesAsync_MethodGroup:
        @typing.overload
        def __call__(self, path: str, contents: IEnumerable_1[str], cancellationToken: CancellationToken = ...) -> Task:...
        @typing.overload
        def __call__(self, path: str, contents: IEnumerable_1[str], encoding: Encoding, cancellationToken: CancellationToken = ...) -> Task:...

    # Skipped WriteAllText due to it being static, abstract and generic.

    WriteAllText : WriteAllText_MethodGroup
    class WriteAllText_MethodGroup:
        @typing.overload
        def __call__(self, path: str, contents: str) -> None:...
        @typing.overload
        def __call__(self, path: str, contents: str, encoding: Encoding) -> None:...

    # Skipped WriteAllTextAsync due to it being static, abstract and generic.

    WriteAllTextAsync : WriteAllTextAsync_MethodGroup
    class WriteAllTextAsync_MethodGroup:
        @typing.overload
        def __call__(self, path: str, contents: str, cancellationToken: CancellationToken = ...) -> Task:...
        @typing.overload
        def __call__(self, path: str, contents: str, encoding: Encoding, cancellationToken: CancellationToken = ...) -> Task:...



class FileAccess(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Read : FileAccess # 1
    Write : FileAccess # 2
    ReadWrite : FileAccess # 3


class FileAttributes(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    ReadOnly : FileAttributes # 1
    Hidden : FileAttributes # 2
    System : FileAttributes # 4
    Directory : FileAttributes # 16
    Archive : FileAttributes # 32
    Device : FileAttributes # 64
    Normal : FileAttributes # 128
    Temporary : FileAttributes # 256
    SparseFile : FileAttributes # 512
    ReparsePoint : FileAttributes # 1024
    Compressed : FileAttributes # 2048
    Offline : FileAttributes # 4096
    NotContentIndexed : FileAttributes # 8192
    Encrypted : FileAttributes # 16384
    IntegrityStream : FileAttributes # 32768
    NoScrubData : FileAttributes # 131072


class FileInfo(FileSystemInfo):
    def __init__(self, fileName: str) -> None: ...
    @property
    def Attributes(self) -> FileAttributes: ...
    @Attributes.setter
    def Attributes(self, value: FileAttributes) -> FileAttributes: ...
    @property
    def CreationTime(self) -> DateTime: ...
    @CreationTime.setter
    def CreationTime(self, value: DateTime) -> DateTime: ...
    @property
    def CreationTimeUtc(self) -> DateTime: ...
    @CreationTimeUtc.setter
    def CreationTimeUtc(self, value: DateTime) -> DateTime: ...
    @property
    def Directory(self) -> DirectoryInfo: ...
    @property
    def DirectoryName(self) -> str: ...
    @property
    def Exists(self) -> bool: ...
    @property
    def Extension(self) -> str: ...
    @property
    def FullName(self) -> str: ...
    @property
    def IsReadOnly(self) -> bool: ...
    @IsReadOnly.setter
    def IsReadOnly(self, value: bool) -> bool: ...
    @property
    def LastAccessTime(self) -> DateTime: ...
    @LastAccessTime.setter
    def LastAccessTime(self, value: DateTime) -> DateTime: ...
    @property
    def LastAccessTimeUtc(self) -> DateTime: ...
    @LastAccessTimeUtc.setter
    def LastAccessTimeUtc(self, value: DateTime) -> DateTime: ...
    @property
    def LastWriteTime(self) -> DateTime: ...
    @LastWriteTime.setter
    def LastWriteTime(self, value: DateTime) -> DateTime: ...
    @property
    def LastWriteTimeUtc(self) -> DateTime: ...
    @LastWriteTimeUtc.setter
    def LastWriteTimeUtc(self, value: DateTime) -> DateTime: ...
    @property
    def Length(self) -> int: ...
    @property
    def LinkTarget(self) -> str: ...
    @property
    def Name(self) -> str: ...
    def AppendText(self) -> StreamWriter: ...
    def Create(self) -> FileStream: ...
    def CreateText(self) -> StreamWriter: ...
    def Decrypt(self) -> None: ...
    def Delete(self) -> None: ...
    def Encrypt(self) -> None: ...
    def OpenRead(self) -> FileStream: ...
    def OpenText(self) -> StreamReader: ...
    def OpenWrite(self) -> FileStream: ...
    # Skipped CopyTo due to it being static, abstract and generic.

    CopyTo : CopyTo_MethodGroup
    class CopyTo_MethodGroup:
        @typing.overload
        def __call__(self, destFileName: str) -> FileInfo:...
        @typing.overload
        def __call__(self, destFileName: str, overwrite: bool) -> FileInfo:...

    # Skipped MoveTo due to it being static, abstract and generic.

    MoveTo : MoveTo_MethodGroup
    class MoveTo_MethodGroup:
        @typing.overload
        def __call__(self, destFileName: str) -> None:...
        @typing.overload
        def __call__(self, destFileName: str, overwrite: bool) -> None:...

    # Skipped Open due to it being static, abstract and generic.

    Open : Open_MethodGroup
    class Open_MethodGroup:
        @typing.overload
        def __call__(self, mode: FileMode) -> FileStream:...
        @typing.overload
        def __call__(self, options: FileStreamOptions) -> FileStream:...
        @typing.overload
        def __call__(self, mode: FileMode, access: FileAccess) -> FileStream:...
        @typing.overload
        def __call__(self, mode: FileMode, access: FileAccess, share: FileShare) -> FileStream:...

    # Skipped Replace due to it being static, abstract and generic.

    Replace : Replace_MethodGroup
    class Replace_MethodGroup:
        @typing.overload
        def __call__(self, destinationFileName: str, destinationBackupFileName: str) -> FileInfo:...
        @typing.overload
        def __call__(self, destinationFileName: str, destinationBackupFileName: str, ignoreMetadataErrors: bool) -> FileInfo:...



class FileLoadException(IOException):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, fileName: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, fileName: str, inner: Exception) -> None: ...
    @typing.overload
    def __init__(self, message: str, inner: Exception) -> None: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def FileName(self) -> str: ...
    @property
    def FusionLog(self) -> str: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...
    def GetObjectData(self, info: SerializationInfo, context: StreamingContext) -> None: ...
    def ToString(self) -> str: ...


class FileMode(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    CreateNew : FileMode # 1
    Create : FileMode # 2
    Open : FileMode # 3
    OpenOrCreate : FileMode # 4
    Truncate : FileMode # 5
    Append : FileMode # 6


class FileNotFoundException(IOException):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, fileName: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, fileName: str, innerException: Exception) -> None: ...
    @typing.overload
    def __init__(self, message: str, innerException: Exception) -> None: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def FileName(self) -> str: ...
    @property
    def FusionLog(self) -> str: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...
    def GetObjectData(self, info: SerializationInfo, context: StreamingContext) -> None: ...
    def ToString(self) -> str: ...


class FileOptions(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : FileOptions # 0
    Encrypted : FileOptions # 16384
    DeleteOnClose : FileOptions # 67108864
    SequentialScan : FileOptions # 134217728
    RandomAccess : FileOptions # 268435456
    Asynchronous : FileOptions # 1073741824
    WriteThrough : FileOptions # -2147483648


class FileShare(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : FileShare # 0
    Read : FileShare # 1
    Write : FileShare # 2
    ReadWrite : FileShare # 3
    Delete : FileShare # 4
    Inheritable : FileShare # 16


class FileStream(Stream):
    @typing.overload
    def __init__(self, handle: int, access: FileAccess) -> None: ...
    @typing.overload
    def __init__(self, handle: SafeFileHandle, access: FileAccess) -> None: ...
    @typing.overload
    def __init__(self, handle: SafeFileHandle, access: FileAccess, bufferSize: int) -> None: ...
    @typing.overload
    def __init__(self, handle: SafeFileHandle, access: FileAccess, bufferSize: int, isAsync: bool) -> None: ...
    @typing.overload
    def __init__(self, handle: int, access: FileAccess, ownsHandle: bool) -> None: ...
    @typing.overload
    def __init__(self, handle: int, access: FileAccess, ownsHandle: bool, bufferSize: int) -> None: ...
    @typing.overload
    def __init__(self, handle: int, access: FileAccess, ownsHandle: bool, bufferSize: int, isAsync: bool) -> None: ...
    @typing.overload
    def __init__(self, path: str, mode: FileMode) -> None: ...
    @typing.overload
    def __init__(self, path: str, mode: FileMode, access: FileAccess) -> None: ...
    @typing.overload
    def __init__(self, path: str, mode: FileMode, access: FileAccess, share: FileShare) -> None: ...
    @typing.overload
    def __init__(self, path: str, mode: FileMode, access: FileAccess, share: FileShare, bufferSize: int) -> None: ...
    @typing.overload
    def __init__(self, path: str, mode: FileMode, access: FileAccess, share: FileShare, bufferSize: int, options: FileOptions) -> None: ...
    @typing.overload
    def __init__(self, path: str, mode: FileMode, access: FileAccess, share: FileShare, bufferSize: int, useAsync: bool) -> None: ...
    @typing.overload
    def __init__(self, path: str, options: FileStreamOptions) -> None: ...
    @property
    def CanRead(self) -> bool: ...
    @property
    def CanSeek(self) -> bool: ...
    @property
    def CanTimeout(self) -> bool: ...
    @property
    def CanWrite(self) -> bool: ...
    @property
    def Handle(self) -> int: ...
    @property
    def IsAsync(self) -> bool: ...
    @property
    def Length(self) -> int: ...
    @property
    def Name(self) -> str: ...
    @property
    def Position(self) -> int: ...
    @Position.setter
    def Position(self, value: int) -> int: ...
    @property
    def ReadTimeout(self) -> int: ...
    @ReadTimeout.setter
    def ReadTimeout(self, value: int) -> int: ...
    @property
    def SafeFileHandle(self) -> SafeFileHandle: ...
    @property
    def WriteTimeout(self) -> int: ...
    @WriteTimeout.setter
    def WriteTimeout(self, value: int) -> int: ...
    def BeginRead(self, buffer: Array_1[int], offset: int, count: int, callback: AsyncCallback, state: typing.Any) -> IAsyncResult: ...
    def BeginWrite(self, buffer: Array_1[int], offset: int, count: int, callback: AsyncCallback, state: typing.Any) -> IAsyncResult: ...
    def CopyTo(self, destination: Stream, bufferSize: int) -> None: ...
    def CopyToAsync(self, destination: Stream, bufferSize: int, cancellationToken: CancellationToken) -> Task: ...
    def DisposeAsync(self) -> ValueTask: ...
    def EndRead(self, asyncResult: IAsyncResult) -> int: ...
    def EndWrite(self, asyncResult: IAsyncResult) -> None: ...
    def FlushAsync(self, cancellationToken: CancellationToken) -> Task: ...
    def Lock(self, position: int, length: int) -> None: ...
    def ReadByte(self) -> int: ...
    def Seek(self, offset: int, origin: SeekOrigin) -> int: ...
    def SetLength(self, value: int) -> None: ...
    def Unlock(self, position: int, length: int) -> None: ...
    def WriteByte(self, value: int) -> None: ...
    # Skipped Flush due to it being static, abstract and generic.

    Flush : Flush_MethodGroup
    class Flush_MethodGroup:
        @typing.overload
        def __call__(self) -> None:...
        @typing.overload
        def __call__(self, flushToDisk: bool) -> None:...

    # Skipped Read due to it being static, abstract and generic.

    Read : Read_MethodGroup
    class Read_MethodGroup:
        @typing.overload
        def __call__(self, buffer: Span_1[int]) -> int:...
        @typing.overload
        def __call__(self, buffer: Array_1[int], offset: int, count: int) -> int:...

    # Skipped ReadAsync due to it being static, abstract and generic.

    ReadAsync : ReadAsync_MethodGroup
    class ReadAsync_MethodGroup:
        @typing.overload
        def __call__(self, buffer: Memory_1[int], cancellationToken: CancellationToken = ...) -> ValueTask_1[int]:...
        @typing.overload
        def __call__(self, buffer: Array_1[int], offset: int, count: int, cancellationToken: CancellationToken) -> Task_1[int]:...

    # Skipped Write due to it being static, abstract and generic.

    Write : Write_MethodGroup
    class Write_MethodGroup:
        @typing.overload
        def __call__(self, buffer: ReadOnlySpan_1[int]) -> None:...
        @typing.overload
        def __call__(self, buffer: Array_1[int], offset: int, count: int) -> None:...

    # Skipped WriteAsync due to it being static, abstract and generic.

    WriteAsync : WriteAsync_MethodGroup
    class WriteAsync_MethodGroup:
        @typing.overload
        def __call__(self, buffer: ReadOnlyMemory_1[int], cancellationToken: CancellationToken = ...) -> ValueTask:...
        @typing.overload
        def __call__(self, buffer: Array_1[int], offset: int, count: int, cancellationToken: CancellationToken) -> Task:...



class FileStreamOptions:
    def __init__(self) -> None: ...
    @property
    def Access(self) -> FileAccess: ...
    @Access.setter
    def Access(self, value: FileAccess) -> FileAccess: ...
    @property
    def BufferSize(self) -> int: ...
    @BufferSize.setter
    def BufferSize(self, value: int) -> int: ...
    @property
    def Mode(self) -> FileMode: ...
    @Mode.setter
    def Mode(self, value: FileMode) -> FileMode: ...
    @property
    def Options(self) -> FileOptions: ...
    @Options.setter
    def Options(self, value: FileOptions) -> FileOptions: ...
    @property
    def PreallocationSize(self) -> int: ...
    @PreallocationSize.setter
    def PreallocationSize(self, value: int) -> int: ...
    @property
    def Share(self) -> FileShare: ...
    @Share.setter
    def Share(self, value: FileShare) -> FileShare: ...


class FileSystemInfo(MarshalByRefObject, ISerializable):
    @property
    def Attributes(self) -> FileAttributes: ...
    @Attributes.setter
    def Attributes(self, value: FileAttributes) -> FileAttributes: ...
    @property
    def CreationTime(self) -> DateTime: ...
    @CreationTime.setter
    def CreationTime(self, value: DateTime) -> DateTime: ...
    @property
    def CreationTimeUtc(self) -> DateTime: ...
    @CreationTimeUtc.setter
    def CreationTimeUtc(self, value: DateTime) -> DateTime: ...
    @property
    def Exists(self) -> bool: ...
    @property
    def Extension(self) -> str: ...
    @property
    def FullName(self) -> str: ...
    @property
    def LastAccessTime(self) -> DateTime: ...
    @LastAccessTime.setter
    def LastAccessTime(self, value: DateTime) -> DateTime: ...
    @property
    def LastAccessTimeUtc(self) -> DateTime: ...
    @LastAccessTimeUtc.setter
    def LastAccessTimeUtc(self, value: DateTime) -> DateTime: ...
    @property
    def LastWriteTime(self) -> DateTime: ...
    @LastWriteTime.setter
    def LastWriteTime(self, value: DateTime) -> DateTime: ...
    @property
    def LastWriteTimeUtc(self) -> DateTime: ...
    @LastWriteTimeUtc.setter
    def LastWriteTimeUtc(self, value: DateTime) -> DateTime: ...
    @property
    def LinkTarget(self) -> str: ...
    @property
    def Name(self) -> str: ...
    def CreateAsSymbolicLink(self, pathToTarget: str) -> None: ...
    @abc.abstractmethod
    def Delete(self) -> None: ...
    def GetObjectData(self, info: SerializationInfo, context: StreamingContext) -> None: ...
    def Refresh(self) -> None: ...
    def ResolveLinkTarget(self, returnFinalTarget: bool) -> FileSystemInfo: ...
    def ToString(self) -> str: ...


class HandleInheritability(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : HandleInheritability # 0
    Inheritable : HandleInheritability # 1


class InvalidDataException(SystemException):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, innerException: Exception) -> None: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...


class IOException(SystemException):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, hresult: int) -> None: ...
    @typing.overload
    def __init__(self, message: str, innerException: Exception) -> None: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...


class MatchCasing(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    PlatformDefault : MatchCasing # 0
    CaseSensitive : MatchCasing # 1
    CaseInsensitive : MatchCasing # 2


class MatchType(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Simple : MatchType # 0
    Win32 : MatchType # 1


class MemoryStream(Stream):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, buffer: Array_1[int]) -> None: ...
    @typing.overload
    def __init__(self, buffer: Array_1[int], index: int, count: int) -> None: ...
    @typing.overload
    def __init__(self, buffer: Array_1[int], index: int, count: int, writable: bool) -> None: ...
    @typing.overload
    def __init__(self, buffer: Array_1[int], index: int, count: int, writable: bool, publiclyVisible: bool) -> None: ...
    @typing.overload
    def __init__(self, buffer: Array_1[int], writable: bool) -> None: ...
    @typing.overload
    def __init__(self, capacity: int) -> None: ...
    @property
    def CanRead(self) -> bool: ...
    @property
    def CanSeek(self) -> bool: ...
    @property
    def CanTimeout(self) -> bool: ...
    @property
    def CanWrite(self) -> bool: ...
    @property
    def Capacity(self) -> int: ...
    @Capacity.setter
    def Capacity(self, value: int) -> int: ...
    @property
    def Length(self) -> int: ...
    @property
    def Position(self) -> int: ...
    @Position.setter
    def Position(self, value: int) -> int: ...
    @property
    def ReadTimeout(self) -> int: ...
    @ReadTimeout.setter
    def ReadTimeout(self, value: int) -> int: ...
    @property
    def WriteTimeout(self) -> int: ...
    @WriteTimeout.setter
    def WriteTimeout(self, value: int) -> int: ...
    def CopyTo(self, destination: Stream, bufferSize: int) -> None: ...
    def CopyToAsync(self, destination: Stream, bufferSize: int, cancellationToken: CancellationToken) -> Task: ...
    def Flush(self) -> None: ...
    def FlushAsync(self, cancellationToken: CancellationToken) -> Task: ...
    def GetBuffer(self) -> Array_1[int]: ...
    def ReadByte(self) -> int: ...
    def Seek(self, offset: int, loc: SeekOrigin) -> int: ...
    def SetLength(self, value: int) -> None: ...
    def ToArray(self) -> Array_1[int]: ...
    def TryGetBuffer(self, buffer: clr.Reference[ArraySegment_1[int]]) -> bool: ...
    def WriteByte(self, value: int) -> None: ...
    def WriteTo(self, stream: Stream) -> None: ...
    # Skipped Read due to it being static, abstract and generic.

    Read : Read_MethodGroup
    class Read_MethodGroup:
        @typing.overload
        def __call__(self, buffer: Span_1[int]) -> int:...
        @typing.overload
        def __call__(self, buffer: Array_1[int], offset: int, count: int) -> int:...

    # Skipped ReadAsync due to it being static, abstract and generic.

    ReadAsync : ReadAsync_MethodGroup
    class ReadAsync_MethodGroup:
        @typing.overload
        def __call__(self, buffer: Memory_1[int], cancellationToken: CancellationToken = ...) -> ValueTask_1[int]:...
        @typing.overload
        def __call__(self, buffer: Array_1[int], offset: int, count: int, cancellationToken: CancellationToken) -> Task_1[int]:...

    # Skipped Write due to it being static, abstract and generic.

    Write : Write_MethodGroup
    class Write_MethodGroup:
        @typing.overload
        def __call__(self, buffer: ReadOnlySpan_1[int]) -> None:...
        @typing.overload
        def __call__(self, buffer: Array_1[int], offset: int, count: int) -> None:...

    # Skipped WriteAsync due to it being static, abstract and generic.

    WriteAsync : WriteAsync_MethodGroup
    class WriteAsync_MethodGroup:
        @typing.overload
        def __call__(self, buffer: ReadOnlyMemory_1[int], cancellationToken: CancellationToken = ...) -> ValueTask:...
        @typing.overload
        def __call__(self, buffer: Array_1[int], offset: int, count: int, cancellationToken: CancellationToken) -> Task:...



class Path(abc.ABC):
    AltDirectorySeparatorChar : str
    DirectorySeparatorChar : str
    InvalidPathChars : Array_1[str]
    PathSeparator : str
    VolumeSeparatorChar : str
    @staticmethod
    def ChangeExtension(path: str, extension: str) -> str: ...
    @staticmethod
    def GetInvalidFileNameChars() -> Array_1[str]: ...
    @staticmethod
    def GetInvalidPathChars() -> Array_1[str]: ...
    @staticmethod
    def GetRandomFileName() -> str: ...
    @staticmethod
    def GetRelativePath(relativeTo: str, path: str) -> str: ...
    @staticmethod
    def GetTempFileName() -> str: ...
    @staticmethod
    def GetTempPath() -> str: ...
    # Skipped Combine due to it being static, abstract and generic.

    Combine : Combine_MethodGroup
    class Combine_MethodGroup:
        @typing.overload
        def __call__(self, paths: Array_1[str]) -> str:...
        @typing.overload
        def __call__(self, path1: str, path2: str) -> str:...
        @typing.overload
        def __call__(self, path1: str, path2: str, path3: str) -> str:...
        @typing.overload
        def __call__(self, path1: str, path2: str, path3: str, path4: str) -> str:...

    # Skipped EndsInDirectorySeparator due to it being static, abstract and generic.

    EndsInDirectorySeparator : EndsInDirectorySeparator_MethodGroup
    class EndsInDirectorySeparator_MethodGroup:
        @typing.overload
        def __call__(self, path: ReadOnlySpan_1[str]) -> bool:...
        @typing.overload
        def __call__(self, path: str) -> bool:...

    # Skipped GetDirectoryName due to it being static, abstract and generic.

    GetDirectoryName : GetDirectoryName_MethodGroup
    class GetDirectoryName_MethodGroup:
        @typing.overload
        def __call__(self, path: ReadOnlySpan_1[str]) -> ReadOnlySpan_1[str]:...
        @typing.overload
        def __call__(self, path: str) -> str:...

    # Skipped GetExtension due to it being static, abstract and generic.

    GetExtension : GetExtension_MethodGroup
    class GetExtension_MethodGroup:
        @typing.overload
        def __call__(self, path: ReadOnlySpan_1[str]) -> ReadOnlySpan_1[str]:...
        @typing.overload
        def __call__(self, path: str) -> str:...

    # Skipped GetFileName due to it being static, abstract and generic.

    GetFileName : GetFileName_MethodGroup
    class GetFileName_MethodGroup:
        @typing.overload
        def __call__(self, path: ReadOnlySpan_1[str]) -> ReadOnlySpan_1[str]:...
        @typing.overload
        def __call__(self, path: str) -> str:...

    # Skipped GetFileNameWithoutExtension due to it being static, abstract and generic.

    GetFileNameWithoutExtension : GetFileNameWithoutExtension_MethodGroup
    class GetFileNameWithoutExtension_MethodGroup:
        @typing.overload
        def __call__(self, path: ReadOnlySpan_1[str]) -> ReadOnlySpan_1[str]:...
        @typing.overload
        def __call__(self, path: str) -> str:...

    # Skipped GetFullPath due to it being static, abstract and generic.

    GetFullPath : GetFullPath_MethodGroup
    class GetFullPath_MethodGroup:
        @typing.overload
        def __call__(self, path: str) -> str:...
        @typing.overload
        def __call__(self, path: str, basePath: str) -> str:...

    # Skipped GetPathRoot due to it being static, abstract and generic.

    GetPathRoot : GetPathRoot_MethodGroup
    class GetPathRoot_MethodGroup:
        @typing.overload
        def __call__(self, path: ReadOnlySpan_1[str]) -> ReadOnlySpan_1[str]:...
        @typing.overload
        def __call__(self, path: str) -> str:...

    # Skipped HasExtension due to it being static, abstract and generic.

    HasExtension : HasExtension_MethodGroup
    class HasExtension_MethodGroup:
        @typing.overload
        def __call__(self, path: ReadOnlySpan_1[str]) -> bool:...
        @typing.overload
        def __call__(self, path: str) -> bool:...

    # Skipped IsPathFullyQualified due to it being static, abstract and generic.

    IsPathFullyQualified : IsPathFullyQualified_MethodGroup
    class IsPathFullyQualified_MethodGroup:
        @typing.overload
        def __call__(self, path: ReadOnlySpan_1[str]) -> bool:...
        @typing.overload
        def __call__(self, path: str) -> bool:...

    # Skipped IsPathRooted due to it being static, abstract and generic.

    IsPathRooted : IsPathRooted_MethodGroup
    class IsPathRooted_MethodGroup:
        @typing.overload
        def __call__(self, path: ReadOnlySpan_1[str]) -> bool:...
        @typing.overload
        def __call__(self, path: str) -> bool:...

    # Skipped Join due to it being static, abstract and generic.

    Join : Join_MethodGroup
    class Join_MethodGroup:
        @typing.overload
        def __call__(self, paths: Array_1[str]) -> str:...
        @typing.overload
        def __call__(self, path1: ReadOnlySpan_1[str], path2: ReadOnlySpan_1[str]) -> str:...
        @typing.overload
        def __call__(self, path1: str, path2: str) -> str:...
        @typing.overload
        def __call__(self, path1: ReadOnlySpan_1[str], path2: ReadOnlySpan_1[str], path3: ReadOnlySpan_1[str]) -> str:...
        @typing.overload
        def __call__(self, path1: str, path2: str, path3: str) -> str:...
        @typing.overload
        def __call__(self, path1: ReadOnlySpan_1[str], path2: ReadOnlySpan_1[str], path3: ReadOnlySpan_1[str], path4: ReadOnlySpan_1[str]) -> str:...
        @typing.overload
        def __call__(self, path1: str, path2: str, path3: str, path4: str) -> str:...

    # Skipped TrimEndingDirectorySeparator due to it being static, abstract and generic.

    TrimEndingDirectorySeparator : TrimEndingDirectorySeparator_MethodGroup
    class TrimEndingDirectorySeparator_MethodGroup:
        @typing.overload
        def __call__(self, path: ReadOnlySpan_1[str]) -> ReadOnlySpan_1[str]:...
        @typing.overload
        def __call__(self, path: str) -> str:...

    # Skipped TryJoin due to it being static, abstract and generic.

    TryJoin : TryJoin_MethodGroup
    class TryJoin_MethodGroup:
        @typing.overload
        def __call__(self, path1: ReadOnlySpan_1[str], path2: ReadOnlySpan_1[str], destination: Span_1[str], charsWritten: clr.Reference[int]) -> bool:...
        @typing.overload
        def __call__(self, path1: ReadOnlySpan_1[str], path2: ReadOnlySpan_1[str], path3: ReadOnlySpan_1[str], destination: Span_1[str], charsWritten: clr.Reference[int]) -> bool:...



class PathTooLongException(IOException):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, innerException: Exception) -> None: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...


class RandomAccess(abc.ABC):
    @staticmethod
    def GetLength(handle: SafeFileHandle) -> int: ...
    # Skipped Read due to it being static, abstract and generic.

    Read : Read_MethodGroup
    class Read_MethodGroup:
        @typing.overload
        def __call__(self, handle: SafeFileHandle, buffers: IReadOnlyList_1[Memory_1[int]], fileOffset: int) -> int:...
        @typing.overload
        def __call__(self, handle: SafeFileHandle, buffer: Span_1[int], fileOffset: int) -> int:...

    # Skipped ReadAsync due to it being static, abstract and generic.

    ReadAsync : ReadAsync_MethodGroup
    class ReadAsync_MethodGroup:
        @typing.overload
        def __call__(self, handle: SafeFileHandle, buffers: IReadOnlyList_1[Memory_1[int]], fileOffset: int, cancellationToken: CancellationToken = ...) -> ValueTask_1[int]:...
        @typing.overload
        def __call__(self, handle: SafeFileHandle, buffer: Memory_1[int], fileOffset: int, cancellationToken: CancellationToken = ...) -> ValueTask_1[int]:...

    # Skipped Write due to it being static, abstract and generic.

    Write : Write_MethodGroup
    class Write_MethodGroup:
        @typing.overload
        def __call__(self, handle: SafeFileHandle, buffers: IReadOnlyList_1[ReadOnlyMemory_1[int]], fileOffset: int) -> None:...
        @typing.overload
        def __call__(self, handle: SafeFileHandle, buffer: ReadOnlySpan_1[int], fileOffset: int) -> None:...

    # Skipped WriteAsync due to it being static, abstract and generic.

    WriteAsync : WriteAsync_MethodGroup
    class WriteAsync_MethodGroup:
        @typing.overload
        def __call__(self, handle: SafeFileHandle, buffers: IReadOnlyList_1[ReadOnlyMemory_1[int]], fileOffset: int, cancellationToken: CancellationToken = ...) -> ValueTask:...
        @typing.overload
        def __call__(self, handle: SafeFileHandle, buffer: ReadOnlyMemory_1[int], fileOffset: int, cancellationToken: CancellationToken = ...) -> ValueTask:...



class SearchOption(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    TopDirectoryOnly : SearchOption # 0
    AllDirectories : SearchOption # 1


class SeekOrigin(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Begin : SeekOrigin # 0
    Current : SeekOrigin # 1
    End : SeekOrigin # 2


class Stream(MarshalByRefObject, IAsyncDisposable, IDisposable):
    Null : Stream
    @property
    def CanRead(self) -> bool: ...
    @property
    def CanSeek(self) -> bool: ...
    @property
    def CanTimeout(self) -> bool: ...
    @property
    def CanWrite(self) -> bool: ...
    @property
    def Length(self) -> int: ...
    @property
    def Position(self) -> int: ...
    @Position.setter
    def Position(self, value: int) -> int: ...
    @property
    def ReadTimeout(self) -> int: ...
    @ReadTimeout.setter
    def ReadTimeout(self, value: int) -> int: ...
    @property
    def WriteTimeout(self) -> int: ...
    @WriteTimeout.setter
    def WriteTimeout(self, value: int) -> int: ...
    def BeginRead(self, buffer: Array_1[int], offset: int, count: int, callback: AsyncCallback, state: typing.Any) -> IAsyncResult: ...
    def BeginWrite(self, buffer: Array_1[int], offset: int, count: int, callback: AsyncCallback, state: typing.Any) -> IAsyncResult: ...
    def Close(self) -> None: ...
    def Dispose(self) -> None: ...
    def DisposeAsync(self) -> ValueTask: ...
    def EndRead(self, asyncResult: IAsyncResult) -> int: ...
    def EndWrite(self, asyncResult: IAsyncResult) -> None: ...
    @abc.abstractmethod
    def Flush(self) -> None: ...
    def ReadByte(self) -> int: ...
    @abc.abstractmethod
    def Seek(self, offset: int, origin: SeekOrigin) -> int: ...
    @abc.abstractmethod
    def SetLength(self, value: int) -> None: ...
    @staticmethod
    def Synchronized(stream: Stream) -> Stream: ...
    def WriteByte(self, value: int) -> None: ...
    # Skipped CopyTo due to it being static, abstract and generic.

    CopyTo : CopyTo_MethodGroup
    class CopyTo_MethodGroup:
        @typing.overload
        def __call__(self, destination: Stream) -> None:...
        @typing.overload
        def __call__(self, destination: Stream, bufferSize: int) -> None:...

    # Skipped CopyToAsync due to it being static, abstract and generic.

    CopyToAsync : CopyToAsync_MethodGroup
    class CopyToAsync_MethodGroup:
        @typing.overload
        def __call__(self, destination: Stream) -> Task:...
        @typing.overload
        def __call__(self, destination: Stream, bufferSize: int) -> Task:...
        @typing.overload
        def __call__(self, destination: Stream, cancellationToken: CancellationToken) -> Task:...
        @typing.overload
        def __call__(self, destination: Stream, bufferSize: int, cancellationToken: CancellationToken) -> Task:...

    # Skipped FlushAsync due to it being static, abstract and generic.

    FlushAsync : FlushAsync_MethodGroup
    class FlushAsync_MethodGroup:
        @typing.overload
        def __call__(self) -> Task:...
        @typing.overload
        def __call__(self, cancellationToken: CancellationToken) -> Task:...

    # Skipped Read due to it being static, abstract and generic.

    Read : Read_MethodGroup
    class Read_MethodGroup:
        @typing.overload
        def __call__(self, buffer: Span_1[int]) -> int:...
        @typing.overload
        def __call__(self, buffer: Array_1[int], offset: int, count: int) -> int:...

    # Skipped ReadAsync due to it being static, abstract and generic.

    ReadAsync : ReadAsync_MethodGroup
    class ReadAsync_MethodGroup:
        @typing.overload
        def __call__(self, buffer: Memory_1[int], cancellationToken: CancellationToken = ...) -> ValueTask_1[int]:...
        @typing.overload
        def __call__(self, buffer: Array_1[int], offset: int, count: int) -> Task_1[int]:...
        @typing.overload
        def __call__(self, buffer: Array_1[int], offset: int, count: int, cancellationToken: CancellationToken) -> Task_1[int]:...

    # Skipped Write due to it being static, abstract and generic.

    Write : Write_MethodGroup
    class Write_MethodGroup:
        @typing.overload
        def __call__(self, buffer: ReadOnlySpan_1[int]) -> None:...
        @typing.overload
        def __call__(self, buffer: Array_1[int], offset: int, count: int) -> None:...

    # Skipped WriteAsync due to it being static, abstract and generic.

    WriteAsync : WriteAsync_MethodGroup
    class WriteAsync_MethodGroup:
        @typing.overload
        def __call__(self, buffer: ReadOnlyMemory_1[int], cancellationToken: CancellationToken = ...) -> ValueTask:...
        @typing.overload
        def __call__(self, buffer: Array_1[int], offset: int, count: int) -> Task:...
        @typing.overload
        def __call__(self, buffer: Array_1[int], offset: int, count: int, cancellationToken: CancellationToken) -> Task:...



class StreamReader(TextReader):
    @typing.overload
    def __init__(self, path: str) -> None: ...
    @typing.overload
    def __init__(self, path: str, detectEncodingFromByteOrderMarks: bool) -> None: ...
    @typing.overload
    def __init__(self, path: str, encoding: Encoding) -> None: ...
    @typing.overload
    def __init__(self, path: str, encoding: Encoding, detectEncodingFromByteOrderMarks: bool) -> None: ...
    @typing.overload
    def __init__(self, path: str, encoding: Encoding, detectEncodingFromByteOrderMarks: bool, bufferSize: int) -> None: ...
    @typing.overload
    def __init__(self, path: str, encoding: Encoding, detectEncodingFromByteOrderMarks: bool, options: FileStreamOptions) -> None: ...
    @typing.overload
    def __init__(self, path: str, options: FileStreamOptions) -> None: ...
    @typing.overload
    def __init__(self, stream: Stream) -> None: ...
    @typing.overload
    def __init__(self, stream: Stream, detectEncodingFromByteOrderMarks: bool) -> None: ...
    @typing.overload
    def __init__(self, stream: Stream, encoding: Encoding) -> None: ...
    @typing.overload
    def __init__(self, stream: Stream, encoding: Encoding, detectEncodingFromByteOrderMarks: bool) -> None: ...
    @typing.overload
    def __init__(self, stream: Stream, encoding: Encoding, detectEncodingFromByteOrderMarks: bool, bufferSize: int) -> None: ...
    @typing.overload
    def __init__(self, stream: Stream, encoding: Encoding = ..., detectEncodingFromByteOrderMarks: bool = ..., bufferSize: int = ..., leaveOpen: bool = ...) -> None: ...
    Null : StreamReader
    @property
    def BaseStream(self) -> Stream: ...
    @property
    def CurrentEncoding(self) -> Encoding: ...
    @property
    def EndOfStream(self) -> bool: ...
    def Close(self) -> None: ...
    def DiscardBufferedData(self) -> None: ...
    def Peek(self) -> int: ...
    def ReadLine(self) -> str: ...
    def ReadLineAsync(self) -> Task_1[str]: ...
    def ReadToEnd(self) -> str: ...
    def ReadToEndAsync(self) -> Task_1[str]: ...
    # Skipped Read due to it being static, abstract and generic.

    Read : Read_MethodGroup
    class Read_MethodGroup:
        @typing.overload
        def __call__(self) -> int:...
        @typing.overload
        def __call__(self, buffer: Span_1[str]) -> int:...
        @typing.overload
        def __call__(self, buffer: Array_1[str], index: int, count: int) -> int:...

    # Skipped ReadAsync due to it being static, abstract and generic.

    ReadAsync : ReadAsync_MethodGroup
    class ReadAsync_MethodGroup:
        @typing.overload
        def __call__(self, buffer: Memory_1[str], cancellationToken: CancellationToken = ...) -> ValueTask_1[int]:...
        @typing.overload
        def __call__(self, buffer: Array_1[str], index: int, count: int) -> Task_1[int]:...

    # Skipped ReadBlock due to it being static, abstract and generic.

    ReadBlock : ReadBlock_MethodGroup
    class ReadBlock_MethodGroup:
        @typing.overload
        def __call__(self, buffer: Span_1[str]) -> int:...
        @typing.overload
        def __call__(self, buffer: Array_1[str], index: int, count: int) -> int:...

    # Skipped ReadBlockAsync due to it being static, abstract and generic.

    ReadBlockAsync : ReadBlockAsync_MethodGroup
    class ReadBlockAsync_MethodGroup:
        @typing.overload
        def __call__(self, buffer: Memory_1[str], cancellationToken: CancellationToken = ...) -> ValueTask_1[int]:...
        @typing.overload
        def __call__(self, buffer: Array_1[str], index: int, count: int) -> Task_1[int]:...



class StreamWriter(TextWriter):
    @typing.overload
    def __init__(self, path: str) -> None: ...
    @typing.overload
    def __init__(self, path: str, append: bool) -> None: ...
    @typing.overload
    def __init__(self, path: str, append: bool, encoding: Encoding) -> None: ...
    @typing.overload
    def __init__(self, path: str, append: bool, encoding: Encoding, bufferSize: int) -> None: ...
    @typing.overload
    def __init__(self, path: str, encoding: Encoding, options: FileStreamOptions) -> None: ...
    @typing.overload
    def __init__(self, path: str, options: FileStreamOptions) -> None: ...
    @typing.overload
    def __init__(self, stream: Stream) -> None: ...
    @typing.overload
    def __init__(self, stream: Stream, encoding: Encoding) -> None: ...
    @typing.overload
    def __init__(self, stream: Stream, encoding: Encoding, bufferSize: int) -> None: ...
    @typing.overload
    def __init__(self, stream: Stream, encoding: Encoding = ..., bufferSize: int = ..., leaveOpen: bool = ...) -> None: ...
    Null : StreamWriter
    @property
    def AutoFlush(self) -> bool: ...
    @AutoFlush.setter
    def AutoFlush(self, value: bool) -> bool: ...
    @property
    def BaseStream(self) -> Stream: ...
    @property
    def Encoding(self) -> Encoding: ...
    @property
    def FormatProvider(self) -> IFormatProvider: ...
    @property
    def NewLine(self) -> str: ...
    @NewLine.setter
    def NewLine(self, value: str) -> str: ...
    def Close(self) -> None: ...
    def DisposeAsync(self) -> ValueTask: ...
    def Flush(self) -> None: ...
    def FlushAsync(self) -> Task: ...
    # Skipped Write due to it being static, abstract and generic.

    Write : Write_MethodGroup
    class Write_MethodGroup:
        @typing.overload
        def __call__(self, value: str) -> None:...
        @typing.overload
        def __call__(self, buffer: Array_1[str]) -> None:...
        @typing.overload
        def __call__(self, buffer: ReadOnlySpan_1[str]) -> None:...
        # Method Write(value : String) was skipped since it collides with above method
        @typing.overload
        def __call__(self, format: str, arg: Array_1[typing.Any]) -> None:...
        @typing.overload
        def __call__(self, format: str, arg0: typing.Any) -> None:...
        @typing.overload
        def __call__(self, buffer: Array_1[str], index: int, count: int) -> None:...
        @typing.overload
        def __call__(self, format: str, arg0: typing.Any, arg1: typing.Any) -> None:...
        @typing.overload
        def __call__(self, format: str, arg0: typing.Any, arg1: typing.Any, arg2: typing.Any) -> None:...

    # Skipped WriteAsync due to it being static, abstract and generic.

    WriteAsync : WriteAsync_MethodGroup
    class WriteAsync_MethodGroup:
        @typing.overload
        def __call__(self, value: str) -> Task:...
        # Method WriteAsync(value : String) was skipped since it collides with above method
        @typing.overload
        def __call__(self, buffer: ReadOnlyMemory_1[str], cancellationToken: CancellationToken = ...) -> Task:...
        @typing.overload
        def __call__(self, buffer: Array_1[str], index: int, count: int) -> Task:...

    # Skipped WriteLine due to it being static, abstract and generic.

    WriteLine : WriteLine_MethodGroup
    class WriteLine_MethodGroup:
        @typing.overload
        def __call__(self, buffer: ReadOnlySpan_1[str]) -> None:...
        @typing.overload
        def __call__(self, value: str) -> None:...
        @typing.overload
        def __call__(self, format: str, arg: Array_1[typing.Any]) -> None:...
        @typing.overload
        def __call__(self, format: str, arg0: typing.Any) -> None:...
        @typing.overload
        def __call__(self, format: str, arg0: typing.Any, arg1: typing.Any) -> None:...
        @typing.overload
        def __call__(self, format: str, arg0: typing.Any, arg1: typing.Any, arg2: typing.Any) -> None:...

    # Skipped WriteLineAsync due to it being static, abstract and generic.

    WriteLineAsync : WriteLineAsync_MethodGroup
    class WriteLineAsync_MethodGroup:
        @typing.overload
        def __call__(self) -> Task:...
        @typing.overload
        def __call__(self, value: str) -> Task:...
        # Method WriteLineAsync(value : String) was skipped since it collides with above method
        @typing.overload
        def __call__(self, buffer: ReadOnlyMemory_1[str], cancellationToken: CancellationToken = ...) -> Task:...
        @typing.overload
        def __call__(self, buffer: Array_1[str], index: int, count: int) -> Task:...



class StringReader(TextReader):
    def __init__(self, s: str) -> None: ...
    def Close(self) -> None: ...
    def Peek(self) -> int: ...
    def ReadBlock(self, buffer: Span_1[str]) -> int: ...
    def ReadLine(self) -> str: ...
    def ReadLineAsync(self) -> Task_1[str]: ...
    def ReadToEnd(self) -> str: ...
    def ReadToEndAsync(self) -> Task_1[str]: ...
    # Skipped Read due to it being static, abstract and generic.

    Read : Read_MethodGroup
    class Read_MethodGroup:
        @typing.overload
        def __call__(self) -> int:...
        @typing.overload
        def __call__(self, buffer: Span_1[str]) -> int:...
        @typing.overload
        def __call__(self, buffer: Array_1[str], index: int, count: int) -> int:...

    # Skipped ReadAsync due to it being static, abstract and generic.

    ReadAsync : ReadAsync_MethodGroup
    class ReadAsync_MethodGroup:
        @typing.overload
        def __call__(self, buffer: Memory_1[str], cancellationToken: CancellationToken = ...) -> ValueTask_1[int]:...
        @typing.overload
        def __call__(self, buffer: Array_1[str], index: int, count: int) -> Task_1[int]:...

    # Skipped ReadBlockAsync due to it being static, abstract and generic.

    ReadBlockAsync : ReadBlockAsync_MethodGroup
    class ReadBlockAsync_MethodGroup:
        @typing.overload
        def __call__(self, buffer: Memory_1[str], cancellationToken: CancellationToken = ...) -> ValueTask_1[int]:...
        @typing.overload
        def __call__(self, buffer: Array_1[str], index: int, count: int) -> Task_1[int]:...



class StringWriter(TextWriter):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, formatProvider: IFormatProvider) -> None: ...
    @typing.overload
    def __init__(self, sb: StringBuilder) -> None: ...
    @typing.overload
    def __init__(self, sb: StringBuilder, formatProvider: IFormatProvider) -> None: ...
    @property
    def Encoding(self) -> Encoding: ...
    @property
    def FormatProvider(self) -> IFormatProvider: ...
    @property
    def NewLine(self) -> str: ...
    @NewLine.setter
    def NewLine(self, value: str) -> str: ...
    def Close(self) -> None: ...
    def FlushAsync(self) -> Task: ...
    def GetStringBuilder(self) -> StringBuilder: ...
    def ToString(self) -> str: ...
    # Skipped Write due to it being static, abstract and generic.

    Write : Write_MethodGroup
    class Write_MethodGroup:
        @typing.overload
        def __call__(self, value: str) -> None:...
        @typing.overload
        def __call__(self, buffer: ReadOnlySpan_1[str]) -> None:...
        # Method Write(value : String) was skipped since it collides with above method
        @typing.overload
        def __call__(self, value: StringBuilder) -> None:...
        @typing.overload
        def __call__(self, buffer: Array_1[str], index: int, count: int) -> None:...

    # Skipped WriteAsync due to it being static, abstract and generic.

    WriteAsync : WriteAsync_MethodGroup
    class WriteAsync_MethodGroup:
        @typing.overload
        def __call__(self, value: str) -> Task:...
        # Method WriteAsync(value : String) was skipped since it collides with above method
        @typing.overload
        def __call__(self, buffer: ReadOnlyMemory_1[str], cancellationToken: CancellationToken = ...) -> Task:...
        @typing.overload
        def __call__(self, value: StringBuilder, cancellationToken: CancellationToken = ...) -> Task:...
        @typing.overload
        def __call__(self, buffer: Array_1[str], index: int, count: int) -> Task:...

    # Skipped WriteLine due to it being static, abstract and generic.

    WriteLine : WriteLine_MethodGroup
    class WriteLine_MethodGroup:
        @typing.overload
        def __call__(self, buffer: ReadOnlySpan_1[str]) -> None:...
        @typing.overload
        def __call__(self, value: StringBuilder) -> None:...

    # Skipped WriteLineAsync due to it being static, abstract and generic.

    WriteLineAsync : WriteLineAsync_MethodGroup
    class WriteLineAsync_MethodGroup:
        @typing.overload
        def __call__(self, value: str) -> Task:...
        # Method WriteLineAsync(value : String) was skipped since it collides with above method
        @typing.overload
        def __call__(self, buffer: ReadOnlyMemory_1[str], cancellationToken: CancellationToken = ...) -> Task:...
        @typing.overload
        def __call__(self, value: StringBuilder, cancellationToken: CancellationToken = ...) -> Task:...
        @typing.overload
        def __call__(self, buffer: Array_1[str], index: int, count: int) -> Task:...



class TextReader(MarshalByRefObject, IDisposable):
    Null : TextReader
    def Close(self) -> None: ...
    def Dispose(self) -> None: ...
    def Peek(self) -> int: ...
    def ReadLine(self) -> str: ...
    def ReadLineAsync(self) -> Task_1[str]: ...
    def ReadToEnd(self) -> str: ...
    def ReadToEndAsync(self) -> Task_1[str]: ...
    @staticmethod
    def Synchronized(reader: TextReader) -> TextReader: ...
    # Skipped Read due to it being static, abstract and generic.

    Read : Read_MethodGroup
    class Read_MethodGroup:
        @typing.overload
        def __call__(self) -> int:...
        @typing.overload
        def __call__(self, buffer: Span_1[str]) -> int:...
        @typing.overload
        def __call__(self, buffer: Array_1[str], index: int, count: int) -> int:...

    # Skipped ReadAsync due to it being static, abstract and generic.

    ReadAsync : ReadAsync_MethodGroup
    class ReadAsync_MethodGroup:
        @typing.overload
        def __call__(self, buffer: Memory_1[str], cancellationToken: CancellationToken = ...) -> ValueTask_1[int]:...
        @typing.overload
        def __call__(self, buffer: Array_1[str], index: int, count: int) -> Task_1[int]:...

    # Skipped ReadBlock due to it being static, abstract and generic.

    ReadBlock : ReadBlock_MethodGroup
    class ReadBlock_MethodGroup:
        @typing.overload
        def __call__(self, buffer: Span_1[str]) -> int:...
        @typing.overload
        def __call__(self, buffer: Array_1[str], index: int, count: int) -> int:...

    # Skipped ReadBlockAsync due to it being static, abstract and generic.

    ReadBlockAsync : ReadBlockAsync_MethodGroup
    class ReadBlockAsync_MethodGroup:
        @typing.overload
        def __call__(self, buffer: Memory_1[str], cancellationToken: CancellationToken = ...) -> ValueTask_1[int]:...
        @typing.overload
        def __call__(self, buffer: Array_1[str], index: int, count: int) -> Task_1[int]:...



class TextWriter(MarshalByRefObject, IAsyncDisposable, IDisposable):
    Null : TextWriter
    @property
    def Encoding(self) -> Encoding: ...
    @property
    def FormatProvider(self) -> IFormatProvider: ...
    @property
    def NewLine(self) -> str: ...
    @NewLine.setter
    def NewLine(self, value: str) -> str: ...
    def Close(self) -> None: ...
    def Dispose(self) -> None: ...
    def DisposeAsync(self) -> ValueTask: ...
    def Flush(self) -> None: ...
    def FlushAsync(self) -> Task: ...
    @staticmethod
    def Synchronized(writer: TextWriter) -> TextWriter: ...
    # Skipped Write due to it being static, abstract and generic.

    Write : Write_MethodGroup
    class Write_MethodGroup:
        @typing.overload
        def __call__(self, value: float) -> None:...
        # Method Write(value : Double) was skipped since it collides with above method
        @typing.overload
        def __call__(self, value: str) -> None:...
        # Method Write(value : Int32) was skipped since it collides with above method
        # Method Write(value : UInt32) was skipped since it collides with above method
        # Method Write(value : Int64) was skipped since it collides with above method
        # Method Write(value : UInt64) was skipped since it collides with above method
        @typing.overload
        def __call__(self, value: Decimal) -> None:...
        @typing.overload
        def __call__(self, buffer: Array_1[str]) -> None:...
        @typing.overload
        def __call__(self, buffer: ReadOnlySpan_1[str]) -> None:...
        # Method Write(value : Boolean) was skipped since it collides with above method
        # Method Write(value : String) was skipped since it collides with above method
        @typing.overload
        def __call__(self, value: StringBuilder) -> None:...
        @typing.overload
        def __call__(self, value: typing.Any) -> None:...
        @typing.overload
        def __call__(self, format: str, arg: Array_1[typing.Any]) -> None:...
        @typing.overload
        def __call__(self, format: str, arg0: typing.Any) -> None:...
        @typing.overload
        def __call__(self, buffer: Array_1[str], index: int, count: int) -> None:...
        @typing.overload
        def __call__(self, format: str, arg0: typing.Any, arg1: typing.Any) -> None:...
        @typing.overload
        def __call__(self, format: str, arg0: typing.Any, arg1: typing.Any, arg2: typing.Any) -> None:...

    # Skipped WriteAsync due to it being static, abstract and generic.

    WriteAsync : WriteAsync_MethodGroup
    class WriteAsync_MethodGroup:
        @typing.overload
        def __call__(self, value: str) -> Task:...
        @typing.overload
        def __call__(self, buffer: Array_1[str]) -> Task:...
        # Method WriteAsync(value : String) was skipped since it collides with above method
        @typing.overload
        def __call__(self, buffer: ReadOnlyMemory_1[str], cancellationToken: CancellationToken = ...) -> Task:...
        @typing.overload
        def __call__(self, value: StringBuilder, cancellationToken: CancellationToken = ...) -> Task:...
        @typing.overload
        def __call__(self, buffer: Array_1[str], index: int, count: int) -> Task:...

    # Skipped WriteLine due to it being static, abstract and generic.

    WriteLine : WriteLine_MethodGroup
    class WriteLine_MethodGroup:
        @typing.overload
        def __call__(self) -> None:...
        @typing.overload
        def __call__(self, value: float) -> None:...
        # Method WriteLine(value : Double) was skipped since it collides with above method
        @typing.overload
        def __call__(self, value: str) -> None:...
        # Method WriteLine(value : Int32) was skipped since it collides with above method
        # Method WriteLine(value : UInt32) was skipped since it collides with above method
        # Method WriteLine(value : Int64) was skipped since it collides with above method
        # Method WriteLine(value : UInt64) was skipped since it collides with above method
        @typing.overload
        def __call__(self, value: Decimal) -> None:...
        @typing.overload
        def __call__(self, buffer: Array_1[str]) -> None:...
        @typing.overload
        def __call__(self, buffer: ReadOnlySpan_1[str]) -> None:...
        # Method WriteLine(value : Boolean) was skipped since it collides with above method
        # Method WriteLine(value : String) was skipped since it collides with above method
        @typing.overload
        def __call__(self, value: StringBuilder) -> None:...
        @typing.overload
        def __call__(self, value: typing.Any) -> None:...
        @typing.overload
        def __call__(self, format: str, arg: Array_1[typing.Any]) -> None:...
        @typing.overload
        def __call__(self, format: str, arg0: typing.Any) -> None:...
        @typing.overload
        def __call__(self, buffer: Array_1[str], index: int, count: int) -> None:...
        @typing.overload
        def __call__(self, format: str, arg0: typing.Any, arg1: typing.Any) -> None:...
        @typing.overload
        def __call__(self, format: str, arg0: typing.Any, arg1: typing.Any, arg2: typing.Any) -> None:...

    # Skipped WriteLineAsync due to it being static, abstract and generic.

    WriteLineAsync : WriteLineAsync_MethodGroup
    class WriteLineAsync_MethodGroup:
        @typing.overload
        def __call__(self) -> Task:...
        @typing.overload
        def __call__(self, value: str) -> Task:...
        @typing.overload
        def __call__(self, buffer: Array_1[str]) -> Task:...
        # Method WriteLineAsync(value : String) was skipped since it collides with above method
        @typing.overload
        def __call__(self, buffer: ReadOnlyMemory_1[str], cancellationToken: CancellationToken = ...) -> Task:...
        @typing.overload
        def __call__(self, value: StringBuilder, cancellationToken: CancellationToken = ...) -> Task:...
        @typing.overload
        def __call__(self, buffer: Array_1[str], index: int, count: int) -> Task:...



class UnmanagedMemoryAccessor(IDisposable):
    @typing.overload
    def __init__(self, buffer: SafeBuffer, offset: int, capacity: int) -> None: ...
    @typing.overload
    def __init__(self, buffer: SafeBuffer, offset: int, capacity: int, access: FileAccess) -> None: ...
    @property
    def CanRead(self) -> bool: ...
    @property
    def CanWrite(self) -> bool: ...
    @property
    def Capacity(self) -> int: ...
    def Dispose(self) -> None: ...
    def ReadBoolean(self, position: int) -> bool: ...
    def ReadByte(self, position: int) -> int: ...
    def ReadChar(self, position: int) -> str: ...
    def ReadDecimal(self, position: int) -> Decimal: ...
    def ReadDouble(self, position: int) -> float: ...
    def ReadInt16(self, position: int) -> int: ...
    def ReadInt32(self, position: int) -> int: ...
    def ReadInt64(self, position: int) -> int: ...
    def ReadSByte(self, position: int) -> int: ...
    def ReadSingle(self, position: int) -> float: ...
    def ReadUInt16(self, position: int) -> int: ...
    def ReadUInt32(self, position: int) -> int: ...
    def ReadUInt64(self, position: int) -> int: ...
    # Skipped Read due to it being static, abstract and generic.

    Read : Read_MethodGroup
    class Read_MethodGroup:
        def __getitem__(self, t:typing.Type[Read_1_T1]) -> Read_1[Read_1_T1]: ...

        Read_1_T1 = typing.TypeVar('Read_1_T1')
        class Read_1(typing.Generic[Read_1_T1]):
            Read_1_T = UnmanagedMemoryAccessor.Read_MethodGroup.Read_1_T1
            def __call__(self, position: int, structure: clr.Reference[Read_1_T]) -> None:...


    # Skipped ReadArray due to it being static, abstract and generic.

    ReadArray : ReadArray_MethodGroup
    class ReadArray_MethodGroup:
        def __getitem__(self, t:typing.Type[ReadArray_1_T1]) -> ReadArray_1[ReadArray_1_T1]: ...

        ReadArray_1_T1 = typing.TypeVar('ReadArray_1_T1')
        class ReadArray_1(typing.Generic[ReadArray_1_T1]):
            ReadArray_1_T = UnmanagedMemoryAccessor.ReadArray_MethodGroup.ReadArray_1_T1
            def __call__(self, position: int, array: Array_1[ReadArray_1_T], offset: int, count: int) -> int:...


    # Skipped Write due to it being static, abstract and generic.

    Write : Write_MethodGroup
    class Write_MethodGroup:
        def __getitem__(self, t:typing.Type[Write_1_T1]) -> Write_1[Write_1_T1]: ...

        Write_1_T1 = typing.TypeVar('Write_1_T1')
        class Write_1(typing.Generic[Write_1_T1]):
            Write_1_T = UnmanagedMemoryAccessor.Write_MethodGroup.Write_1_T1
            def __call__(self, position: int, structure: clr.Reference[Write_1_T]) -> None:...

        @typing.overload
        def __call__(self, position: int, value: float) -> None:...
        # Method Write(position : Int64, value : Double) was skipped since it collides with above method
        # Method Write(position : Int64, value : Byte) was skipped since it collides with above method
        @typing.overload
        def __call__(self, position: int, value: str) -> None:...
        # Method Write(position : Int64, value : Int16) was skipped since it collides with above method
        # Method Write(position : Int64, value : Int32) was skipped since it collides with above method
        # Method Write(position : Int64, value : Int64) was skipped since it collides with above method
        # Method Write(position : Int64, value : SByte) was skipped since it collides with above method
        # Method Write(position : Int64, value : UInt16) was skipped since it collides with above method
        # Method Write(position : Int64, value : UInt32) was skipped since it collides with above method
        # Method Write(position : Int64, value : UInt64) was skipped since it collides with above method
        @typing.overload
        def __call__(self, position: int, value: Decimal) -> None:...
        # Method Write(position : Int64, value : Boolean) was skipped since it collides with above method

    # Skipped WriteArray due to it being static, abstract and generic.

    WriteArray : WriteArray_MethodGroup
    class WriteArray_MethodGroup:
        def __getitem__(self, t:typing.Type[WriteArray_1_T1]) -> WriteArray_1[WriteArray_1_T1]: ...

        WriteArray_1_T1 = typing.TypeVar('WriteArray_1_T1')
        class WriteArray_1(typing.Generic[WriteArray_1_T1]):
            WriteArray_1_T = UnmanagedMemoryAccessor.WriteArray_MethodGroup.WriteArray_1_T1
            def __call__(self, position: int, array: Array_1[WriteArray_1_T], offset: int, count: int) -> None:...




class UnmanagedMemoryStream(Stream):
    @typing.overload
    def __init__(self, buffer: SafeBuffer, offset: int, length: int) -> None: ...
    @typing.overload
    def __init__(self, buffer: SafeBuffer, offset: int, length: int, access: FileAccess) -> None: ...
    @typing.overload
    def __init__(self, pointer: clr.Reference[int], length: int) -> None: ...
    @typing.overload
    def __init__(self, pointer: clr.Reference[int], length: int, capacity: int, access: FileAccess) -> None: ...
    @property
    def CanRead(self) -> bool: ...
    @property
    def CanSeek(self) -> bool: ...
    @property
    def CanTimeout(self) -> bool: ...
    @property
    def CanWrite(self) -> bool: ...
    @property
    def Capacity(self) -> int: ...
    @property
    def Length(self) -> int: ...
    @property
    def Position(self) -> int: ...
    @Position.setter
    def Position(self, value: int) -> int: ...
    @property
    def PositionPointer(self) -> clr.Reference[int]: ...
    @PositionPointer.setter
    def PositionPointer(self, value: clr.Reference[int]) -> clr.Reference[int]: ...
    @property
    def ReadTimeout(self) -> int: ...
    @ReadTimeout.setter
    def ReadTimeout(self, value: int) -> int: ...
    @property
    def WriteTimeout(self) -> int: ...
    @WriteTimeout.setter
    def WriteTimeout(self, value: int) -> int: ...
    def Flush(self) -> None: ...
    def FlushAsync(self, cancellationToken: CancellationToken) -> Task: ...
    def ReadByte(self) -> int: ...
    def Seek(self, offset: int, loc: SeekOrigin) -> int: ...
    def SetLength(self, value: int) -> None: ...
    def WriteByte(self, value: int) -> None: ...
    # Skipped Read due to it being static, abstract and generic.

    Read : Read_MethodGroup
    class Read_MethodGroup:
        @typing.overload
        def __call__(self, buffer: Span_1[int]) -> int:...
        @typing.overload
        def __call__(self, buffer: Array_1[int], offset: int, count: int) -> int:...

    # Skipped ReadAsync due to it being static, abstract and generic.

    ReadAsync : ReadAsync_MethodGroup
    class ReadAsync_MethodGroup:
        @typing.overload
        def __call__(self, buffer: Memory_1[int], cancellationToken: CancellationToken = ...) -> ValueTask_1[int]:...
        @typing.overload
        def __call__(self, buffer: Array_1[int], offset: int, count: int, cancellationToken: CancellationToken) -> Task_1[int]:...

    # Skipped Write due to it being static, abstract and generic.

    Write : Write_MethodGroup
    class Write_MethodGroup:
        @typing.overload
        def __call__(self, buffer: ReadOnlySpan_1[int]) -> None:...
        @typing.overload
        def __call__(self, buffer: Array_1[int], offset: int, count: int) -> None:...

    # Skipped WriteAsync due to it being static, abstract and generic.

    WriteAsync : WriteAsync_MethodGroup
    class WriteAsync_MethodGroup:
        @typing.overload
        def __call__(self, buffer: ReadOnlyMemory_1[int], cancellationToken: CancellationToken = ...) -> ValueTask:...
        @typing.overload
        def __call__(self, buffer: Array_1[int], offset: int, count: int, cancellationToken: CancellationToken) -> Task:...


