/*
    Copyright 2021 Google LLC

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
*/

#ifndef FQE_LIB_BINOM_H_
#define FQE_LIB_BINOM_H_
#include <stdint.h>

inline void initialize_binom(uint64_t *binom) {
  binom[ 0*65+ 0] =                    1ull; binom[ 1*65+ 0] =                    1ull; binom[ 1*65+ 1] =                    1ull; binom[ 2*65+ 0] =                    1ull;
  binom[ 2*65+ 1] =                    2ull; binom[ 2*65+ 2] =                    1ull; binom[ 3*65+ 0] =                    1ull; binom[ 3*65+ 1] =                    3ull;
  binom[ 3*65+ 2] =                    3ull; binom[ 3*65+ 3] =                    1ull; binom[ 4*65+ 0] =                    1ull; binom[ 4*65+ 1] =                    4ull;
  binom[ 4*65+ 2] =                    6ull; binom[ 4*65+ 3] =                    4ull; binom[ 4*65+ 4] =                    1ull; binom[ 5*65+ 0] =                    1ull;
  binom[ 5*65+ 1] =                    5ull; binom[ 5*65+ 2] =                   10ull; binom[ 5*65+ 3] =                   10ull; binom[ 5*65+ 4] =                    5ull;
  binom[ 5*65+ 5] =                    1ull; binom[ 6*65+ 0] =                    1ull; binom[ 6*65+ 1] =                    6ull; binom[ 6*65+ 2] =                   15ull;
  binom[ 6*65+ 3] =                   20ull; binom[ 6*65+ 4] =                   15ull; binom[ 6*65+ 5] =                    6ull; binom[ 6*65+ 6] =                    1ull;
  binom[ 7*65+ 0] =                    1ull; binom[ 7*65+ 1] =                    7ull; binom[ 7*65+ 2] =                   21ull; binom[ 7*65+ 3] =                   35ull;
  binom[ 7*65+ 4] =                   35ull; binom[ 7*65+ 5] =                   21ull; binom[ 7*65+ 6] =                    7ull; binom[ 7*65+ 7] =                    1ull;
  binom[ 8*65+ 0] =                    1ull; binom[ 8*65+ 1] =                    8ull; binom[ 8*65+ 2] =                   28ull; binom[ 8*65+ 3] =                   56ull;
  binom[ 8*65+ 4] =                   70ull; binom[ 8*65+ 5] =                   56ull; binom[ 8*65+ 6] =                   28ull; binom[ 8*65+ 7] =                    8ull;
  binom[ 8*65+ 8] =                    1ull; binom[ 9*65+ 0] =                    1ull; binom[ 9*65+ 1] =                    9ull; binom[ 9*65+ 2] =                   36ull;
  binom[ 9*65+ 3] =                   84ull; binom[ 9*65+ 4] =                  126ull; binom[ 9*65+ 5] =                  126ull; binom[ 9*65+ 6] =                   84ull;
  binom[ 9*65+ 7] =                   36ull; binom[ 9*65+ 8] =                    9ull; binom[ 9*65+ 9] =                    1ull; binom[10*65+ 0] =                    1ull;
  binom[10*65+ 1] =                   10ull; binom[10*65+ 2] =                   45ull; binom[10*65+ 3] =                  120ull; binom[10*65+ 4] =                  210ull;
  binom[10*65+ 5] =                  252ull; binom[10*65+ 6] =                  210ull; binom[10*65+ 7] =                  120ull; binom[10*65+ 8] =                   45ull;
  binom[10*65+ 9] =                   10ull; binom[10*65+10] =                    1ull; binom[11*65+ 0] =                    1ull; binom[11*65+ 1] =                   11ull;
  binom[11*65+ 2] =                   55ull; binom[11*65+ 3] =                  165ull; binom[11*65+ 4] =                  330ull; binom[11*65+ 5] =                  462ull;
  binom[11*65+ 6] =                  462ull; binom[11*65+ 7] =                  330ull; binom[11*65+ 8] =                  165ull; binom[11*65+ 9] =                   55ull;
  binom[11*65+10] =                   11ull; binom[11*65+11] =                    1ull; binom[12*65+ 0] =                    1ull; binom[12*65+ 1] =                   12ull;
  binom[12*65+ 2] =                   66ull; binom[12*65+ 3] =                  220ull; binom[12*65+ 4] =                  495ull; binom[12*65+ 5] =                  792ull;
  binom[12*65+ 6] =                  924ull; binom[12*65+ 7] =                  792ull; binom[12*65+ 8] =                  495ull; binom[12*65+ 9] =                  220ull;
  binom[12*65+10] =                   66ull; binom[12*65+11] =                   12ull; binom[12*65+12] =                    1ull; binom[13*65+ 0] =                    1ull;
  binom[13*65+ 1] =                   13ull; binom[13*65+ 2] =                   78ull; binom[13*65+ 3] =                  286ull; binom[13*65+ 4] =                  715ull;
  binom[13*65+ 5] =                 1287ull; binom[13*65+ 6] =                 1716ull; binom[13*65+ 7] =                 1716ull; binom[13*65+ 8] =                 1287ull;
  binom[13*65+ 9] =                  715ull; binom[13*65+10] =                  286ull; binom[13*65+11] =                   78ull; binom[13*65+12] =                   13ull;
  binom[13*65+13] =                    1ull; binom[14*65+ 0] =                    1ull; binom[14*65+ 1] =                   14ull; binom[14*65+ 2] =                   91ull;
  binom[14*65+ 3] =                  364ull; binom[14*65+ 4] =                 1001ull; binom[14*65+ 5] =                 2002ull; binom[14*65+ 6] =                 3003ull;
  binom[14*65+ 7] =                 3432ull; binom[14*65+ 8] =                 3003ull; binom[14*65+ 9] =                 2002ull; binom[14*65+10] =                 1001ull;
  binom[14*65+11] =                  364ull; binom[14*65+12] =                   91ull; binom[14*65+13] =                   14ull; binom[14*65+14] =                    1ull;
  binom[15*65+ 0] =                    1ull; binom[15*65+ 1] =                   15ull; binom[15*65+ 2] =                  105ull; binom[15*65+ 3] =                  455ull;
  binom[15*65+ 4] =                 1365ull; binom[15*65+ 5] =                 3003ull; binom[15*65+ 6] =                 5005ull; binom[15*65+ 7] =                 6435ull;
  binom[15*65+ 8] =                 6435ull; binom[15*65+ 9] =                 5005ull; binom[15*65+10] =                 3003ull; binom[15*65+11] =                 1365ull;
  binom[15*65+12] =                  455ull; binom[15*65+13] =                  105ull; binom[15*65+14] =                   15ull; binom[15*65+15] =                    1ull;
  binom[16*65+ 0] =                    1ull; binom[16*65+ 1] =                   16ull; binom[16*65+ 2] =                  120ull; binom[16*65+ 3] =                  560ull;
  binom[16*65+ 4] =                 1820ull; binom[16*65+ 5] =                 4368ull; binom[16*65+ 6] =                 8008ull; binom[16*65+ 7] =                11440ull;
  binom[16*65+ 8] =                12870ull; binom[16*65+ 9] =                11440ull; binom[16*65+10] =                 8008ull; binom[16*65+11] =                 4368ull;
  binom[16*65+12] =                 1820ull; binom[16*65+13] =                  560ull; binom[16*65+14] =                  120ull; binom[16*65+15] =                   16ull;
  binom[16*65+16] =                    1ull; binom[17*65+ 0] =                    1ull; binom[17*65+ 1] =                   17ull; binom[17*65+ 2] =                  136ull;
  binom[17*65+ 3] =                  680ull; binom[17*65+ 4] =                 2380ull; binom[17*65+ 5] =                 6188ull; binom[17*65+ 6] =                12376ull;
  binom[17*65+ 7] =                19448ull; binom[17*65+ 8] =                24310ull; binom[17*65+ 9] =                24310ull; binom[17*65+10] =                19448ull;
  binom[17*65+11] =                12376ull; binom[17*65+12] =                 6188ull; binom[17*65+13] =                 2380ull; binom[17*65+14] =                  680ull;
  binom[17*65+15] =                  136ull; binom[17*65+16] =                   17ull; binom[17*65+17] =                    1ull; binom[18*65+ 0] =                    1ull;
  binom[18*65+ 1] =                   18ull; binom[18*65+ 2] =                  153ull; binom[18*65+ 3] =                  816ull; binom[18*65+ 4] =                 3060ull;
  binom[18*65+ 5] =                 8568ull; binom[18*65+ 6] =                18564ull; binom[18*65+ 7] =                31824ull; binom[18*65+ 8] =                43758ull;
  binom[18*65+ 9] =                48620ull; binom[18*65+10] =                43758ull; binom[18*65+11] =                31824ull; binom[18*65+12] =                18564ull;
  binom[18*65+13] =                 8568ull; binom[18*65+14] =                 3060ull; binom[18*65+15] =                  816ull; binom[18*65+16] =                  153ull;
  binom[18*65+17] =                   18ull; binom[18*65+18] =                    1ull; binom[19*65+ 0] =                    1ull; binom[19*65+ 1] =                   19ull;
  binom[19*65+ 2] =                  171ull; binom[19*65+ 3] =                  969ull; binom[19*65+ 4] =                 3876ull; binom[19*65+ 5] =                11628ull;
  binom[19*65+ 6] =                27132ull; binom[19*65+ 7] =                50388ull; binom[19*65+ 8] =                75582ull; binom[19*65+ 9] =                92378ull;
  binom[19*65+10] =                92378ull; binom[19*65+11] =                75582ull; binom[19*65+12] =                50388ull; binom[19*65+13] =                27132ull;
  binom[19*65+14] =                11628ull; binom[19*65+15] =                 3876ull; binom[19*65+16] =                  969ull; binom[19*65+17] =                  171ull;
  binom[19*65+18] =                   19ull; binom[19*65+19] =                    1ull; binom[20*65+ 0] =                    1ull; binom[20*65+ 1] =                   20ull;
  binom[20*65+ 2] =                  190ull; binom[20*65+ 3] =                 1140ull; binom[20*65+ 4] =                 4845ull; binom[20*65+ 5] =                15504ull;
  binom[20*65+ 6] =                38760ull; binom[20*65+ 7] =                77520ull; binom[20*65+ 8] =               125970ull; binom[20*65+ 9] =               167960ull;
  binom[20*65+10] =               184756ull; binom[20*65+11] =               167960ull; binom[20*65+12] =               125970ull; binom[20*65+13] =                77520ull;
  binom[20*65+14] =                38760ull; binom[20*65+15] =                15504ull; binom[20*65+16] =                 4845ull; binom[20*65+17] =                 1140ull;
  binom[20*65+18] =                  190ull; binom[20*65+19] =                   20ull; binom[20*65+20] =                    1ull; binom[21*65+ 0] =                    1ull;
  binom[21*65+ 1] =                   21ull; binom[21*65+ 2] =                  210ull; binom[21*65+ 3] =                 1330ull; binom[21*65+ 4] =                 5985ull;
  binom[21*65+ 5] =                20349ull; binom[21*65+ 6] =                54264ull; binom[21*65+ 7] =               116280ull; binom[21*65+ 8] =               203490ull;
  binom[21*65+ 9] =               293930ull; binom[21*65+10] =               352716ull; binom[21*65+11] =               352716ull; binom[21*65+12] =               293930ull;
  binom[21*65+13] =               203490ull; binom[21*65+14] =               116280ull; binom[21*65+15] =                54264ull; binom[21*65+16] =                20349ull;
  binom[21*65+17] =                 5985ull; binom[21*65+18] =                 1330ull; binom[21*65+19] =                  210ull; binom[21*65+20] =                   21ull;
  binom[21*65+21] =                    1ull; binom[22*65+ 0] =                    1ull; binom[22*65+ 1] =                   22ull; binom[22*65+ 2] =                  231ull;
  binom[22*65+ 3] =                 1540ull; binom[22*65+ 4] =                 7315ull; binom[22*65+ 5] =                26334ull; binom[22*65+ 6] =                74613ull;
  binom[22*65+ 7] =               170544ull; binom[22*65+ 8] =               319770ull; binom[22*65+ 9] =               497420ull; binom[22*65+10] =               646646ull;
  binom[22*65+11] =               705432ull; binom[22*65+12] =               646646ull; binom[22*65+13] =               497420ull; binom[22*65+14] =               319770ull;
  binom[22*65+15] =               170544ull; binom[22*65+16] =                74613ull; binom[22*65+17] =                26334ull; binom[22*65+18] =                 7315ull;
  binom[22*65+19] =                 1540ull; binom[22*65+20] =                  231ull; binom[22*65+21] =                   22ull; binom[22*65+22] =                    1ull;
  binom[23*65+ 0] =                    1ull; binom[23*65+ 1] =                   23ull; binom[23*65+ 2] =                  253ull; binom[23*65+ 3] =                 1771ull;
  binom[23*65+ 4] =                 8855ull; binom[23*65+ 5] =                33649ull; binom[23*65+ 6] =               100947ull; binom[23*65+ 7] =               245157ull;
  binom[23*65+ 8] =               490314ull; binom[23*65+ 9] =               817190ull; binom[23*65+10] =              1144066ull; binom[23*65+11] =              1352078ull;
  binom[23*65+12] =              1352078ull; binom[23*65+13] =              1144066ull; binom[23*65+14] =               817190ull; binom[23*65+15] =               490314ull;
  binom[23*65+16] =               245157ull; binom[23*65+17] =               100947ull; binom[23*65+18] =                33649ull; binom[23*65+19] =                 8855ull;
  binom[23*65+20] =                 1771ull; binom[23*65+21] =                  253ull; binom[23*65+22] =                   23ull; binom[23*65+23] =                    1ull;
  binom[24*65+ 0] =                    1ull; binom[24*65+ 1] =                   24ull; binom[24*65+ 2] =                  276ull; binom[24*65+ 3] =                 2024ull;
  binom[24*65+ 4] =                10626ull; binom[24*65+ 5] =                42504ull; binom[24*65+ 6] =               134596ull; binom[24*65+ 7] =               346104ull;
  binom[24*65+ 8] =               735471ull; binom[24*65+ 9] =              1307504ull; binom[24*65+10] =              1961256ull; binom[24*65+11] =              2496144ull;
  binom[24*65+12] =              2704156ull; binom[24*65+13] =              2496144ull; binom[24*65+14] =              1961256ull; binom[24*65+15] =              1307504ull;
  binom[24*65+16] =               735471ull; binom[24*65+17] =               346104ull; binom[24*65+18] =               134596ull; binom[24*65+19] =                42504ull;
  binom[24*65+20] =                10626ull; binom[24*65+21] =                 2024ull; binom[24*65+22] =                  276ull; binom[24*65+23] =                   24ull;
  binom[24*65+24] =                    1ull; binom[25*65+ 0] =                    1ull; binom[25*65+ 1] =                   25ull; binom[25*65+ 2] =                  300ull;
  binom[25*65+ 3] =                 2300ull; binom[25*65+ 4] =                12650ull; binom[25*65+ 5] =                53130ull; binom[25*65+ 6] =               177100ull;
  binom[25*65+ 7] =               480700ull; binom[25*65+ 8] =              1081575ull; binom[25*65+ 9] =              2042975ull; binom[25*65+10] =              3268760ull;
  binom[25*65+11] =              4457400ull; binom[25*65+12] =              5200300ull; binom[25*65+13] =              5200300ull; binom[25*65+14] =              4457400ull;
  binom[25*65+15] =              3268760ull; binom[25*65+16] =              2042975ull; binom[25*65+17] =              1081575ull; binom[25*65+18] =               480700ull;
  binom[25*65+19] =               177100ull; binom[25*65+20] =                53130ull; binom[25*65+21] =                12650ull; binom[25*65+22] =                 2300ull;
  binom[25*65+23] =                  300ull; binom[25*65+24] =                   25ull; binom[25*65+25] =                    1ull; binom[26*65+ 0] =                    1ull;
  binom[26*65+ 1] =                   26ull; binom[26*65+ 2] =                  325ull; binom[26*65+ 3] =                 2600ull; binom[26*65+ 4] =                14950ull;
  binom[26*65+ 5] =                65780ull; binom[26*65+ 6] =               230230ull; binom[26*65+ 7] =               657800ull; binom[26*65+ 8] =              1562275ull;
  binom[26*65+ 9] =              3124550ull; binom[26*65+10] =              5311735ull; binom[26*65+11] =              7726160ull; binom[26*65+12] =              9657700ull;
  binom[26*65+13] =             10400600ull; binom[26*65+14] =              9657700ull; binom[26*65+15] =              7726160ull; binom[26*65+16] =              5311735ull;
  binom[26*65+17] =              3124550ull; binom[26*65+18] =              1562275ull; binom[26*65+19] =               657800ull; binom[26*65+20] =               230230ull;
  binom[26*65+21] =                65780ull; binom[26*65+22] =                14950ull; binom[26*65+23] =                 2600ull; binom[26*65+24] =                  325ull;
  binom[26*65+25] =                   26ull; binom[26*65+26] =                    1ull; binom[27*65+ 0] =                    1ull; binom[27*65+ 1] =                   27ull;
  binom[27*65+ 2] =                  351ull; binom[27*65+ 3] =                 2925ull; binom[27*65+ 4] =                17550ull; binom[27*65+ 5] =                80730ull;
  binom[27*65+ 6] =               296010ull; binom[27*65+ 7] =               888030ull; binom[27*65+ 8] =              2220075ull; binom[27*65+ 9] =              4686825ull;
  binom[27*65+10] =              8436285ull; binom[27*65+11] =             13037895ull; binom[27*65+12] =             17383860ull; binom[27*65+13] =             20058300ull;
  binom[27*65+14] =             20058300ull; binom[27*65+15] =             17383860ull; binom[27*65+16] =             13037895ull; binom[27*65+17] =              8436285ull;
  binom[27*65+18] =              4686825ull; binom[27*65+19] =              2220075ull; binom[27*65+20] =               888030ull; binom[27*65+21] =               296010ull;
  binom[27*65+22] =                80730ull; binom[27*65+23] =                17550ull; binom[27*65+24] =                 2925ull; binom[27*65+25] =                  351ull;
  binom[27*65+26] =                   27ull; binom[27*65+27] =                    1ull; binom[28*65+ 0] =                    1ull; binom[28*65+ 1] =                   28ull;
  binom[28*65+ 2] =                  378ull; binom[28*65+ 3] =                 3276ull; binom[28*65+ 4] =                20475ull; binom[28*65+ 5] =                98280ull;
  binom[28*65+ 6] =               376740ull; binom[28*65+ 7] =              1184040ull; binom[28*65+ 8] =              3108105ull; binom[28*65+ 9] =              6906900ull;
  binom[28*65+10] =             13123110ull; binom[28*65+11] =             21474180ull; binom[28*65+12] =             30421755ull; binom[28*65+13] =             37442160ull;
  binom[28*65+14] =             40116600ull; binom[28*65+15] =             37442160ull; binom[28*65+16] =             30421755ull; binom[28*65+17] =             21474180ull;
  binom[28*65+18] =             13123110ull; binom[28*65+19] =              6906900ull; binom[28*65+20] =              3108105ull; binom[28*65+21] =              1184040ull;
  binom[28*65+22] =               376740ull; binom[28*65+23] =                98280ull; binom[28*65+24] =                20475ull; binom[28*65+25] =                 3276ull;
  binom[28*65+26] =                  378ull; binom[28*65+27] =                   28ull; binom[28*65+28] =                    1ull; binom[29*65+ 0] =                    1ull;
  binom[29*65+ 1] =                   29ull; binom[29*65+ 2] =                  406ull; binom[29*65+ 3] =                 3654ull; binom[29*65+ 4] =                23751ull;
  binom[29*65+ 5] =               118755ull; binom[29*65+ 6] =               475020ull; binom[29*65+ 7] =              1560780ull; binom[29*65+ 8] =              4292145ull;
  binom[29*65+ 9] =             10015005ull; binom[29*65+10] =             20030010ull; binom[29*65+11] =             34597290ull; binom[29*65+12] =             51895935ull;
  binom[29*65+13] =             67863915ull; binom[29*65+14] =             77558760ull; binom[29*65+15] =             77558760ull; binom[29*65+16] =             67863915ull;
  binom[29*65+17] =             51895935ull; binom[29*65+18] =             34597290ull; binom[29*65+19] =             20030010ull; binom[29*65+20] =             10015005ull;
  binom[29*65+21] =              4292145ull; binom[29*65+22] =              1560780ull; binom[29*65+23] =               475020ull; binom[29*65+24] =               118755ull;
  binom[29*65+25] =                23751ull; binom[29*65+26] =                 3654ull; binom[29*65+27] =                  406ull; binom[29*65+28] =                   29ull;
  binom[29*65+29] =                    1ull; binom[30*65+ 0] =                    1ull; binom[30*65+ 1] =                   30ull; binom[30*65+ 2] =                  435ull;
  binom[30*65+ 3] =                 4060ull; binom[30*65+ 4] =                27405ull; binom[30*65+ 5] =               142506ull; binom[30*65+ 6] =               593775ull;
  binom[30*65+ 7] =              2035800ull; binom[30*65+ 8] =              5852925ull; binom[30*65+ 9] =             14307150ull; binom[30*65+10] =             30045015ull;
  binom[30*65+11] =             54627300ull; binom[30*65+12] =             86493225ull; binom[30*65+13] =            119759850ull; binom[30*65+14] =            145422675ull;
  binom[30*65+15] =            155117520ull; binom[30*65+16] =            145422675ull; binom[30*65+17] =            119759850ull; binom[30*65+18] =             86493225ull;
  binom[30*65+19] =             54627300ull; binom[30*65+20] =             30045015ull; binom[30*65+21] =             14307150ull; binom[30*65+22] =              5852925ull;
  binom[30*65+23] =              2035800ull; binom[30*65+24] =               593775ull; binom[30*65+25] =               142506ull; binom[30*65+26] =                27405ull;
  binom[30*65+27] =                 4060ull; binom[30*65+28] =                  435ull; binom[30*65+29] =                   30ull; binom[30*65+30] =                    1ull;
  binom[31*65+ 0] =                    1ull; binom[31*65+ 1] =                   31ull; binom[31*65+ 2] =                  465ull; binom[31*65+ 3] =                 4495ull;
  binom[31*65+ 4] =                31465ull; binom[31*65+ 5] =               169911ull; binom[31*65+ 6] =               736281ull; binom[31*65+ 7] =              2629575ull;
  binom[31*65+ 8] =              7888725ull; binom[31*65+ 9] =             20160075ull; binom[31*65+10] =             44352165ull; binom[31*65+11] =             84672315ull;
  binom[31*65+12] =            141120525ull; binom[31*65+13] =            206253075ull; binom[31*65+14] =            265182525ull; binom[31*65+15] =            300540195ull;
  binom[31*65+16] =            300540195ull; binom[31*65+17] =            265182525ull; binom[31*65+18] =            206253075ull; binom[31*65+19] =            141120525ull;
  binom[31*65+20] =             84672315ull; binom[31*65+21] =             44352165ull; binom[31*65+22] =             20160075ull; binom[31*65+23] =              7888725ull;
  binom[31*65+24] =              2629575ull; binom[31*65+25] =               736281ull; binom[31*65+26] =               169911ull; binom[31*65+27] =                31465ull;
  binom[31*65+28] =                 4495ull; binom[31*65+29] =                  465ull; binom[31*65+30] =                   31ull; binom[31*65+31] =                    1ull;
  binom[32*65+ 0] =                    1ull; binom[32*65+ 1] =                   32ull; binom[32*65+ 2] =                  496ull; binom[32*65+ 3] =                 4960ull;
  binom[32*65+ 4] =                35960ull; binom[32*65+ 5] =               201376ull; binom[32*65+ 6] =               906192ull; binom[32*65+ 7] =              3365856ull;
  binom[32*65+ 8] =             10518300ull; binom[32*65+ 9] =             28048800ull; binom[32*65+10] =             64512240ull; binom[32*65+11] =            129024480ull;
  binom[32*65+12] =            225792840ull; binom[32*65+13] =            347373600ull; binom[32*65+14] =            471435600ull; binom[32*65+15] =            565722720ull;
  binom[32*65+16] =            601080390ull; binom[32*65+17] =            565722720ull; binom[32*65+18] =            471435600ull; binom[32*65+19] =            347373600ull;
  binom[32*65+20] =            225792840ull; binom[32*65+21] =            129024480ull; binom[32*65+22] =             64512240ull; binom[32*65+23] =             28048800ull;
  binom[32*65+24] =             10518300ull; binom[32*65+25] =              3365856ull; binom[32*65+26] =               906192ull; binom[32*65+27] =               201376ull;
  binom[32*65+28] =                35960ull; binom[32*65+29] =                 4960ull; binom[32*65+30] =                  496ull; binom[32*65+31] =                   32ull;
  binom[32*65+32] =                    1ull; binom[33*65+ 0] =                    1ull; binom[33*65+ 1] =                   33ull; binom[33*65+ 2] =                  528ull;
  binom[33*65+ 3] =                 5456ull; binom[33*65+ 4] =                40920ull; binom[33*65+ 5] =               237336ull; binom[33*65+ 6] =              1107568ull;
  binom[33*65+ 7] =              4272048ull; binom[33*65+ 8] =             13884156ull; binom[33*65+ 9] =             38567100ull; binom[33*65+10] =             92561040ull;
  binom[33*65+11] =            193536720ull; binom[33*65+12] =            354817320ull; binom[33*65+13] =            573166440ull; binom[33*65+14] =            818809200ull;
  binom[33*65+15] =           1037158320ull; binom[33*65+16] =           1166803110ull; binom[33*65+17] =           1166803110ull; binom[33*65+18] =           1037158320ull;
  binom[33*65+19] =            818809200ull; binom[33*65+20] =            573166440ull; binom[33*65+21] =            354817320ull; binom[33*65+22] =            193536720ull;
  binom[33*65+23] =             92561040ull; binom[33*65+24] =             38567100ull; binom[33*65+25] =             13884156ull; binom[33*65+26] =              4272048ull;
  binom[33*65+27] =              1107568ull; binom[33*65+28] =               237336ull; binom[33*65+29] =                40920ull; binom[33*65+30] =                 5456ull;
  binom[33*65+31] =                  528ull; binom[33*65+32] =                   33ull; binom[33*65+33] =                    1ull; binom[34*65+ 0] =                    1ull;
  binom[34*65+ 1] =                   34ull; binom[34*65+ 2] =                  561ull; binom[34*65+ 3] =                 5984ull; binom[34*65+ 4] =                46376ull;
  binom[34*65+ 5] =               278256ull; binom[34*65+ 6] =              1344904ull; binom[34*65+ 7] =              5379616ull; binom[34*65+ 8] =             18156204ull;
  binom[34*65+ 9] =             52451256ull; binom[34*65+10] =            131128140ull; binom[34*65+11] =            286097760ull; binom[34*65+12] =            548354040ull;
  binom[34*65+13] =            927983760ull; binom[34*65+14] =           1391975640ull; binom[34*65+15] =           1855967520ull; binom[34*65+16] =           2203961430ull;
  binom[34*65+17] =           2333606220ull; binom[34*65+18] =           2203961430ull; binom[34*65+19] =           1855967520ull; binom[34*65+20] =           1391975640ull;
  binom[34*65+21] =            927983760ull; binom[34*65+22] =            548354040ull; binom[34*65+23] =            286097760ull; binom[34*65+24] =            131128140ull;
  binom[34*65+25] =             52451256ull; binom[34*65+26] =             18156204ull; binom[34*65+27] =              5379616ull; binom[34*65+28] =              1344904ull;
  binom[34*65+29] =               278256ull; binom[34*65+30] =                46376ull; binom[34*65+31] =                 5984ull; binom[34*65+32] =                  561ull;
  binom[34*65+33] =                   34ull; binom[34*65+34] =                    1ull; binom[35*65+ 0] =                    1ull; binom[35*65+ 1] =                   35ull;
  binom[35*65+ 2] =                  595ull; binom[35*65+ 3] =                 6545ull; binom[35*65+ 4] =                52360ull; binom[35*65+ 5] =               324632ull;
  binom[35*65+ 6] =              1623160ull; binom[35*65+ 7] =              6724520ull; binom[35*65+ 8] =             23535820ull; binom[35*65+ 9] =             70607460ull;
  binom[35*65+10] =            183579396ull; binom[35*65+11] =            417225900ull; binom[35*65+12] =            834451800ull; binom[35*65+13] =           1476337800ull;
  binom[35*65+14] =           2319959400ull; binom[35*65+15] =           3247943160ull; binom[35*65+16] =           4059928950ull; binom[35*65+17] =           4537567650ull;
  binom[35*65+18] =           4537567650ull; binom[35*65+19] =           4059928950ull; binom[35*65+20] =           3247943160ull; binom[35*65+21] =           2319959400ull;
  binom[35*65+22] =           1476337800ull; binom[35*65+23] =            834451800ull; binom[35*65+24] =            417225900ull; binom[35*65+25] =            183579396ull;
  binom[35*65+26] =             70607460ull; binom[35*65+27] =             23535820ull; binom[35*65+28] =              6724520ull; binom[35*65+29] =              1623160ull;
  binom[35*65+30] =               324632ull; binom[35*65+31] =                52360ull; binom[35*65+32] =                 6545ull; binom[35*65+33] =                  595ull;
  binom[35*65+34] =                   35ull; binom[35*65+35] =                    1ull; binom[36*65+ 0] =                    1ull; binom[36*65+ 1] =                   36ull;
  binom[36*65+ 2] =                  630ull; binom[36*65+ 3] =                 7140ull; binom[36*65+ 4] =                58905ull; binom[36*65+ 5] =               376992ull;
  binom[36*65+ 6] =              1947792ull; binom[36*65+ 7] =              8347680ull; binom[36*65+ 8] =             30260340ull; binom[36*65+ 9] =             94143280ull;
  binom[36*65+10] =            254186856ull; binom[36*65+11] =            600805296ull; binom[36*65+12] =           1251677700ull; binom[36*65+13] =           2310789600ull;
  binom[36*65+14] =           3796297200ull; binom[36*65+15] =           5567902560ull; binom[36*65+16] =           7307872110ull; binom[36*65+17] =           8597496600ull;
  binom[36*65+18] =           9075135300ull; binom[36*65+19] =           8597496600ull; binom[36*65+20] =           7307872110ull; binom[36*65+21] =           5567902560ull;
  binom[36*65+22] =           3796297200ull; binom[36*65+23] =           2310789600ull; binom[36*65+24] =           1251677700ull; binom[36*65+25] =            600805296ull;
  binom[36*65+26] =            254186856ull; binom[36*65+27] =             94143280ull; binom[36*65+28] =             30260340ull; binom[36*65+29] =              8347680ull;
  binom[36*65+30] =              1947792ull; binom[36*65+31] =               376992ull; binom[36*65+32] =                58905ull; binom[36*65+33] =                 7140ull;
  binom[36*65+34] =                  630ull; binom[36*65+35] =                   36ull; binom[36*65+36] =                    1ull; binom[37*65+ 0] =                    1ull;
  binom[37*65+ 1] =                   37ull; binom[37*65+ 2] =                  666ull; binom[37*65+ 3] =                 7770ull; binom[37*65+ 4] =                66045ull;
  binom[37*65+ 5] =               435897ull; binom[37*65+ 6] =              2324784ull; binom[37*65+ 7] =             10295472ull; binom[37*65+ 8] =             38608020ull;
  binom[37*65+ 9] =            124403620ull; binom[37*65+10] =            348330136ull; binom[37*65+11] =            854992152ull; binom[37*65+12] =           1852482996ull;
  binom[37*65+13] =           3562467300ull; binom[37*65+14] =           6107086800ull; binom[37*65+15] =           9364199760ull; binom[37*65+16] =          12875774670ull;
  binom[37*65+17] =          15905368710ull; binom[37*65+18] =          17672631900ull; binom[37*65+19] =          17672631900ull; binom[37*65+20] =          15905368710ull;
  binom[37*65+21] =          12875774670ull; binom[37*65+22] =           9364199760ull; binom[37*65+23] =           6107086800ull; binom[37*65+24] =           3562467300ull;
  binom[37*65+25] =           1852482996ull; binom[37*65+26] =            854992152ull; binom[37*65+27] =            348330136ull; binom[37*65+28] =            124403620ull;
  binom[37*65+29] =             38608020ull; binom[37*65+30] =             10295472ull; binom[37*65+31] =              2324784ull; binom[37*65+32] =               435897ull;
  binom[37*65+33] =                66045ull; binom[37*65+34] =                 7770ull; binom[37*65+35] =                  666ull; binom[37*65+36] =                   37ull;
  binom[37*65+37] =                    1ull; binom[38*65+ 0] =                    1ull; binom[38*65+ 1] =                   38ull; binom[38*65+ 2] =                  703ull;
  binom[38*65+ 3] =                 8436ull; binom[38*65+ 4] =                73815ull; binom[38*65+ 5] =               501942ull; binom[38*65+ 6] =              2760681ull;
  binom[38*65+ 7] =             12620256ull; binom[38*65+ 8] =             48903492ull; binom[38*65+ 9] =            163011640ull; binom[38*65+10] =            472733756ull;
  binom[38*65+11] =           1203322288ull; binom[38*65+12] =           2707475148ull; binom[38*65+13] =           5414950296ull; binom[38*65+14] =           9669554100ull;
  binom[38*65+15] =          15471286560ull; binom[38*65+16] =          22239974430ull; binom[38*65+17] =          28781143380ull; binom[38*65+18] =          33578000610ull;
  binom[38*65+19] =          35345263800ull; binom[38*65+20] =          33578000610ull; binom[38*65+21] =          28781143380ull; binom[38*65+22] =          22239974430ull;
  binom[38*65+23] =          15471286560ull; binom[38*65+24] =           9669554100ull; binom[38*65+25] =           5414950296ull; binom[38*65+26] =           2707475148ull;
  binom[38*65+27] =           1203322288ull; binom[38*65+28] =            472733756ull; binom[38*65+29] =            163011640ull; binom[38*65+30] =             48903492ull;
  binom[38*65+31] =             12620256ull; binom[38*65+32] =              2760681ull; binom[38*65+33] =               501942ull; binom[38*65+34] =                73815ull;
  binom[38*65+35] =                 8436ull; binom[38*65+36] =                  703ull; binom[38*65+37] =                   38ull; binom[38*65+38] =                    1ull;
  binom[39*65+ 0] =                    1ull; binom[39*65+ 1] =                   39ull; binom[39*65+ 2] =                  741ull; binom[39*65+ 3] =                 9139ull;
  binom[39*65+ 4] =                82251ull; binom[39*65+ 5] =               575757ull; binom[39*65+ 6] =              3262623ull; binom[39*65+ 7] =             15380937ull;
  binom[39*65+ 8] =             61523748ull; binom[39*65+ 9] =            211915132ull; binom[39*65+10] =            635745396ull; binom[39*65+11] =           1676056044ull;
  binom[39*65+12] =           3910797436ull; binom[39*65+13] =           8122425444ull; binom[39*65+14] =          15084504396ull; binom[39*65+15] =          25140840660ull;
  binom[39*65+16] =          37711260990ull; binom[39*65+17] =          51021117810ull; binom[39*65+18] =          62359143990ull; binom[39*65+19] =          68923264410ull;
  binom[39*65+20] =          68923264410ull; binom[39*65+21] =          62359143990ull; binom[39*65+22] =          51021117810ull; binom[39*65+23] =          37711260990ull;
  binom[39*65+24] =          25140840660ull; binom[39*65+25] =          15084504396ull; binom[39*65+26] =           8122425444ull; binom[39*65+27] =           3910797436ull;
  binom[39*65+28] =           1676056044ull; binom[39*65+29] =            635745396ull; binom[39*65+30] =            211915132ull; binom[39*65+31] =             61523748ull;
  binom[39*65+32] =             15380937ull; binom[39*65+33] =              3262623ull; binom[39*65+34] =               575757ull; binom[39*65+35] =                82251ull;
  binom[39*65+36] =                 9139ull; binom[39*65+37] =                  741ull; binom[39*65+38] =                   39ull; binom[39*65+39] =                    1ull;
  binom[40*65+ 0] =                    1ull; binom[40*65+ 1] =                   40ull; binom[40*65+ 2] =                  780ull; binom[40*65+ 3] =                 9880ull;
  binom[40*65+ 4] =                91390ull; binom[40*65+ 5] =               658008ull; binom[40*65+ 6] =              3838380ull; binom[40*65+ 7] =             18643560ull;
  binom[40*65+ 8] =             76904685ull; binom[40*65+ 9] =            273438880ull; binom[40*65+10] =            847660528ull; binom[40*65+11] =           2311801440ull;
  binom[40*65+12] =           5586853480ull; binom[40*65+13] =          12033222880ull; binom[40*65+14] =          23206929840ull; binom[40*65+15] =          40225345056ull;
  binom[40*65+16] =          62852101650ull; binom[40*65+17] =          88732378800ull; binom[40*65+18] =         113380261800ull; binom[40*65+19] =         131282408400ull;
  binom[40*65+20] =         137846528820ull; binom[40*65+21] =         131282408400ull; binom[40*65+22] =         113380261800ull; binom[40*65+23] =          88732378800ull;
  binom[40*65+24] =          62852101650ull; binom[40*65+25] =          40225345056ull; binom[40*65+26] =          23206929840ull; binom[40*65+27] =          12033222880ull;
  binom[40*65+28] =           5586853480ull; binom[40*65+29] =           2311801440ull; binom[40*65+30] =            847660528ull; binom[40*65+31] =            273438880ull;
  binom[40*65+32] =             76904685ull; binom[40*65+33] =             18643560ull; binom[40*65+34] =              3838380ull; binom[40*65+35] =               658008ull;
  binom[40*65+36] =                91390ull; binom[40*65+37] =                 9880ull; binom[40*65+38] =                  780ull; binom[40*65+39] =                   40ull;
  binom[40*65+40] =                    1ull; binom[41*65+ 0] =                    1ull; binom[41*65+ 1] =                   41ull; binom[41*65+ 2] =                  820ull;
  binom[41*65+ 3] =                10660ull; binom[41*65+ 4] =               101270ull; binom[41*65+ 5] =               749398ull; binom[41*65+ 6] =              4496388ull;
  binom[41*65+ 7] =             22481940ull; binom[41*65+ 8] =             95548245ull; binom[41*65+ 9] =            350343565ull; binom[41*65+10] =           1121099408ull;
  binom[41*65+11] =           3159461968ull; binom[41*65+12] =           7898654920ull; binom[41*65+13] =          17620076360ull; binom[41*65+14] =          35240152720ull;
  binom[41*65+15] =          63432274896ull; binom[41*65+16] =         103077446706ull; binom[41*65+17] =         151584480450ull; binom[41*65+18] =         202112640600ull;
  binom[41*65+19] =         244662670200ull; binom[41*65+20] =         269128937220ull; binom[41*65+21] =         269128937220ull; binom[41*65+22] =         244662670200ull;
  binom[41*65+23] =         202112640600ull; binom[41*65+24] =         151584480450ull; binom[41*65+25] =         103077446706ull; binom[41*65+26] =          63432274896ull;
  binom[41*65+27] =          35240152720ull; binom[41*65+28] =          17620076360ull; binom[41*65+29] =           7898654920ull; binom[41*65+30] =           3159461968ull;
  binom[41*65+31] =           1121099408ull; binom[41*65+32] =            350343565ull; binom[41*65+33] =             95548245ull; binom[41*65+34] =             22481940ull;
  binom[41*65+35] =              4496388ull; binom[41*65+36] =               749398ull; binom[41*65+37] =               101270ull; binom[41*65+38] =                10660ull;
  binom[41*65+39] =                  820ull; binom[41*65+40] =                   41ull; binom[41*65+41] =                    1ull; binom[42*65+ 0] =                    1ull;
  binom[42*65+ 1] =                   42ull; binom[42*65+ 2] =                  861ull; binom[42*65+ 3] =                11480ull; binom[42*65+ 4] =               111930ull;
  binom[42*65+ 5] =               850668ull; binom[42*65+ 6] =              5245786ull; binom[42*65+ 7] =             26978328ull; binom[42*65+ 8] =            118030185ull;
  binom[42*65+ 9] =            445891810ull; binom[42*65+10] =           1471442973ull; binom[42*65+11] =           4280561376ull; binom[42*65+12] =          11058116888ull;
  binom[42*65+13] =          25518731280ull; binom[42*65+14] =          52860229080ull; binom[42*65+15] =          98672427616ull; binom[42*65+16] =         166509721602ull;
  binom[42*65+17] =         254661927156ull; binom[42*65+18] =         353697121050ull; binom[42*65+19] =         446775310800ull; binom[42*65+20] =         513791607420ull;
  binom[42*65+21] =         538257874440ull; binom[42*65+22] =         513791607420ull; binom[42*65+23] =         446775310800ull; binom[42*65+24] =         353697121050ull;
  binom[42*65+25] =         254661927156ull; binom[42*65+26] =         166509721602ull; binom[42*65+27] =          98672427616ull; binom[42*65+28] =          52860229080ull;
  binom[42*65+29] =          25518731280ull; binom[42*65+30] =          11058116888ull; binom[42*65+31] =           4280561376ull; binom[42*65+32] =           1471442973ull;
  binom[42*65+33] =            445891810ull; binom[42*65+34] =            118030185ull; binom[42*65+35] =             26978328ull; binom[42*65+36] =              5245786ull;
  binom[42*65+37] =               850668ull; binom[42*65+38] =               111930ull; binom[42*65+39] =                11480ull; binom[42*65+40] =                  861ull;
  binom[42*65+41] =                   42ull; binom[42*65+42] =                    1ull; binom[43*65+ 0] =                    1ull; binom[43*65+ 1] =                   43ull;
  binom[43*65+ 2] =                  903ull; binom[43*65+ 3] =                12341ull; binom[43*65+ 4] =               123410ull; binom[43*65+ 5] =               962598ull;
  binom[43*65+ 6] =              6096454ull; binom[43*65+ 7] =             32224114ull; binom[43*65+ 8] =            145008513ull; binom[43*65+ 9] =            563921995ull;
  binom[43*65+10] =           1917334783ull; binom[43*65+11] =           5752004349ull; binom[43*65+12] =          15338678264ull; binom[43*65+13] =          36576848168ull;
  binom[43*65+14] =          78378960360ull; binom[43*65+15] =         151532656696ull; binom[43*65+16] =         265182149218ull; binom[43*65+17] =         421171648758ull;
  binom[43*65+18] =         608359048206ull; binom[43*65+19] =         800472431850ull; binom[43*65+20] =         960566918220ull; binom[43*65+21] =        1052049481860ull;
  binom[43*65+22] =        1052049481860ull; binom[43*65+23] =         960566918220ull; binom[43*65+24] =         800472431850ull; binom[43*65+25] =         608359048206ull;
  binom[43*65+26] =         421171648758ull; binom[43*65+27] =         265182149218ull; binom[43*65+28] =         151532656696ull; binom[43*65+29] =          78378960360ull;
  binom[43*65+30] =          36576848168ull; binom[43*65+31] =          15338678264ull; binom[43*65+32] =           5752004349ull; binom[43*65+33] =           1917334783ull;
  binom[43*65+34] =            563921995ull; binom[43*65+35] =            145008513ull; binom[43*65+36] =             32224114ull; binom[43*65+37] =              6096454ull;
  binom[43*65+38] =               962598ull; binom[43*65+39] =               123410ull; binom[43*65+40] =                12341ull; binom[43*65+41] =                  903ull;
  binom[43*65+42] =                   43ull; binom[43*65+43] =                    1ull; binom[44*65+ 0] =                    1ull; binom[44*65+ 1] =                   44ull;
  binom[44*65+ 2] =                  946ull; binom[44*65+ 3] =                13244ull; binom[44*65+ 4] =               135751ull; binom[44*65+ 5] =              1086008ull;
  binom[44*65+ 6] =              7059052ull; binom[44*65+ 7] =             38320568ull; binom[44*65+ 8] =            177232627ull; binom[44*65+ 9] =            708930508ull;
  binom[44*65+10] =           2481256778ull; binom[44*65+11] =           7669339132ull; binom[44*65+12] =          21090682613ull; binom[44*65+13] =          51915526432ull;
  binom[44*65+14] =         114955808528ull; binom[44*65+15] =         229911617056ull; binom[44*65+16] =         416714805914ull; binom[44*65+17] =         686353797976ull;
  binom[44*65+18] =        1029530696964ull; binom[44*65+19] =        1408831480056ull; binom[44*65+20] =        1761039350070ull; binom[44*65+21] =        2012616400080ull;
  binom[44*65+22] =        2104098963720ull; binom[44*65+23] =        2012616400080ull; binom[44*65+24] =        1761039350070ull; binom[44*65+25] =        1408831480056ull;
  binom[44*65+26] =        1029530696964ull; binom[44*65+27] =         686353797976ull; binom[44*65+28] =         416714805914ull; binom[44*65+29] =         229911617056ull;
  binom[44*65+30] =         114955808528ull; binom[44*65+31] =          51915526432ull; binom[44*65+32] =          21090682613ull; binom[44*65+33] =           7669339132ull;
  binom[44*65+34] =           2481256778ull; binom[44*65+35] =            708930508ull; binom[44*65+36] =            177232627ull; binom[44*65+37] =             38320568ull;
  binom[44*65+38] =              7059052ull; binom[44*65+39] =              1086008ull; binom[44*65+40] =               135751ull; binom[44*65+41] =                13244ull;
  binom[44*65+42] =                  946ull; binom[44*65+43] =                   44ull; binom[44*65+44] =                    1ull; binom[45*65+ 0] =                    1ull;
  binom[45*65+ 1] =                   45ull; binom[45*65+ 2] =                  990ull; binom[45*65+ 3] =                14190ull; binom[45*65+ 4] =               148995ull;
  binom[45*65+ 5] =              1221759ull; binom[45*65+ 6] =              8145060ull; binom[45*65+ 7] =             45379620ull; binom[45*65+ 8] =            215553195ull;
  binom[45*65+ 9] =            886163135ull; binom[45*65+10] =           3190187286ull; binom[45*65+11] =          10150595910ull; binom[45*65+12] =          28760021745ull;
  binom[45*65+13] =          73006209045ull; binom[45*65+14] =         166871334960ull; binom[45*65+15] =         344867425584ull; binom[45*65+16] =         646626422970ull;
  binom[45*65+17] =        1103068603890ull; binom[45*65+18] =        1715884494940ull; binom[45*65+19] =        2438362177020ull; binom[45*65+20] =        3169870830126ull;
  binom[45*65+21] =        3773655750150ull; binom[45*65+22] =        4116715363800ull; binom[45*65+23] =        4116715363800ull; binom[45*65+24] =        3773655750150ull;
  binom[45*65+25] =        3169870830126ull; binom[45*65+26] =        2438362177020ull; binom[45*65+27] =        1715884494940ull; binom[45*65+28] =        1103068603890ull;
  binom[45*65+29] =         646626422970ull; binom[45*65+30] =         344867425584ull; binom[45*65+31] =         166871334960ull; binom[45*65+32] =          73006209045ull;
  binom[45*65+33] =          28760021745ull; binom[45*65+34] =          10150595910ull; binom[45*65+35] =           3190187286ull; binom[45*65+36] =            886163135ull;
  binom[45*65+37] =            215553195ull; binom[45*65+38] =             45379620ull; binom[45*65+39] =              8145060ull; binom[45*65+40] =              1221759ull;
  binom[45*65+41] =               148995ull; binom[45*65+42] =                14190ull; binom[45*65+43] =                  990ull; binom[45*65+44] =                   45ull;
  binom[45*65+45] =                    1ull; binom[46*65+ 0] =                    1ull; binom[46*65+ 1] =                   46ull; binom[46*65+ 2] =                 1035ull;
  binom[46*65+ 3] =                15180ull; binom[46*65+ 4] =               163185ull; binom[46*65+ 5] =              1370754ull; binom[46*65+ 6] =              9366819ull;
  binom[46*65+ 7] =             53524680ull; binom[46*65+ 8] =            260932815ull; binom[46*65+ 9] =           1101716330ull; binom[46*65+10] =           4076350421ull;
  binom[46*65+11] =          13340783196ull; binom[46*65+12] =          38910617655ull; binom[46*65+13] =         101766230790ull; binom[46*65+14] =         239877544005ull;
  binom[46*65+15] =         511738760544ull; binom[46*65+16] =         991493848554ull; binom[46*65+17] =        1749695026860ull; binom[46*65+18] =        2818953098830ull;
  binom[46*65+19] =        4154246671960ull; binom[46*65+20] =        5608233007146ull; binom[46*65+21] =        6943526580276ull; binom[46*65+22] =        7890371113950ull;
  binom[46*65+23] =        8233430727600ull; binom[46*65+24] =        7890371113950ull; binom[46*65+25] =        6943526580276ull; binom[46*65+26] =        5608233007146ull;
  binom[46*65+27] =        4154246671960ull; binom[46*65+28] =        2818953098830ull; binom[46*65+29] =        1749695026860ull; binom[46*65+30] =         991493848554ull;
  binom[46*65+31] =         511738760544ull; binom[46*65+32] =         239877544005ull; binom[46*65+33] =         101766230790ull; binom[46*65+34] =          38910617655ull;
  binom[46*65+35] =          13340783196ull; binom[46*65+36] =           4076350421ull; binom[46*65+37] =           1101716330ull; binom[46*65+38] =            260932815ull;
  binom[46*65+39] =             53524680ull; binom[46*65+40] =              9366819ull; binom[46*65+41] =              1370754ull; binom[46*65+42] =               163185ull;
  binom[46*65+43] =                15180ull; binom[46*65+44] =                 1035ull; binom[46*65+45] =                   46ull; binom[46*65+46] =                    1ull;
  binom[47*65+ 0] =                    1ull; binom[47*65+ 1] =                   47ull; binom[47*65+ 2] =                 1081ull; binom[47*65+ 3] =                16215ull;
  binom[47*65+ 4] =               178365ull; binom[47*65+ 5] =              1533939ull; binom[47*65+ 6] =             10737573ull; binom[47*65+ 7] =             62891499ull;
  binom[47*65+ 8] =            314457495ull; binom[47*65+ 9] =           1362649145ull; binom[47*65+10] =           5178066751ull; binom[47*65+11] =          17417133617ull;
  binom[47*65+12] =          52251400851ull; binom[47*65+13] =         140676848445ull; binom[47*65+14] =         341643774795ull; binom[47*65+15] =         751616304549ull;
  binom[47*65+16] =        1503232609098ull; binom[47*65+17] =        2741188875414ull; binom[47*65+18] =        4568648125690ull; binom[47*65+19] =        6973199770790ull;
  binom[47*65+20] =        9762479679106ull; binom[47*65+21] =       12551759587422ull; binom[47*65+22] =       14833897694226ull; binom[47*65+23] =       16123801841550ull;
  binom[47*65+24] =       16123801841550ull; binom[47*65+25] =       14833897694226ull; binom[47*65+26] =       12551759587422ull; binom[47*65+27] =        9762479679106ull;
  binom[47*65+28] =        6973199770790ull; binom[47*65+29] =        4568648125690ull; binom[47*65+30] =        2741188875414ull; binom[47*65+31] =        1503232609098ull;
  binom[47*65+32] =         751616304549ull; binom[47*65+33] =         341643774795ull; binom[47*65+34] =         140676848445ull; binom[47*65+35] =          52251400851ull;
  binom[47*65+36] =          17417133617ull; binom[47*65+37] =           5178066751ull; binom[47*65+38] =           1362649145ull; binom[47*65+39] =            314457495ull;
  binom[47*65+40] =             62891499ull; binom[47*65+41] =             10737573ull; binom[47*65+42] =              1533939ull; binom[47*65+43] =               178365ull;
  binom[47*65+44] =                16215ull; binom[47*65+45] =                 1081ull; binom[47*65+46] =                   47ull; binom[47*65+47] =                    1ull;
  binom[48*65+ 0] =                    1ull; binom[48*65+ 1] =                   48ull; binom[48*65+ 2] =                 1128ull; binom[48*65+ 3] =                17296ull;
  binom[48*65+ 4] =               194580ull; binom[48*65+ 5] =              1712304ull; binom[48*65+ 6] =             12271512ull; binom[48*65+ 7] =             73629072ull;
  binom[48*65+ 8] =            377348994ull; binom[48*65+ 9] =           1677106640ull; binom[48*65+10] =           6540715896ull; binom[48*65+11] =          22595200368ull;
  binom[48*65+12] =          69668534468ull; binom[48*65+13] =         192928249296ull; binom[48*65+14] =         482320623240ull; binom[48*65+15] =        1093260079344ull;
  binom[48*65+16] =        2254848913647ull; binom[48*65+17] =        4244421484512ull; binom[48*65+18] =        7309837001104ull; binom[48*65+19] =       11541847896480ull;
  binom[48*65+20] =       16735679449896ull; binom[48*65+21] =       22314239266528ull; binom[48*65+22] =       27385657281648ull; binom[48*65+23] =       30957699535776ull;
  binom[48*65+24] =       32247603683100ull; binom[48*65+25] =       30957699535776ull; binom[48*65+26] =       27385657281648ull; binom[48*65+27] =       22314239266528ull;
  binom[48*65+28] =       16735679449896ull; binom[48*65+29] =       11541847896480ull; binom[48*65+30] =        7309837001104ull; binom[48*65+31] =        4244421484512ull;
  binom[48*65+32] =        2254848913647ull; binom[48*65+33] =        1093260079344ull; binom[48*65+34] =         482320623240ull; binom[48*65+35] =         192928249296ull;
  binom[48*65+36] =          69668534468ull; binom[48*65+37] =          22595200368ull; binom[48*65+38] =           6540715896ull; binom[48*65+39] =           1677106640ull;
  binom[48*65+40] =            377348994ull; binom[48*65+41] =             73629072ull; binom[48*65+42] =             12271512ull; binom[48*65+43] =              1712304ull;
  binom[48*65+44] =               194580ull; binom[48*65+45] =                17296ull; binom[48*65+46] =                 1128ull; binom[48*65+47] =                   48ull;
  binom[48*65+48] =                    1ull; binom[49*65+ 0] =                    1ull; binom[49*65+ 1] =                   49ull; binom[49*65+ 2] =                 1176ull;
  binom[49*65+ 3] =                18424ull; binom[49*65+ 4] =               211876ull; binom[49*65+ 5] =              1906884ull; binom[49*65+ 6] =             13983816ull;
  binom[49*65+ 7] =             85900584ull; binom[49*65+ 8] =            450978066ull; binom[49*65+ 9] =           2054455634ull; binom[49*65+10] =           8217822536ull;
  binom[49*65+11] =          29135916264ull; binom[49*65+12] =          92263734836ull; binom[49*65+13] =         262596783764ull; binom[49*65+14] =         675248872536ull;
  binom[49*65+15] =        1575580702584ull; binom[49*65+16] =        3348108992991ull; binom[49*65+17] =        6499270398159ull; binom[49*65+18] =       11554258485616ull;
  binom[49*65+19] =       18851684897584ull; binom[49*65+20] =       28277527346376ull; binom[49*65+21] =       39049918716424ull; binom[49*65+22] =       49699896548176ull;
  binom[49*65+23] =       58343356817424ull; binom[49*65+24] =       63205303218876ull; binom[49*65+25] =       63205303218876ull; binom[49*65+26] =       58343356817424ull;
  binom[49*65+27] =       49699896548176ull; binom[49*65+28] =       39049918716424ull; binom[49*65+29] =       28277527346376ull; binom[49*65+30] =       18851684897584ull;
  binom[49*65+31] =       11554258485616ull; binom[49*65+32] =        6499270398159ull; binom[49*65+33] =        3348108992991ull; binom[49*65+34] =        1575580702584ull;
  binom[49*65+35] =         675248872536ull; binom[49*65+36] =         262596783764ull; binom[49*65+37] =          92263734836ull; binom[49*65+38] =          29135916264ull;
  binom[49*65+39] =           8217822536ull; binom[49*65+40] =           2054455634ull; binom[49*65+41] =            450978066ull; binom[49*65+42] =             85900584ull;
  binom[49*65+43] =             13983816ull; binom[49*65+44] =              1906884ull; binom[49*65+45] =               211876ull; binom[49*65+46] =                18424ull;
  binom[49*65+47] =                 1176ull; binom[49*65+48] =                   49ull; binom[49*65+49] =                    1ull; binom[50*65+ 0] =                    1ull;
  binom[50*65+ 1] =                   50ull; binom[50*65+ 2] =                 1225ull; binom[50*65+ 3] =                19600ull; binom[50*65+ 4] =               230300ull;
  binom[50*65+ 5] =              2118760ull; binom[50*65+ 6] =             15890700ull; binom[50*65+ 7] =             99884400ull; binom[50*65+ 8] =            536878650ull;
  binom[50*65+ 9] =           2505433700ull; binom[50*65+10] =          10272278170ull; binom[50*65+11] =          37353738800ull; binom[50*65+12] =         121399651100ull;
  binom[50*65+13] =         354860518600ull; binom[50*65+14] =         937845656300ull; binom[50*65+15] =        2250829575120ull; binom[50*65+16] =        4923689695575ull;
  binom[50*65+17] =        9847379391150ull; binom[50*65+18] =       18053528883775ull; binom[50*65+19] =       30405943383200ull; binom[50*65+20] =       47129212243960ull;
  binom[50*65+21] =       67327446062800ull; binom[50*65+22] =       88749815264600ull; binom[50*65+23] =      108043253365600ull; binom[50*65+24] =      121548660036300ull;
  binom[50*65+25] =      126410606437752ull; binom[50*65+26] =      121548660036300ull; binom[50*65+27] =      108043253365600ull; binom[50*65+28] =       88749815264600ull;
  binom[50*65+29] =       67327446062800ull; binom[50*65+30] =       47129212243960ull; binom[50*65+31] =       30405943383200ull; binom[50*65+32] =       18053528883775ull;
  binom[50*65+33] =        9847379391150ull; binom[50*65+34] =        4923689695575ull; binom[50*65+35] =        2250829575120ull; binom[50*65+36] =         937845656300ull;
  binom[50*65+37] =         354860518600ull; binom[50*65+38] =         121399651100ull; binom[50*65+39] =          37353738800ull; binom[50*65+40] =          10272278170ull;
  binom[50*65+41] =           2505433700ull; binom[50*65+42] =            536878650ull; binom[50*65+43] =             99884400ull; binom[50*65+44] =             15890700ull;
  binom[50*65+45] =              2118760ull; binom[50*65+46] =               230300ull; binom[50*65+47] =                19600ull; binom[50*65+48] =                 1225ull;
  binom[50*65+49] =                   50ull; binom[50*65+50] =                    1ull; binom[51*65+ 0] =                    1ull; binom[51*65+ 1] =                   51ull;
  binom[51*65+ 2] =                 1275ull; binom[51*65+ 3] =                20825ull; binom[51*65+ 4] =               249900ull; binom[51*65+ 5] =              2349060ull;
  binom[51*65+ 6] =             18009460ull; binom[51*65+ 7] =            115775100ull; binom[51*65+ 8] =            636763050ull; binom[51*65+ 9] =           3042312350ull;
  binom[51*65+10] =          12777711870ull; binom[51*65+11] =          47626016970ull; binom[51*65+12] =         158753389900ull; binom[51*65+13] =         476260169700ull;
  binom[51*65+14] =        1292706174900ull; binom[51*65+15] =        3188675231420ull; binom[51*65+16] =        7174519270695ull; binom[51*65+17] =       14771069086725ull;
  binom[51*65+18] =       27900908274925ull; binom[51*65+19] =       48459472266975ull; binom[51*65+20] =       77535155627160ull; binom[51*65+21] =      114456658306760ull;
  binom[51*65+22] =      156077261327400ull; binom[51*65+23] =      196793068630200ull; binom[51*65+24] =      229591913401900ull; binom[51*65+25] =      247959266474052ull;
  binom[51*65+26] =      247959266474052ull; binom[51*65+27] =      229591913401900ull; binom[51*65+28] =      196793068630200ull; binom[51*65+29] =      156077261327400ull;
  binom[51*65+30] =      114456658306760ull; binom[51*65+31] =       77535155627160ull; binom[51*65+32] =       48459472266975ull; binom[51*65+33] =       27900908274925ull;
  binom[51*65+34] =       14771069086725ull; binom[51*65+35] =        7174519270695ull; binom[51*65+36] =        3188675231420ull; binom[51*65+37] =        1292706174900ull;
  binom[51*65+38] =         476260169700ull; binom[51*65+39] =         158753389900ull; binom[51*65+40] =          47626016970ull; binom[51*65+41] =          12777711870ull;
  binom[51*65+42] =           3042312350ull; binom[51*65+43] =            636763050ull; binom[51*65+44] =            115775100ull; binom[51*65+45] =             18009460ull;
  binom[51*65+46] =              2349060ull; binom[51*65+47] =               249900ull; binom[51*65+48] =                20825ull; binom[51*65+49] =                 1275ull;
  binom[51*65+50] =                   51ull; binom[51*65+51] =                    1ull; binom[52*65+ 0] =                    1ull; binom[52*65+ 1] =                   52ull;
  binom[52*65+ 2] =                 1326ull; binom[52*65+ 3] =                22100ull; binom[52*65+ 4] =               270725ull; binom[52*65+ 5] =              2598960ull;
  binom[52*65+ 6] =             20358520ull; binom[52*65+ 7] =            133784560ull; binom[52*65+ 8] =            752538150ull; binom[52*65+ 9] =           3679075400ull;
  binom[52*65+10] =          15820024220ull; binom[52*65+11] =          60403728840ull; binom[52*65+12] =         206379406870ull; binom[52*65+13] =         635013559600ull;
  binom[52*65+14] =        1768966344600ull; binom[52*65+15] =        4481381406320ull; binom[52*65+16] =       10363194502115ull; binom[52*65+17] =       21945588357420ull;
  binom[52*65+18] =       42671977361650ull; binom[52*65+19] =       76360380541900ull; binom[52*65+20] =      125994627894135ull; binom[52*65+21] =      191991813933920ull;
  binom[52*65+22] =      270533919634160ull; binom[52*65+23] =      352870329957600ull; binom[52*65+24] =      426384982032100ull; binom[52*65+25] =      477551179875952ull;
  binom[52*65+26] =      495918532948104ull; binom[52*65+27] =      477551179875952ull; binom[52*65+28] =      426384982032100ull; binom[52*65+29] =      352870329957600ull;
  binom[52*65+30] =      270533919634160ull; binom[52*65+31] =      191991813933920ull; binom[52*65+32] =      125994627894135ull; binom[52*65+33] =       76360380541900ull;
  binom[52*65+34] =       42671977361650ull; binom[52*65+35] =       21945588357420ull; binom[52*65+36] =       10363194502115ull; binom[52*65+37] =        4481381406320ull;
  binom[52*65+38] =        1768966344600ull; binom[52*65+39] =         635013559600ull; binom[52*65+40] =         206379406870ull; binom[52*65+41] =          60403728840ull;
  binom[52*65+42] =          15820024220ull; binom[52*65+43] =           3679075400ull; binom[52*65+44] =            752538150ull; binom[52*65+45] =            133784560ull;
  binom[52*65+46] =             20358520ull; binom[52*65+47] =              2598960ull; binom[52*65+48] =               270725ull; binom[52*65+49] =                22100ull;
  binom[52*65+50] =                 1326ull; binom[52*65+51] =                   52ull; binom[52*65+52] =                    1ull; binom[53*65+ 0] =                    1ull;
  binom[53*65+ 1] =                   53ull; binom[53*65+ 2] =                 1378ull; binom[53*65+ 3] =                23426ull; binom[53*65+ 4] =               292825ull;
  binom[53*65+ 5] =              2869685ull; binom[53*65+ 6] =             22957480ull; binom[53*65+ 7] =            154143080ull; binom[53*65+ 8] =            886322710ull;
  binom[53*65+ 9] =           4431613550ull; binom[53*65+10] =          19499099620ull; binom[53*65+11] =          76223753060ull; binom[53*65+12] =         266783135710ull;
  binom[53*65+13] =         841392966470ull; binom[53*65+14] =        2403979904200ull; binom[53*65+15] =        6250347750920ull; binom[53*65+16] =       14844575908435ull;
  binom[53*65+17] =       32308782859535ull; binom[53*65+18] =       64617565719070ull; binom[53*65+19] =      119032357903550ull; binom[53*65+20] =      202355008436035ull;
  binom[53*65+21] =      317986441828055ull; binom[53*65+22] =      462525733568080ull; binom[53*65+23] =      623404249591760ull; binom[53*65+24] =      779255311989700ull;
  binom[53*65+25] =      903936161908052ull; binom[53*65+26] =      973469712824056ull; binom[53*65+27] =      973469712824056ull; binom[53*65+28] =      903936161908052ull;
  binom[53*65+29] =      779255311989700ull; binom[53*65+30] =      623404249591760ull; binom[53*65+31] =      462525733568080ull; binom[53*65+32] =      317986441828055ull;
  binom[53*65+33] =      202355008436035ull; binom[53*65+34] =      119032357903550ull; binom[53*65+35] =       64617565719070ull; binom[53*65+36] =       32308782859535ull;
  binom[53*65+37] =       14844575908435ull; binom[53*65+38] =        6250347750920ull; binom[53*65+39] =        2403979904200ull; binom[53*65+40] =         841392966470ull;
  binom[53*65+41] =         266783135710ull; binom[53*65+42] =          76223753060ull; binom[53*65+43] =          19499099620ull; binom[53*65+44] =           4431613550ull;
  binom[53*65+45] =            886322710ull; binom[53*65+46] =            154143080ull; binom[53*65+47] =             22957480ull; binom[53*65+48] =              2869685ull;
  binom[53*65+49] =               292825ull; binom[53*65+50] =                23426ull; binom[53*65+51] =                 1378ull; binom[53*65+52] =                   53ull;
  binom[53*65+53] =                    1ull; binom[54*65+ 0] =                    1ull; binom[54*65+ 1] =                   54ull; binom[54*65+ 2] =                 1431ull;
  binom[54*65+ 3] =                24804ull; binom[54*65+ 4] =               316251ull; binom[54*65+ 5] =              3162510ull; binom[54*65+ 6] =             25827165ull;
  binom[54*65+ 7] =            177100560ull; binom[54*65+ 8] =           1040465790ull; binom[54*65+ 9] =           5317936260ull; binom[54*65+10] =          23930713170ull;
  binom[54*65+11] =          95722852680ull; binom[54*65+12] =         343006888770ull; binom[54*65+13] =        1108176102180ull; binom[54*65+14] =        3245372870670ull;
  binom[54*65+15] =        8654327655120ull; binom[54*65+16] =       21094923659355ull; binom[54*65+17] =       47153358767970ull; binom[54*65+18] =       96926348578605ull;
  binom[54*65+19] =      183649923622620ull; binom[54*65+20] =      321387366339585ull; binom[54*65+21] =      520341450264090ull; binom[54*65+22] =      780512175396135ull;
  binom[54*65+23] =     1085929983159840ull; binom[54*65+24] =     1402659561581460ull; binom[54*65+25] =     1683191473897752ull; binom[54*65+26] =     1877405874732108ull;
  binom[54*65+27] =     1946939425648112ull; binom[54*65+28] =     1877405874732108ull; binom[54*65+29] =     1683191473897752ull; binom[54*65+30] =     1402659561581460ull;
  binom[54*65+31] =     1085929983159840ull; binom[54*65+32] =      780512175396135ull; binom[54*65+33] =      520341450264090ull; binom[54*65+34] =      321387366339585ull;
  binom[54*65+35] =      183649923622620ull; binom[54*65+36] =       96926348578605ull; binom[54*65+37] =       47153358767970ull; binom[54*65+38] =       21094923659355ull;
  binom[54*65+39] =        8654327655120ull; binom[54*65+40] =        3245372870670ull; binom[54*65+41] =        1108176102180ull; binom[54*65+42] =         343006888770ull;
  binom[54*65+43] =          95722852680ull; binom[54*65+44] =          23930713170ull; binom[54*65+45] =           5317936260ull; binom[54*65+46] =           1040465790ull;
  binom[54*65+47] =            177100560ull; binom[54*65+48] =             25827165ull; binom[54*65+49] =              3162510ull; binom[54*65+50] =               316251ull;
  binom[54*65+51] =                24804ull; binom[54*65+52] =                 1431ull; binom[54*65+53] =                   54ull; binom[54*65+54] =                    1ull;
  binom[55*65+ 0] =                    1ull; binom[55*65+ 1] =                   55ull; binom[55*65+ 2] =                 1485ull; binom[55*65+ 3] =                26235ull;
  binom[55*65+ 4] =               341055ull; binom[55*65+ 5] =              3478761ull; binom[55*65+ 6] =             28989675ull; binom[55*65+ 7] =            202927725ull;
  binom[55*65+ 8] =           1217566350ull; binom[55*65+ 9] =           6358402050ull; binom[55*65+10] =          29248649430ull; binom[55*65+11] =         119653565850ull;
  binom[55*65+12] =         438729741450ull; binom[55*65+13] =        1451182990950ull; binom[55*65+14] =        4353548972850ull; binom[55*65+15] =       11899700525790ull;
  binom[55*65+16] =       29749251314475ull; binom[55*65+17] =       68248282427325ull; binom[55*65+18] =      144079707346575ull; binom[55*65+19] =      280576272201225ull;
  binom[55*65+20] =      505037289962205ull; binom[55*65+21] =      841728816603675ull; binom[55*65+22] =     1300853625660225ull; binom[55*65+23] =     1866442158555975ull;
  binom[55*65+24] =     2488589544741300ull; binom[55*65+25] =     3085851035479212ull; binom[55*65+26] =     3560597348629860ull; binom[55*65+27] =     3824345300380220ull;
  binom[55*65+28] =     3824345300380220ull; binom[55*65+29] =     3560597348629860ull; binom[55*65+30] =     3085851035479212ull; binom[55*65+31] =     2488589544741300ull;
  binom[55*65+32] =     1866442158555975ull; binom[55*65+33] =     1300853625660225ull; binom[55*65+34] =      841728816603675ull; binom[55*65+35] =      505037289962205ull;
  binom[55*65+36] =      280576272201225ull; binom[55*65+37] =      144079707346575ull; binom[55*65+38] =       68248282427325ull; binom[55*65+39] =       29749251314475ull;
  binom[55*65+40] =       11899700525790ull; binom[55*65+41] =        4353548972850ull; binom[55*65+42] =        1451182990950ull; binom[55*65+43] =         438729741450ull;
  binom[55*65+44] =         119653565850ull; binom[55*65+45] =          29248649430ull; binom[55*65+46] =           6358402050ull; binom[55*65+47] =           1217566350ull;
  binom[55*65+48] =            202927725ull; binom[55*65+49] =             28989675ull; binom[55*65+50] =              3478761ull; binom[55*65+51] =               341055ull;
  binom[55*65+52] =                26235ull; binom[55*65+53] =                 1485ull; binom[55*65+54] =                   55ull; binom[55*65+55] =                    1ull;
  binom[56*65+ 0] =                    1ull; binom[56*65+ 1] =                   56ull; binom[56*65+ 2] =                 1540ull; binom[56*65+ 3] =                27720ull;
  binom[56*65+ 4] =               367290ull; binom[56*65+ 5] =              3819816ull; binom[56*65+ 6] =             32468436ull; binom[56*65+ 7] =            231917400ull;
  binom[56*65+ 8] =           1420494075ull; binom[56*65+ 9] =           7575968400ull; binom[56*65+10] =          35607051480ull; binom[56*65+11] =         148902215280ull;
  binom[56*65+12] =         558383307300ull; binom[56*65+13] =        1889912732400ull; binom[56*65+14] =        5804731963800ull; binom[56*65+15] =       16253249498640ull;
  binom[56*65+16] =       41648951840265ull; binom[56*65+17] =       97997533741800ull; binom[56*65+18] =      212327989773900ull; binom[56*65+19] =      424655979547800ull;
  binom[56*65+20] =      785613562163430ull; binom[56*65+21] =     1346766106565880ull; binom[56*65+22] =     2142582442263900ull; binom[56*65+23] =     3167295784216200ull;
  binom[56*65+24] =     4355031703297275ull; binom[56*65+25] =     5574440580220512ull; binom[56*65+26] =     6646448384109072ull; binom[56*65+27] =     7384942649010080ull;
  binom[56*65+28] =     7648690600760440ull; binom[56*65+29] =     7384942649010080ull; binom[56*65+30] =     6646448384109072ull; binom[56*65+31] =     5574440580220512ull;
  binom[56*65+32] =     4355031703297275ull; binom[56*65+33] =     3167295784216200ull; binom[56*65+34] =     2142582442263900ull; binom[56*65+35] =     1346766106565880ull;
  binom[56*65+36] =      785613562163430ull; binom[56*65+37] =      424655979547800ull; binom[56*65+38] =      212327989773900ull; binom[56*65+39] =       97997533741800ull;
  binom[56*65+40] =       41648951840265ull; binom[56*65+41] =       16253249498640ull; binom[56*65+42] =        5804731963800ull; binom[56*65+43] =        1889912732400ull;
  binom[56*65+44] =         558383307300ull; binom[56*65+45] =         148902215280ull; binom[56*65+46] =          35607051480ull; binom[56*65+47] =           7575968400ull;
  binom[56*65+48] =           1420494075ull; binom[56*65+49] =            231917400ull; binom[56*65+50] =             32468436ull; binom[56*65+51] =              3819816ull;
  binom[56*65+52] =               367290ull; binom[56*65+53] =                27720ull; binom[56*65+54] =                 1540ull; binom[56*65+55] =                   56ull;
  binom[56*65+56] =                    1ull; binom[57*65+ 0] =                    1ull; binom[57*65+ 1] =                   57ull; binom[57*65+ 2] =                 1596ull;
  binom[57*65+ 3] =                29260ull; binom[57*65+ 4] =               395010ull; binom[57*65+ 5] =              4187106ull; binom[57*65+ 6] =             36288252ull;
  binom[57*65+ 7] =            264385836ull; binom[57*65+ 8] =           1652411475ull; binom[57*65+ 9] =           8996462475ull; binom[57*65+10] =          43183019880ull;
  binom[57*65+11] =         184509266760ull; binom[57*65+12] =         707285522580ull; binom[57*65+13] =        2448296039700ull; binom[57*65+14] =        7694644696200ull;
  binom[57*65+15] =       22057981462440ull; binom[57*65+16] =       57902201338905ull; binom[57*65+17] =      139646485582065ull; binom[57*65+18] =      310325523515700ull;
  binom[57*65+19] =      636983969321700ull; binom[57*65+20] =     1210269541711230ull; binom[57*65+21] =     2132379668729310ull; binom[57*65+22] =     3489348548829780ull;
  binom[57*65+23] =     5309878226480100ull; binom[57*65+24] =     7522327487513475ull; binom[57*65+25] =     9929472283517787ull; binom[57*65+26] =    12220888964329584ull;
  binom[57*65+27] =    14031391033119152ull; binom[57*65+28] =    15033633249770520ull; binom[57*65+29] =    15033633249770520ull; binom[57*65+30] =    14031391033119152ull;
  binom[57*65+31] =    12220888964329584ull; binom[57*65+32] =     9929472283517787ull; binom[57*65+33] =     7522327487513475ull; binom[57*65+34] =     5309878226480100ull;
  binom[57*65+35] =     3489348548829780ull; binom[57*65+36] =     2132379668729310ull; binom[57*65+37] =     1210269541711230ull; binom[57*65+38] =      636983969321700ull;
  binom[57*65+39] =      310325523515700ull; binom[57*65+40] =      139646485582065ull; binom[57*65+41] =       57902201338905ull; binom[57*65+42] =       22057981462440ull;
  binom[57*65+43] =        7694644696200ull; binom[57*65+44] =        2448296039700ull; binom[57*65+45] =         707285522580ull; binom[57*65+46] =         184509266760ull;
  binom[57*65+47] =          43183019880ull; binom[57*65+48] =           8996462475ull; binom[57*65+49] =           1652411475ull; binom[57*65+50] =            264385836ull;
  binom[57*65+51] =             36288252ull; binom[57*65+52] =              4187106ull; binom[57*65+53] =               395010ull; binom[57*65+54] =                29260ull;
  binom[57*65+55] =                 1596ull; binom[57*65+56] =                   57ull; binom[57*65+57] =                    1ull; binom[58*65+ 0] =                    1ull;
  binom[58*65+ 1] =                   58ull; binom[58*65+ 2] =                 1653ull; binom[58*65+ 3] =                30856ull; binom[58*65+ 4] =               424270ull;
  binom[58*65+ 5] =              4582116ull; binom[58*65+ 6] =             40475358ull; binom[58*65+ 7] =            300674088ull; binom[58*65+ 8] =           1916797311ull;
  binom[58*65+ 9] =          10648873950ull; binom[58*65+10] =          52179482355ull; binom[58*65+11] =         227692286640ull; binom[58*65+12] =         891794789340ull;
  binom[58*65+13] =        3155581562280ull; binom[58*65+14] =       10142940735900ull; binom[58*65+15] =       29752626158640ull; binom[58*65+16] =       79960182801345ull;
  binom[58*65+17] =      197548686920970ull; binom[58*65+18] =      449972009097765ull; binom[58*65+19] =      947309492837400ull; binom[58*65+20] =     1847253511032930ull;
  binom[58*65+21] =     3342649210440540ull; binom[58*65+22] =     5621728217559090ull; binom[58*65+23] =     8799226775309880ull; binom[58*65+24] =    12832205713993575ull;
  binom[58*65+25] =    17451799771031262ull; binom[58*65+26] =    22150361247847371ull; binom[58*65+27] =    26252279997448736ull; binom[58*65+28] =    29065024282889672ull;
  binom[58*65+29] =    30067266499541040ull; binom[58*65+30] =    29065024282889672ull; binom[58*65+31] =    26252279997448736ull; binom[58*65+32] =    22150361247847371ull;
  binom[58*65+33] =    17451799771031262ull; binom[58*65+34] =    12832205713993575ull; binom[58*65+35] =     8799226775309880ull; binom[58*65+36] =     5621728217559090ull;
  binom[58*65+37] =     3342649210440540ull; binom[58*65+38] =     1847253511032930ull; binom[58*65+39] =      947309492837400ull; binom[58*65+40] =      449972009097765ull;
  binom[58*65+41] =      197548686920970ull; binom[58*65+42] =       79960182801345ull; binom[58*65+43] =       29752626158640ull; binom[58*65+44] =       10142940735900ull;
  binom[58*65+45] =        3155581562280ull; binom[58*65+46] =         891794789340ull; binom[58*65+47] =         227692286640ull; binom[58*65+48] =          52179482355ull;
  binom[58*65+49] =          10648873950ull; binom[58*65+50] =           1916797311ull; binom[58*65+51] =            300674088ull; binom[58*65+52] =             40475358ull;
  binom[58*65+53] =              4582116ull; binom[58*65+54] =               424270ull; binom[58*65+55] =                30856ull; binom[58*65+56] =                 1653ull;
  binom[58*65+57] =                   58ull; binom[58*65+58] =                    1ull; binom[59*65+ 0] =                    1ull; binom[59*65+ 1] =                   59ull;
  binom[59*65+ 2] =                 1711ull; binom[59*65+ 3] =                32509ull; binom[59*65+ 4] =               455126ull; binom[59*65+ 5] =              5006386ull;
  binom[59*65+ 6] =             45057474ull; binom[59*65+ 7] =            341149446ull; binom[59*65+ 8] =           2217471399ull; binom[59*65+ 9] =          12565671261ull;
  binom[59*65+10] =          62828356305ull; binom[59*65+11] =         279871768995ull; binom[59*65+12] =        1119487075980ull; binom[59*65+13] =        4047376351620ull;
  binom[59*65+14] =       13298522298180ull; binom[59*65+15] =       39895566894540ull; binom[59*65+16] =      109712808959985ull; binom[59*65+17] =      277508869722315ull;
  binom[59*65+18] =      647520696018735ull; binom[59*65+19] =     1397281501935165ull; binom[59*65+20] =     2794563003870330ull; binom[59*65+21] =     5189902721473470ull;
  binom[59*65+22] =     8964377427999630ull; binom[59*65+23] =    14420954992868970ull; binom[59*65+24] =    21631432489303455ull; binom[59*65+25] =    30284005485024837ull;
  binom[59*65+26] =    39602161018878633ull; binom[59*65+27] =    48402641245296107ull; binom[59*65+28] =    55317304280338408ull; binom[59*65+29] =    59132290782430712ull;
  binom[59*65+30] =    59132290782430712ull; binom[59*65+31] =    55317304280338408ull; binom[59*65+32] =    48402641245296107ull; binom[59*65+33] =    39602161018878633ull;
  binom[59*65+34] =    30284005485024837ull; binom[59*65+35] =    21631432489303455ull; binom[59*65+36] =    14420954992868970ull; binom[59*65+37] =     8964377427999630ull;
  binom[59*65+38] =     5189902721473470ull; binom[59*65+39] =     2794563003870330ull; binom[59*65+40] =     1397281501935165ull; binom[59*65+41] =      647520696018735ull;
  binom[59*65+42] =      277508869722315ull; binom[59*65+43] =      109712808959985ull; binom[59*65+44] =       39895566894540ull; binom[59*65+45] =       13298522298180ull;
  binom[59*65+46] =        4047376351620ull; binom[59*65+47] =        1119487075980ull; binom[59*65+48] =         279871768995ull; binom[59*65+49] =          62828356305ull;
  binom[59*65+50] =          12565671261ull; binom[59*65+51] =           2217471399ull; binom[59*65+52] =            341149446ull; binom[59*65+53] =             45057474ull;
  binom[59*65+54] =              5006386ull; binom[59*65+55] =               455126ull; binom[59*65+56] =                32509ull; binom[59*65+57] =                 1711ull;
  binom[59*65+58] =                   59ull; binom[59*65+59] =                    1ull; binom[60*65+ 0] =                    1ull; binom[60*65+ 1] =                   60ull;
  binom[60*65+ 2] =                 1770ull; binom[60*65+ 3] =                34220ull; binom[60*65+ 4] =               487635ull; binom[60*65+ 5] =              5461512ull;
  binom[60*65+ 6] =             50063860ull; binom[60*65+ 7] =            386206920ull; binom[60*65+ 8] =           2558620845ull; binom[60*65+ 9] =          14783142660ull;
  binom[60*65+10] =          75394027566ull; binom[60*65+11] =         342700125300ull; binom[60*65+12] =        1399358844975ull; binom[60*65+13] =        5166863427600ull;
  binom[60*65+14] =       17345898649800ull; binom[60*65+15] =       53194089192720ull; binom[60*65+16] =      149608375854525ull; binom[60*65+17] =      387221678682300ull;
  binom[60*65+18] =      925029565741050ull; binom[60*65+19] =     2044802197953900ull; binom[60*65+20] =     4191844505805495ull; binom[60*65+21] =     7984465725343800ull;
  binom[60*65+22] =    14154280149473100ull; binom[60*65+23] =    23385332420868600ull; binom[60*65+24] =    36052387482172425ull; binom[60*65+25] =    51915437974328292ull;
  binom[60*65+26] =    69886166503903470ull; binom[60*65+27] =    88004802264174740ull; binom[60*65+28] =   103719945525634515ull; binom[60*65+29] =   114449595062769120ull;
  binom[60*65+30] =   118264581564861424ull; binom[60*65+31] =   114449595062769120ull; binom[60*65+32] =   103719945525634515ull; binom[60*65+33] =    88004802264174740ull;
  binom[60*65+34] =    69886166503903470ull; binom[60*65+35] =    51915437974328292ull; binom[60*65+36] =    36052387482172425ull; binom[60*65+37] =    23385332420868600ull;
  binom[60*65+38] =    14154280149473100ull; binom[60*65+39] =     7984465725343800ull; binom[60*65+40] =     4191844505805495ull; binom[60*65+41] =     2044802197953900ull;
  binom[60*65+42] =      925029565741050ull; binom[60*65+43] =      387221678682300ull; binom[60*65+44] =      149608375854525ull; binom[60*65+45] =       53194089192720ull;
  binom[60*65+46] =       17345898649800ull; binom[60*65+47] =        5166863427600ull; binom[60*65+48] =        1399358844975ull; binom[60*65+49] =         342700125300ull;
  binom[60*65+50] =          75394027566ull; binom[60*65+51] =          14783142660ull; binom[60*65+52] =           2558620845ull; binom[60*65+53] =            386206920ull;
  binom[60*65+54] =             50063860ull; binom[60*65+55] =              5461512ull; binom[60*65+56] =               487635ull; binom[60*65+57] =                34220ull;
  binom[60*65+58] =                 1770ull; binom[60*65+59] =                   60ull; binom[60*65+60] =                    1ull; binom[61*65+ 0] =                    1ull;
  binom[61*65+ 1] =                   61ull; binom[61*65+ 2] =                 1830ull; binom[61*65+ 3] =                35990ull; binom[61*65+ 4] =               521855ull;
  binom[61*65+ 5] =              5949147ull; binom[61*65+ 6] =             55525372ull; binom[61*65+ 7] =            436270780ull; binom[61*65+ 8] =           2944827765ull;
  binom[61*65+ 9] =          17341763505ull; binom[61*65+10] =          90177170226ull; binom[61*65+11] =         418094152866ull; binom[61*65+12] =        1742058970275ull;
  binom[61*65+13] =        6566222272575ull; binom[61*65+14] =       22512762077400ull; binom[61*65+15] =       70539987842520ull; binom[61*65+16] =      202802465047245ull;
  binom[61*65+17] =      536830054536825ull; binom[61*65+18] =     1312251244423350ull; binom[61*65+19] =     2969831763694950ull; binom[61*65+20] =     6236646703759395ull;
  binom[61*65+21] =    12176310231149295ull; binom[61*65+22] =    22138745874816900ull; binom[61*65+23] =    37539612570341700ull; binom[61*65+24] =    59437719903041025ull;
  binom[61*65+25] =    87967825456500717ull; binom[61*65+26] =   121801604478231762ull; binom[61*65+27] =   157890968768078210ull; binom[61*65+28] =   191724747789809255ull;
  binom[61*65+29] =   218169540588403635ull; binom[61*65+30] =   232714176627630544ull; binom[61*65+31] =   232714176627630544ull; binom[61*65+32] =   218169540588403635ull;
  binom[61*65+33] =   191724747789809255ull; binom[61*65+34] =   157890968768078210ull; binom[61*65+35] =   121801604478231762ull; binom[61*65+36] =    87967825456500717ull;
  binom[61*65+37] =    59437719903041025ull; binom[61*65+38] =    37539612570341700ull; binom[61*65+39] =    22138745874816900ull; binom[61*65+40] =    12176310231149295ull;
  binom[61*65+41] =     6236646703759395ull; binom[61*65+42] =     2969831763694950ull; binom[61*65+43] =     1312251244423350ull; binom[61*65+44] =      536830054536825ull;
  binom[61*65+45] =      202802465047245ull; binom[61*65+46] =       70539987842520ull; binom[61*65+47] =       22512762077400ull; binom[61*65+48] =        6566222272575ull;
  binom[61*65+49] =        1742058970275ull; binom[61*65+50] =         418094152866ull; binom[61*65+51] =          90177170226ull; binom[61*65+52] =          17341763505ull;
  binom[61*65+53] =           2944827765ull; binom[61*65+54] =            436270780ull; binom[61*65+55] =             55525372ull; binom[61*65+56] =              5949147ull;
  binom[61*65+57] =               521855ull; binom[61*65+58] =                35990ull; binom[61*65+59] =                 1830ull; binom[61*65+60] =                   61ull;
  binom[61*65+61] =                    1ull; binom[62*65+ 0] =                    1ull; binom[62*65+ 1] =                   62ull; binom[62*65+ 2] =                 1891ull;
  binom[62*65+ 3] =                37820ull; binom[62*65+ 4] =               557845ull; binom[62*65+ 5] =              6471002ull; binom[62*65+ 6] =             61474519ull;
  binom[62*65+ 7] =            491796152ull; binom[62*65+ 8] =           3381098545ull; binom[62*65+ 9] =          20286591270ull; binom[62*65+10] =         107518933731ull;
  binom[62*65+11] =         508271323092ull; binom[62*65+12] =        2160153123141ull; binom[62*65+13] =        8308281242850ull; binom[62*65+14] =       29078984349975ull;
  binom[62*65+15] =       93052749919920ull; binom[62*65+16] =      273342452889765ull; binom[62*65+17] =      739632519584070ull; binom[62*65+18] =     1849081298960175ull;
  binom[62*65+19] =     4282083008118300ull; binom[62*65+20] =     9206478467454345ull; binom[62*65+21] =    18412956934908690ull; binom[62*65+22] =    34315056105966195ull;
  binom[62*65+23] =    59678358445158600ull; binom[62*65+24] =    96977332473382725ull; binom[62*65+25] =   147405545359541742ull; binom[62*65+26] =   209769429934732479ull;
  binom[62*65+27] =   279692573246309972ull; binom[62*65+28] =   349615716557887465ull; binom[62*65+29] =   409894288378212890ull; binom[62*65+30] =   450883717216034179ull;
  binom[62*65+31] =   465428353255261088ull; binom[62*65+32] =   450883717216034179ull; binom[62*65+33] =   409894288378212890ull; binom[62*65+34] =   349615716557887465ull;
  binom[62*65+35] =   279692573246309972ull; binom[62*65+36] =   209769429934732479ull; binom[62*65+37] =   147405545359541742ull; binom[62*65+38] =    96977332473382725ull;
  binom[62*65+39] =    59678358445158600ull; binom[62*65+40] =    34315056105966195ull; binom[62*65+41] =    18412956934908690ull; binom[62*65+42] =     9206478467454345ull;
  binom[62*65+43] =     4282083008118300ull; binom[62*65+44] =     1849081298960175ull; binom[62*65+45] =      739632519584070ull; binom[62*65+46] =      273342452889765ull;
  binom[62*65+47] =       93052749919920ull; binom[62*65+48] =       29078984349975ull; binom[62*65+49] =        8308281242850ull; binom[62*65+50] =        2160153123141ull;
  binom[62*65+51] =         508271323092ull; binom[62*65+52] =         107518933731ull; binom[62*65+53] =          20286591270ull; binom[62*65+54] =           3381098545ull;
  binom[62*65+55] =            491796152ull; binom[62*65+56] =             61474519ull; binom[62*65+57] =              6471002ull; binom[62*65+58] =               557845ull;
  binom[62*65+59] =                37820ull; binom[62*65+60] =                 1891ull; binom[62*65+61] =                   62ull; binom[62*65+62] =                    1ull;
  binom[63*65+ 0] =                    1ull; binom[63*65+ 1] =                   63ull; binom[63*65+ 2] =                 1953ull; binom[63*65+ 3] =                39711ull;
  binom[63*65+ 4] =               595665ull; binom[63*65+ 5] =              7028847ull; binom[63*65+ 6] =             67945521ull; binom[63*65+ 7] =            553270671ull;
  binom[63*65+ 8] =           3872894697ull; binom[63*65+ 9] =          23667689815ull; binom[63*65+10] =         127805525001ull; binom[63*65+11] =         615790256823ull;
  binom[63*65+12] =        2668424446233ull; binom[63*65+13] =       10468434365991ull; binom[63*65+14] =       37387265592825ull; binom[63*65+15] =      122131734269895ull;
  binom[63*65+16] =      366395202809685ull; binom[63*65+17] =     1012974972473835ull; binom[63*65+18] =     2588713818544245ull; binom[63*65+19] =     6131164307078475ull;
  binom[63*65+20] =    13488561475572645ull; binom[63*65+21] =    27619435402363035ull; binom[63*65+22] =    52728013040874885ull; binom[63*65+23] =    93993414551124795ull;
  binom[63*65+24] =   156655690918541325ull; binom[63*65+25] =   244382877832924467ull; binom[63*65+26] =   357174975294274221ull; binom[63*65+27] =   489462003181042451ull;
  binom[63*65+28] =   629308289804197437ull; binom[63*65+29] =   759510004936100355ull; binom[63*65+30] =   860778005594247069ull; binom[63*65+31] =   916312070471295267ull;
  binom[63*65+32] =   916312070471295267ull; binom[63*65+33] =   860778005594247069ull; binom[63*65+34] =   759510004936100355ull; binom[63*65+35] =   629308289804197437ull;
  binom[63*65+36] =   489462003181042451ull; binom[63*65+37] =   357174975294274221ull; binom[63*65+38] =   244382877832924467ull; binom[63*65+39] =   156655690918541325ull;
  binom[63*65+40] =    93993414551124795ull; binom[63*65+41] =    52728013040874885ull; binom[63*65+42] =    27619435402363035ull; binom[63*65+43] =    13488561475572645ull;
  binom[63*65+44] =     6131164307078475ull; binom[63*65+45] =     2588713818544245ull; binom[63*65+46] =     1012974972473835ull; binom[63*65+47] =      366395202809685ull;
  binom[63*65+48] =      122131734269895ull; binom[63*65+49] =       37387265592825ull; binom[63*65+50] =       10468434365991ull; binom[63*65+51] =        2668424446233ull;
  binom[63*65+52] =         615790256823ull; binom[63*65+53] =         127805525001ull; binom[63*65+54] =          23667689815ull; binom[63*65+55] =           3872894697ull;
  binom[63*65+56] =            553270671ull; binom[63*65+57] =             67945521ull; binom[63*65+58] =              7028847ull; binom[63*65+59] =               595665ull;
  binom[63*65+60] =                39711ull; binom[63*65+61] =                 1953ull; binom[63*65+62] =                   63ull; binom[63*65+63] =                    1ull;
  binom[64*65+ 0] =                    1ull; binom[64*65+ 1] =                   64ull; binom[64*65+ 2] =                 2016ull; binom[64*65+ 3] =                41664ull;
  binom[64*65+ 4] =               635376ull; binom[64*65+ 5] =              7624512ull; binom[64*65+ 6] =             74974368ull; binom[64*65+ 7] =            621216192ull;
  binom[64*65+ 8] =           4426165368ull; binom[64*65+ 9] =          27540584512ull; binom[64*65+10] =         151473214816ull; binom[64*65+11] =         743595781824ull;
  binom[64*65+12] =        3284214703056ull; binom[64*65+13] =       13136858812224ull; binom[64*65+14] =       47855699958816ull; binom[64*65+15] =      159518999862720ull;
  binom[64*65+16] =      488526937079580ull; binom[64*65+17] =     1379370175283520ull; binom[64*65+18] =     3601688791018080ull; binom[64*65+19] =     8719878125622720ull;
  binom[64*65+20] =    19619725782651120ull; binom[64*65+21] =    41107996877935680ull; binom[64*65+22] =    80347448443237920ull; binom[64*65+23] =   146721427591999680ull;
  binom[64*65+24] =   250649105469666120ull; binom[64*65+25] =   401038568751465792ull; binom[64*65+26] =   601557853127198688ull; binom[64*65+27] =   846636978475316672ull;
  binom[64*65+28] =  1118770292985239888ull; binom[64*65+29] =  1388818294740297792ull; binom[64*65+30] =  1620288010530347424ull; binom[64*65+31] =  1777090076065542336ull;
  binom[64*65+32] =  1832624140942590534ull; binom[64*65+33] =  1777090076065542336ull; binom[64*65+34] =  1620288010530347424ull; binom[64*65+35] =  1388818294740297792ull;
  binom[64*65+36] =  1118770292985239888ull; binom[64*65+37] =   846636978475316672ull; binom[64*65+38] =   601557853127198688ull; binom[64*65+39] =   401038568751465792ull;
  binom[64*65+40] =   250649105469666120ull; binom[64*65+41] =   146721427591999680ull; binom[64*65+42] =    80347448443237920ull; binom[64*65+43] =    41107996877935680ull;
  binom[64*65+44] =    19619725782651120ull; binom[64*65+45] =     8719878125622720ull; binom[64*65+46] =     3601688791018080ull; binom[64*65+47] =     1379370175283520ull;
  binom[64*65+48] =      488526937079580ull; binom[64*65+49] =      159518999862720ull; binom[64*65+50] =       47855699958816ull; binom[64*65+51] =       13136858812224ull;
  binom[64*65+52] =        3284214703056ull; binom[64*65+53] =         743595781824ull; binom[64*65+54] =         151473214816ull; binom[64*65+55] =          27540584512ull;
  binom[64*65+56] =           4426165368ull; binom[64*65+57] =            621216192ull; binom[64*65+58] =             74974368ull; binom[64*65+59] =              7624512ull;
  binom[64*65+60] =               635376ull; binom[64*65+61] =                41664ull; binom[64*65+62] =                 2016ull; binom[64*65+63] =                   64ull;
  binom[64*65+64] =                    1ull;
}

#endif  // FQE_LIB_BINOM_H_
