"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from typing import Any, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="UpdatePredictionRequest")


@_attrs_define
class UpdatePredictionRequest:
    """
    Attributes:
        expected_label (Union[None, Unset, int]):
        tags (Union[Unset, List[str]]):
        memory_id (Union[None, Unset, str]):
    """

    expected_label: Union[None, Unset, int] = UNSET
    tags: Union[Unset, List[str]] = UNSET
    memory_id: Union[None, Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        expected_label: Union[None, Unset, int]
        if isinstance(self.expected_label, Unset):
            expected_label = UNSET
        else:
            expected_label = self.expected_label

        tags: Union[Unset, List[str]] = UNSET
        if not isinstance(self.tags, Unset):
            tags = self.tags

        memory_id: Union[None, Unset, str]
        if isinstance(self.memory_id, Unset):
            memory_id = UNSET
        else:
            memory_id = self.memory_id

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if expected_label is not UNSET:
            field_dict["expected_label"] = expected_label
        if tags is not UNSET:
            field_dict["tags"] = tags
        if memory_id is not UNSET:
            field_dict["memory_id"] = memory_id

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()

        def _parse_expected_label(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        expected_label = _parse_expected_label(d.pop("expected_label", UNSET))

        tags = cast(List[str], d.pop("tags", UNSET))

        def _parse_memory_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        memory_id = _parse_memory_id(d.pop("memory_id", UNSET))

        update_prediction_request = cls(
            expected_label=expected_label,
            tags=tags,
            memory_id=memory_id,
        )

        update_prediction_request.additional_properties = d
        return update_prediction_request

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
