"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.filter_item import FilterItem
    from ..models.telemetry_filter_item import TelemetryFilterItem
    from ..models.telemetry_sort_options import TelemetrySortOptions


T = TypeVar("T", bound="TelemetryMemoriesRequest")


@_attrs_define
class TelemetryMemoriesRequest:
    """
    Attributes:
        memoryset_id (str):
        offset (Union[Unset, int]):  Default: 0.
        limit (Union[Unset, int]):  Default: 100.
        filters (Union[Unset, List[Union['FilterItem', 'TelemetryFilterItem']]]):
        sort (Union[List['TelemetrySortOptions'], None, Unset]):
    """

    memoryset_id: str
    offset: Union[Unset, int] = 0
    limit: Union[Unset, int] = 100
    filters: Union[Unset, List[Union["FilterItem", "TelemetryFilterItem"]]] = UNSET
    sort: Union[List["TelemetrySortOptions"], None, Unset] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        from ..models.filter_item import FilterItem

        memoryset_id = self.memoryset_id

        offset = self.offset

        limit = self.limit

        filters: Union[Unset, List[Dict[str, Any]]] = UNSET
        if not isinstance(self.filters, Unset):
            filters = []
            for filters_item_data in self.filters:
                filters_item: Dict[str, Any]
                if isinstance(filters_item_data, FilterItem):
                    filters_item = filters_item_data.to_dict()
                else:
                    filters_item = filters_item_data.to_dict()

                filters.append(filters_item)

        sort: Union[List[Dict[str, Any]], None, Unset]
        if isinstance(self.sort, Unset):
            sort = UNSET
        elif isinstance(self.sort, list):
            sort = []
            for sort_type_0_item_data in self.sort:
                sort_type_0_item = sort_type_0_item_data.to_dict()
                sort.append(sort_type_0_item)

        else:
            sort = self.sort

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "memoryset_id": memoryset_id,
            }
        )
        if offset is not UNSET:
            field_dict["offset"] = offset
        if limit is not UNSET:
            field_dict["limit"] = limit
        if filters is not UNSET:
            field_dict["filters"] = filters
        if sort is not UNSET:
            field_dict["sort"] = sort

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        from ..models.filter_item import FilterItem
        from ..models.telemetry_filter_item import TelemetryFilterItem
        from ..models.telemetry_sort_options import TelemetrySortOptions

        d = src_dict.copy()
        memoryset_id = d.pop("memoryset_id")

        offset = d.pop("offset", UNSET)

        limit = d.pop("limit", UNSET)

        filters = []
        _filters = d.pop("filters", UNSET)
        for filters_item_data in _filters or []:

            def _parse_filters_item(data: object) -> Union["FilterItem", "TelemetryFilterItem"]:
                try:
                    if not isinstance(data, dict):
                        raise TypeError()
                    filters_item_type_0 = FilterItem.from_dict(data)

                    return filters_item_type_0
                except:  # noqa: E722
                    pass
                if not isinstance(data, dict):
                    raise TypeError()
                filters_item_type_1 = TelemetryFilterItem.from_dict(data)

                return filters_item_type_1

            filters_item = _parse_filters_item(filters_item_data)

            filters.append(filters_item)

        def _parse_sort(data: object) -> Union[List["TelemetrySortOptions"], None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, list):
                    raise TypeError()
                sort_type_0 = []
                _sort_type_0 = data
                for sort_type_0_item_data in _sort_type_0:
                    sort_type_0_item = TelemetrySortOptions.from_dict(sort_type_0_item_data)

                    sort_type_0.append(sort_type_0_item)

                return sort_type_0
            except:  # noqa: E722
                pass
            return cast(Union[List["TelemetrySortOptions"], None, Unset], data)

        sort = _parse_sort(d.pop("sort", UNSET))

        telemetry_memories_request = cls(
            memoryset_id=memoryset_id,
            offset=offset,
            limit=limit,
            filters=filters,
            sort=sort,
        )

        telemetry_memories_request.additional_properties = d
        return telemetry_memories_request

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
