"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

import datetime
from enum import Enum
from typing import Any, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..models.task_status import TaskStatus

T = TypeVar("T", bound="TaskStatusInfo")


@_attrs_define
class TaskStatusInfo:
    """
    Attributes:
        status (TaskStatus): Status of task in the task queue
        steps_total (Union[None, int]):
        steps_completed (Union[None, int]):
        exception (Union[None, str]):
        updated_at (datetime.datetime):
        created_at (datetime.datetime):
    """

    status: TaskStatus
    steps_total: Union[None, int]
    steps_completed: Union[None, int]
    exception: Union[None, str]
    updated_at: datetime.datetime
    created_at: datetime.datetime
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        status = self.status.value if isinstance(self.status, Enum) else self.status

        steps_total: Union[None, int]
        steps_total = self.steps_total

        steps_completed: Union[None, int]
        steps_completed = self.steps_completed

        exception: Union[None, str]
        exception = self.exception

        updated_at = self.updated_at.isoformat()

        created_at = self.created_at.isoformat()

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "status": status,
                "steps_total": steps_total,
                "steps_completed": steps_completed,
                "exception": exception,
                "updated_at": updated_at,
                "created_at": created_at,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()
        status = TaskStatus(d.pop("status"))

        def _parse_steps_total(data: object) -> Union[None, int]:
            if data is None:
                return data
            return cast(Union[None, int], data)

        steps_total = _parse_steps_total(d.pop("steps_total"))

        def _parse_steps_completed(data: object) -> Union[None, int]:
            if data is None:
                return data
            return cast(Union[None, int], data)

        steps_completed = _parse_steps_completed(d.pop("steps_completed"))

        def _parse_exception(data: object) -> Union[None, str]:
            if data is None:
                return data
            return cast(Union[None, str], data)

        exception = _parse_exception(d.pop("exception"))

        updated_at = isoparse(d.pop("updated_at"))

        created_at = isoparse(d.pop("created_at"))

        task_status_info = cls(
            status=status,
            steps_total=steps_total,
            steps_completed=steps_completed,
            exception=exception,
            updated_at=updated_at,
            created_at=created_at,
        )

        task_status_info.additional_properties = d
        return task_status_info

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
