"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

import datetime
from enum import Enum
from typing import Any, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..models.rac_head_type import RACHeadType

T = TypeVar("T", bound="RACModelMetadata")


@_attrs_define
class RACModelMetadata:
    """
    Attributes:
        id (str):
        org_id (str):
        name (str):
        description (Union[None, str]):
        version (int):
        num_classes (int):
        head_type (RACHeadType):
        memoryset_id (str):
        memory_lookup_count (int):
        weigh_memories (Union[None, bool]):
        min_memory_weight (Union[None, float]):
        storage_path (str):
        memoryset_collection_name (str):
        created_at (datetime.datetime):
        updated_at (datetime.datetime):
    """

    id: str
    org_id: str
    name: str
    description: Union[None, str]
    version: int
    num_classes: int
    head_type: RACHeadType
    memoryset_id: str
    memory_lookup_count: int
    weigh_memories: Union[None, bool]
    min_memory_weight: Union[None, float]
    storage_path: str
    memoryset_collection_name: str
    created_at: datetime.datetime
    updated_at: datetime.datetime
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        id = self.id

        org_id = self.org_id

        name = self.name

        description: Union[None, str]
        description = self.description

        version = self.version

        num_classes = self.num_classes

        head_type = self.head_type.value if isinstance(self.head_type, Enum) else self.head_type

        memoryset_id = self.memoryset_id

        memory_lookup_count = self.memory_lookup_count

        weigh_memories: Union[None, bool]
        weigh_memories = self.weigh_memories

        min_memory_weight: Union[None, float]
        min_memory_weight = self.min_memory_weight

        storage_path = self.storage_path

        memoryset_collection_name = self.memoryset_collection_name

        created_at = self.created_at.isoformat()

        updated_at = self.updated_at.isoformat()

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "id": id,
                "org_id": org_id,
                "name": name,
                "description": description,
                "version": version,
                "num_classes": num_classes,
                "head_type": head_type,
                "memoryset_id": memoryset_id,
                "memory_lookup_count": memory_lookup_count,
                "weigh_memories": weigh_memories,
                "min_memory_weight": min_memory_weight,
                "storage_path": storage_path,
                "memoryset_collection_name": memoryset_collection_name,
                "created_at": created_at,
                "updated_at": updated_at,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()
        id = d.pop("id")

        org_id = d.pop("org_id")

        name = d.pop("name")

        def _parse_description(data: object) -> Union[None, str]:
            if data is None:
                return data
            return cast(Union[None, str], data)

        description = _parse_description(d.pop("description"))

        version = d.pop("version")

        num_classes = d.pop("num_classes")

        head_type = RACHeadType(d.pop("head_type"))

        memoryset_id = d.pop("memoryset_id")

        memory_lookup_count = d.pop("memory_lookup_count")

        def _parse_weigh_memories(data: object) -> Union[None, bool]:
            if data is None:
                return data
            return cast(Union[None, bool], data)

        weigh_memories = _parse_weigh_memories(d.pop("weigh_memories"))

        def _parse_min_memory_weight(data: object) -> Union[None, float]:
            if data is None:
                return data
            return cast(Union[None, float], data)

        min_memory_weight = _parse_min_memory_weight(d.pop("min_memory_weight"))

        storage_path = d.pop("storage_path")

        memoryset_collection_name = d.pop("memoryset_collection_name")

        created_at = isoparse(d.pop("created_at"))

        updated_at = isoparse(d.pop("updated_at"))

        rac_model_metadata = cls(
            id=id,
            org_id=org_id,
            name=name,
            description=description,
            version=version,
            num_classes=num_classes,
            head_type=head_type,
            memoryset_id=memoryset_id,
            memory_lookup_count=memory_lookup_count,
            weigh_memories=weigh_memories,
            min_memory_weight=min_memory_weight,
            storage_path=storage_path,
            memoryset_collection_name=memoryset_collection_name,
            created_at=created_at,
            updated_at=updated_at,
        )

        rac_model_metadata.additional_properties = d
        return rac_model_metadata

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
