"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from enum import Enum
from typing import Any, Type, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.pretrained_embedding_model_name import PretrainedEmbeddingModelName

T = TypeVar("T", bound="PretrainedEmbeddingModelMetadata")


@_attrs_define
class PretrainedEmbeddingModelMetadata:
    """
    Attributes:
        embedding_dim (int):
        max_seq_length (int):
        uses_context (bool):
        name (PretrainedEmbeddingModelName): Names of pretrained embedding models that are supported by OrcaCloud
    """

    embedding_dim: int
    max_seq_length: int
    uses_context: bool
    name: PretrainedEmbeddingModelName
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        embedding_dim = self.embedding_dim

        max_seq_length = self.max_seq_length

        uses_context = self.uses_context

        name = self.name.value if isinstance(self.name, Enum) else self.name

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "embedding_dim": embedding_dim,
                "max_seq_length": max_seq_length,
                "uses_context": uses_context,
                "name": name,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()
        embedding_dim = d.pop("embedding_dim")

        max_seq_length = d.pop("max_seq_length")

        uses_context = d.pop("uses_context")

        name = PretrainedEmbeddingModelName(d.pop("name"))

        pretrained_embedding_model_metadata = cls(
            embedding_dim=embedding_dim,
            max_seq_length=max_seq_length,
            uses_context=uses_context,
            name=name,
        )

        pretrained_embedding_model_metadata.additional_properties = d
        return pretrained_embedding_model_metadata

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
