"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from typing import Any, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="PredictionRequest")


@_attrs_define
class PredictionRequest:
    """
    Attributes:
        input_values (List[str]):
        expected_labels (Union[List[int], None, Unset]):
        tags (Union[Unset, List[str]]):
        memoryset_override_id (Union[None, Unset, str]):
    """

    input_values: List[str]
    expected_labels: Union[List[int], None, Unset] = UNSET
    tags: Union[Unset, List[str]] = UNSET
    memoryset_override_id: Union[None, Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        input_values: List[str]
        if isinstance(self.input_values, list):
            input_values = self.input_values

        expected_labels: Union[List[int], None, Unset]
        if isinstance(self.expected_labels, Unset):
            expected_labels = UNSET
        elif isinstance(self.expected_labels, list):
            expected_labels = self.expected_labels

        else:
            expected_labels = self.expected_labels

        tags: Union[Unset, List[str]] = UNSET
        if not isinstance(self.tags, Unset):
            tags = self.tags

        memoryset_override_id: Union[None, Unset, str]
        if isinstance(self.memoryset_override_id, Unset):
            memoryset_override_id = UNSET
        else:
            memoryset_override_id = self.memoryset_override_id

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "input_values": input_values,
            }
        )
        if expected_labels is not UNSET:
            field_dict["expected_labels"] = expected_labels
        if tags is not UNSET:
            field_dict["tags"] = tags
        if memoryset_override_id is not UNSET:
            field_dict["memoryset_override_id"] = memoryset_override_id

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()

        def _parse_input_values(data: object) -> List[str]:
            try:
                if not isinstance(data, list):
                    raise TypeError()
                input_values_type_0 = cast(List[str], data)

                return input_values_type_0
            except:  # noqa: E722
                pass
            try:
                if not isinstance(data, list):
                    raise TypeError()
                input_values_type_1 = cast(List[str], data)

                return input_values_type_1
            except:  # noqa: E722
                pass
            try:
                if not isinstance(data, list):
                    raise TypeError()
                input_values_type_2 = cast(List[str], data)

                return input_values_type_2
            except:  # noqa: E722
                pass
            if not isinstance(data, list):
                raise TypeError()
            input_values_type_3 = []
            _input_values_type_3 = data
            for input_values_type_3_item_data in _input_values_type_3:

                def _parse_input_values_type_3_item(data: object) -> str:
                    return cast(str, data)

                input_values_type_3_item = _parse_input_values_type_3_item(input_values_type_3_item_data)

                input_values_type_3.append(input_values_type_3_item)

            return input_values_type_3

        input_values = _parse_input_values(d.pop("input_values"))

        def _parse_expected_labels(data: object) -> Union[List[int], None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, list):
                    raise TypeError()
                expected_labels_type_0 = cast(List[int], data)

                return expected_labels_type_0
            except:  # noqa: E722
                pass
            return cast(Union[List[int], None, Unset], data)

        expected_labels = _parse_expected_labels(d.pop("expected_labels", UNSET))

        tags = cast(List[str], d.pop("tags", UNSET))

        def _parse_memoryset_override_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        memoryset_override_id = _parse_memoryset_override_id(d.pop("memoryset_override_id", UNSET))

        prediction_request = cls(
            input_values=input_values,
            expected_labels=expected_labels,
            tags=tags,
            memoryset_override_id=memoryset_override_id,
        )

        prediction_request.additional_properties = d
        return prediction_request

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
