"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from typing import Any, List, Type, TypeVar, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

T = TypeVar("T", bound="PredictionFeedbackResult")


@_attrs_define
class PredictionFeedbackResult:
    """
    Attributes:
        prediction_ids (List[str]):
        deleted_feedback_ids (List[str]):
        updated_feedback_ids (List[str]):
        inserted_feedback_ids (List[str]):
        new_category_ids (List[str]):
    """

    prediction_ids: List[str]
    deleted_feedback_ids: List[str]
    updated_feedback_ids: List[str]
    inserted_feedback_ids: List[str]
    new_category_ids: List[str]
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        prediction_ids = self.prediction_ids

        deleted_feedback_ids = self.deleted_feedback_ids

        updated_feedback_ids = self.updated_feedback_ids

        inserted_feedback_ids = self.inserted_feedback_ids

        new_category_ids = self.new_category_ids

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "prediction_ids": prediction_ids,
                "deleted_feedback_ids": deleted_feedback_ids,
                "updated_feedback_ids": updated_feedback_ids,
                "inserted_feedback_ids": inserted_feedback_ids,
                "new_category_ids": new_category_ids,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()
        prediction_ids = cast(List[str], d.pop("prediction_ids"))

        deleted_feedback_ids = cast(List[str], d.pop("deleted_feedback_ids"))

        updated_feedback_ids = cast(List[str], d.pop("updated_feedback_ids"))

        inserted_feedback_ids = cast(List[str], d.pop("inserted_feedback_ids"))

        new_category_ids = cast(List[str], d.pop("new_category_ids"))

        prediction_feedback_result = cls(
            prediction_ids=prediction_ids,
            deleted_feedback_ids=deleted_feedback_ids,
            updated_feedback_ids=updated_feedback_ids,
            inserted_feedback_ids=inserted_feedback_ids,
            new_category_ids=new_category_ids,
        )

        prediction_feedback_result.additional_properties = d
        return prediction_feedback_result

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
