"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from typing import Any, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="PredictionFeedbackRequest")


@_attrs_define
class PredictionFeedbackRequest:
    """
    Attributes:
        prediction_id (str):
        category_name (str):
        value (Union[None, Unset, bool, float]): The feedback value. For updates, UNSET means keep existing value. None
            means delete the feedback.
        comment (Union[None, Unset, str]): Optional comment. For updates, UNSET means keep existing comment. None means
            remove the comment.
    """

    prediction_id: str
    category_name: str
    value: Union[None, Unset, bool, float] = UNSET
    comment: Union[None, Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        prediction_id = self.prediction_id

        category_name = self.category_name

        value: Union[None, Unset, bool, float]
        if isinstance(self.value, Unset):
            value = UNSET
        else:
            value = self.value

        comment: Union[None, Unset, str]
        if isinstance(self.comment, Unset):
            comment = UNSET
        else:
            comment = self.comment

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "prediction_id": prediction_id,
                "category_name": category_name,
            }
        )
        if value is not UNSET:
            field_dict["value"] = value
        if comment is not UNSET:
            field_dict["comment"] = comment

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()
        prediction_id = d.pop("prediction_id")

        category_name = d.pop("category_name")

        def _parse_value(data: object) -> Union[None, Unset, bool, float]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, bool, float], data)

        value = _parse_value(d.pop("value", UNSET))

        def _parse_comment(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        comment = _parse_comment(d.pop("comment", UNSET))

        prediction_feedback_request = cls(
            prediction_id=prediction_id,
            category_name=category_name,
            value=value,
            comment=comment,
        )

        prediction_feedback_request.additional_properties = d
        return prediction_feedback_request

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
