"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

import datetime
from enum import Enum
from typing import Any, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..models.feedback_type import FeedbackType

T = TypeVar("T", bound="PredictionFeedback")


@_attrs_define
class PredictionFeedback:
    """
    Attributes:
        prediction_id (str):
        category_name (str):
        value (Union[bool, float]):
        comment (Union[None, str]):
        id (str):
        org_id (str):
        category_id (str):
        category_type (FeedbackType):
        created_at (datetime.datetime):
        updated_at (datetime.datetime):
    """

    prediction_id: str
    category_name: str
    value: Union[bool, float]
    comment: Union[None, str]
    id: str
    org_id: str
    category_id: str
    category_type: FeedbackType
    created_at: datetime.datetime
    updated_at: datetime.datetime
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        prediction_id = self.prediction_id

        category_name = self.category_name

        value: Union[bool, float]
        value = self.value

        comment: Union[None, str]
        comment = self.comment

        id = self.id

        org_id = self.org_id

        category_id = self.category_id

        category_type = self.category_type.value if isinstance(self.category_type, Enum) else self.category_type

        created_at = self.created_at.isoformat()

        updated_at = self.updated_at.isoformat()

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "prediction_id": prediction_id,
                "category_name": category_name,
                "value": value,
                "comment": comment,
                "id": id,
                "org_id": org_id,
                "category_id": category_id,
                "category_type": category_type,
                "created_at": created_at,
                "updated_at": updated_at,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()
        prediction_id = d.pop("prediction_id")

        category_name = d.pop("category_name")

        def _parse_value(data: object) -> Union[bool, float]:
            return cast(Union[bool, float], data)

        value = _parse_value(d.pop("value"))

        def _parse_comment(data: object) -> Union[None, str]:
            if data is None:
                return data
            return cast(Union[None, str], data)

        comment = _parse_comment(d.pop("comment"))

        id = d.pop("id")

        org_id = d.pop("org_id")

        category_id = d.pop("category_id")

        category_type = FeedbackType(d.pop("category_type"))

        created_at = isoparse(d.pop("created_at"))

        updated_at = isoparse(d.pop("updated_at"))

        prediction_feedback = cls(
            prediction_id=prediction_id,
            category_name=category_name,
            value=value,
            comment=comment,
            id=id,
            org_id=org_id,
            category_id=category_id,
            category_type=category_type,
            created_at=created_at,
            updated_at=updated_at,
        )

        prediction_feedback.additional_properties = d
        return prediction_feedback

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
