"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from typing import TYPE_CHECKING, Any, List, Type, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

if TYPE_CHECKING:
    from ..models.labeled_memory_with_feedback_metrics import LabeledMemoryWithFeedbackMetrics


T = TypeVar("T", bound="PaginatedLabeledMemoryWithFeedbackMetrics")


@_attrs_define
class PaginatedLabeledMemoryWithFeedbackMetrics:
    """
    Attributes:
        items (List['LabeledMemoryWithFeedbackMetrics']):
        total (int):
        offset (int):
        limit (int):
    """

    items: List["LabeledMemoryWithFeedbackMetrics"]
    total: int
    offset: int
    limit: int
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        items = []
        for items_item_data in self.items:
            items_item = items_item_data.to_dict()
            items.append(items_item)

        total = self.total

        offset = self.offset

        limit = self.limit

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "items": items,
                "total": total,
                "offset": offset,
                "limit": limit,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        from ..models.labeled_memory_with_feedback_metrics import LabeledMemoryWithFeedbackMetrics

        d = src_dict.copy()
        items = []
        _items = d.pop("items")
        for items_item_data in _items:
            items_item = LabeledMemoryWithFeedbackMetrics.from_dict(items_item_data)

            items.append(items_item)

        total = d.pop("total")

        offset = d.pop("offset")

        limit = d.pop("limit")

        paginated_labeled_memory_with_feedback_metrics = cls(
            items=items,
            total=total,
            offset=offset,
            limit=limit,
        )

        paginated_labeled_memory_with_feedback_metrics.additional_properties = d
        return paginated_labeled_memory_with_feedback_metrics

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
