"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from enum import Enum
from typing import Any, Literal, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.not_found_error_response_resource_type_0 import NotFoundErrorResponseResourceType0

T = TypeVar("T", bound="NotFoundErrorResponse")


@_attrs_define
class NotFoundErrorResponse:
    """
    Attributes:
        status_code (Literal[404]):
        resource (Union[None, NotFoundErrorResponseResourceType0]):
    """

    status_code: Literal[404]
    resource: Union[None, NotFoundErrorResponseResourceType0]
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        status_code = self.status_code

        resource: Union[None, str]
        if isinstance(self.resource, NotFoundErrorResponseResourceType0):
            resource = self.resource.value if isinstance(self.resource, Enum) else self.resource
        else:
            resource = self.resource

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "status_code": status_code,
                "resource": resource,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()
        status_code = cast(Literal[404], d.pop("status_code"))
        if status_code != 404:
            raise ValueError(f"status_code must match const 404, got '{status_code}'")

        def _parse_resource(data: object) -> Union[None, NotFoundErrorResponseResourceType0]:
            if data is None:
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                resource_type_0 = NotFoundErrorResponseResourceType0(data)

                return resource_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, NotFoundErrorResponseResourceType0], data)

        resource = _parse_resource(d.pop("resource"))

        not_found_error_response = cls(
            status_code=status_code,
            resource=resource,
        )

        not_found_error_response.additional_properties = d
        return not_found_error_response

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
