"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from typing import Any, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="MemorysetNeighborAnalysisConfig")


@_attrs_define
class MemorysetNeighborAnalysisConfig:
    """
    Attributes:
        neighbor_counts (Union[Unset, List[int]]):
        quantiles (Union[Unset, List[float]]):
    """

    neighbor_counts: Union[Unset, List[int]] = UNSET
    quantiles: Union[Unset, List[float]] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        neighbor_counts: Union[Unset, List[int]] = UNSET
        if not isinstance(self.neighbor_counts, Unset):
            neighbor_counts = self.neighbor_counts

        quantiles: Union[Unset, List[float]] = UNSET
        if not isinstance(self.quantiles, Unset):
            quantiles = self.quantiles

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if neighbor_counts is not UNSET:
            field_dict["neighbor_counts"] = neighbor_counts
        if quantiles is not UNSET:
            field_dict["quantiles"] = quantiles

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()
        neighbor_counts = cast(List[int], d.pop("neighbor_counts", UNSET))

        quantiles = cast(List[float], d.pop("quantiles", UNSET))

        memoryset_neighbor_analysis_config = cls(
            neighbor_counts=neighbor_counts,
            quantiles=quantiles,
        )

        memoryset_neighbor_analysis_config.additional_properties = d
        return memoryset_neighbor_analysis_config

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
