"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from typing import TYPE_CHECKING, Any, Dict, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.memoryset_cluster_metrics import MemorysetClusterMetrics
    from ..models.memoryset_duplicate_metrics import MemorysetDuplicateMetrics
    from ..models.memoryset_label_metrics import MemorysetLabelMetrics
    from ..models.memoryset_neighbor_metrics import MemorysetNeighborMetrics
    from ..models.memoryset_projection_metrics import MemorysetProjectionMetrics


T = TypeVar("T", bound="MemorysetMetrics")


@_attrs_define
class MemorysetMetrics:
    """
    Attributes:
        neighbor (Union['MemorysetNeighborMetrics', None, Unset]):
        label (Union['MemorysetLabelMetrics', None, Unset]):
        duplicate (Union['MemorysetDuplicateMetrics', None, Unset]):
        projection (Union['MemorysetProjectionMetrics', None, Unset]):
        cluster (Union['MemorysetClusterMetrics', None, Unset]):
    """

    neighbor: Union["MemorysetNeighborMetrics", None, Unset] = UNSET
    label: Union["MemorysetLabelMetrics", None, Unset] = UNSET
    duplicate: Union["MemorysetDuplicateMetrics", None, Unset] = UNSET
    projection: Union["MemorysetProjectionMetrics", None, Unset] = UNSET
    cluster: Union["MemorysetClusterMetrics", None, Unset] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        from ..models.memoryset_cluster_metrics import MemorysetClusterMetrics
        from ..models.memoryset_duplicate_metrics import MemorysetDuplicateMetrics
        from ..models.memoryset_label_metrics import MemorysetLabelMetrics
        from ..models.memoryset_neighbor_metrics import MemorysetNeighborMetrics
        from ..models.memoryset_projection_metrics import MemorysetProjectionMetrics

        neighbor: Union[Dict[str, Any], None, Unset]
        if isinstance(self.neighbor, Unset):
            neighbor = UNSET
        elif isinstance(self.neighbor, MemorysetNeighborMetrics):
            neighbor = self.neighbor.to_dict()
        else:
            neighbor = self.neighbor

        label: Union[Dict[str, Any], None, Unset]
        if isinstance(self.label, Unset):
            label = UNSET
        elif isinstance(self.label, MemorysetLabelMetrics):
            label = self.label.to_dict()
        else:
            label = self.label

        duplicate: Union[Dict[str, Any], None, Unset]
        if isinstance(self.duplicate, Unset):
            duplicate = UNSET
        elif isinstance(self.duplicate, MemorysetDuplicateMetrics):
            duplicate = self.duplicate.to_dict()
        else:
            duplicate = self.duplicate

        projection: Union[Dict[str, Any], None, Unset]
        if isinstance(self.projection, Unset):
            projection = UNSET
        elif isinstance(self.projection, MemorysetProjectionMetrics):
            projection = self.projection.to_dict()
        else:
            projection = self.projection

        cluster: Union[Dict[str, Any], None, Unset]
        if isinstance(self.cluster, Unset):
            cluster = UNSET
        elif isinstance(self.cluster, MemorysetClusterMetrics):
            cluster = self.cluster.to_dict()
        else:
            cluster = self.cluster

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if neighbor is not UNSET:
            field_dict["neighbor"] = neighbor
        if label is not UNSET:
            field_dict["label"] = label
        if duplicate is not UNSET:
            field_dict["duplicate"] = duplicate
        if projection is not UNSET:
            field_dict["projection"] = projection
        if cluster is not UNSET:
            field_dict["cluster"] = cluster

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        from ..models.memoryset_cluster_metrics import MemorysetClusterMetrics
        from ..models.memoryset_duplicate_metrics import MemorysetDuplicateMetrics
        from ..models.memoryset_label_metrics import MemorysetLabelMetrics
        from ..models.memoryset_neighbor_metrics import MemorysetNeighborMetrics
        from ..models.memoryset_projection_metrics import MemorysetProjectionMetrics

        d = src_dict.copy()

        def _parse_neighbor(data: object) -> Union["MemorysetNeighborMetrics", None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, dict):
                    raise TypeError()
                neighbor_type_0 = MemorysetNeighborMetrics.from_dict(data)

                return neighbor_type_0
            except:  # noqa: E722
                pass
            return cast(Union["MemorysetNeighborMetrics", None, Unset], data)

        neighbor = _parse_neighbor(d.pop("neighbor", UNSET))

        def _parse_label(data: object) -> Union["MemorysetLabelMetrics", None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, dict):
                    raise TypeError()
                label_type_0 = MemorysetLabelMetrics.from_dict(data)

                return label_type_0
            except:  # noqa: E722
                pass
            return cast(Union["MemorysetLabelMetrics", None, Unset], data)

        label = _parse_label(d.pop("label", UNSET))

        def _parse_duplicate(data: object) -> Union["MemorysetDuplicateMetrics", None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, dict):
                    raise TypeError()
                duplicate_type_0 = MemorysetDuplicateMetrics.from_dict(data)

                return duplicate_type_0
            except:  # noqa: E722
                pass
            return cast(Union["MemorysetDuplicateMetrics", None, Unset], data)

        duplicate = _parse_duplicate(d.pop("duplicate", UNSET))

        def _parse_projection(data: object) -> Union["MemorysetProjectionMetrics", None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, dict):
                    raise TypeError()
                projection_type_0 = MemorysetProjectionMetrics.from_dict(data)

                return projection_type_0
            except:  # noqa: E722
                pass
            return cast(Union["MemorysetProjectionMetrics", None, Unset], data)

        projection = _parse_projection(d.pop("projection", UNSET))

        def _parse_cluster(data: object) -> Union["MemorysetClusterMetrics", None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, dict):
                    raise TypeError()
                cluster_type_0 = MemorysetClusterMetrics.from_dict(data)

                return cluster_type_0
            except:  # noqa: E722
                pass
            return cast(Union["MemorysetClusterMetrics", None, Unset], data)

        cluster = _parse_cluster(d.pop("cluster", UNSET))

        memoryset_metrics = cls(
            neighbor=neighbor,
            label=label,
            duplicate=duplicate,
            projection=projection,
            cluster=cluster,
        )

        memoryset_metrics.additional_properties = d
        return memoryset_metrics

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
