"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from typing import TYPE_CHECKING, Any, List, Type, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

if TYPE_CHECKING:
    from ..models.cluster_metrics import ClusterMetrics


T = TypeVar("T", bound="MemorysetClusterMetrics")


@_attrs_define
class MemorysetClusterMetrics:
    """
    Attributes:
        cluster_metrics (List['ClusterMetrics']):
        num_outliers (int):
        num_clusters (int):
    """

    cluster_metrics: List["ClusterMetrics"]
    num_outliers: int
    num_clusters: int
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        cluster_metrics = []
        for cluster_metrics_item_data in self.cluster_metrics:
            cluster_metrics_item = cluster_metrics_item_data.to_dict()
            cluster_metrics.append(cluster_metrics_item)

        num_outliers = self.num_outliers

        num_clusters = self.num_clusters

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "cluster_metrics": cluster_metrics,
                "num_outliers": num_outliers,
                "num_clusters": num_clusters,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        from ..models.cluster_metrics import ClusterMetrics

        d = src_dict.copy()
        cluster_metrics = []
        _cluster_metrics = d.pop("cluster_metrics")
        for cluster_metrics_item_data in _cluster_metrics:
            cluster_metrics_item = ClusterMetrics.from_dict(cluster_metrics_item_data)

            cluster_metrics.append(cluster_metrics_item)

        num_outliers = d.pop("num_outliers")

        num_clusters = d.pop("num_clusters")

        memoryset_cluster_metrics = cls(
            cluster_metrics=cluster_metrics,
            num_outliers=num_outliers,
            num_clusters=num_clusters,
        )

        memoryset_cluster_metrics.additional_properties = d
        return memoryset_cluster_metrics

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
