"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from typing import Any, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.memoryset_cluster_analysis_config_clustering_method import MemorysetClusterAnalysisConfigClusteringMethod
from ..models.memoryset_cluster_analysis_config_partitioning_method import (
    MemorysetClusterAnalysisConfigPartitioningMethod,
)
from ..types import UNSET, Unset

T = TypeVar("T", bound="MemorysetClusterAnalysisConfig")


@_attrs_define
class MemorysetClusterAnalysisConfig:
    """
    Attributes:
        min_cluster_size (Union[None, Unset, int]):
        max_cluster_size (Union[None, Unset, int]):
        clustering_method (Union[Unset, MemorysetClusterAnalysisConfigClusteringMethod]):  Default:
            MemorysetClusterAnalysisConfigClusteringMethod.GRAPH.
        min_cluster_distance (Union[Unset, float]):  Default: 0.0.
        partitioning_method (Union[Unset, MemorysetClusterAnalysisConfigPartitioningMethod]):  Default:
            MemorysetClusterAnalysisConfigPartitioningMethod.NG.
        resolution (Union[None, Unset, float]):
        num_iterations (Union[Unset, int]):  Default: 2.
        random_state (Union[None, Unset, int]):  Default: 42.
    """

    min_cluster_size: Union[None, Unset, int] = UNSET
    max_cluster_size: Union[None, Unset, int] = UNSET
    clustering_method: Union[Unset, MemorysetClusterAnalysisConfigClusteringMethod] = (
        MemorysetClusterAnalysisConfigClusteringMethod.GRAPH
    )
    min_cluster_distance: Union[Unset, float] = 0.0
    partitioning_method: Union[Unset, MemorysetClusterAnalysisConfigPartitioningMethod] = (
        MemorysetClusterAnalysisConfigPartitioningMethod.NG
    )
    resolution: Union[None, Unset, float] = UNSET
    num_iterations: Union[Unset, int] = 2
    random_state: Union[None, Unset, int] = 42
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        min_cluster_size: Union[None, Unset, int]
        if isinstance(self.min_cluster_size, Unset):
            min_cluster_size = UNSET
        else:
            min_cluster_size = self.min_cluster_size

        max_cluster_size: Union[None, Unset, int]
        if isinstance(self.max_cluster_size, Unset):
            max_cluster_size = UNSET
        else:
            max_cluster_size = self.max_cluster_size

        clustering_method: Union[Unset, str] = UNSET
        if not isinstance(self.clustering_method, Unset):
            clustering_method = self.clustering_method.value

        min_cluster_distance = self.min_cluster_distance

        partitioning_method: Union[Unset, str] = UNSET
        if not isinstance(self.partitioning_method, Unset):
            partitioning_method = self.partitioning_method.value

        resolution: Union[None, Unset, float]
        if isinstance(self.resolution, Unset):
            resolution = UNSET
        else:
            resolution = self.resolution

        num_iterations = self.num_iterations

        random_state: Union[None, Unset, int]
        if isinstance(self.random_state, Unset):
            random_state = UNSET
        else:
            random_state = self.random_state

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if min_cluster_size is not UNSET:
            field_dict["min_cluster_size"] = min_cluster_size
        if max_cluster_size is not UNSET:
            field_dict["max_cluster_size"] = max_cluster_size
        if clustering_method is not UNSET:
            field_dict["clustering_method"] = clustering_method
        if min_cluster_distance is not UNSET:
            field_dict["min_cluster_distance"] = min_cluster_distance
        if partitioning_method is not UNSET:
            field_dict["partitioning_method"] = partitioning_method
        if resolution is not UNSET:
            field_dict["resolution"] = resolution
        if num_iterations is not UNSET:
            field_dict["num_iterations"] = num_iterations
        if random_state is not UNSET:
            field_dict["random_state"] = random_state

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()

        def _parse_min_cluster_size(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        min_cluster_size = _parse_min_cluster_size(d.pop("min_cluster_size", UNSET))

        def _parse_max_cluster_size(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        max_cluster_size = _parse_max_cluster_size(d.pop("max_cluster_size", UNSET))

        _clustering_method = d.pop("clustering_method", UNSET)
        clustering_method: Union[Unset, MemorysetClusterAnalysisConfigClusteringMethod]
        if isinstance(_clustering_method, Unset):
            clustering_method = UNSET
        else:
            clustering_method = MemorysetClusterAnalysisConfigClusteringMethod(_clustering_method)

        min_cluster_distance = d.pop("min_cluster_distance", UNSET)

        _partitioning_method = d.pop("partitioning_method", UNSET)
        partitioning_method: Union[Unset, MemorysetClusterAnalysisConfigPartitioningMethod]
        if isinstance(_partitioning_method, Unset):
            partitioning_method = UNSET
        else:
            partitioning_method = MemorysetClusterAnalysisConfigPartitioningMethod(_partitioning_method)

        def _parse_resolution(data: object) -> Union[None, Unset, float]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, float], data)

        resolution = _parse_resolution(d.pop("resolution", UNSET))

        num_iterations = d.pop("num_iterations", UNSET)

        def _parse_random_state(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        random_state = _parse_random_state(d.pop("random_state", UNSET))

        memoryset_cluster_analysis_config = cls(
            min_cluster_size=min_cluster_size,
            max_cluster_size=max_cluster_size,
            clustering_method=clustering_method,
            min_cluster_distance=min_cluster_distance,
            partitioning_method=partitioning_method,
            resolution=resolution,
            num_iterations=num_iterations,
            random_state=random_state,
        )

        memoryset_cluster_analysis_config.additional_properties = d
        return memoryset_cluster_analysis_config

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
