"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

import datetime
from enum import Enum
from typing import TYPE_CHECKING, Any, Dict, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..models.task_status import TaskStatus

if TYPE_CHECKING:
    from ..models.memoryset_analysis_configs import MemorysetAnalysisConfigs
    from ..models.memoryset_metrics import MemorysetMetrics


T = TypeVar("T", bound="MemorysetAnalysisResponse")


@_attrs_define
class MemorysetAnalysisResponse:
    """
    Attributes:
        task_id (str):
        org_id (str):
        memoryset_id (str):
        status (TaskStatus): Status of task in the task queue
        lookup_count (int):
        batch_size (int):
        clear_metrics (bool):
        configs (MemorysetAnalysisConfigs):
        results (Union['MemorysetMetrics', None]):
        created_at (datetime.datetime):
        updated_at (datetime.datetime):
    """

    task_id: str
    org_id: str
    memoryset_id: str
    status: TaskStatus
    lookup_count: int
    batch_size: int
    clear_metrics: bool
    configs: "MemorysetAnalysisConfigs"
    results: Union["MemorysetMetrics", None]
    created_at: datetime.datetime
    updated_at: datetime.datetime
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        from ..models.memoryset_metrics import MemorysetMetrics

        task_id = self.task_id

        org_id = self.org_id

        memoryset_id = self.memoryset_id

        status = self.status.value if isinstance(self.status, Enum) else self.status

        lookup_count = self.lookup_count

        batch_size = self.batch_size

        clear_metrics = self.clear_metrics

        configs = self.configs.to_dict()

        results: Union[Dict[str, Any], None]
        if isinstance(self.results, MemorysetMetrics):
            results = self.results.to_dict()
        else:
            results = self.results

        created_at = self.created_at.isoformat()

        updated_at = self.updated_at.isoformat()

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "task_id": task_id,
                "org_id": org_id,
                "memoryset_id": memoryset_id,
                "status": status,
                "lookup_count": lookup_count,
                "batch_size": batch_size,
                "clear_metrics": clear_metrics,
                "configs": configs,
                "results": results,
                "created_at": created_at,
                "updated_at": updated_at,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        from ..models.memoryset_analysis_configs import MemorysetAnalysisConfigs
        from ..models.memoryset_metrics import MemorysetMetrics

        d = src_dict.copy()
        task_id = d.pop("task_id")

        org_id = d.pop("org_id")

        memoryset_id = d.pop("memoryset_id")

        status = TaskStatus(d.pop("status"))

        lookup_count = d.pop("lookup_count")

        batch_size = d.pop("batch_size")

        clear_metrics = d.pop("clear_metrics")

        configs = MemorysetAnalysisConfigs.from_dict(d.pop("configs"))

        def _parse_results(data: object) -> Union["MemorysetMetrics", None]:
            if data is None:
                return data
            try:
                if not isinstance(data, dict):
                    raise TypeError()
                results_type_0 = MemorysetMetrics.from_dict(data)

                return results_type_0
            except:  # noqa: E722
                pass
            return cast(Union["MemorysetMetrics", None], data)

        results = _parse_results(d.pop("results"))

        created_at = isoparse(d.pop("created_at"))

        updated_at = isoparse(d.pop("updated_at"))

        memoryset_analysis_response = cls(
            task_id=task_id,
            org_id=org_id,
            memoryset_id=memoryset_id,
            status=status,
            lookup_count=lookup_count,
            batch_size=batch_size,
            clear_metrics=clear_metrics,
            configs=configs,
            results=results,
            created_at=created_at,
            updated_at=updated_at,
        )

        memoryset_analysis_response.additional_properties = d
        return memoryset_analysis_response

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
