"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from typing import TYPE_CHECKING, Any, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.memoryset_analysis_configs import MemorysetAnalysisConfigs


T = TypeVar("T", bound="MemorysetAnalysisRequest")


@_attrs_define
class MemorysetAnalysisRequest:
    """
    Attributes:
        configs (MemorysetAnalysisConfigs):
        lookup_count (Union[Unset, int]):  Default: 15.
        batch_size (Union[Unset, int]):  Default: 32.
        clear_metrics (Union[Unset, bool]):  Default: False.
    """

    configs: "MemorysetAnalysisConfigs"
    lookup_count: Union[Unset, int] = 15
    batch_size: Union[Unset, int] = 32
    clear_metrics: Union[Unset, bool] = False
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        configs = self.configs.to_dict()

        lookup_count = self.lookup_count

        batch_size = self.batch_size

        clear_metrics = self.clear_metrics

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "configs": configs,
            }
        )
        if lookup_count is not UNSET:
            field_dict["lookup_count"] = lookup_count
        if batch_size is not UNSET:
            field_dict["batch_size"] = batch_size
        if clear_metrics is not UNSET:
            field_dict["clear_metrics"] = clear_metrics

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        from ..models.memoryset_analysis_configs import MemorysetAnalysisConfigs

        d = src_dict.copy()
        configs = MemorysetAnalysisConfigs.from_dict(d.pop("configs"))

        lookup_count = d.pop("lookup_count", UNSET)

        batch_size = d.pop("batch_size", UNSET)

        clear_metrics = d.pop("clear_metrics", UNSET)

        memoryset_analysis_request = cls(
            configs=configs,
            lookup_count=lookup_count,
            batch_size=batch_size,
            clear_metrics=clear_metrics,
        )

        memoryset_analysis_request.additional_properties = d
        return memoryset_analysis_request

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
