"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from typing import TYPE_CHECKING, Any, Dict, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.memoryset_cluster_analysis_config import MemorysetClusterAnalysisConfig
    from ..models.memoryset_duplicate_analysis_config import MemorysetDuplicateAnalysisConfig
    from ..models.memoryset_label_analysis_config import MemorysetLabelAnalysisConfig
    from ..models.memoryset_neighbor_analysis_config import MemorysetNeighborAnalysisConfig
    from ..models.memoryset_projection_analysis_config import MemorysetProjectionAnalysisConfig


T = TypeVar("T", bound="MemorysetAnalysisConfigs")


@_attrs_define
class MemorysetAnalysisConfigs:
    """
    Attributes:
        neighbor (Union['MemorysetNeighborAnalysisConfig', None, Unset]):
        label (Union['MemorysetLabelAnalysisConfig', None, Unset]):
        duplicate (Union['MemorysetDuplicateAnalysisConfig', None, Unset]):
        projection (Union['MemorysetProjectionAnalysisConfig', None, Unset]):
        cluster (Union['MemorysetClusterAnalysisConfig', None, Unset]):
    """

    neighbor: Union["MemorysetNeighborAnalysisConfig", None, Unset] = UNSET
    label: Union["MemorysetLabelAnalysisConfig", None, Unset] = UNSET
    duplicate: Union["MemorysetDuplicateAnalysisConfig", None, Unset] = UNSET
    projection: Union["MemorysetProjectionAnalysisConfig", None, Unset] = UNSET
    cluster: Union["MemorysetClusterAnalysisConfig", None, Unset] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        from ..models.memoryset_cluster_analysis_config import MemorysetClusterAnalysisConfig
        from ..models.memoryset_duplicate_analysis_config import MemorysetDuplicateAnalysisConfig
        from ..models.memoryset_label_analysis_config import MemorysetLabelAnalysisConfig
        from ..models.memoryset_neighbor_analysis_config import MemorysetNeighborAnalysisConfig
        from ..models.memoryset_projection_analysis_config import MemorysetProjectionAnalysisConfig

        neighbor: Union[Dict[str, Any], None, Unset]
        if isinstance(self.neighbor, Unset):
            neighbor = UNSET
        elif isinstance(self.neighbor, MemorysetNeighborAnalysisConfig):
            neighbor = self.neighbor.to_dict()
        else:
            neighbor = self.neighbor

        label: Union[Dict[str, Any], None, Unset]
        if isinstance(self.label, Unset):
            label = UNSET
        elif isinstance(self.label, MemorysetLabelAnalysisConfig):
            label = self.label.to_dict()
        else:
            label = self.label

        duplicate: Union[Dict[str, Any], None, Unset]
        if isinstance(self.duplicate, Unset):
            duplicate = UNSET
        elif isinstance(self.duplicate, MemorysetDuplicateAnalysisConfig):
            duplicate = self.duplicate.to_dict()
        else:
            duplicate = self.duplicate

        projection: Union[Dict[str, Any], None, Unset]
        if isinstance(self.projection, Unset):
            projection = UNSET
        elif isinstance(self.projection, MemorysetProjectionAnalysisConfig):
            projection = self.projection.to_dict()
        else:
            projection = self.projection

        cluster: Union[Dict[str, Any], None, Unset]
        if isinstance(self.cluster, Unset):
            cluster = UNSET
        elif isinstance(self.cluster, MemorysetClusterAnalysisConfig):
            cluster = self.cluster.to_dict()
        else:
            cluster = self.cluster

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if neighbor is not UNSET:
            field_dict["neighbor"] = neighbor
        if label is not UNSET:
            field_dict["label"] = label
        if duplicate is not UNSET:
            field_dict["duplicate"] = duplicate
        if projection is not UNSET:
            field_dict["projection"] = projection
        if cluster is not UNSET:
            field_dict["cluster"] = cluster

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        from ..models.memoryset_cluster_analysis_config import MemorysetClusterAnalysisConfig
        from ..models.memoryset_duplicate_analysis_config import MemorysetDuplicateAnalysisConfig
        from ..models.memoryset_label_analysis_config import MemorysetLabelAnalysisConfig
        from ..models.memoryset_neighbor_analysis_config import MemorysetNeighborAnalysisConfig
        from ..models.memoryset_projection_analysis_config import MemorysetProjectionAnalysisConfig

        d = src_dict.copy()

        def _parse_neighbor(data: object) -> Union["MemorysetNeighborAnalysisConfig", None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, dict):
                    raise TypeError()
                neighbor_type_0 = MemorysetNeighborAnalysisConfig.from_dict(data)

                return neighbor_type_0
            except:  # noqa: E722
                pass
            return cast(Union["MemorysetNeighborAnalysisConfig", None, Unset], data)

        neighbor = _parse_neighbor(d.pop("neighbor", UNSET))

        def _parse_label(data: object) -> Union["MemorysetLabelAnalysisConfig", None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, dict):
                    raise TypeError()
                label_type_0 = MemorysetLabelAnalysisConfig.from_dict(data)

                return label_type_0
            except:  # noqa: E722
                pass
            return cast(Union["MemorysetLabelAnalysisConfig", None, Unset], data)

        label = _parse_label(d.pop("label", UNSET))

        def _parse_duplicate(data: object) -> Union["MemorysetDuplicateAnalysisConfig", None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, dict):
                    raise TypeError()
                duplicate_type_0 = MemorysetDuplicateAnalysisConfig.from_dict(data)

                return duplicate_type_0
            except:  # noqa: E722
                pass
            return cast(Union["MemorysetDuplicateAnalysisConfig", None, Unset], data)

        duplicate = _parse_duplicate(d.pop("duplicate", UNSET))

        def _parse_projection(data: object) -> Union["MemorysetProjectionAnalysisConfig", None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, dict):
                    raise TypeError()
                projection_type_0 = MemorysetProjectionAnalysisConfig.from_dict(data)

                return projection_type_0
            except:  # noqa: E722
                pass
            return cast(Union["MemorysetProjectionAnalysisConfig", None, Unset], data)

        projection = _parse_projection(d.pop("projection", UNSET))

        def _parse_cluster(data: object) -> Union["MemorysetClusterAnalysisConfig", None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, dict):
                    raise TypeError()
                cluster_type_0 = MemorysetClusterAnalysisConfig.from_dict(data)

                return cluster_type_0
            except:  # noqa: E722
                pass
            return cast(Union["MemorysetClusterAnalysisConfig", None, Unset], data)

        cluster = _parse_cluster(d.pop("cluster", UNSET))

        memoryset_analysis_configs = cls(
            neighbor=neighbor,
            label=label,
            duplicate=duplicate,
            projection=projection,
            cluster=cluster,
        )

        memoryset_analysis_configs.additional_properties = d
        return memoryset_analysis_configs

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
