"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from enum import Enum
from typing import Any, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.prediction_sort_item_item_type_0 import PredictionSortItemItemType0
from ..models.prediction_sort_item_item_type_1 import PredictionSortItemItemType1
from ..types import UNSET, Unset

T = TypeVar("T", bound="ListPredictionsRequest")


@_attrs_define
class ListPredictionsRequest:
    """
    Attributes:
        model_id (Union[None, Unset, str]):
        tag (Union[None, Unset, str]):
        prediction_ids (Union[List[str], None, Unset]):
        limit (Union[None, Unset, int]):
        offset (Union[None, Unset, int]):  Default: 0.
        sort (Union[Unset, List[List[Union[PredictionSortItemItemType0, PredictionSortItemItemType1]]]]):
        expected_label_match (Union[None, Unset, bool]):
    """

    model_id: Union[None, Unset, str] = UNSET
    tag: Union[None, Unset, str] = UNSET
    prediction_ids: Union[List[str], None, Unset] = UNSET
    limit: Union[None, Unset, int] = UNSET
    offset: Union[None, Unset, int] = 0
    sort: Union[Unset, List[List[Union[PredictionSortItemItemType0, PredictionSortItemItemType1]]]] = UNSET
    expected_label_match: Union[None, Unset, bool] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        model_id: Union[None, Unset, str]
        if isinstance(self.model_id, Unset):
            model_id = UNSET
        else:
            model_id = self.model_id

        tag: Union[None, Unset, str]
        if isinstance(self.tag, Unset):
            tag = UNSET
        else:
            tag = self.tag

        prediction_ids: Union[List[str], None, Unset]
        if isinstance(self.prediction_ids, Unset):
            prediction_ids = UNSET
        elif isinstance(self.prediction_ids, list):
            prediction_ids = self.prediction_ids

        else:
            prediction_ids = self.prediction_ids

        limit: Union[None, Unset, int]
        if isinstance(self.limit, Unset):
            limit = UNSET
        else:
            limit = self.limit

        offset: Union[None, Unset, int]
        if isinstance(self.offset, Unset):
            offset = UNSET
        else:
            offset = self.offset

        sort: Union[Unset, List[List[str]]] = UNSET
        if not isinstance(self.sort, Unset):
            sort = []
            for componentsschemas_prediction_sort_item_data in self.sort:
                componentsschemas_prediction_sort_item = []
                for componentsschemas_prediction_sort_item_item_data in componentsschemas_prediction_sort_item_data:
                    componentsschemas_prediction_sort_item_item: str
                    if isinstance(componentsschemas_prediction_sort_item_item_data, PredictionSortItemItemType0):
                        componentsschemas_prediction_sort_item_item = (
                            componentsschemas_prediction_sort_item_item_data.value
                            if isinstance(componentsschemas_prediction_sort_item_item_data, Enum)
                            else componentsschemas_prediction_sort_item_item_data
                        )
                    else:
                        componentsschemas_prediction_sort_item_item = (
                            componentsschemas_prediction_sort_item_item_data.value
                            if isinstance(componentsschemas_prediction_sort_item_item_data, Enum)
                            else componentsschemas_prediction_sort_item_item_data
                        )

                    componentsschemas_prediction_sort_item.append(componentsschemas_prediction_sort_item_item)

                sort.append(componentsschemas_prediction_sort_item)

        expected_label_match: Union[None, Unset, bool]
        if isinstance(self.expected_label_match, Unset):
            expected_label_match = UNSET
        else:
            expected_label_match = self.expected_label_match

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if model_id is not UNSET:
            field_dict["model_id"] = model_id
        if tag is not UNSET:
            field_dict["tag"] = tag
        if prediction_ids is not UNSET:
            field_dict["prediction_ids"] = prediction_ids
        if limit is not UNSET:
            field_dict["limit"] = limit
        if offset is not UNSET:
            field_dict["offset"] = offset
        if sort is not UNSET:
            field_dict["sort"] = sort
        if expected_label_match is not UNSET:
            field_dict["expected_label_match"] = expected_label_match

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()

        def _parse_model_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        model_id = _parse_model_id(d.pop("model_id", UNSET))

        def _parse_tag(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        tag = _parse_tag(d.pop("tag", UNSET))

        def _parse_prediction_ids(data: object) -> Union[List[str], None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, list):
                    raise TypeError()
                prediction_ids_type_0 = cast(List[str], data)

                return prediction_ids_type_0
            except:  # noqa: E722
                pass
            return cast(Union[List[str], None, Unset], data)

        prediction_ids = _parse_prediction_ids(d.pop("prediction_ids", UNSET))

        def _parse_limit(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        limit = _parse_limit(d.pop("limit", UNSET))

        def _parse_offset(data: object) -> Union[None, Unset, int]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, int], data)

        offset = _parse_offset(d.pop("offset", UNSET))

        sort = []
        _sort = d.pop("sort", UNSET)
        for componentsschemas_prediction_sort_item_data in _sort or []:
            componentsschemas_prediction_sort_item = []
            _componentsschemas_prediction_sort_item = componentsschemas_prediction_sort_item_data
            for componentsschemas_prediction_sort_item_item_data in _componentsschemas_prediction_sort_item:

                def _parse_componentsschemas_prediction_sort_item_item(
                    data: object,
                ) -> Union[PredictionSortItemItemType0, PredictionSortItemItemType1]:
                    try:
                        if not isinstance(data, str):
                            raise TypeError()
                        componentsschemas_prediction_sort_item_item_type_0 = PredictionSortItemItemType0(data)

                        return componentsschemas_prediction_sort_item_item_type_0
                    except:  # noqa: E722
                        pass
                    if not isinstance(data, str):
                        raise TypeError()
                    componentsschemas_prediction_sort_item_item_type_1 = PredictionSortItemItemType1(data)

                    return componentsschemas_prediction_sort_item_item_type_1

                componentsschemas_prediction_sort_item_item = _parse_componentsschemas_prediction_sort_item_item(
                    componentsschemas_prediction_sort_item_item_data
                )

                componentsschemas_prediction_sort_item.append(componentsschemas_prediction_sort_item_item)

            sort.append(componentsschemas_prediction_sort_item)

        def _parse_expected_label_match(data: object) -> Union[None, Unset, bool]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, bool], data)

        expected_label_match = _parse_expected_label_match(d.pop("expected_label_match", UNSET))

        list_predictions_request = cls(
            model_id=model_id,
            tag=tag,
            prediction_ids=prediction_ids,
            limit=limit,
            offset=offset,
            sort=sort,
            expected_label_match=expected_label_match,
        )

        list_predictions_request.additional_properties = d
        return list_predictions_request

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
