"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

import datetime
from enum import Enum
from typing import TYPE_CHECKING, Any, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..models.pretrained_embedding_model_name import PretrainedEmbeddingModelName
from ..models.task_status import TaskStatus

if TYPE_CHECKING:
    from ..models.memoryset_metrics import MemorysetMetrics


T = TypeVar("T", bound="LabeledMemorysetMetadata")


@_attrs_define
class LabeledMemorysetMetadata:
    """
    Attributes:
        id (str):
        org_id (str):
        collection_name (str):
        name (str):
        description (Union[None, str]):
        length (int):
        pretrained_embedding_model_name (Union[None, PretrainedEmbeddingModelName]):
        finetuned_embedding_model_id (Union[None, str]):
        label_names (List[str]):
        created_at (datetime.datetime):
        updated_at (datetime.datetime):
        insertion_task_id (str):
        insertion_status (TaskStatus): Status of task in the task queue
        metrics (MemorysetMetrics):
    """

    id: str
    org_id: str
    collection_name: str
    name: str
    description: Union[None, str]
    length: int
    pretrained_embedding_model_name: Union[None, PretrainedEmbeddingModelName]
    finetuned_embedding_model_id: Union[None, str]
    label_names: List[str]
    created_at: datetime.datetime
    updated_at: datetime.datetime
    insertion_task_id: str
    insertion_status: TaskStatus
    metrics: "MemorysetMetrics"
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        id = self.id

        org_id = self.org_id

        collection_name = self.collection_name

        name = self.name

        description: Union[None, str]
        description = self.description

        length = self.length

        pretrained_embedding_model_name: Union[None, str]
        if isinstance(self.pretrained_embedding_model_name, PretrainedEmbeddingModelName):
            pretrained_embedding_model_name = (
                self.pretrained_embedding_model_name.value
                if isinstance(self.pretrained_embedding_model_name, Enum)
                else self.pretrained_embedding_model_name
            )
        else:
            pretrained_embedding_model_name = self.pretrained_embedding_model_name

        finetuned_embedding_model_id: Union[None, str]
        finetuned_embedding_model_id = self.finetuned_embedding_model_id

        label_names = self.label_names

        created_at = self.created_at.isoformat()

        updated_at = self.updated_at.isoformat()

        insertion_task_id = self.insertion_task_id

        insertion_status = (
            self.insertion_status.value if isinstance(self.insertion_status, Enum) else self.insertion_status
        )

        metrics = self.metrics.to_dict()

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "id": id,
                "org_id": org_id,
                "collection_name": collection_name,
                "name": name,
                "description": description,
                "length": length,
                "pretrained_embedding_model_name": pretrained_embedding_model_name,
                "finetuned_embedding_model_id": finetuned_embedding_model_id,
                "label_names": label_names,
                "created_at": created_at,
                "updated_at": updated_at,
                "insertion_task_id": insertion_task_id,
                "insertion_status": insertion_status,
                "metrics": metrics,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        from ..models.memoryset_metrics import MemorysetMetrics

        d = src_dict.copy()
        id = d.pop("id")

        org_id = d.pop("org_id")

        collection_name = d.pop("collection_name")

        name = d.pop("name")

        def _parse_description(data: object) -> Union[None, str]:
            if data is None:
                return data
            return cast(Union[None, str], data)

        description = _parse_description(d.pop("description"))

        length = d.pop("length")

        def _parse_pretrained_embedding_model_name(data: object) -> Union[None, PretrainedEmbeddingModelName]:
            if data is None:
                return data
            try:
                if not isinstance(data, str):
                    raise TypeError()
                pretrained_embedding_model_name_type_0 = PretrainedEmbeddingModelName(data)

                return pretrained_embedding_model_name_type_0
            except:  # noqa: E722
                pass
            return cast(Union[None, PretrainedEmbeddingModelName], data)

        pretrained_embedding_model_name = _parse_pretrained_embedding_model_name(
            d.pop("pretrained_embedding_model_name")
        )

        def _parse_finetuned_embedding_model_id(data: object) -> Union[None, str]:
            if data is None:
                return data
            return cast(Union[None, str], data)

        finetuned_embedding_model_id = _parse_finetuned_embedding_model_id(d.pop("finetuned_embedding_model_id"))

        label_names = cast(List[str], d.pop("label_names"))

        created_at = isoparse(d.pop("created_at"))

        updated_at = isoparse(d.pop("updated_at"))

        insertion_task_id = d.pop("insertion_task_id")

        insertion_status = TaskStatus(d.pop("insertion_status"))

        metrics = MemorysetMetrics.from_dict(d.pop("metrics"))

        labeled_memoryset_metadata = cls(
            id=id,
            org_id=org_id,
            collection_name=collection_name,
            name=name,
            description=description,
            length=length,
            pretrained_embedding_model_name=pretrained_embedding_model_name,
            finetuned_embedding_model_id=finetuned_embedding_model_id,
            label_names=label_names,
            created_at=created_at,
            updated_at=updated_at,
            insertion_task_id=insertion_task_id,
            insertion_status=insertion_status,
            metrics=metrics,
        )

        labeled_memoryset_metadata.additional_properties = d
        return labeled_memoryset_metadata

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
