"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

import datetime
from typing import TYPE_CHECKING, Any, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

if TYPE_CHECKING:
    from ..models.labeled_memory_metrics import LabeledMemoryMetrics
    from ..models.labeled_memory_with_feedback_metrics_feedback_metrics import (
        LabeledMemoryWithFeedbackMetricsFeedbackMetrics,
    )
    from ..models.labeled_memory_with_feedback_metrics_metadata import LabeledMemoryWithFeedbackMetricsMetadata


T = TypeVar("T", bound="LabeledMemoryWithFeedbackMetrics")


@_attrs_define
class LabeledMemoryWithFeedbackMetrics:
    """
    Attributes:
        value (str):
        embedding (List[float]):
        source_id (Union[None, str]):
        metadata (LabeledMemoryWithFeedbackMetricsMetadata):
        memory_id (str):
        memory_version (int):
        created_at (datetime.datetime):
        updated_at (datetime.datetime):
        metrics (LabeledMemoryMetrics): Metrics computed for a labeled memory.
        label (int):
        label_name (Union[None, str]):
        feedback_metrics (LabeledMemoryWithFeedbackMetricsFeedbackMetrics):
        lookup_count (int):
    """

    value: str
    embedding: List[float]
    source_id: Union[None, str]
    metadata: "LabeledMemoryWithFeedbackMetricsMetadata"
    memory_id: str
    memory_version: int
    created_at: datetime.datetime
    updated_at: datetime.datetime
    metrics: "LabeledMemoryMetrics"
    label: int
    label_name: Union[None, str]
    feedback_metrics: "LabeledMemoryWithFeedbackMetricsFeedbackMetrics"
    lookup_count: int
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        value: str
        value = self.value

        embedding = self.embedding

        source_id: Union[None, str]
        source_id = self.source_id

        metadata = self.metadata.to_dict()

        memory_id = self.memory_id

        memory_version = self.memory_version

        created_at = self.created_at.isoformat()

        updated_at = self.updated_at.isoformat()

        metrics = self.metrics.to_dict()

        label = self.label

        label_name: Union[None, str]
        label_name = self.label_name

        feedback_metrics = self.feedback_metrics.to_dict()

        lookup_count = self.lookup_count

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "value": value,
                "embedding": embedding,
                "source_id": source_id,
                "metadata": metadata,
                "memory_id": memory_id,
                "memory_version": memory_version,
                "created_at": created_at,
                "updated_at": updated_at,
                "metrics": metrics,
                "label": label,
                "label_name": label_name,
                "feedback_metrics": feedback_metrics,
                "lookup_count": lookup_count,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        from ..models.labeled_memory_metrics import LabeledMemoryMetrics
        from ..models.labeled_memory_with_feedback_metrics_feedback_metrics import (
            LabeledMemoryWithFeedbackMetricsFeedbackMetrics,
        )
        from ..models.labeled_memory_with_feedback_metrics_metadata import LabeledMemoryWithFeedbackMetricsMetadata

        d = src_dict.copy()

        def _parse_value(data: object) -> str:
            return cast(str, data)

        value = _parse_value(d.pop("value"))

        embedding = cast(List[float], d.pop("embedding"))

        def _parse_source_id(data: object) -> Union[None, str]:
            if data is None:
                return data
            return cast(Union[None, str], data)

        source_id = _parse_source_id(d.pop("source_id"))

        metadata = LabeledMemoryWithFeedbackMetricsMetadata.from_dict(d.pop("metadata"))

        memory_id = d.pop("memory_id")

        memory_version = d.pop("memory_version")

        created_at = isoparse(d.pop("created_at"))

        updated_at = isoparse(d.pop("updated_at"))

        metrics = LabeledMemoryMetrics.from_dict(d.pop("metrics"))

        label = d.pop("label")

        def _parse_label_name(data: object) -> Union[None, str]:
            if data is None:
                return data
            return cast(Union[None, str], data)

        label_name = _parse_label_name(d.pop("label_name"))

        feedback_metrics = LabeledMemoryWithFeedbackMetricsFeedbackMetrics.from_dict(d.pop("feedback_metrics"))

        lookup_count = d.pop("lookup_count")

        labeled_memory_with_feedback_metrics = cls(
            value=value,
            embedding=embedding,
            source_id=source_id,
            metadata=metadata,
            memory_id=memory_id,
            memory_version=memory_version,
            created_at=created_at,
            updated_at=updated_at,
            metrics=metrics,
            label=label,
            label_name=label_name,
            feedback_metrics=feedback_metrics,
            lookup_count=lookup_count,
        )

        labeled_memory_with_feedback_metrics.additional_properties = d
        return labeled_memory_with_feedback_metrics

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
