"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from typing import TYPE_CHECKING, Any, Dict, Type, TypeVar, Union, cast

from attrs import define as _attrs_define

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.labeled_memory_metrics import LabeledMemoryMetrics
    from ..models.labeled_memory_update_metadata_type_0 import LabeledMemoryUpdateMetadataType0


T = TypeVar("T", bound="LabeledMemoryUpdate")


@_attrs_define
class LabeledMemoryUpdate:
    """Model for updating a labeled memory (unset fields are kept as is)

    Attributes:
        memory_id (str):
        value (Union[Unset, str]):
        metadata (Union['LabeledMemoryUpdateMetadataType0', None, Unset]):
        source_id (Union[None, Unset, str]):
        label (Union[Unset, int]):
        metrics (Union['LabeledMemoryMetrics', None, Unset]):
    """

    memory_id: str
    value: Union[Unset, str] = UNSET
    metadata: Union["LabeledMemoryUpdateMetadataType0", None, Unset] = UNSET
    source_id: Union[None, Unset, str] = UNSET
    label: Union[Unset, int] = UNSET
    metrics: Union["LabeledMemoryMetrics", None, Unset] = UNSET

    def to_dict(self) -> dict[str, Any]:
        from ..models.labeled_memory_metrics import LabeledMemoryMetrics
        from ..models.labeled_memory_update_metadata_type_0 import LabeledMemoryUpdateMetadataType0

        memory_id = self.memory_id

        value: Union[Unset, str]
        if isinstance(self.value, Unset):
            value = UNSET
        else:
            value = self.value

        metadata: Union[Dict[str, Any], None, Unset]
        if isinstance(self.metadata, Unset):
            metadata = UNSET
        elif isinstance(self.metadata, LabeledMemoryUpdateMetadataType0):
            metadata = self.metadata.to_dict()
        else:
            metadata = self.metadata

        source_id: Union[None, Unset, str]
        if isinstance(self.source_id, Unset):
            source_id = UNSET
        else:
            source_id = self.source_id

        label = self.label

        metrics: Union[Dict[str, Any], None, Unset]
        if isinstance(self.metrics, Unset):
            metrics = UNSET
        elif isinstance(self.metrics, LabeledMemoryMetrics):
            metrics = self.metrics.to_dict()
        else:
            metrics = self.metrics

        field_dict: dict[str, Any] = {}
        field_dict.update(
            {
                "memory_id": memory_id,
            }
        )
        if value is not UNSET:
            field_dict["value"] = value
        if metadata is not UNSET:
            field_dict["metadata"] = metadata
        if source_id is not UNSET:
            field_dict["source_id"] = source_id
        if label is not UNSET:
            field_dict["label"] = label
        if metrics is not UNSET:
            field_dict["metrics"] = metrics

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        from ..models.labeled_memory_metrics import LabeledMemoryMetrics
        from ..models.labeled_memory_update_metadata_type_0 import LabeledMemoryUpdateMetadataType0

        d = src_dict.copy()
        memory_id = d.pop("memory_id")

        def _parse_value(data: object) -> Union[Unset, str]:
            if isinstance(data, Unset):
                return data
            return cast(Union[Unset, str], data)

        value = _parse_value(d.pop("value", UNSET))

        def _parse_metadata(data: object) -> Union["LabeledMemoryUpdateMetadataType0", None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, dict):
                    raise TypeError()
                metadata_type_0 = LabeledMemoryUpdateMetadataType0.from_dict(data)

                return metadata_type_0
            except:  # noqa: E722
                pass
            return cast(Union["LabeledMemoryUpdateMetadataType0", None, Unset], data)

        metadata = _parse_metadata(d.pop("metadata", UNSET))

        def _parse_source_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        source_id = _parse_source_id(d.pop("source_id", UNSET))

        label = d.pop("label", UNSET)

        def _parse_metrics(data: object) -> Union["LabeledMemoryMetrics", None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, dict):
                    raise TypeError()
                metrics_type_0 = LabeledMemoryMetrics.from_dict(data)

                return metrics_type_0
            except:  # noqa: E722
                pass
            return cast(Union["LabeledMemoryMetrics", None, Unset], data)

        metrics = _parse_metrics(d.pop("metrics", UNSET))

        labeled_memory_update = cls(
            memory_id=memory_id,
            value=value,
            metadata=metadata,
            source_id=source_id,
            label=label,
            metrics=metrics,
        )

        return labeled_memory_update
