"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from typing import Any, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="LabeledMemoryMetrics")


@_attrs_define
class LabeledMemoryMetrics:
    """Metrics computed for a labeled memory.

    Attributes:
        is_duplicate (Union[Unset, bool]):
        duplicate_memory_ids (Union[Unset, List[str]]):
        has_potential_duplicates (Union[Unset, bool]):
        potential_duplicate_memory_ids (Union[List[str], None, Unset]):
        cluster (Union[Unset, int]):
        embedding_2d (Union[Unset, List[float]]):
        anomaly_score (Union[Unset, float]):
        neighbor_label_logits (Union[Unset, List[float]]):
        neighbor_predicted_label (Union[Unset, int]):
        neighbor_predicted_label_ambiguity (Union[Unset, float]):
        neighbor_predicted_label_confidence (Union[Unset, float]):
        current_label_neighbor_confidence (Union[Unset, float]):
        normalized_neighbor_label_entropy (Union[Unset, float]):
        neighbor_predicted_label_matches_current_label (Union[None, Unset, bool]):
    """

    is_duplicate: Union[Unset, bool] = UNSET
    duplicate_memory_ids: Union[Unset, List[str]] = UNSET
    has_potential_duplicates: Union[Unset, bool] = UNSET
    potential_duplicate_memory_ids: Union[List[str], None, Unset] = UNSET
    cluster: Union[Unset, int] = UNSET
    embedding_2d: Union[Unset, List[float]] = UNSET
    anomaly_score: Union[Unset, float] = UNSET
    neighbor_label_logits: Union[Unset, List[float]] = UNSET
    neighbor_predicted_label: Union[Unset, int] = UNSET
    neighbor_predicted_label_ambiguity: Union[Unset, float] = UNSET
    neighbor_predicted_label_confidence: Union[Unset, float] = UNSET
    current_label_neighbor_confidence: Union[Unset, float] = UNSET
    normalized_neighbor_label_entropy: Union[Unset, float] = UNSET
    neighbor_predicted_label_matches_current_label: Union[None, Unset, bool] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        is_duplicate = self.is_duplicate

        duplicate_memory_ids: Union[Unset, List[str]] = UNSET
        if not isinstance(self.duplicate_memory_ids, Unset):
            duplicate_memory_ids = self.duplicate_memory_ids

        has_potential_duplicates = self.has_potential_duplicates

        potential_duplicate_memory_ids: Union[List[str], None, Unset]
        if isinstance(self.potential_duplicate_memory_ids, Unset):
            potential_duplicate_memory_ids = UNSET
        elif isinstance(self.potential_duplicate_memory_ids, list):
            potential_duplicate_memory_ids = self.potential_duplicate_memory_ids

        else:
            potential_duplicate_memory_ids = self.potential_duplicate_memory_ids

        cluster = self.cluster

        embedding_2d: Union[Unset, List[float]] = UNSET
        if not isinstance(self.embedding_2d, Unset):
            embedding_2d = []
            for embedding_2d_item_data in self.embedding_2d:
                embedding_2d_item: float
                embedding_2d_item = embedding_2d_item_data
                embedding_2d.append(embedding_2d_item)

        anomaly_score = self.anomaly_score

        neighbor_label_logits: Union[Unset, List[float]] = UNSET
        if not isinstance(self.neighbor_label_logits, Unset):
            neighbor_label_logits = self.neighbor_label_logits

        neighbor_predicted_label = self.neighbor_predicted_label

        neighbor_predicted_label_ambiguity = self.neighbor_predicted_label_ambiguity

        neighbor_predicted_label_confidence = self.neighbor_predicted_label_confidence

        current_label_neighbor_confidence = self.current_label_neighbor_confidence

        normalized_neighbor_label_entropy = self.normalized_neighbor_label_entropy

        neighbor_predicted_label_matches_current_label: Union[None, Unset, bool]
        if isinstance(self.neighbor_predicted_label_matches_current_label, Unset):
            neighbor_predicted_label_matches_current_label = UNSET
        else:
            neighbor_predicted_label_matches_current_label = self.neighbor_predicted_label_matches_current_label

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if is_duplicate is not UNSET:
            field_dict["is_duplicate"] = is_duplicate
        if duplicate_memory_ids is not UNSET:
            field_dict["duplicate_memory_ids"] = duplicate_memory_ids
        if has_potential_duplicates is not UNSET:
            field_dict["has_potential_duplicates"] = has_potential_duplicates
        if potential_duplicate_memory_ids is not UNSET:
            field_dict["potential_duplicate_memory_ids"] = potential_duplicate_memory_ids
        if cluster is not UNSET:
            field_dict["cluster"] = cluster
        if embedding_2d is not UNSET:
            field_dict["embedding_2d"] = embedding_2d
        if anomaly_score is not UNSET:
            field_dict["anomaly_score"] = anomaly_score
        if neighbor_label_logits is not UNSET:
            field_dict["neighbor_label_logits"] = neighbor_label_logits
        if neighbor_predicted_label is not UNSET:
            field_dict["neighbor_predicted_label"] = neighbor_predicted_label
        if neighbor_predicted_label_ambiguity is not UNSET:
            field_dict["neighbor_predicted_label_ambiguity"] = neighbor_predicted_label_ambiguity
        if neighbor_predicted_label_confidence is not UNSET:
            field_dict["neighbor_predicted_label_confidence"] = neighbor_predicted_label_confidence
        if current_label_neighbor_confidence is not UNSET:
            field_dict["current_label_neighbor_confidence"] = current_label_neighbor_confidence
        if normalized_neighbor_label_entropy is not UNSET:
            field_dict["normalized_neighbor_label_entropy"] = normalized_neighbor_label_entropy
        if neighbor_predicted_label_matches_current_label is not UNSET:
            field_dict["neighbor_predicted_label_matches_current_label"] = (
                neighbor_predicted_label_matches_current_label
            )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()
        is_duplicate = d.pop("is_duplicate", UNSET)

        duplicate_memory_ids = cast(List[str], d.pop("duplicate_memory_ids", UNSET))

        has_potential_duplicates = d.pop("has_potential_duplicates", UNSET)

        def _parse_potential_duplicate_memory_ids(data: object) -> Union[List[str], None, Unset]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            try:
                if not isinstance(data, list):
                    raise TypeError()
                potential_duplicate_memory_ids_type_0 = cast(List[str], data)

                return potential_duplicate_memory_ids_type_0
            except:  # noqa: E722
                pass
            return cast(Union[List[str], None, Unset], data)

        potential_duplicate_memory_ids = _parse_potential_duplicate_memory_ids(
            d.pop("potential_duplicate_memory_ids", UNSET)
        )

        cluster = d.pop("cluster", UNSET)

        embedding_2d = []
        _embedding_2d = d.pop("embedding_2d", UNSET)
        for embedding_2d_item_data in _embedding_2d or []:

            def _parse_embedding_2d_item(data: object) -> float:
                return cast(float, data)

            embedding_2d_item = _parse_embedding_2d_item(embedding_2d_item_data)

            embedding_2d.append(embedding_2d_item)

        anomaly_score = d.pop("anomaly_score", UNSET)

        neighbor_label_logits = cast(List[float], d.pop("neighbor_label_logits", UNSET))

        neighbor_predicted_label = d.pop("neighbor_predicted_label", UNSET)

        neighbor_predicted_label_ambiguity = d.pop("neighbor_predicted_label_ambiguity", UNSET)

        neighbor_predicted_label_confidence = d.pop("neighbor_predicted_label_confidence", UNSET)

        current_label_neighbor_confidence = d.pop("current_label_neighbor_confidence", UNSET)

        normalized_neighbor_label_entropy = d.pop("normalized_neighbor_label_entropy", UNSET)

        def _parse_neighbor_predicted_label_matches_current_label(data: object) -> Union[None, Unset, bool]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, bool], data)

        neighbor_predicted_label_matches_current_label = _parse_neighbor_predicted_label_matches_current_label(
            d.pop("neighbor_predicted_label_matches_current_label", UNSET)
        )

        labeled_memory_metrics = cls(
            is_duplicate=is_duplicate,
            duplicate_memory_ids=duplicate_memory_ids,
            has_potential_duplicates=has_potential_duplicates,
            potential_duplicate_memory_ids=potential_duplicate_memory_ids,
            cluster=cluster,
            embedding_2d=embedding_2d,
            anomaly_score=anomaly_score,
            neighbor_label_logits=neighbor_label_logits,
            neighbor_predicted_label=neighbor_predicted_label,
            neighbor_predicted_label_ambiguity=neighbor_predicted_label_ambiguity,
            neighbor_predicted_label_confidence=neighbor_predicted_label_confidence,
            current_label_neighbor_confidence=current_label_neighbor_confidence,
            normalized_neighbor_label_entropy=normalized_neighbor_label_entropy,
            neighbor_predicted_label_matches_current_label=neighbor_predicted_label_matches_current_label,
        )

        labeled_memory_metrics.additional_properties = d
        return labeled_memory_metrics

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
