"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from typing import TYPE_CHECKING, Any, Dict, Type, TypeVar, Union, cast

from attrs import define as _attrs_define

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.labeled_memory_insert_metadata import LabeledMemoryInsertMetadata


T = TypeVar("T", bound="LabeledMemoryInsert")


@_attrs_define
class LabeledMemoryInsert:
    """Model of fields required for inserting a labeled memory

    Attributes:
        value (str):
        label (int):
        memory_id (Union[None, Unset, str]):
        metadata (Union[Unset, LabeledMemoryInsertMetadata]):
        source_id (Union[None, Unset, str]):
    """

    value: str
    label: int
    memory_id: Union[None, Unset, str] = UNSET
    metadata: Union[Unset, "LabeledMemoryInsertMetadata"] = UNSET
    source_id: Union[None, Unset, str] = UNSET

    def to_dict(self) -> dict[str, Any]:
        value: str
        value = self.value

        label = self.label

        memory_id: Union[None, Unset, str]
        if isinstance(self.memory_id, Unset):
            memory_id = UNSET
        else:
            memory_id = self.memory_id

        metadata: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.metadata, Unset):
            metadata = self.metadata.to_dict()

        source_id: Union[None, Unset, str]
        if isinstance(self.source_id, Unset):
            source_id = UNSET
        else:
            source_id = self.source_id

        field_dict: dict[str, Any] = {}
        field_dict.update(
            {
                "value": value,
                "label": label,
            }
        )
        if memory_id is not UNSET:
            field_dict["memory_id"] = memory_id
        if metadata is not UNSET:
            field_dict["metadata"] = metadata
        if source_id is not UNSET:
            field_dict["source_id"] = source_id

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        from ..models.labeled_memory_insert_metadata import LabeledMemoryInsertMetadata

        d = src_dict.copy()

        def _parse_value(data: object) -> str:
            return cast(str, data)

        value = _parse_value(d.pop("value"))

        label = d.pop("label")

        def _parse_memory_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        memory_id = _parse_memory_id(d.pop("memory_id", UNSET))

        _metadata = d.pop("metadata", UNSET)
        metadata: Union[Unset, LabeledMemoryInsertMetadata]
        if isinstance(_metadata, Unset):
            metadata = UNSET
        else:
            metadata = LabeledMemoryInsertMetadata.from_dict(_metadata)

        def _parse_source_id(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        source_id = _parse_source_id(d.pop("source_id", UNSET))

        labeled_memory_insert = cls(
            value=value,
            label=label,
            memory_id=memory_id,
            metadata=metadata,
            source_id=source_id,
        )

        return labeled_memory_insert
