"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

import datetime
from typing import TYPE_CHECKING, Any, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

if TYPE_CHECKING:
    from ..models.labeled_memory_metadata import LabeledMemoryMetadata
    from ..models.labeled_memory_metrics import LabeledMemoryMetrics


T = TypeVar("T", bound="LabeledMemory")


@_attrs_define
class LabeledMemory:
    """A labeled memory is a single item that can be stored in the database and has a label.

    Attributes:
        value (str):
        embedding (List[float]):
        source_id (Union[None, str]):
        metadata (LabeledMemoryMetadata):
        memory_id (str):
        memory_version (int):
        created_at (datetime.datetime):
        updated_at (datetime.datetime):
        metrics (LabeledMemoryMetrics): Metrics computed for a labeled memory.
        label (int):
        label_name (Union[None, str]):
    """

    value: str
    embedding: List[float]
    source_id: Union[None, str]
    metadata: "LabeledMemoryMetadata"
    memory_id: str
    memory_version: int
    created_at: datetime.datetime
    updated_at: datetime.datetime
    metrics: "LabeledMemoryMetrics"
    label: int
    label_name: Union[None, str]
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        value: str
        value = self.value

        embedding = self.embedding

        source_id: Union[None, str]
        source_id = self.source_id

        metadata = self.metadata.to_dict()

        memory_id = self.memory_id

        memory_version = self.memory_version

        created_at = self.created_at.isoformat()

        updated_at = self.updated_at.isoformat()

        metrics = self.metrics.to_dict()

        label = self.label

        label_name: Union[None, str]
        label_name = self.label_name

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "value": value,
                "embedding": embedding,
                "source_id": source_id,
                "metadata": metadata,
                "memory_id": memory_id,
                "memory_version": memory_version,
                "created_at": created_at,
                "updated_at": updated_at,
                "metrics": metrics,
                "label": label,
                "label_name": label_name,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        from ..models.labeled_memory_metadata import LabeledMemoryMetadata
        from ..models.labeled_memory_metrics import LabeledMemoryMetrics

        d = src_dict.copy()

        def _parse_value(data: object) -> str:
            return cast(str, data)

        value = _parse_value(d.pop("value"))

        embedding = cast(List[float], d.pop("embedding"))

        def _parse_source_id(data: object) -> Union[None, str]:
            if data is None:
                return data
            return cast(Union[None, str], data)

        source_id = _parse_source_id(d.pop("source_id"))

        metadata = LabeledMemoryMetadata.from_dict(d.pop("metadata"))

        memory_id = d.pop("memory_id")

        memory_version = d.pop("memory_version")

        created_at = isoparse(d.pop("created_at"))

        updated_at = isoparse(d.pop("updated_at"))

        metrics = LabeledMemoryMetrics.from_dict(d.pop("metrics"))

        label = d.pop("label")

        def _parse_label_name(data: object) -> Union[None, str]:
            if data is None:
                return data
            return cast(Union[None, str], data)

        label_name = _parse_label_name(d.pop("label_name"))

        labeled_memory = cls(
            value=value,
            embedding=embedding,
            source_id=source_id,
            metadata=metadata,
            memory_id=memory_id,
            memory_version=memory_version,
            created_at=created_at,
            updated_at=updated_at,
            metrics=metrics,
            label=label,
            label_name=label_name,
        )

        labeled_memory.additional_properties = d
        return labeled_memory

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
