"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

import datetime
from typing import TYPE_CHECKING, Any, List, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

if TYPE_CHECKING:
    from ..models.label_prediction_memory_lookup import LabelPredictionMemoryLookup
    from ..models.prediction_feedback import PredictionFeedback


T = TypeVar("T", bound="LabelPredictionWithMemoriesAndFeedback")


@_attrs_define
class LabelPredictionWithMemoriesAndFeedback:
    """
    Attributes:
        prediction_id (str):
        confidence (float):
        anomaly_score (Union[None, float]):
        label (int):
        label_name (Union[None, str]):
        timestamp (datetime.datetime):
        input_value (str):
        input_embedding (List[float]):
        logits (List[float]):
        expected_label (Union[None, int]):
        expected_label_name (Union[None, str]):
        memories (List['LabelPredictionMemoryLookup']):
        org_id (str):
        memoryset_id (str):
        model_id (str):
        updated_at (datetime.datetime):
        tags (List[str]):
        explanation (Union[None, str]):
        memory_id (Union[None, str]):
        feedbacks (List['PredictionFeedback']):
    """

    prediction_id: str
    confidence: float
    anomaly_score: Union[None, float]
    label: int
    label_name: Union[None, str]
    timestamp: datetime.datetime
    input_value: str
    input_embedding: List[float]
    logits: List[float]
    expected_label: Union[None, int]
    expected_label_name: Union[None, str]
    memories: List["LabelPredictionMemoryLookup"]
    org_id: str
    memoryset_id: str
    model_id: str
    updated_at: datetime.datetime
    tags: List[str]
    explanation: Union[None, str]
    memory_id: Union[None, str]
    feedbacks: List["PredictionFeedback"]
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        prediction_id = self.prediction_id

        confidence = self.confidence

        anomaly_score: Union[None, float]
        anomaly_score = self.anomaly_score

        label = self.label

        label_name: Union[None, str]
        label_name = self.label_name

        timestamp = self.timestamp.isoformat()

        input_value: str
        input_value = self.input_value

        input_embedding = self.input_embedding

        logits = self.logits

        expected_label: Union[None, int]
        expected_label = self.expected_label

        expected_label_name: Union[None, str]
        expected_label_name = self.expected_label_name

        memories = []
        for memories_item_data in self.memories:
            memories_item = memories_item_data.to_dict()
            memories.append(memories_item)

        org_id = self.org_id

        memoryset_id = self.memoryset_id

        model_id = self.model_id

        updated_at = self.updated_at.isoformat()

        tags = self.tags

        explanation: Union[None, str]
        explanation = self.explanation

        memory_id: Union[None, str]
        memory_id = self.memory_id

        feedbacks = []
        for feedbacks_item_data in self.feedbacks:
            feedbacks_item = feedbacks_item_data.to_dict()
            feedbacks.append(feedbacks_item)

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "prediction_id": prediction_id,
                "confidence": confidence,
                "anomaly_score": anomaly_score,
                "label": label,
                "label_name": label_name,
                "timestamp": timestamp,
                "input_value": input_value,
                "input_embedding": input_embedding,
                "logits": logits,
                "expected_label": expected_label,
                "expected_label_name": expected_label_name,
                "memories": memories,
                "org_id": org_id,
                "memoryset_id": memoryset_id,
                "model_id": model_id,
                "updated_at": updated_at,
                "tags": tags,
                "explanation": explanation,
                "memory_id": memory_id,
                "feedbacks": feedbacks,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        from ..models.label_prediction_memory_lookup import LabelPredictionMemoryLookup
        from ..models.prediction_feedback import PredictionFeedback

        d = src_dict.copy()
        prediction_id = d.pop("prediction_id")

        confidence = d.pop("confidence")

        def _parse_anomaly_score(data: object) -> Union[None, float]:
            if data is None:
                return data
            return cast(Union[None, float], data)

        anomaly_score = _parse_anomaly_score(d.pop("anomaly_score"))

        label = d.pop("label")

        def _parse_label_name(data: object) -> Union[None, str]:
            if data is None:
                return data
            return cast(Union[None, str], data)

        label_name = _parse_label_name(d.pop("label_name"))

        timestamp = isoparse(d.pop("timestamp"))

        def _parse_input_value(data: object) -> str:
            return cast(str, data)

        input_value = _parse_input_value(d.pop("input_value"))

        input_embedding = cast(List[float], d.pop("input_embedding"))

        logits = cast(List[float], d.pop("logits"))

        def _parse_expected_label(data: object) -> Union[None, int]:
            if data is None:
                return data
            return cast(Union[None, int], data)

        expected_label = _parse_expected_label(d.pop("expected_label"))

        def _parse_expected_label_name(data: object) -> Union[None, str]:
            if data is None:
                return data
            return cast(Union[None, str], data)

        expected_label_name = _parse_expected_label_name(d.pop("expected_label_name"))

        memories = []
        _memories = d.pop("memories")
        for memories_item_data in _memories:
            memories_item = LabelPredictionMemoryLookup.from_dict(memories_item_data)

            memories.append(memories_item)

        org_id = d.pop("org_id")

        memoryset_id = d.pop("memoryset_id")

        model_id = d.pop("model_id")

        updated_at = isoparse(d.pop("updated_at"))

        tags = cast(List[str], d.pop("tags"))

        def _parse_explanation(data: object) -> Union[None, str]:
            if data is None:
                return data
            return cast(Union[None, str], data)

        explanation = _parse_explanation(d.pop("explanation"))

        def _parse_memory_id(data: object) -> Union[None, str]:
            if data is None:
                return data
            return cast(Union[None, str], data)

        memory_id = _parse_memory_id(d.pop("memory_id"))

        feedbacks = []
        _feedbacks = d.pop("feedbacks")
        for feedbacks_item_data in _feedbacks:
            feedbacks_item = PredictionFeedback.from_dict(feedbacks_item_data)

            feedbacks.append(feedbacks_item)

        label_prediction_with_memories_and_feedback = cls(
            prediction_id=prediction_id,
            confidence=confidence,
            anomaly_score=anomaly_score,
            label=label,
            label_name=label_name,
            timestamp=timestamp,
            input_value=input_value,
            input_embedding=input_embedding,
            logits=logits,
            expected_label=expected_label,
            expected_label_name=expected_label_name,
            memories=memories,
            org_id=org_id,
            memoryset_id=memoryset_id,
            model_id=model_id,
            updated_at=updated_at,
            tags=tags,
            explanation=explanation,
            memory_id=memory_id,
            feedbacks=feedbacks,
        )

        label_prediction_with_memories_and_feedback.additional_properties = d
        return label_prediction_with_memories_and_feedback

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
