"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from typing import Any, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

T = TypeVar("T", bound="LabelPredictionResult")


@_attrs_define
class LabelPredictionResult:
    """Predicted label and confidence for a single input.

    Attributes:
        prediction_id (str):
        confidence (float):
        anomaly_score (Union[None, float]):
        label (int):
        label_name (Union[None, str]):
    """

    prediction_id: str
    confidence: float
    anomaly_score: Union[None, float]
    label: int
    label_name: Union[None, str]
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        prediction_id = self.prediction_id

        confidence = self.confidence

        anomaly_score: Union[None, float]
        anomaly_score = self.anomaly_score

        label = self.label

        label_name: Union[None, str]
        label_name = self.label_name

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "prediction_id": prediction_id,
                "confidence": confidence,
                "anomaly_score": anomaly_score,
                "label": label,
                "label_name": label_name,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()
        prediction_id = d.pop("prediction_id")

        confidence = d.pop("confidence")

        def _parse_anomaly_score(data: object) -> Union[None, float]:
            if data is None:
                return data
            return cast(Union[None, float], data)

        anomaly_score = _parse_anomaly_score(d.pop("anomaly_score"))

        label = d.pop("label")

        def _parse_label_name(data: object) -> Union[None, str]:
            if data is None:
                return data
            return cast(Union[None, str], data)

        label_name = _parse_label_name(d.pop("label_name"))

        label_prediction_result = cls(
            prediction_id=prediction_id,
            confidence=confidence,
            anomaly_score=anomaly_score,
            label=label,
            label_name=label_name,
        )

        label_prediction_result.additional_properties = d
        return label_prediction_result

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
