"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

from typing import Any, Type, TypeVar, Union, cast

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="LabelClassMetrics")


@_attrs_define
class LabelClassMetrics:
    """
    Attributes:
        label (int):
        average_lookup_score (float):
        memory_count (int):
        label_name (Union[None, Unset, str]):
    """

    label: int
    average_lookup_score: float
    memory_count: int
    label_name: Union[None, Unset, str] = UNSET
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        label = self.label

        average_lookup_score = self.average_lookup_score

        memory_count = self.memory_count

        label_name: Union[None, Unset, str]
        if isinstance(self.label_name, Unset):
            label_name = UNSET
        else:
            label_name = self.label_name

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "label": label,
                "average_lookup_score": average_lookup_score,
                "memory_count": memory_count,
            }
        )
        if label_name is not UNSET:
            field_dict["label_name"] = label_name

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()
        label = d.pop("label")

        average_lookup_score = d.pop("average_lookup_score")

        memory_count = d.pop("memory_count")

        def _parse_label_name(data: object) -> Union[None, Unset, str]:
            if data is None:
                return data
            if isinstance(data, Unset):
                return data
            return cast(Union[None, Unset, str], data)

        label_name = _parse_label_name(d.pop("label_name", UNSET))

        label_class_metrics = cls(
            label=label,
            average_lookup_score=average_lookup_score,
            memory_count=memory_count,
            label_name=label_name,
        )

        label_class_metrics.additional_properties = d
        return label_class_metrics

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
