"""
This file is generated by the openapi-python-client tool via the generate_api_client.py script

It is a customized template from the openapi-python-client tool's default template:
https://github.com/openapi-generators/openapi-python-client/blob/861ef5622f10fc96d240dc9becb0edf94e61446c/openapi_python_client/templates/model.py.jinja

The main change is:
- Fix typing issues
"""

# flake8: noqa: C901

import datetime
from enum import Enum
from typing import Any, Type, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field
from dateutil.parser import isoparse

from ..models.pretrained_embedding_model_name import PretrainedEmbeddingModelName
from ..models.task_status import TaskStatus

T = TypeVar("T", bound="FinetunedEmbeddingModelMetadata")


@_attrs_define
class FinetunedEmbeddingModelMetadata:
    """
    Attributes:
        embedding_dim (int):
        max_seq_length (int):
        uses_context (bool):
        id (str):
        org_id (str):
        name (str):
        storage_path (str):
        created_at (datetime.datetime):
        updated_at (datetime.datetime):
        base_model (PretrainedEmbeddingModelName): Names of pretrained embedding models that are supported by OrcaCloud
        finetuning_task_id (str):
        finetuning_status (TaskStatus): Status of task in the task queue
    """

    embedding_dim: int
    max_seq_length: int
    uses_context: bool
    id: str
    org_id: str
    name: str
    storage_path: str
    created_at: datetime.datetime
    updated_at: datetime.datetime
    base_model: PretrainedEmbeddingModelName
    finetuning_task_id: str
    finetuning_status: TaskStatus
    additional_properties: dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> dict[str, Any]:
        embedding_dim = self.embedding_dim

        max_seq_length = self.max_seq_length

        uses_context = self.uses_context

        id = self.id

        org_id = self.org_id

        name = self.name

        storage_path = self.storage_path

        created_at = self.created_at.isoformat()

        updated_at = self.updated_at.isoformat()

        base_model = self.base_model.value if isinstance(self.base_model, Enum) else self.base_model

        finetuning_task_id = self.finetuning_task_id

        finetuning_status = (
            self.finetuning_status.value if isinstance(self.finetuning_status, Enum) else self.finetuning_status
        )

        field_dict: dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "embedding_dim": embedding_dim,
                "max_seq_length": max_seq_length,
                "uses_context": uses_context,
                "id": id,
                "org_id": org_id,
                "name": name,
                "storage_path": storage_path,
                "created_at": created_at,
                "updated_at": updated_at,
                "base_model": base_model,
                "finetuning_task_id": finetuning_task_id,
                "finetuning_status": finetuning_status,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: dict[str, Any]) -> T:
        d = src_dict.copy()
        embedding_dim = d.pop("embedding_dim")

        max_seq_length = d.pop("max_seq_length")

        uses_context = d.pop("uses_context")

        id = d.pop("id")

        org_id = d.pop("org_id")

        name = d.pop("name")

        storage_path = d.pop("storage_path")

        created_at = isoparse(d.pop("created_at"))

        updated_at = isoparse(d.pop("updated_at"))

        base_model = PretrainedEmbeddingModelName(d.pop("base_model"))

        finetuning_task_id = d.pop("finetuning_task_id")

        finetuning_status = TaskStatus(d.pop("finetuning_status"))

        finetuned_embedding_model_metadata = cls(
            embedding_dim=embedding_dim,
            max_seq_length=max_seq_length,
            uses_context=uses_context,
            id=id,
            org_id=org_id,
            name=name,
            storage_path=storage_path,
            created_at=created_at,
            updated_at=updated_at,
            base_model=base_model,
            finetuning_task_id=finetuning_task_id,
            finetuning_status=finetuning_status,
        )

        finetuned_embedding_model_metadata.additional_properties = d
        return finetuned_embedding_model_metadata

    @property
    def additional_keys(self) -> list[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
